static char rcsid[] = "@(#)$Id: outdate.c,v 1.3 2021/09/22 17:50:58 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.3 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_addr.h"

DEBUG_VAR(Debug,__FILE__,"addr");

#include <limits.h>

#define EXP_DATE_magic		0xFC0B

struct expanded_date {
    unsigned short magic;      /* EXP_DATE_magic */

    struct tm        value;

    time_t           cached_time;
    enum date_source explicit_date;
} * new_expanded_date(value,t_value,explicit_date)
   const struct tm     * value    /* may be NULL */;
   time_t                t_value  /* 0, if not set */;
   enum date_source      explicit_date;
{
    struct expanded_date * ret = safe_zero_alloc(sizeof (* ret));

    ret->value.tm_sec  = 0;
    ret->value.tm_min  = 0;
    ret->value.tm_hour = 0;
    ret->value.tm_mday = 0;
    ret->value.tm_mon  = 0;
    ret->value.tm_year = 0;
    ret->value.tm_wday = 0;
    ret->value.tm_yday = 0;
    ret->value.tm_isdst = -1;   /* Not available */

    ret->cached_time    = t_value;

    if (value) {
	char *c = asctime(value);
	
	ret->value = *value;

	if (c) {
	    /* asctime() includes \n */
	    DPRINT(Debug,16,(&Debug,"new_expanded_date: value %s",c));
	}

	if (0 == ret->cached_time ||
	    (time_t)-1 == ret->cached_time) {

	    time_t time_value = expanded_get_time_t(& (ret->value));

	    if ((time_t)-1 != time_value &&
		time_value > 0) {
		ret->cached_time = time_value;

		DPRINT(Debug,16,(&Debug,"new_expanded_date: cached_time %ld\n",
				 (long)(ret->cached_time)));
	    }
	}
	
    } else if ((time_t)-1 != ret->cached_time &&
	       ret->cached_time > 0) {
	struct tm * the_time =  localtime(&(ret->cached_time));

	if (the_time) {
	    char *c = asctime(the_time);
	    
	    ret->value = *the_time;
	    if (c) {
		/* asctime() includes \n */
		DPRINT(Debug,16,(&Debug,"new_expanded_date: calculated value %s",c));
	    }
	}	    
    }

    ret->explicit_date = explicit_date;
    
    ret->magic = EXP_DATE_magic;

    return ret;
}

void free_expanded_date(ptr)
     struct expanded_date **ptr;
{
    if (EXP_DATE_magic != (*ptr)->magic)
	panic("HEADER PANIC",__FILE__,__LINE__,
	      "free_expanded_date",
	      "Bad magic number (expanded_date)",0);

    (*ptr)->magic = 0; /* Invalidate */

    free(*ptr);
    *ptr = NULL;
}

/* May return NULL */
const struct tm * get_expanded_date_value(ptr)
     struct expanded_date *ptr;
{
    if (EXP_DATE_magic != ptr->magic)
	panic("HEADER PANIC",__FILE__,__LINE__,
	      "get_expanded_date_value",
	      "Bad magic number (expanded_date)",0);

    /* If 0 == ptr->value.tm_mday, then value is not set */
    if (ptr->value.tm_mday > 0)   /* Day of the month (1-31) */
	return &(ptr->value);
    
    return NULL;
}


/* May return 0 if fail or year < 1970 */
time_t get_expanded_date_cached_time(ptr)
     struct expanded_date *ptr;
{
    if (EXP_DATE_magic != ptr->magic)
	panic("HEADER PANIC",__FILE__,__LINE__,
	      "get_expanded_date_cached_time",
	      "Bad magic number (expanded_date)",0);

    if (0 == ptr->cached_time) {

	/* If 0 == ret->value.tm_mday, then value is not set */
	if (ptr->value.tm_mday > 0) {  /* Day of the month (1-31) */
	
	    time_t time_value = expanded_get_time_t(& (ptr->value));
	    
	    if ((time_t)-1 != time_value &&
		time_value > 0) {
		ptr->cached_time = time_value;
		
		DPRINT(Debug,16,(&Debug,"get_expanded_date_cached_time: cached_time %ld\n",
				 (long)(ptr->cached_time)));
	    }
	}
    }

    DPRINT(Debug,16,(&Debug,"get_expanded_date_cached_time=%ld\n",
		     (long)(ptr->cached_time)));

    return ptr->cached_time;
}

enum date_source get_expanded_date_source(ptr)
     const struct expanded_date *ptr;
{
    enum date_source ret;

    if (EXP_DATE_magic != ptr->magic)
	panic("HEADER PANIC",__FILE__,__LINE__,
	      "get_expanded_date_source",
	      "Bad magic number (expanded_date)",0);

    ret = ptr->explicit_date;
    
    DPRINT(Debug,16,(&Debug,"get_expanded_date_source=%d",
		     ret));

    switch (ret) {
    case date_automatic:  DPRINT(Debug,16,(&Debug," date_automatic")); break;
    case date_explicit:   DPRINT(Debug,16,(&Debug," date_explicit"));  break;
    }
    DPRINT(Debug,16,(&Debug,"\n"));
    
    return ret;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
