static char rcsid[] = "@(#)$Id: alias_vector.c,v 1.7 2016/03/21 20:26:14 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.7 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/


#include "def_alias.h"
#include "s_me.h"

DEBUG_VAR(Debug,__FILE__,"alias");

#define ALIASES_vector_magic    0xF607

struct alias_vector {
    unsigned short magic;    /* ALIASES_vector_magic */

    struct string **aliases;
    int             aliases_len;
};

void free_alias_vector(vector)
     struct alias_vector **vector;
{
    if (ALIASES_vector_magic != (*vector)->magic)
	panic("ALIASES PANIC",__FILE__,__LINE__,"free_alias_vector",
	      "Bad magic number",0);

    if ((*vector)->aliases) {
	int i;

	for (i = 0; i < (*vector)->aliases_len; i++) {
	    if ((*vector)->aliases[i])
		free_string(& ((*vector)->aliases[i]));
	}

	free((*vector)->aliases);
	(*vector)->aliases = NULL;
    }

    (*vector)->aliases_len = 0;

    (*vector)->magic = 0;   /* Invalidate */
    free(*vector);
    *vector = NULL;
}

struct alias_vector * new_alias_vector()
{
    struct alias_vector *ret = safe_zero_alloc(sizeof(*ret));

    ret->magic       = ALIASES_vector_magic;
    ret->aliases     = NULL;
    ret->aliases_len = 0;

    return ret;
}

struct alias_vector * dup_alias_vector(vector)
     const struct alias_vector * vector;
{
    struct alias_vector *ret = new_alias_vector();

    if (ALIASES_vector_magic != vector->magic)
	panic("ALIASES PANIC",__FILE__,__LINE__,"dup_alias_vector",
	      "Bad magic number",0);

    if (vector->aliases_len > 0) {
	int i;

	ret->aliases = 
	    safe_calloc(vector->aliases_len,
			sizeof(ret->aliases[0]));

	for (i = 0; i < vector->aliases_len; i++) {
	    ret->aliases[i] = dup_string(vector->aliases[i]);	    
	}
	ret->aliases_len = i;
    }

    return ret;
}

void alias_vector_add_alias(vector,alias)
     struct alias_vector *vector;
     const struct string *alias;
{
    if (ALIASES_vector_magic != vector->magic)
	panic("ALIASES PANIC",__FILE__,__LINE__,"alias_vector_add_alias",
	      "Bad magic number",0);

    vector->aliases = safe_array_realloc(vector->aliases,
					 (vector->aliases_len+1),
					 sizeof(vector->aliases[0]));

    vector->aliases[vector->aliases_len] = dup_string(alias);
    vector->aliases_len++;
}

int alias_vector_item_count(vector)
     const struct alias_vector *vector;
{
    return vector->aliases_len;
}

const struct string * alias_vector_get_alias(vector,idx)
     const struct alias_vector *vector;
     int idx;
{
    if (ALIASES_vector_magic != vector->magic)
	panic("ALIASES PANIC",__FILE__,__LINE__,"alias_vector_get_alias",
	      "Bad magic number",0);

    if (idx < 0 || idx >= vector->aliases_len)
	panic("ALIASES PANIC",__FILE__,__LINE__,"alias_vector_get_alias",
	      "Bad index",0);

    return vector->aliases[idx];
}




/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
