static char rcsid[] = "@(#)$Id: aliasexpand.c,v 1.13 2021/07/13 07:58:36 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.13 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************
 * Partially based on Elm 2.4 src/aliaslib.c. 
 * That code was following copyright:
 *
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/


#include "def_alias.h"

#include "s_elm.h"

DEBUG_VAR(Debug,__FILE__,"alias");


static unsigned char *s2us P_((char *str));
static unsigned char *s2us(str)
     char *str;
{
    return (unsigned char *)str;
}

#if ANSI_C
alias_stack_lookup_f alias_simple_lookup;
#endif
int alias_simple_lookup(value,alias,result_alias,result_list,
			expand_result)
     union alias_stack_item     value;
     const struct string         *alias;
     const struct address_alias **result_alias;
     /* Caller must free result_list */
     struct addr_list          **result_list;
     enum alias_address_expand_result * expand_result;
{
    int index = -1;

    *result_list   = NULL;

    *result_alias  = 
	aliases_map_lookup_alias(value.alias_map,
				 alias,&index);

    if (*result_alias) {
	
	if (expand_result) {
	     *expand_result = alias_expand_ok;
	     DPRINT(Debug,10,
		    (&Debug,"alias_simple_lookup: setting alias_expand_ok\n"));
	}
	
	return 1;
    }
	
    return 0;
}

static void append_list_with_group P_((struct addr_list *result, const struct addr_list *list,
				       int group_num));
static void append_list_with_group (result,list,group_num)
     struct addr_list *result;
     const struct addr_list *list;
     int group_num;
{
    int idx, addr_item_count = addr_list_item_count(list);

    for (idx = 0; idx < addr_item_count; idx++) {
	int tmp = -1;
	const struct address * address = 
	    addr_list_get_item(list,idx,&tmp);


	add_address_to_list(result,address,group_num);
    }
}

#define ALIAS_STACK_magic       0xF609

struct alias_stack {
    unsigned short magic;       /* ALIAS_STACK_magic */


    struct {
	alias_stack_lookup_f    *lookup;
	union alias_stack_item   value;

    }        * stack_array ;
    int        stack_len;

};


void   free_alias_stack(ptr) 
     struct alias_stack **ptr;
{
    if (ALIAS_STACK_magic != (*ptr)->magic)
	panic("ALIAS PANIC",__FILE__,__LINE__,"free_alias_stack",
	      "Bad magic number",0);

    if ((*ptr)->stack_array) {
	free((*ptr)->stack_array);
	(*ptr)->stack_array = NULL;
    }
    (*ptr)->stack_len = 0;

    (*ptr)->magic = 0;      /* Invalidate */
    free(*ptr);
    *ptr = NULL;
}

struct alias_stack * new_alias_stack()
{
    struct alias_stack *stack = safe_zero_alloc(sizeof (*stack));
    
    stack->stack_array  = NULL;
    stack->stack_len    = 0;

    stack->magic = ALIAS_STACK_magic;

    return stack;
}


void add_lookup_to_alias_stack(stack,lookup,value)
     struct alias_stack      *stack;
     alias_stack_lookup_f    *lookup;
     union alias_stack_item   value;
{
    if (ALIAS_STACK_magic != stack->magic)
	panic("ALIAS PANIC",__FILE__,__LINE__,"add_lookup_to_alias_stack",
	      "Bad magic number",0);

    stack->stack_array = 
	safe_array_realloc(stack->stack_array,
			   (stack->stack_len+1),
			   sizeof(stack->stack_array[0]));

    stack->stack_array[stack->stack_len].lookup = lookup;
    stack->stack_array[stack->stack_len].value  = value;

    stack->stack_len++;
}

static int do_expand_alias_tail P_((const struct address_alias *result_alias,
				    struct addr_list     * result,
				    struct alias_stack   * stack,
				    int                    stack_ptr,
				    int depth,
				    int group_num));

static int do_expand_alias P_((struct addr_list     * result,
			       struct alias_stack   * stack,
			       int                    stack_level,
			       const struct string     *alias,			       
			       int depth,
			       int group_num,
			       enum alias_address_expand_result * expand_result
			       ));

static int do_expand_alias_tail(result_alias,result,
				stack,stack_level,depth,group_num)
     const struct address_alias *result_alias;
     struct addr_list     * result;
     struct alias_stack   * stack;
     int                    stack_level;
     int depth;
     int group_num;
{
    int r = 1;

    /* 2)  Person  */

    {
	const struct string *firstn;
	const struct string *lastn;
	const struct address *address;
	
	if (address_alias_get_person(result_alias,
				     &firstn,&lastn,&address)) {
	    const char * addr;

	    if (!address) {
		/* Should not happen ... */

		DPRINT(Debug,1,
		       (&Debug, "%*s  ->Found person alias -- NO address!\n", 	
			(depth*2), ""));
		
		goto no_address;

	    }

	    if (address_is_empty(address) && ! firstn &&  !lastn) {
		DPRINT(Debug,12,
		       (&Debug, "%*s  ->Found person alias -- skipping empty address!\n", 	
			(depth*2), ""));
		
		goto no_address;		
	    }
	    
	    addr = address_get_ascii_addr(address);
	    
	    DPRINT(Debug,5,
		   (&Debug, "%*s  ->Found person alias %s\n",
		    (depth*2), "",
		    addr ? addr : "<no address>"));
	    
	    if (address_get_phrase(address) || !addr)
		add_address_to_list(result, address, group_num);
	    else {
		const struct string * comment =
		    address_get_comment(address);
		
		struct string * fullname = NULL;
		struct address * address_1 = NULL;
		
		if (firstn)
		    append_string(&fullname,firstn,1);
		if (fullname)
		    add_ascii_to_string(fullname,s2us(" "));
		if (lastn)
		    append_string(&fullname,lastn,1);
		
		address_1 = new_address(addr,fullname,comment);
		
		add_address_to_list(result, address_1,group_num);
		
		free_address(&address_1);
		
		if (fullname)
		    free_string(&fullname);
	    }
	    
	}

    no_address: ;

    }
    
    
    /* 3) List */
    {
	const struct addr_list * list = address_alias_get_list(result_alias);
	
	if (list) {
	    
	    DPRINT(Debug,5,
		   (&Debug, "%*s  ->Found address list\n", 	(depth*2), ""));
	    
	    if (group_num >= 0)
		append_list_with_group(result,list,group_num);
	    else
		append_addr_list(result,list);   
	}	    
    }
    
    /* 4) Group */
    {
	const struct string        *phrase;
	const struct alias_vector  *vector;
	
	
	if (address_alias_get_group(result_alias,&phrase,&vector)) {
	    int i;
	    int vc;
	    int new_group_num = -1;
	    
	    if (!vector) {
		/* Should not happen ... */

		DPRINT(Debug,1,
		       (&Debug, "%*s  ->Found group alias -- NO vector!\n", 	
			(depth*2), ""));
		
		goto no_vector;
	    }

	    vc = alias_vector_item_count(vector);

	    DPRINT(Debug,5,
		   (&Debug, "%*s  ->Found group alias (%d items)\n", 	
		    (depth*2), "",vc));
	    
	    
	    if (phrase && string_len(phrase) > 0)
		new_group_num =  add_group_to_list(result,phrase);
	    
	    
	    for ( i = 0; i < vc; i++) {
		const struct string * alias_item = 
		    alias_vector_get_alias(vector,i);
		
		
		if (! do_expand_alias(result,
				      stack,
				      stack_level,
				      alias_item,
				      depth,
				      new_group_num,
				      NULL)) {
		    
		    
		    DPRINT(Debug,5,
			   (&Debug, "%*s  -> .. Failed to expand alias \"%S\" on alias group\n",
			    (depth*2), "",alias_item));
		    r = 0;
		}
		
		
	    }
	}

    no_vector:
	;

    }

    return r;
}

static int do_expand_alias(result,stack,stack_ptr,alias,depth,group_num,expand_result)
     struct addr_list       * result;
     struct alias_stack     * stack;
     int                      stack_ptr;
     const struct string    * alias;
     int depth;
     int group_num;
     enum alias_address_expand_result * expand_result;

{
    int stack_level = 0;
    const struct address_alias *result_alias = NULL;
    struct addr_list           *result_list  = NULL;
    int r = 0;


    if (ALIAS_STACK_magic != stack->magic)
	panic("ALIAS PANIC",__FILE__,__LINE__,"do_expand_alias",
	      "Bad magic number",0);


    /* update the recursion depth counter */
    ++depth;
    
    DPRINT(Debug,5,(&Debug, "%*s-> Attempting alias expansion on \"%S\" (level %d, stack len %d)\n",
		    (depth*2), "", alias,stack_ptr,stack->stack_len));


    if (stack_ptr >= stack->stack_len) {
	DPRINT(Debug,5,(&Debug, "%*s-> Alias stack exhausted\n",
			(depth*2), ""));
	return 0;
    }


    for (stack_level = stack_ptr; stack_level < stack->stack_len; stack_level++) {

	if (stack->stack_array[stack_level].lookup(stack->stack_array[stack_level].value, 
						   alias,
						   & result_alias, &result_list,expand_result))
	    goto found_alias;
	
	if (result_list)
	    panic("ALIAS PANIC",__FILE__,__LINE__,"do_expand_alias",
		  "Unexpected alias data",0);	   
    }


    DPRINT(Debug,5,(&Debug, "%*s-> Alias not found\n",
			(depth*2), ""));
    return 0;


 found_alias:

    if (stack_level > stack_ptr) {
	DPRINT(Debug,5,(&Debug, "%*s-> Found on nested level %d\n",
			(depth*2), "",stack_level));	
    }
   
    if (result_list) {
	/* 1) Address list was returned */

	r = 1;

	DPRINT(Debug,5,
	       (&Debug, "%*s  ->expanded alias to address list\n",
		(depth*2), ""));

	
	if (group_num >= 0)
	    append_list_with_group(result,result_list,group_num);
	else
	    append_addr_list(result,result_list);
	
	free_addr_list(& result_list);
    }


    if (result_alias) {
	/* Alias was returned */
     	
	if (depth < 32) {

	    r = do_expand_alias_tail(result_alias,result,
				     stack,stack_level,depth,group_num);

	    if (r && expand_result) {
		*expand_result = alias_expand_ok;
		 DPRINT(Debug,10,(&Debug,"do_expand_alias: setting alias_expand_ok\n"));
	    }

	} else {	    
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmErrorExpanding,
			      "Error expanding \"%S\" - probable alias definition loop."),
		      alias);
	    r = 0;
	}

    }

    DPRINT(Debug,5,(&Debug, "%*s-> Alias \"%S\" expanded %s\n",
		    (depth*2), "", alias,
		    r ? "(succeed)" : "(failure)"));
    
    return r;
}


struct addr_list * aliases_expand_alias(stack,alias,expand_result)
     struct alias_stack       * stack;
     const struct string      * alias;
     enum alias_address_expand_result * expand_result;
{
    struct addr_list * result = new_empty_addr_list(1);
    
    if (ALIAS_STACK_magic != stack->magic)
	panic("ALIAS PANIC",__FILE__,__LINE__,"aliases_expand_alias",
	      "Bad magic number",0);

    if (stack->stack_len < 1) {
	DPRINT(Debug,5,(&Debug, "Alias stack empty when expanding alias \"%S\"\n",
			alias));
	return NULL;
    }

    if (do_expand_alias(result,stack,0,alias,0,-1,expand_result)) {

	int alen  = addr_list_item_count(result);
	int glen = addr_list_group_count(result);
	int i;

	DPRINT(Debug,2,
	       (&Debug,"Alias \"%S\" in aliases_expand_alias expands %d addresses (with %d groups).\n",
		alias,alen,glen));

	for (i = 0; i < glen;  i++) {
	    const struct string * G UNUSED_VAROK = 
		addr_list_get_group(result,i);
	    
	    DPRINT(Debug,6,(&Debug,"aliases_expand_alias: group [%d]: group=%S\n",
			    i,G));
	}
	
	for (i = 0; i < alen;  i++) {
	    
	    int group = -1;
	    const struct address * address = 
		addr_list_get_item(result,i,&group);
	    
	    const char          * addr     UNUSED_VAROK = 
		address_get_ascii_addr(address);
	    const struct string * fullname = address_get_phrase(address);
	    const struct string * comment  = address_get_comment(address);
	    
	    DPRINT(Debug,6,(&Debug,"aliases_expand_alias: addr [%d]: addr=%s",
			    i,addr ? addr : "<NULL>"));
	    
	    if (fullname) {		
		DPRINT(Debug,6,(&Debug,", fullname=%S",
				fullname));
	    }
	    
	    if (comment) {		
		DPRINT(Debug,6,(&Debug,", comment=%S",comment));
	    }
	    
	    DPRINT(Debug,6,(&Debug,", group=%d\n",group));
	}
	
    } else {
	DPRINT(Debug,2,
	       (&Debug,"Could not expand alias \"%S\" in aliases_expand_alias\n",
		alias));
	
	free_addr_list(&result);

	if (expand_result) {
	    *expand_result = alias_expand_fail;
	     DPRINT(Debug,10,(&Debug,"aliases_expand_alias: setting alias_expand_fail\n"));
	}
    }

    if (expand_result) {
	 DPRINT(Debug,10,(&Debug,"aliases_expand_alias: *expand_result=%d",
		 *expand_result));
	 switch (*expand_result) {
	 case alias_expand_fail:        DPRINT(Debug,10,(&Debug," alias_expand_fail"));        break;
	 case alias_expand_ok:          DPRINT(Debug,10,(&Debug," alias_expand_ok"));          break;
	 case alias_expand_local_fill:  DPRINT(Debug,10,(&Debug," alias_expand_local_fill"));  break;
	 case alias_expand_local_dummy: DPRINT(Debug,10,(&Debug," alias_expand_local_dummy")); break;
	 }
	 DPRINT(Debug,10,(&Debug,"\n"));
    }
    
    return result;
}


struct addr_list * aliases_expand_alias_proto(stack,alias)
     struct alias_stack       * stack;
     const struct address_alias *alias;
{
    struct addr_list * result = new_empty_addr_list(1);

    if (ALIAS_STACK_magic != stack->magic)
	panic("ALIAS PANIC",__FILE__,__LINE__,"aliases_expand_alias_proto",
	      "Bad magic number",0);


    if (do_expand_alias_tail(alias,result,stack,0,0,-1)) {
	int alen  = addr_list_item_count(result);
	int glen = addr_list_group_count(result);
	int i;

	DPRINT(Debug,2,
	       (&Debug,"Alias in aliases_expand_alias_proto expands %d addresses (with %d groups).\n",
		alen,glen));

	for (i = 0; i < glen;  i++) {
	    const struct string * G UNUSED_VAROK  = 
		addr_list_get_group(result,i);
	    
	    DPRINT(Debug,6,(&Debug,"aliases_expand_alias_proto: group [%d]: group=%S\n",
			    i,G));
	}
	
	for (i = 0; i < alen;  i++) {
	    
	    int group = -1;
	    const struct address * address = 
		addr_list_get_item(result,i,&group);
	    
	    const char          * addr     UNUSED_VAROK = 
		address_get_ascii_addr(address);
	    const struct string * fullname = address_get_phrase(address);
	    const struct string * comment  = address_get_comment(address);
	    
	    DPRINT(Debug,6,(&Debug,"aliases_expand_alias_proto: addr [%d]: addr=%s",
			    i,addr ? addr : "<NULL>"));
	    
	    if (fullname) {
		DPRINT(Debug,6,(&Debug,", fullname=%S",
				fullname));
	    }
	    
	    if (comment) {
		
		DPRINT(Debug,6,(&Debug,", comment=%S",comment));
	    }
	    
	    DPRINT(Debug,6,(&Debug,", group=%d\n",group));
	}
	
    } else {
	DPRINT(Debug,2,
	       (&Debug,"Could not expand alias in aliases_expand_alias_proto\n"));
	
	free_addr_list(&result);
    }

    return result;
}

/* Non recursive ---- */
const struct address_alias * aliases_get_alias(stack,alias)
     struct alias_stack      *stack;
     const struct string     *alias;
{
    int stack_level = 0;
    const struct address_alias *result_alias = NULL;
    struct addr_list           *result_list  = NULL;

    if (ALIAS_STACK_magic != stack->magic)
	panic("ALIAS PANIC",__FILE__,__LINE__,"aliases_get_alias",
	      "Bad magic number",0);

    if (stack->stack_len < 1) {
	DPRINT(Debug,5,(&Debug, "Alias stack empty when lookup alias \"%S\"\n",
			alias));
	return NULL;
    }

    DPRINT(Debug,5,(&Debug, "-> Attempting alias lookup on \"%S\" (stack len %d)\n",
		    alias,stack->stack_len));

    
    for (stack_level = 0; stack_level < stack->stack_len; stack_level++) {
	
	if (stack->stack_array[stack_level].lookup(stack->stack_array[stack_level].value, 
						   alias,
						   & result_alias, &result_list,
						   NULL))
	    goto found_alias;
	
	if (result_list)
	    panic("ALIAS PANIC",__FILE__,__LINE__,"do_expand_alias",
		  "Unexpected alias data",0);	   
    }


    DPRINT(Debug,5,(&Debug, "-> Alias not found\n"));
    return NULL;

 found_alias:

    if (stack_level) {
	DPRINT(Debug,5,(&Debug, "->Found on nested level %d\n",
			stack_level));	
    }
    
    DPRINT(Debug,5,(&Debug, "-> Alias \"%S\" located %s\n",
		    alias,
		    result_alias ? "(succeed)" : "(failure)"));

    return result_alias;
}




/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
