/* $Id: def_alias.h,v 1.7 2021/07/13 07:58:36 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.7 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "elm_defs.h"
#include "addrlib.h"
#include "aliaslib.h"

/* address aliases routines */

extern void address_alias_add_comment P_((struct address_alias **alias,
					  const struct string *comment,
					  struct string **have_error));
extern void address_alias_add_firstname P_((struct address_alias **alias,
					    const struct string *firstname,
					    struct string **have_error));
extern void address_alias_add_lastname P_((struct address_alias **alias,
					   const struct string *lastname,
					   struct string **have_error));
extern void address_alias_add_address P_((struct address_alias **alias,
					  const struct address *addr,
					  struct string **have_error));
extern void address_alias_add_addr_list P_((struct address_alias **alias,
					  const struct addr_list *addr_list,
					  struct string **have_error));
extern void address_alias_add_phrase P_((struct address_alias **alias,
					 const struct string *phrase,
					 struct string **have_error));

extern void address_alias_add_group_start P_((struct address_alias **alias,
					      struct string **have_error));
extern void address_alias_add_group_item P_((struct address_alias **alias,
					     const struct string *alias_item,
					     struct string **have_error));

/* Alias vector routines */

extern struct alias_vector * dup_alias_vector P_((const struct alias_vector 
						  * vector));

/* address aliases routines */

extern void free_address_alias P_((struct address_alias **alias));

/* Editing routines called, if returns 1 */
extern int edited_address_alias P_((struct address_alias *alias,
				    int reset /* reset edited flag */));

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
