static char rcsid[] = "@(#)$Id: chloc.c,v 2.4 2014/07/14 15:07:25 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.4 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 lib/chloc.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** 

**/

#include "elm_defs.h"

DEBUG_VAR(Debug,__FILE__,"core");

/* Is this really needed? This does same than strchr or index, except
 *  that return type is different.
 *
 *                          - K E H <hurtta@ozone.FMI.FI>
 */

/* Argument (second) can't be char because there is both prototype and
 * non-prototype declaration.
 */
int chloc(string, ch)
     const char *string;
     int ch;
{
    /** returns the index of ch in string, or -1 if not in string **/
    const char *s;
    
    for (s = string; *s; s++)
	if (*s == ch)
	    return(s - string);

    return(-1);
}

int qchloc(string, ch)
     const char *string;
     int ch;
{
    /* returns the index of ch in string, or -1 if not in string
     * skips over quoted portions of the string
     */
    const char *s;
    int l;

    for (s = string; *s; s++) {
	l = len_next_part(s);
	if (l > 1) { /* a quoted char/string can not be a match */
	    s += l - 1;
	    continue;
	}
	
	if (*s == ch)
	    return(s - string);
    }

    return(-1);
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
