static char rcsid[] = "$Id: dynarray.c,v 2.5 2016/03/21 20:26:13 hurtta Exp $";

/*****************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.5 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                       (was hurtta+elm@posti.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 *
 * Initially written by: Michael Elkins <elkins@aero.org>, 1995/06/01
 *****************************************************************************/

/** routines for handling of dynamic arrays **/

#include "elm_defs.h"

DEBUG_VAR(Debug,__FILE__,"core");

void ** DynamicArray (p, record_size, max, n)
     void **p;
     int record_size;
     int *max;
     int n;
{
    int newmax, j;
    void **c;

    newmax = *max + n;
    
    if (!p)
	c = safe_calloc( (n+1),record_size);
    else
	c = safe_array_realloc(p, (newmax+1), record_size);
    
    if (!c)
	return(0);
    
    /* We reserver in above (newmax+1) elements --
     * element c[newmax] must be always NULL so DestroyDynamicArray
     * works.
     */
    for (j = *max ; j <= newmax ; j++)
	c[j] = 0;
    
    *max = newmax;
    
    return(c);
}

void DestroyDynamicArray (p)
     void **p;
{
    void **b;
    
    if (!p)
	return;
    b = p;
    while (*b)
	free(*b++);
    free(p);
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
