static char rcsid[] = "@(#)$Id: getaddr.c,v 2.5 2014/07/14 15:07:26 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.5 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *
 *  Content (originally) partially moved from melib/parse_util.c 
 *  (however rfc822_reap_comments is now on mparse.c)
 *****************************************************************************/

#include "elm_defs.h"

DEBUG_VAR(Debug,__FILE__,"addr");

char **rfc822_tokenize(line) 
     const char *line;
{
    const char * ptr;
    char **res;
    int len, count = 0,i;
    
    DPRINT(Debug,25,(&Debug, 
		    "rfc822_tokenize(line=\"%s\n\"):\n",line));
    
    for (ptr = line; *ptr; ptr += len) {
	len = rfc822_toklen(ptr);
	count++;
    }
    DPRINT(Debug,25,(&Debug,
		     "rfc822_tokenize: count=%d\n",count));
    res = safe_malloc((count+1) * sizeof (char *));
    
    for (i = 0, ptr = line; 
	 i < count; 
	 i++, ptr += len) {
	len = rfc822_toklen(ptr);
	res[i] = safe_malloc(len+1);
	strncpy(res[i],ptr,len);
	res[i][len] = '\0';
	DPRINT(Debug,25,(&Debug,
			 "             : [%i]=\"%s\"\n",i,res[i]));
    }
    res[i] = NULL;
    DPRINT(Debug,25,(&Debug,
		     "             : [%i]=NULL\n",i));
    return res;
}

void remove_space_tokenized(tokenized)
     char ** tokenized;
{
    int ptr, ptr2 = 0;
    
    for (ptr = 0; tokenized[ptr]; ptr++) {
	if ('(' == tokenized[ptr][0] || whitespace(tokenized[ptr][0]) ||
	    '\n' == tokenized[ptr][0]) {
	    DPRINT(Debug,25,(&Debug, 
			     "remove_space_tokenized: FREE \t<= [%d] = \"%s\"\n",
			     ptr,tokenized[ptr]));
	    free(tokenized[ptr]);
	    tokenized[ptr] = NULL;
	} else {
	    DPRINT(Debug,25,(&Debug,
			     "remove_space_tokenized: [%d] \t<= [%d] = \"%s\"\n",
			     ptr2,ptr,tokenized[ptr]));
	    tokenized[ptr2] = tokenized[ptr];
	    if (ptr2 != ptr)
		tokenized[ptr] = NULL;
	    ptr2++;
	}
    }
    /* Check: */
    while (ptr2 <= ptr) {
	if (!tokenized[ptr2]) {
	    DPRINT(Debug,25,(&Debug,
			     "remove_space_tokenized: [%d] \t<= NULL\n",
			     ptr2));
	} else {
	    DPRINT(Debug,25,(&Debug,
			     "remove_space_tokenized: [%d] \t== \"%s\" ERROR!\n",
			     ptr2,tokenized[ptr2]));
	}
	ptr2++;
    }
}

void free_rfc822tokenized(res)
     char **res; 
{
    int i;
    for (i = 0; res[i]; i++) {
	DPRINT(Debug,100,(&Debug, 
			"free_rfc822tokenized: free(res[%d]=\"%s\")\n",
			i,res[i]));
	free(res[i]);
    }
    DPRINT(Debug,100,(&Debug, 
		    "free_rfc822tokenized: free(res)\n"));
    free(res);
}

static const unsigned char * csUs P_((const char *str));
static const unsigned char * csUs(str)
     const char *str;
{
    return (const unsigned char *)str;
}


void look_special_tokens(tokenized,tok_chars,
			start,ended,demime,set,
			comments,scanned) 
     char **tokenized;
     const char *tok_chars;
     int start; 
     int *ended;
     int demime;     
     charset_t set;
     struct string **comments;
     char ***scanned;
{
    int end;
    
    DPRINT(Debug,25,(&Debug, 
		     "look_special_tokens: start=%d, tok_chars=%s,*comments=%p\n", 
		     start,tok_chars,*comments));
  
    *scanned = NULL;
    
    DPRINT(Debug,25,(&Debug,
		     "look_special_tokens: "));
    
    for (end = start; tokenized[end]; end++) {
	if (NULL != strchr(tok_chars,tokenized[end][0]) &&
	    '\0' == tokenized[end][1])
	    break;
	DPRINT(Debug,25,(&Debug," [%d]=%s",end,tokenized[end]));
    }
    DPRINT(Debug,25,(&Debug,"\n"));

    if (!tokenized[end]) {
	DPRINT(Debug,25,(&Debug,"look_special_tokens: end=%d NO MATCH\n",end));
    } else {
	DPRINT(Debug,25,(&Debug,"look_special_tokens: end=%d MATCH=%s\n",
			 end,tokenized[end]));
    }

    if (end > start) {
	int count = end-start;
	int i, in_ptr,out_ptr;
	char **res;
	DPRINT(Debug,26,(&Debug,"look_special_tokens: count=%d\n",
			 count));
	
	res = safe_malloc((count+1) * sizeof (res[0]));
	for (i = 0; i <= count; i++)
	    res[i] = NULL;

	for (in_ptr=start, out_ptr=0;
	     in_ptr < end && out_ptr < count;
	     in_ptr++) {
	    if (whitespace(tokenized[in_ptr][0])) {
		if (*comments && string_len(*comments) && in_ptr < end-1)
		    add_ascii_to_string(*comments,csUs(tokenized[in_ptr]));
	    } else if ('(' == tokenized[in_ptr][0]) {
		struct string * tmp;

		char buffer[1000];
		int k, j = 0;

		for (k = 1; tokenized[in_ptr][k] && 
			 (tokenized[in_ptr][k] != ')' || tokenized[in_ptr][k+1]) &&
			 j < sizeof buffer -1; k++)
		    buffer[j++] = tokenized[in_ptr][k];
		buffer[j] = '\0';

		tmp = hdr_to_string(HDR_COMMENT,buffer,set,demime);
		
		append_string(comments,tmp,1);
		free_string(&tmp);

	    } else
		res[out_ptr++] = safe_strdup(tokenized[in_ptr]);       
	}

	DPRINT(Debug,26,(&Debug,"look_special_tokens: real count=%d, scanned:",
			 out_ptr));

	for (i = 0; i < out_ptr; i++) {
	    DPRINT(Debug,26,(&Debug," [%d]=%s",i,res[i]));
	}
	*scanned=res;

	DPRINT(Debug,26,(&Debug,
			 "\nlook_special_tokens: *scanned=%p, *comments=%S\n",
			 *scanned,*comments));
    }
    if (ended)
	*ended = end;

}

struct string * scanned_to_phrase P_((char **scanned,
				      int demime, charset_t set));

struct string *scanned_to_phrase(scanned,demime,set)
     char * *scanned;
     int demime;
     charset_t set;
{
    struct string * res = NULL;
    char * buffer = NULL;
    int idx, max_idx;
    const char * A UNUSED_VAROK;
    const char * B UNUSED_VAROK;

    DPRINT(Debug,25,(&Debug, "scanned_to_phrase: demime=%d\n",demime));
    DPRINT(Debug,25,(&Debug, 
		    "scanned_to_phrase:"));
    for (max_idx  = 0; scanned[max_idx]; max_idx++) {
	DPRINT(Debug,25,(&Debug, 
			" [%d]=%s",max_idx,scanned[max_idx]));
    }
    DPRINT(Debug,25,(&Debug, 
		    "\n"));

    for (idx  = 0; idx < max_idx; idx++) {
	if (buffer)
	    buffer = strmcat(buffer," ");
	buffer = strmcat(buffer,scanned[idx]);	
    }
    
    if (buffer) {
	res = hdr_to_string(HDR_PHRASE,buffer,set,demime);
	free(buffer);
    } else
	res = new_string(set);

    DPRINT(Debug,25,(&Debug, "scanned_to_phrase=%S\n",res));
    A = get_string_MIME_name(res);
    B = get_string_lang(res);
    DPRINT(Debug,25,(&Debug, "                  cs=%s lang=%s\n",
		     A ? A : "<none>", B ? B : "<none>"));

    return res;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
