case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh

    ;;
esac

case "$subdir" in
'')
    case "$0" in
    */*) cd `expr X$0 : 'X\(.*\)/'` ;;
    esac	    

    vpathdef="#VPATH	= "
    XXsrc="."
    XXsrcroot="../.."
    ;;
*)
    vpathdef="VPATH	=	$source_dir/$subdir"
    XXsrc="$source_dir/$subdir"
    XXsrcroot="$source_dir"
    ;;
esac

case "$d_dlopen_libs" in
define)  sharedobj="shared_mailer.o"
	 ;;
*)	  sharedobj=
	;;
esac

echo "Extracting lib/mailer/Makefile (with variable substitutions)"
$cat >Makefile <<!GROK!THIS!
#!$make
#
# $Id: Makefile.SH,v 2.16 2020/05/22 06:15:54 hurtta Exp $
#
#  Makefile for the ELM ME+ mail program.
#
#  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
#                  (was hurtta+elm@posti.FMI.FI)
#       or Kari Hurtta <elm@elmme-mailer.org>
#
#
AR		=	$ar
CC		=	$cc
CCFLAGS		=	$ccflags $picflag $xencf
LFLAGS		=	$ldflags $backtrace_opt $xenlf
CP		=	$cp
RM              =       $rm -f
MV              =       $mv
OPTIMIZE	=	$optimize
RANLIB		=	$ranlib
TOUCH           =       $touch
CHMOD           =       $chmod
REG             =       ../../bin/elmregister 

SHAREDOBJ	=	$sharedobj
$vpathdef
SRC		=	$XXsrc
SRCROOT		=	$XXsrcroot

!GROK!THIS!


if $test "$d_shared" = "$define" ; then
   A=
   if $test "$soname_include_path" = y ; then
	A="$shlib/"
   fi

cat >>Makefile <<SUBSTITUTE
INSTLIB		= \$(ELM_ROOT)//$shlib/libelmme-mailer.so$d_shared_rev
SONAME          = ${soname_opt}${A}libelmme-mailer.so$d_shared_rev
SOTARG          = ../../shlib/libelmme-mailer.so

SUBSTITUTE

else

cat >>Makefile <<'!NO!SUBS!'
INSTLIB         =
SONAME		=
SOTARG          =

!NO!SUBS!

fi

$cat >>Makefile <<'!NO!SUBS!'
IHDR		=	../../hdrs
CFLAGS		=	-I$(IHDR) -I$(INCLDIR) $(CCFLAGS) $(OPTIMIZE)
INCLDIR		=	$(SRCROOT)/hdrs
OBJS            =       mailer.o outheaders.o $(SHAREDOBJ) init.o  mime_encode.o \
			message-id.o write_common.o feed_common.o senderhelper.o

all:	Makefile ../../libs/libelmme-mailer.a $(SOTARG)
install_s: all $(INSTLIB)

uninstall_s:
	$(REG) rm $(INSTLIB)
	
clean: 
	$(RM) $(OBJS) ../../shlib/libelmme-mailer.so ../../libs/libelmme-mailer.a

.PRECIOUS: $(IHDR)/elm_defs.h $(IHDR)/defs_major.h def_mailer.h

$(IHDR)/elm_defs.h:	$(IHDR)/defs_major.h $(INCLDIR)/elm_nl_types.h \
 $(INCLDIR)/elmlib.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

$(IHDR)/defs_major.h: ../../config.h $(IHDR)/sysdefs.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

def_mailer.h: $(IHDR)/elm_defs.h $(INCLDIR)/mailerlib.h \
 $(INCLDIR)/addrlib.h  $(INCLDIR)/schedule_time.h
	cmp $(SRC)/$@ $@ 2>/dev/null || $(CP) $(SRC)/$@ $@
	$(CHMOD) u+w $@
	$(TOUCH) $@

Makefile: Makefile.SH ../../config.sh 
	@echo "You must run 'sh Configure -S' or 'sh Configure'"
	exit 1

tags:

clean:		

init.o: def_mailer.h $(INCLDIR)/hdr_imp.h $(INCLDIR)/save_opts.h \
 $(INCLDIR)/rc_imp.h $(INCLDIR)/shared_imp.h $(INCLDIR)/s_elm.h

mailer.o: def_mailer.h $(INCLDIR)/s_elm.h $(INCLDIR)/mailer_imp.h $(INCLDIR)/shared_imp.h

outheaders.o: def_mailer.h $(INCLDIR)/s_me.h $(INCLDIR)/hdr_imp.h 

shared_mailer.o: def_mailer.h $(INCLDIR)/mailer_imp.h \
 $(INCLDIR)/shared_imp.h $(INCLDIR)/rc_imp.h $(INCLDIR)/save_opts.h

mime_encode.o: def_mailer.h

message-id.o: def_mailer.h $(INCLDIR)/s_me.h

write_common.o: def_mailer.h

feed_common.o: def_mailer.h

senderhelper.o: def_mailer.h $(INCLDIR)/s_elm.h $(INCLDIR)/s_me.h

../../libs/libelmme-mailer.a: $(OBJS)
	$(AR) r $@ $?
	$(RANLIB) $@

!NO!SUBS!

if $test "$d_shared" = "$define" ; then

cat >>Makefile <<'!NO!SUBS!'

../../shlib/libelmme-mailer.so: $(OBJS)
	$(CC) $(LFLAGS) $(SONAME) -o $@ $(OBJS) 

$(INSTLIB): ../../shlib/libelmme-mailer.so
	$(REG) copy -m 644 $? $@

!NO!SUBS!

else

cat >>Makefile <<'!NO!SUBS!'

!NO!SUBS!

fi

