case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh
    ;;
esac

case "$subdir" in
'')
    case "$0" in
    */*) cd `expr X$0 : 'X\(.*\)/'` ;;
    esac	    

    vpathdef="#VPATH	= "
    XXsrc="."
    XXsrcroot="../.."
    ;;
*)
    vpathdef="VPATH	=	$source_dir/$subdir"
    XXsrc="$source_dir/$subdir"
    XXsrcroot="$source_dir"
    ;;
esac

case "$d_dlopen_libs" in
define)  sharedobj="shared_mbox.o"
	 ;;
*)	 sharedobj=
	;;
esac

echo "Extracting lib/mbox/Makefile (with variable substitutions)"
$cat >Makefile <<!GROK!THIS!
#!$make
#
# $Id: Makefile.SH,v 2.18 2024/06/10 18:05:34 hurtta Exp $
#
#  Makefile for the ELM (ME+) mail program.
#
#  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
#                  (was hurtta+elm@posti.FMI.FI)	   
#      or  Kari Hurtta <elm@elmme-mailer.org>
#
#
#
AR		=	$ar
CC		=	$cc
CCFLAGS		=	$ccflags $picflag $xencf
LFLAGS		=	$ldflags $backtrace_opt $xenlf
CP		=	$cp
RM              =       $rm -f
MV              =       $mv
LN              =       $ln
OPTIMIZE	=	$optimize
RANLIB		=	$ranlib
TOUCH           =       $touch
CHMOD           =       $chmod
REG             =       ../../bin/elmregister 

SHAREDOBJ	=	$sharedobj
$vpathdef
SRC		=	$XXsrc
SRCROOT		=	$XXsrcroot

!GROK!THIS!

if $test "$make_sets_make" != "$define" ; then  

        cat >>Makefile <<!GROK!THIS!
MAKE            =       $make
!GROK!THIS!

fi

if $test "$d_shared" = "$define" ; then
   A=
   if $test "$soname_include_path" = y ; then
	A="$shlib/"
   fi

cat >>Makefile <<SUBSTITUTE
INSTLIB		= \$(ELM_ROOT)//$shlib/libelmme-mbox.so$d_shared_rev
SONAME          = ${soname_opt}${A}libelmme-mbox.so$d_shared_rev
SOTARG          = ../../shlib/libelmme-mbox.so

SUBSTITUTE

else

cat >>Makefile <<'!NO!SUBS!'
INSTLIB         =
SONAME		=
SOTARG          = 
!NO!SUBS!

fi

$cat >>Makefile <<'!NO!SUBS!'
IHDR		=	../../hdrs
CFLAGS		=	-I$(IHDR) -I$(INCLDIR) $(CCFLAGS) $(OPTIMIZE)
INCLDIR		=	$(SRCROOT)/hdrs
OBJS            =       $(SHAREDOBJ) init.o mbox.o localmbx.o \
 savefolder.o imap.o pop.o remote_mbx.o mk_lockname.o realfrom.o \
 forwarded.o header_cmp.o state.o headers.o expires.o parsarpdat.o \
 mbox_generic.o common_local.o remote_server.o connection.o \
 con_imap.o hashmark.o commentfile.o hashmark_local.o \
 hashmark_remote.o hashmark_browser.o hashmark_helper.o \
 quota.o imap_quota.o utime_util.o filelock.o last_read.o

all:	Makefile ../../libs/libelmme-mbox.a $(SOTARG)
install_s: all $(INSTLIB)

uninstall_s:
	$(REG) rm $(INSTLIB)

clean: 
	rm -f $(OBJS) ../../shlib/libelmme-mbox.so ../../libs/libelmme-mbox.a

.PRECIOUS: $(IHDR)/elm_defs.h $(IHDR)/defs_major.h def_mbox.h

$(IHDR)/elm_defs.h:	$(IHDR)/defs_major.h $(INCLDIR)/elm_nl_types.h \
 $(INCLDIR)/elmlib.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

$(IHDR)/defs_major.h: ../../config.h $(IHDR)/sysdefs.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

def_mbox.h: $(IHDR)/elm_defs.h  \
 $(INCLDIR)/mbx_imp.h $(INCLDIR)/connection_imp.h \
 $(INCLDIR)/mime.h $(INCLDIR)/mboxlib.h \
 $(INCLDIR)/addrlib.h $(INCLDIR)/schedule_time.h
	cmp $(SRC)/$@ $@ 2>/dev/null || $(CP) $(SRC)/$@ $@
	$(CHMOD) u+w $@
	$(TOUCH) $@

Makefile: Makefile.SH ../../config.sh 
	@echo "You must run 'sh Configure -S' or 'sh Configure'"
	exit 1

lint:		

tags:

clean:		

../misc/commentfile.o:
	cd ../misc; $(MAKE) $(MJ) $(MFLAGS) commentfile.o
commentfile.o: ../misc/commentfile.o
	$(LN) -f ../misc/$@ $@ || $(CP) ../misc/$@ $@

../misc/filelock.o:
	cd ../misc; $(MAKE) $(MJ) $(MFLAGS) filelock.o
filelock.o: ../misc/filelock.o
	$(LN) -f ../misc/$@ $@ || $(CP) ../misc/$@ $@

init.o: def_mbox.h $(INCLDIR)/hdr_imp.h $(INCLDIR)/save_opts.h \
 $(INCLDIR)/rc_imp.h $(INCLDIR)/shared_imp.h $(INCLDIR)/state_imp.h \
 $(INCLDIR)/s_me.h
con_imap.o: def_mbox.h $(INCLDIR)/ss_imp.h $(INCLDIR)/mbximap_imp.h \
  $(INCLDIR)/s_me.h
hashmark.o: def_mbox.h  $(INCLDIR)/hashmark.h $(INCLDIR)/rc_imp.h \
 $(INCLDIR)/s_me.h $(INCLDIR)/s_elm.h $(INCLDIR)/hashmark_imp.h \
 $(INCLDIR)/commentfile.h
hashmark_browser.o: def_mbox.h $(INCLDIR)/hashmark.h $(INCLDIR)/s_me.h
hashmark_helper.o: def_mbox.h $(INCLDIR)/hashmark.h $(INCLDIR)/hashmark_imp.h
hashmark_local.o: def_mbox.h $(INCLDIR)/hashmark.h \
 $(INCLDIR)/hashmark_imp.h $(INCLDIR)/s_me.h  $(INCLDIR)/rc_imp.h
hashmark_remote.o: def_mbox.h $(INCLDIR)/hashmark.h  \
 $(INCLDIR)/hashmark_imp.h $(INCLDIR)/s_me.h $(INCLDIR)/rc_imp.h \
 $(INCLDIR)/s_elm.h  $(INCLDIR)/ss_imp.h
mbox.o:	def_mbox.h $(INCLDIR)/s_elm.h $(INCLDIR)/s_me.h \
  $(INCLDIR)/shared_imp.h $(INCLDIR)/mime.h $(INCLDIR)/quota_imp.h
localmbx.o: def_mbox.h $(INCLDIR)/s_elm.h $(INCLDIR)/s_me.h \
  $(INCLDIR)/fbrowser.h $(INCLDIR)/mbxlocal_imp.h $(INCLDIR)/filelock.h
mbox_generic.o: def_mbox.h
savefolder.o: def_mbox.h $(INCLDIR)/s_me.h $(INCLDIR)/mbxlocal_imp.h \
  $(INCLDIR)/hashmark.h
imap.o: def_mbox.h $(INCLDIR)/s_elm.h $(INCLDIR)/s_me.h $(INCLDIR)/ss_imp.h \
 $(INCLDIR)/mbximap_imp.h
imap_quota.o: def_mbox.h $(INCLDIR)/quota_imp.h $(INCLDIR)/mbximap_imp.h
pop.o: def_mbox.h $(INCLDIR)/s_elm.h $(INCLDIR)/s_me.h $(INCLDIR)/ss_imp.h
remote_mbx.o: def_mbox.h $(INCLDIR)/s_elm.h $(INCLDIR)/s_me.h \
 $(INCLDIR)/shared_imp.h $(INCLDIR)/ss_imp.h
remote_server.o: def_mbox.h $(INCLDIR)/s_me.h $(INCLDIR)/mbxlocal_imp.h
mk_lockname.o: def_mbox.h
realfrom.o: def_mbox.h $(INCLDIR)/s_elm.h 
forwarded.o: def_mbox.h
header_cmp.o: def_mbox.h
shared_mbox.o: def_mbox.h  $(INCLDIR)/shared_imp.h \
 $(INCLDIR)/rc_imp.h $(INCLDIR)/save_opts.h $(INCLDIR)/cs_imp.h  \
 $(INCLDIR)/ss_imp.h 
state.o: def_mbox.h  $(INCLDIR)/state_imp.h $(INCLDIR)/pg_range_imp.h
headers.o: def_mbox.h $(INCLDIR)/hdr_imp.h $(INCLDIR)/s_me.h
expires.o: def_mbox.h
parsarpdat.o: def_mbox.h
common_local.o: def_mbox.h $(INCLDIR)/mbxlocal_imp.h $(INCLDIR)/s_me.h
connection.o: def_mbox.h $(INCLDIR)/ss_imp.h 
quota.o: def_mbox.h $(INCLDIR)/quota_imp.h
utime_util.o: def_mbox.h
last_read.o: def_mbox.h $(INCLDIR)/mbxlocal_imp.h $(INCLDIR)/s_me.h \
 $(INCLDIR)/filelock.h $(INCLDIR)/commentfile.h

../../libs/libelmme-mbox.a: $(OBJS)
	$(AR) r $@ $?
	$(RANLIB) $@

!NO!SUBS!

if $test "$d_shared" = "$define" ; then

cat >>Makefile <<'!NO!SUBS!'

../../shlib/libelmme-mbox.so: $(OBJS)
	$(CC) $(LFLAGS) $(SONAME) -o $@ $(OBJS) 

$(INSTLIB): ../../shlib/libelmme-mbox.so
	$(REG) copy -m 644 $? $@

!NO!SUBS!

else

cat >>Makefile <<'!NO!SUBS!'

!NO!SUBS!

fi

