/* $Id: def_mbox.h,v 2.24 2024/06/23 07:38:36 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.24 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "elm_defs.h"
#include "schedule_time.h"
#include "connection_imp.h"

#include "addrlib.h"
#include "mboxlib.h"
#include "mbx_imp.h"

#include "mime.h"


#ifdef USE_DLOPEN
extern SHAREDLIB use_shared_mbox;
#endif

extern FLAGS last_read_fbck_locking;

extern struct out_state_type state_out_dir;


extern void remote_server_dec_dir P_((struct folder_browser *browser));
extern void remote_server_inc_dir P_((struct folder_browser *browser,
				      const struct remote_server *server));

extern struct remote_server  * const LOCAL_SERVER;   /* static, not alloced dynamically */

extern struct remote_server_type * const POP_SERVER_TYPE;
extern struct remote_server_type * const IMAP_SERVER_TYPE;

extern void remove_remote_server_from_folder P_((struct folder_info   * folder,
						 struct remote_server * server));
extern struct remote_server * give_remote_server_from_folder P_((struct folder_info        * folder,
								 struct remote_server_type * t,
								 struct browser_passhm     * passhm));


extern void remove_remote_server_from_connection P_((struct connection_cache * con,
						     struct remote_server    * server));
extern struct remote_server * give_remote_server_from_connection P_((struct connection_cache   * con,
								     struct remote_server_type * t,
								     struct browser_passhm     * passhm));


/* remote_server.c */

extern struct browser_type remote_browser;

extern void remote_browser_failure P_((struct folder_browser *dir)); 
extern int change_remote_browser_server P_((struct folder_browser *dir));

extern struct remote_server * remote_browser_server P_((struct folder_browser *dir));

extern struct browser_type
 * remote_server_real_type P_((struct remote_server *server));

extern int connect_remote_server_to_browser P_((
   struct remote_server *server,
   struct folder_browser *dir));


/* savefolder.c */

extern struct browser_type dummy_browser;

extern void dummy_browser_set_remote P_((struct folder_browser *dir,
					 const char *remote /* may be NULL */,
					 struct browser_passhm *passhm));

#if 0
extern const char * dummy_browser_get_remote P_((struct folder_browser *dir));
#endif


/* 0 == new type is same than old
 * 1 == type is changed
 */
extern int change_folder_browser_type P_((struct folder_browser *dir,
					  struct browser_type *new_type));

extern void malloc_keep_browser_write_state P_((WRITE_STATE * ptr));
extern void free_keep_browser_write_state P_((WRITE_STATE * ptr));

/* pop.c */

extern struct remote_account *set_pop_connection P_((struct folder_info    *fh,
						     struct remote_account *X,
						     struct browser_passhm *passhm ));

extern const struct remote_account * give_pop_remote_account P_((struct folder_info *fh));

/* increments refcount of passhm */
extern void pop_mbx_set_passhm P_((struct folder_info *fh,
				   struct browser_passhm * passhm));


/* connection.c */

extern const struct remote_account * give_con_remote_account P_((struct connection_cache *c));

extern void connection_set_reset_quota P_((struct connection_cache * con,
					   struct mail_quota       * quota));

/* imap.c */

extern struct remote_account *set_imap_connection P_((struct folder_info    *fh,
						      struct remote_account *X,
						      struct browser_passhm *passhm));

struct remote_account *set_imap_connection_C P_((struct folder_info *fh,
						 struct connection_cache * CX,
						 struct browser_passhm *passhm));

extern struct connection_cache *give_imap_connection P_((struct folder_browser *dir));

/* increments refcount of passhm */
extern void imap_browser_set_passhm P_((struct folder_browser *dir,
					struct browser_passhm  * passhm));

/* increments refcount of passhm */
extern void imap_mbx_set_passhm P_((struct folder_info *fh,
				   struct browser_passhm * passhm));

extern int imap_same_host_user_nopath P_((const struct folder_info *fh,
					  const struct remote_account *ra2));

/* savefolder.c */

extern int change_dir_helper P_((struct folder_browser *dir,
				 struct string **buffer));

extern int valid_browser P_((struct browser_type    * type));

extern int select_dir_item_helper P_((struct folder_browser *dir,
				      struct string **buffer,
				      int *newpos));

/* mbox_generic.c */


#if ANSI_C
#define E_(x) extern x;
#else
#define E_(x)
#endif

/* Returns 1 if changed,
   -1 error
 */
E_(browser_reset_filter_dir browser_reset_filter_generic)
extern int browser_reset_filter_generic P_((struct folder_browser *dir));

E_(browser_select_idx_dir browser_select_idx_generic)
extern int browser_select_idx_generic P_((struct folder_browser *dir,
					struct name_vector *entry,
					struct string **buffer));


/* Increments refcount */
E_(browser_gethm_name_vector_dir browser_gethm_name_vector_null)
extern struct hashmark_item *
    browser_gethm_name_vector_null P_((struct folder_browser * dir,
					  struct name_vector    * entry));

/* Returns 1 if hashmark saved
   Increments refcount, if hashmark saved */
E_(browser_sethm_name_vector_dir browser_sethm_name_vector_null)
extern int browser_sethm_name_vector_null P_((struct folder_browser * dir,
						 struct name_vector    * entry,
						 struct hashmark_item  * hm
						 ));

E_(mbx_comp_prev_hdr_folder mbx_comp_prev_hdr_default)
extern enum comp_prev_hdr_result
     mbx_comp_prev_hdr_default P_((struct folder_info * folder,
				   struct header_rec  * entry,
				   struct header_rec  * prev_entry,
				   RECONNECT_MODE    reconnect_mode_ptr));

E_(mbx_update_prev_hdr_folder mbx_update_prev_hdr_default)
extern void mbx_update_prev_hdr_default
              P_((struct folder_info * folder,
		  struct header_rec  * entry,
		  struct header_rec  * prev_entry,
		  RECONNECT_MODE    reconnect_mode_ptr,
		  READ_STATE        read_state_ptr
		  ));

E_(mbx_have_folder_quota  mbx_have_default_quota)
extern struct mail_quota * mbx_have_default_quota P_((struct folder_info * folder));

E_(mbx_give_folder_quotar_list mbx_give_default_quotar_list)
extern struct mail_quotaroot_list * mbx_give_default_quotar_list P_((struct folder_info * folder,
								     struct mail_quota   * mq,
	      struct cancel_data  * cd /* Allow cancelation (Ctrl-C) on remote mailbox */,
								     enum quota_mode refresh

								     ));

E_(mbx_give_message_msize_folder  mbx_give_message_msize_default)
extern int mbx_give_message_msize_default P_((struct folder_info * folder,
					  struct header_rec  * entry,
					  unsigned long      * ret_size));

/* Return -1 if not available (local mail) */
E_(mbx_give_message_count_folder mbx_give_message_count_default)
int mbx_give_message_count_default P_((struct folder_info * folder));


extern int sessionlock_create_tempfolder P_((struct folder_info *folder,
					     int *errcode /* errno */));



/* con_map.c */

extern int imap_handle_greeting P_((struct connection_cache *con));

/* last_read.c */

/* Increments refcount - may change or open new cache 
   does not reload cache if directory is corrent 
*/
extern struct last_read_cache * upgrade_last_read P_((struct last_read_cache * dir_last_read,
						      const char        * stat_file,
						      struct stat * stat_buf));

/* Decrements refcount */
extern void free_last_read_cache P_((struct last_read_cache ** dir_last_read));

/* Cache assumed to point correct directory */
extern int have_last_read P_((struct last_read_cache * this_last_read,
			      const char             * pathname,
			      struct stat            * file_stat,
			      time_t                 * last_read_time));

/* Posible allocates new, decrement old refcount if name is changed */
extern int update_last_read P_((struct last_read_cache ** dir_last_read,
				 const char * sys_dir));

/* Write struct last_read_cache if modified */
extern void flush_last_read P_((struct last_read_cache * dir_last_read));

/* Flag local entries and matching with sys_dir prefix */
extern void flag_last_read P_((struct last_read_cache * dir_last_read,
			       const char * sys_dir,
			       const char * entryname));

/* deletes not flagged local entries (and absolute path entries
   matchig with sys_dir prefix) */
extern void purge_last_read P_((struct last_read_cache * dir_last_read,
				const char * sys_dir
				));


/* Increments refcount */
extern struct last_read_cache * last_read_enabled
  P_((enum use_lastread_v use_lastread,
      char             * cur_folder_sys,
      struct stat      * oldstat,
      struct stat      * curstat));


E_(free_rc_hook free_last_read)
extern void free_last_read P_((void));

/* system init hook */
E_(init_default_hook init_last_read_defaults)
extern void init_last_read_defaults P_((int *errors));


/* User init hook */
E_(init_default_hook last_read_rc_file)
extern void last_read_rc_file P_((int *errors));

/* Writes cache */

extern void mark_last_read P_((struct last_read_cache * cache,
			       char                   * cur_folder_sys,
			       struct stat            * curstat));

/* common_local.c */

extern int local_selection_stat P_((const char * str,
				    struct last_read_cache * dir_last_read));


/* localmbx.c */

extern const struct remote_server * mbx_give_normal_server P_((struct folder_info *folder));
extern void adjust_content_remaining P_((long *content_remaining, int len));

extern void zero_FILE_rs P_((struct FILE_rs *rs));
extern void clear_FILE_rs P_((struct FILE_rs *rs));

/* result is malloced */
extern char * cat_dir_entry P_((const char *sys_dir,const char *entryname));

/* dir->a.local_browser->this_last_read */
extern struct last_read_cache *browser_local_last_read P_((struct folder_browser *dir));

/* remote_mbx.c */

extern int same_remote_account_host_user P_((const struct remote_account *ra1,
					     const struct remote_account *ra2));

extern int remote_account_match P_((const struct remote_account *ra, 
				    const char *username, const char *host));

extern enum prepare_reconnect_res {
    prepare_reconnect_fail = -1   /* Fail mbx_prepare_read_* */,
    prepare_reconnect_none = 0    /* Continue without reconnect */,
    prepare_reconnect_ok          /* cur_tempfolder moved to reconnect_ptr */
	} mbx_prepare_read_reconnect P_((struct folder_info *folder,
					 RECONNECT_MODE reconnect_ptr,
					 struct remote_account *X
					 ));
					 
enum remote_login_kw { rlogin_IMAP,
		       rlogin_POP };

extern void mbx_remote_login_msg P_((struct remote_account *C,
				     enum remote_login_kw t));
				     
/* hashmark.c */

extern const unsigned char hashmark_RESERVED_SEPARATOR[];

/* hashmark_browser.c */

extern struct browser_type hashmark_browser;

extern int hashmark_browser_passthru_change P_((struct folder_browser *dir,
						struct hashmark_item *item,
						struct string **dispname));

extern void set_hashmark P_((struct name_vector    *entry,
			     struct hashmark_item *item));

/* hashmark_remote.c */
extern void free_usermap_files P_((void));

/* mbox.c */
extern struct reconnect_mode * malloc_reconnect_mode P_((void));

/* quota.c */

extern void mail_quota_unlink_con P_((struct mail_quota *quota,
				      struct connection_cache *con));

/* imap_quota.c */

extern void init_imap_quota_mbx P_((struct connection_cache * con));
extern void parse_imap_quotaroot P_((struct mail_quota * quota,
				     struct imap_token   quotaroot_params[],
				     int                 quotaroot_param_count));
extern void parse_imap_quota P_((struct mail_quota * quota,
				 struct imap_token   quota_params[],
				 int                 quota_param_count));

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
