static char rcsid[] = "@(#)$Id: forwarded.c,v 2.6 2017/11/18 16:49:26 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.6 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 * This function is originally from Elm 2.4 utils/newmail.c and 
 * src/addr_util.c. Combined result is however totally
 * rewritten.
 *
 * Original code have following copyright:
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

#include "def_mbox.h"

DEBUG_VAR(Debug,__FILE__,"mbox");

void forwarded(buffer, entry)
     char *buffer;
     struct header_rec *entry;
{
    /** change 'from' and date fields to reflect the ORIGINATOR of 
	the message by iteratively parsing the >From fields...
	The leading >From will already be stripped off the line. **/

    char machine[SLEN], who[SLEN], work[SLEN];
    int count, pointer;
    enum env_from_source_v e = 
	give_dt_enumerate_as_int(&env_from_source);

    machine[0] = '\0';
    who[0]='\0';
	
    DPRINT(Debug,7,(&Debug, 
		    "forwarded: buffer=%s, env_from_source=%d\n",
		    buffer,e));

    /* env_from_source:      
       0 == forward-from,
       1 == from,
       2 == return-path
    */

    if (e <= env_source_forward_from) {
	for (count = 0, pointer=0; 
	     count < 10; 
	     count++) {
	    if (-1 == (pointer = get_word(buffer,pointer,work, sizeof work)))
		break;
	    DPRINT(Debug,7,(&Debug, 
			    "forwarded: count=%d, work=%s\n",count,work));
	    switch(count) {
	    case 0: strfcpy(who,work, sizeof who); 
		
		if (!parse_arpa_date(buffer+pointer, entry)) {
		    DPRINT(Debug,7,(&Debug,  "forwarded: fail!\n"));
		    return;
		}
		break;
		
		/* try for srm address */
	    case 7: strfcpy(machine,work, sizeof machine); break;
		
		/* try for address with timezone in date */
	    case 8: strfcpy(machine,work, sizeof machine); break;
		
		/* normal case? */
	    case 9: strfcpy(machine,work, sizeof machine); break;
	    }
	}
	
	if (qstrpbrk(who,"@!") != NULL) {
	    strfcpy(entry->env_from, who, sizeof (entry->env_from));
	} else if (machine[0] == '\0') {
	    DPRINT(Debug,7,(&Debug, "forwarded: fail!\n"));
	    return;
	}
	else 
	    elm_sfprintf(entry->env_from,sizeof (entry->env_from),
			 FRM("%s!%s"), 
			 machine, who);
	
	DPRINT(Debug,7,(&Debug,
			"forwarded, setting env_from=%s\n",entry->env_from));
    }
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
