static char rcsid[] = "@(#)$Id: hashmark_helper.c,v 2.5 2022/02/12 14:00:06 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.5 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *       or Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_mbox.h"
#include "hashmark.h"
#include "hashmark_imp.h"

DEBUG_VAR(Debug,__FILE__,"mbox");

struct browser_passhm * new_browser_passhm(item,from_address,
					   need_cert_check,contype)
     struct hashmark_item      * item;
     struct address            * from_address;
     enum hmcert                  need_cert_check;
     enum hmcon                   contype;
{
    struct browser_passhm *ret = safe_zero_alloc(sizeof (*ret));


    ret->item = item;
    if (ret->item)
	inc_hashmark_item_refcount(ret->item);

    ret->from_address = from_address ? dup_address(from_address) : NULL;


    ret->contype  = contype;  /* for messages */
    ret->refcount = 1;
    ret->magic    = BROWSER_PASSHM_magic;

    return ret;
}


void free_browser_passhm(passhm)
     struct browser_passhm **passhm;
{
    if (BROWSER_PASSHM_magic != (*passhm)->magic)
	panic("CONNECTION PANIC",__FILE__,__LINE__,
	      "free_browser_passhm",
              "Bad magic number",0);

    if ((*passhm)->refcount < 1)
	panic("CONNECTION PANIC",__FILE__,__LINE__,
	      "free_browser_passhm",
	      "Bad refcount",0);

    (*passhm)->refcount--;

    if ((*passhm)->refcount > 0) {  /* Do not free */

        (*passhm) = NULL;           /* Refefence count for this pointer is decrement, */
                                  /* so this must have be reset */
        return;	
    }

    if ((*passhm)->item) 
	free_hashmark_item(& ((*passhm)->item)); /* decrement refcount */

    if ((*passhm)->from_address)
	free_address(& ((*passhm)->from_address));

    (*passhm)->magic = 0;  /* invalidate*/
    free(*passhm);
    *passhm = NULL;
}

void inc_browser_passhm_refcount(passhm)
     struct browser_passhm *passhm;
{
    if (BROWSER_PASSHM_magic != passhm->magic)
	panic("CONNECTION PANIC",__FILE__,__LINE__,
	      "inc_browser_passhm_refcount",
              "Bad magic number",0);

    passhm->refcount++;
}

#ifdef REMOTE_MBX
int browser_passhm_verify_ra_con(passhm,C)
     struct browser_passhm *passhm;
     struct remote_account *C;
{
    int ret = 0;

    if (BROWSER_PASSHM_magic != passhm->magic)
	panic("CONNECTION PANIC",__FILE__,__LINE__,
	      "browser_passhm_verify_ra_con",
              "Bad magic number (browser_passhm)",0);

    if (REMOTE_ACCOUNT_magic != C->magic)
	panic("CONNECTION PANIC",__FILE__,__LINE__,
	      "browser_passhm_verify_ra_con",
              "Bad magic number (remote_account)",0);

    if (passhm->item) {

	ret = hashmark_passhm_verify_ra_con(passhm->item,
					    passhm,C);
				   
    } else if (passhm->need_cert_check < hmcert_ok) {
	DPRINT(Debug,10,(&Debug,
			 "browser_passhm_verify_ra_con: No hashmark item, need_cert_check=%d (failure)\n",
			 passhm->need_cert_check));			     

	    
    } else {
	DPRINT(Debug,10,(&Debug,
			 "browser_passhm_verify_ra_con: No hashmark item, need_cert_check=%d (ok)\n",
			 passhm->need_cert_check));			     
	ret = 1;
    }

    DPRINT(Debug,10,(&Debug,"browser_passhm_verify_ra_con=%d\n",ret));

    return ret;
}


/* -1 == use fallback ;  
   caller does remote_account_init_tls()
 */
int browser_passhm_open_ra(passhm,ra,default_portlist,
			   give_service_entry_flag,
			   force_port)
     struct browser_passhm * passhm;
     struct remote_account * ra;
     const PORTS default_portlist[];
     int give_service_entry_flag;
     PORTS force_port;
{
    int ret = 0;


    if (BROWSER_PASSHM_magic != passhm->magic)
	panic("CONNECTION PANIC",__FILE__,__LINE__,
	      "browser_passhm_open_ra",
              "Bad magic number (browser_passhm)",0);
    
    if (REMOTE_ACCOUNT_magic != ra->magic)
	panic("CONNECTION PANIC",__FILE__,__LINE__,
	      "browser_passhm_open_ra",
              "Bad magic number (remote_account)",0);


    if (passhm->item) {

	ret =  hashmark_passhm_open_ra(passhm->item,
				       passhm,ra,default_portlist,
				       give_service_entry_flag,
				       force_port);

    } else 
	ret = -1;

    DPRINT(Debug,10,(&Debug,"browser_passhm_open_ra=%d\n",ret));

    return ret;
}

/* -1 == use fallback ;  
   caller does remote_account_init_tls()
 */
int browser_passhm_open_ra2(passhm,ra,give_service_entry_flag,est)
     struct browser_passhm * passhm;
     struct remote_account * ra;
     int give_service_entry_flag;
     
     /* For enumerate_service_type */
     struct enum_service_type *est;
{
    int ret = 0;

    if (BROWSER_PASSHM_magic != passhm->magic)
	panic("CONNECTION PANIC",__FILE__,__LINE__,
	      "browser_passhm_open_ra",
              "Bad magic number (browser_passhm)",0);
    
    if (REMOTE_ACCOUNT_magic != ra->magic)
	panic("CONNECTION PANIC",__FILE__,__LINE__,
	      "browser_passhm_open_ra",
              "Bad magic number (remote_account)",0);


    if (passhm->item) {

	ret =  hashmark_passhm_open_ra2(passhm->item,
					passhm,ra,
					give_service_entry_flag,
					est);
    } else 
	ret = -1;

    DPRINT(Debug,10,(&Debug,"browser_passhm_open_ra2=%d\n",ret));

    return ret;        
}
#endif

int browser_passhm_check_type(passhm,contype)
     const struct browser_passhm *passhm;
     const enum hmcon contype;
{
    int ret;

    if (BROWSER_PASSHM_magic != passhm->magic)
	panic("CONNECTION PANIC",__FILE__,__LINE__,
	      "browser_passhm_check_type",
              "Bad magic number (browser_passhm)",0);

    ret =  contype == passhm->contype;

    DPRINT(Debug,10,(&Debug,"browser_passhm_check_type=%d: passhm type = %d %s required type = %d\n",
		     ret,
		     passhm->contype,
		     ret ? "==" : "<>",
		     contype));

    return ret;

}

/* -1 == use fallback
    0 == lookup failed
    1 == ok

    caller must free *se, *username, *hostname, *addr

*/

#ifdef REMOTE_MBX
int browser_passhm_remote_lookup(passhm,se,lookup_flags,username,
				 hostname,addr,useraddr_flags,
				 cancel_p)
     struct browser_passhm * passhm;
     struct service_entry ** se;
     int                     lookup_flags;
     char                 ** username;
     char                 ** hostname;
     struct address       ** addr;
     int                   * useraddr_flags;
     struct cancel_data   ** cancel_p
     /* May be NULL, Used if dns lookup was cancelable */;
{    
    int ret = 0;

    if (BROWSER_PASSHM_magic != passhm->magic)
	panic("CONNECTION PANIC",__FILE__,__LINE__,
	      "browser_passhm_lookup",
              "Bad magic number (browser_passhm)",0);

    if (se) {
	/* '*se' can be NULL */
	free_service_entry(se);
    }

    if (username && *username) {
	free (*username);
	*username = NULL;
    }

    if (hostname && *hostname) {
	free(*hostname);
	*hostname = NULL;
    }

    if (useraddr_flags)
	*useraddr_flags = 0;
    
    if (addr && *addr) 
	free_address(addr);

    if (passhm->item) {

	DPRINT(Debug,14,(&Debug,"browser_passhm_lookup: have item"));

	if (HASHMARK_ITEM_magic != passhm->item->magic)
	    panic("CONNECTION PANIC",__FILE__,__LINE__,
		  "browser_passhm_lookup",
		  "Bad magic number (hashmark_item)",0);
	if (passhm->item->hashmark_name) {
	    DPRINT(Debug,14,(&Debug,", hashmark %S",
			     passhm->item->hashmark_name));
	    DPRINT(Debug,14,(&Debug,"\n"));
	}

	ret =  hashmark_remote_lookup(passhm->item,
				      se,
				      lookup_flags,
				      username,hostname,
				      addr,
				      useraddr_flags,cancel_p);

    } else {
	DPRINT(Debug,14,(&Debug,"browser_passhm_lookup: no item\n"));
	ret = -1;
    }

    DPRINT(Debug,10,(&Debug,"browser_passhm_lookup=%d\n",ret));

    return ret;
}
#endif

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
