static char rcsid[] = "@(#)$Id: init.c,v 2.13 2024/06/10 18:05:34 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.13 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/


#include "def_mbox.h"
#include "s_me.h"

#include "hdr_imp.h"
#include "rc_imp.h"
#include "save_opts.h"
#ifdef USE_DLOPEN
#include "shared_imp.h"
#endif
#include "state_imp.h"

DEBUG_VAR(Debug,__FILE__,"mbox");

#if ANSI_C
#define S_(x) static x;
#else
#define S_(x)
#endif

static char * EDITOR_PROPLINE [] = 
    { "auto", "emacs", "ignore", NULL };
ENUMERATE editor_hm_propline = {
    editor_propline_auto,
    NUM_editor_propline,
    &(EDITOR_PROPLINE[0]),
    NULL,
    0   	/* no boolean  */,
    NULL	/* not delayed */,
    NULL
};

#if USERMAP_PROPLINE
ENUMERATE editor_usermap_propline = {
    editor_propline_auto,
    NUM_editor_propline,
    &(EDITOR_PROPLINE[0]),
    NULL,
    0   	/* no boolean  */,
    NULL	/* not delayed */,
    NULL
};
#endif

static char *USE_LASTREAD[NUM_use_lastread+1] = {
    "no",
    "yes",
    "auto",
    "existing",
    NULL
};

ENUMERATE use_last_read_file = {
    use_lastread_auto,
    NUM_use_lastread,
    &(USE_LASTREAD[0]),
    NULL,
    1		/* allow boolean ON, OFF, TRUE, FALSE, YES and NO */,
    NULL        /* not delayed */,
    NULL
};

ESTR user_map_dir_e = {            
    ESTR_meta|ESTR_slash,
    NULL,
    NULL
};

charset_t                   system_hash_marks_cs;
struct editor_propline    * system_hash_marks_pl;
struct hash_marks_conf    * system_hash_marks_conf;

charset_t                   user_hash_marks_cs;
struct editor_propline    * user_hash_marks_pl;
struct hash_marks_conf    * user_hash_marks_conf;

FLAGS last_read_fbck_locking = {
    /* Current value */
    0L 
#ifdef USE_FLOCK_LOCKING
    | FLAGVAL(lock_flock_flag)
#endif
#ifdef USE_FCNTL_LOCKING
    | FLAGVAL(lock_fcntl_flag)
#endif
    ,0L,0L,
    NUM_mailbox_locking_v,&(MAILBOX_LOCKING[0]),

    /* Allowed values */
    FLAGVAL(lock_prefer_flag)
#ifdef COMPILE_FLOCK_LOCKING
    | FLAGVAL(lock_flock_flag)
#endif
#ifdef COMPILE_FCNTL_LOCKING
    | FLAGVAL(lock_fcntl_flag)
#endif
    , 1,NULL
};


static ZZZ_SAVE_TYPE mbox_info_data[] = {
	
    {"editor-hm-propline",   ZZZ_DT_ENUM(&editor_hm_propline), ZZZ_TAIL },

#if USERMAP_PROPLINE
    {"editor-usermap-propline",   ZZZ_DT_ENUM(&editor_usermap_propline), ZZZ_TAIL },
#endif

    {"last-read-fallback-locking",ZZZ_DT_FLAGS(&last_read_fbck_locking),  ZZZ_TAIL },
    
    {"use-last-read-file",   ZZZ_DT_ENUM(&use_last_read_file), ZZZ_TAIL },
    
#if 0	/* NOT USED -- use register_hidden_library() instead */
#ifdef USE_DLOPEN
    {"use-mbox-library",    ZZZ_DT_SHARED(&use_shared_mbox), 0 },
#endif
#endif

    {"user-map-dir",  ZZZ_DT_ESTR_(FL_SYS,&user_map_dir_e),     ZZZ_TAIL },

};

static int COUNT=(sizeof(mbox_info_data)/sizeof(ZZZ_SAVE_TYPE));
static save_info_recs *mbox_info = (save_info_recs *) mbox_info_data;

S_(dump_conf_map_f dump_user_hashmarks_file)
static int dump_user_hashmarks_file P_((FILE *f,const char *actor,
					char *version_buff,
					int * errn_res));
static int dump_user_hashmarks_file(f,actor,version_buff,errno_res) 
     FILE *f;
     const char *actor;
     char *version_buff;
     int * errno_res;
{
    dump_hash_mark_entries(f,user_hash_marks_conf,NULL,
			   actor,version_buff,
			   user_hash_marks_cs,
			   user_hash_marks_pl,
			   LOCAL_RC);

    return 1; /* Assume succeed */
}

S_(dump_message_f user_hashmarks_file_written)
static void user_hashmarks_file_written P_((char *fname));
static void user_hashmarks_file_written(fname)
     char *fname;
{

    lib_error(CATGETS(elm_msg_cat, MeSet, 
		      MeHashMarksSavedIn,
		      "Hash marks saved in file %s."), 
	      fname);
}

S_(init_default_hook init_hashmark_defaults)
static void init_hashmark_defaults P_((int *errors));
static void init_hashmark_defaults(errors)
     int *errors;
{
    DPRINT(Debug,10,(&Debug,"init_hashmark_defaults: starting\n"));

    system_hash_marks_conf =  
	parse_hash_mark_entries(system_hash_marks,errors,
				&system_hash_marks_cs,
				&system_hash_marks_pl,
				SYSTEM_RC);

    register_conf_write(USER_HASHMARK_FILE,
			user_hash_marks,
			dump_user_hashmarks_file,
			user_hashmarks_file_written,
			NULL /* No automatic rewrite */,
			NO_merge_conf_map);		
    DPRINT(Debug,10,(&Debug,"init_hashmark_defaults: done\n"));					
}

S_(init_default_hook hashmark_read_rc_file)
static void hashmark_read_rc_file P_((int *errors));
static void hashmark_read_rc_file(errors)
     int *errors;
{
    DPRINT(Debug,10,(&Debug,"hashmark_read_rc_file: starting\n"));

    user_hash_marks_conf = 
	parse_hash_mark_entries(user_hash_marks,errors,
				&user_hash_marks_cs,
				&user_hash_marks_pl,
				LOCAL_RC);

    DPRINT(Debug,10,(&Debug,"hashmark_read_rc_file: done\n"));
}

S_(free_rc_hook free_hashmark_rc_file)
static void free_hashmark_rc_file P_((void));
static void free_hashmark_rc_file() 
{
    DPRINT(Debug,8,(&Debug, "free_hasmark_rc_file: Freeing hashmark maps\n"));
    
    if (user_hash_marks_conf)
	free_hash_marks_conf(&user_hash_marks_conf);
    if (system_hash_marks_conf)
	free_hash_marks_conf(&system_hash_marks_conf);

    free_usermap_files();
}

void init_mboxlib(read_flags)
     int read_flags /* READ_FLAG_IGNORE_MISSING */;
{
    user_map_dir_e.unexpanded =  safe_strdup("{lib}/elm.user.map");

    register_delayed(mbox_info,COUNT,read_flags);

#ifdef USE_DLOPEN
    /* Just hidded hook */

    register_hidden_library(&use_shared_connect,&use_shared_mbox);
    register_list(&use_shared_mbox);
#endif

    /* System files */
    
    add_init_default_hook(&init_hashmark_defaults);
    add_init_default_hook(&init_last_read_defaults);

    /* User files */
    
    add_read_rc_file_hook(&hashmark_read_rc_file);
    add_read_rc_file_hook(&last_read_rc_file);

    /* cleanup */
    
    add_free_rc_hook(&free_hashmark_rc_file);
    add_free_rc_hook(&free_last_read);
}



/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
