static char rcsid[] = "@(#)$Id: parsarpdat.c,v 2.5 2018/07/08 18:01:01 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.5 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 lib/parsarpdat.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1993 USENET Community Trust
 *****************************************************************************/


#include "def_mbox.h"

DEBUG_VAR(Debug,__FILE__,"header");

/* SHRT_MAX LONG_MAX */
#include <limits.h>

 
int parse_date_time(str,time_zone,size_time_zone,tz_offset, time_result,year_result)
     const char *str;
     char *time_zone; 
     int size_time_zone;
     time_t *tz_offset; 
     time_t *time_result; 
     short *year_result;     
{
    enum parse_date_time_result r = parse_dt_fail;
    
    /*
     * Parse a date field in either RFC-822 or Unix date(1) format.
     */
    
    int month, day, year = 0, hours, mins, secs, tz;
    
    long temp_result;  /* make_gmttime returns long */

    if (time_zone)
	*time_zone   = '\0';
    if (tz_offset)
	*tz_offset   = 0;
    if (time_result)
	*time_result = 0;
    if (year_result)
	*year_result = 0;   
    
    r = parse_parts_date_time(str,time_zone,size_time_zone,
			      &month, &day, &year, &hours, &mins, &secs, &tz,
			      NULL /* wday */);

    DPRINT(Debug,7,(&Debug, "  parse_parts_date_time gives %d ",
		    r));
    switch (r) {
    case parse_dt_fail:     DPRINT(Debug,7,(&Debug, " parse_dt_fail"));   break;
    case parse_dt_unix:     DPRINT(Debug,7,(&Debug, " parse_dt_unix"));   break;
    case parse_dt_mail:     DPRINT(Debug,7,(&Debug, " parse_dt_mail"));   break;
    case parse_dt_dateonly: DPRINT(Debug,7,(&Debug, " parse_dt_dateonly")); break;
    }
    DPRINT(Debug,7,(&Debug, "\n"));

    if (!r)
	goto failed;
    
    if (year_result) {
	if (year < SHRT_MAX && year > 1900) {
	    *year_result = year;
	    DPRINT(Debug,7,(&Debug,
			    "parse_date_time: Preserving year as %d\n",
			    *year_result));
	} else
	    *year_result = SHRT_MAX;
    }
       
    if (tz_offset) {
	*tz_offset = tz*60;
	DPRINT(Debug,7,(&Debug, "  tz_offset=%ld\n",(long)*tz_offset));
    }
    
  temp_result = make_gmttime(year, month, day, hours, mins-tz, secs);

  DPRINT(Debug,7,(&Debug, "  temp_result=%ld\n",(long)temp_result));
  if (time_result) {
      if (temp_result < 0) {
	  DPRINT(Debug,7,(&Debug, "  ... unsupported\n"));
	  
	  *time_result = 0;
	  
      } else {
	  if (temp_result < LONG_MAX && 
	      temp_result < time_MAX) {
	      *time_result = temp_result;
	  } else {
	      *time_result = time_MAX;
	      DPRINT(Debug,7,(&Debug, "  ... overflows\n"));
	  }
	  
      }

      DPRINT(Debug,7,(&Debug, "  time_result=%ld\n",(long)*time_result));
  }

  
  DPRINT(Debug,7,(&Debug, "  return success\n"));
  return TRUE;

failed:
  DPRINT(Debug,7,(&Debug, "  return FALSE\n"));
  
  return FALSE;

}

int parse_arpa_date(src, entry)
     char *src;
     struct header_rec *entry;
{
    /*
     * Parse a date field in either RFC-822 or Unix date(1) format.
     * We will fill in the "time_zone", "tz_offset", and "time_sent"
     * parts of the "entry" structure.  Return TRUE on success, FALSE
     * on failure.
     */


  if (parse_date_time(src,
		      entry->time_zone,sizeof(entry->time_zone),
		      &(entry->tz_offset), &(entry->time_sent),
		      &(entry->time_menu_year)
		      )) {
      DPRINT(Debug,7,(&Debug,
		      "parse_arpa_date SUCCESS for %s\n",src));
      return TRUE;
  }
  DPRINT(Debug,7,(&Debug,
		  "parse_arpa_date failed for %s\n",src));
  return FALSE;
}

#ifdef _TEST
int debug = 9999;
main()
{
    struct header_rec hdr;
    char buf[1024];
    while (gets(buf) != NULL) {
	if (!parse_arpa_date(buf, &hdr))
	    fprintf(stderr, "FAIL %s\n", buf);
	else {
	    fprintf(stderr, "OK %s\n", buf);
	    fprintf(stderr, "time_zone=%s tz_offset=%d time_sent=%ld\n",
		hdr.time_zone, hdr.tz_offset, hdr.time_sent);
	}
	putc('\n', stderr);
    }
    exit(0);
}
#endif

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
