case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh
    ;;
esac

case "$subdir" in
'')
    case "$0" in
    */*) cd `expr X$0 : 'X\(.*\)/'` ;;
    esac	    

    vpathdef="#VPATH	= "
    XXsrc="."
    XXsrcroot="../.."
    ;;
*)
    vpathdef="VPATH	=	$source_dir/$subdir"
    XXsrc="$source_dir/$subdir"
    XXsrcroot="$source_dir"
    ;;
esac

echo "Extracting lib/misc/Makefile (with variable substitutions)"
$cat >Makefile <<!GROK!THIS!
#!$make
#
# $Id: Makefile.SH,v 2.18 2021/07/13 07:58:36 hurtta Exp $
#
#  Makefile for the ELM (ME+) mail program.
#
#  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
#                  (was hurtta+elm@posti.FMI.FI)
#      or  Kari Hurtta <elm@elmme-mailer.org>
#
#
#
AR		=	$ar
CC		=	$cc
CCFLAGS		=	$ccflags $picflag $xencf
LFLAGS		=	$ldflags $backtrace_opt $xenlf
CP		=	$cp
RM              =       $rm -f
MV              =       $mv
OPTIMIZE	=	$optimize
RANLIB		=	$ranlib
TOUCH           =       $touch
CHMOD           =       $chmod
REG             =       ../../bin/elmregister 

SHAREDOBJ	=	$sharedobj
$vpathdef
SRC		=	$XXsrc
SRCROOT		=	$XXsrcroot

!GROK!THIS!

if $test "$d_shared" = "$define" ; then
   A=
   if $test "$soname_include_path" = y ; then
	A="$shlib/"
   fi

cat >>Makefile <<SUBSTITUTE
INSTLIB		= \$(ELM_ROOT)//$shlib/libelmme-misc.so$d_shared_rev
SONAME          = ${soname_opt}${A}libelmme-misc.so$d_shared_rev
SOTARG          = ../../shlib/libelmme-misc.so

SUBSTITUTE

else

cat >>Makefile <<'!NO!SUBS!'
INSTLIB         =
SONAME		=
SOTARG          = 
!NO!SUBS!

fi

$cat >>Makefile <<'!NO!SUBS!'
IHDR		=	../../hdrs
CFLAGS		=	-I$(IHDR) -I$(INCLDIR) $(CCFLAGS) $(OPTIMIZE)
INCLDIR		=	$(SRCROOT)/hdrs
OBJS            =       init.o terminal.o mediatype.o mime_types.o \
 charset.o mlist.o conf_writer.o mimesend.o commentfile.o service_list.o \
 iso2022.o filelock.o

all:	Makefile ../../libs/libelmme-misc.a $(SOTARG)
install_s: all $(INSTLIB)

uninstall_s:
	$(REG) rm $(INSTLIB)

clean: 
	rm -f $(OBJS) ../../shlib/libelmme-misc.so ../../libs/libelmme-misc.a

.PRECIOUS: $(IHDR)/elm_defs.h $(IHDR)/defs_major.h def_misc.h \
 $(IHDR)/misclib.h

$(IHDR)/elm_defs.h:	$(IHDR)/defs_major.h $(INCLDIR)/elm_nl_types.h \
 $(INCLDIR)/elmlib.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

$(IHDR)/defs_major.h: ../../config.h $(IHDR)/sysdefs.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

$(IHDR)/misclib.h: $(INCLDIR)/mlist_common.h
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@
	
def_misc.h: $(IHDR)/elm_defs.h $(IHDR)/misclib.h $(INCLDIR)/s_me.h
	cmp $(SRC)/$@ $@ 2>/dev/null || $(CP) $(SRC)/$@ $@
	$(CHMOD) u+w $@
	$(TOUCH) $@

Makefile: Makefile.SH ../../config.sh 
	@echo "You must run 'sh Configure -S' or 'sh Configure'"
	exit 1

lint:		

tags:

init.o:		def_misc.h $(INCLDIR)/s_elm.h \
 $(INCLDIR)/save_opts.h $(INCLDIR)/rc_imp.h
terminal.o:	def_misc.h $(INCLDIR)/cs_imp.h \
 $(INCLDIR)/cs_terminal.h $(INCLDIR)/s_me.h
mediatype.o:	def_misc.h
mime_types.o:	def_misc.h $(INCLDIR)/s_me.h
charset.o:	def_misc.h def_misc.h $(INCLDIR)/cs_imp.h \
 $(INCLDIR)/s_me.h
mlist.o:	def_misc.h $(INCLDIR)/s_me.h $(INCLDIR)/mlist_imp.h \
 $(INCLDIR)/rc_imp.h
conf_writer.o:	def_misc.h $(INCLDIR)/s_me.h $(INCLDIR)/conf_writer_imp.h
mimesend.o:     def_misc.h
commentfile.o:	def_misc.h $(INCLDIR)/s_me.h  $(INCLDIR)/commentfile.h
filelock.o:     def_misc.h $(INCLDIR)/filelock.h $(INCLDIR)/s_me.h
service_list.o: def_misc.h $(INCLDIR)/s_me.h def_misc.h \
 $(INCLDIR)/connection_imp.h $(INCLDIR)/rc_imp.h \
 $(INCLDIR)/schedule_time.h
iso2022.o: def_misc.h $(INCLDIR)/s_me.h \
 $(INCLDIR)/cs_imp.h 

../../libs/libelmme-misc.a: $(OBJS)
	$(AR) r $@ $?
	$(RANLIB) $@

!NO!SUBS!

if $test "$d_shared" = "$define" ; then

cat >>Makefile <<'!NO!SUBS!'

../../shlib/libelmme-misc.so: $(OBJS)
	$(CC) $(LFLAGS) $(SONAME) -o $@ $(OBJS) 

$(INSTLIB): ../../shlib/libelmme-misc.so
	$(REG) copy -m 644 $? $@

!NO!SUBS!

else

cat >>Makefile <<'!NO!SUBS!'

!NO!SUBS!

fi

