static char rcsid[] = "@(#)$Id: opt_utils.c,v 2.11 2017/09/30 13:28:01 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.11 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 lib/opt_utils.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** This file contains routines that might be needed for the various
     machines that the mailer can run on.  Please check the Makefile
     for more help and/or information. 

**/

#include "elm_defs.h"
#include "s_error.h"

#ifdef PWDINSYS
#  include <sys/pwd.h>
#else
#  include <pwd.h>
#endif

static const unsigned char *cs2us P_((const char *str));
static const unsigned char *cs2us(str) 
     const char *str;
{
    return (const unsigned char *)str;
}

DEBUG_VAR(Debug,__FILE__,"config");

int gethostdomain(hostdom, size,global_mode)    /* get domain of current host */
     char *hostdom;
     int size;
     int global_mode;
{
	char    buf[64];
	FILE    *fp;
	const char  * result = NULL;
	int haswarning = 0;

	if (size < 3)
	  return -1;

	buf[0] = '\0';

	if (NULL != (result = getenv("LOCALDOMAIN")) &&
	    result[0]) {
	    
	    char * sp = strpbrk(result," \t");

	    DPRINT(Debug,5,(&Debug,
			    "gethostdomain: Readed %s from $LOCALDOMAIN environment variable%s\n",
			    result,
			    sp ? ", includes space" : ""));

	    if (sp) {
		if (sp > &result[0]) {
		    int n = sp - result;

		    if (n >= sizeof buf) {

			haswarning = 1;
			
			lib_error(CATGETS(elm_msg_cat, ErrorSet, 
					  ErrorDomainnameTooLong,
					  "Domainname given by %s is too long (%d, max %d): %s"),
				  "$LOCALDOMAIN", n,sizeof buf-1,result);

			n = sizeof buf - 1;
		    }

		    strncpy(buf,result,n);
		    buf[n] = '\0';
		    result = buf;
		    
		} else
		    goto skip;
	    }
	    
	} else {

	skip:
	    if ((fp = fopen(hostdomfile, "r")) != NULL) {

		result =  fgets(buf, sizeof(buf) - 1, fp);
 
		if (result) {
		    char    *p;
		    
		    if ((p = index(buf, '\n')) != NULL) {
			*p = '\0';
		    } else if (!feof(fp) &&
			       (0 != (global_mode & READ_FLAG_GLOBAL_ONLY) || 
				0 == access(hostdomfile,WRITE_ACCESS))) {
			haswarning = 1;
			
			lib_error(CATGETS(elm_msg_cat, ErrorSet, 
					  ErrorDomainnameTooLong3,
					  "Domainname given on %s is too long (max %d): %s"),
				  hostdomfile,sizeof(buf) - 1, result);
		    }
		}
		
		fclose(fp);
		
		if (!result) {
		    DPRINT(Debug,2,(&Debug,
				    "gethostdomain: Failed to read %s\n",
				    hostdomfile));
		    goto fail;
		} else if (!result[0]) {
		    DPRINT(Debug,5,(&Debug,
				    "gethostdomain: Empty result from %s\n",
				    hostdomfile));
		    goto fail;
		}
		
		DPRINT(Debug,5,(&Debug,
				"gethostdomain: Readed %s from %s\n",
				buf,hostdomfile));
		
		
	    } else {
		DPRINT(Debug,5,(&Debug,
				"gethostdomain: Failed to open %s\n",
				hostdomfile));
		
		
	    fail: {
		    enum name_resolution tag = nr_getdomainname;
		    int ok = 0;
		    
		    if (have_name_resolution(tag)) {
			
			const char * R = name_resolution_okname(tag,global_mode);
			const char * T = name_resolution_tag(tag);
			int E = name_resolution_errno(tag);
			
			if (E && (0 != (global_mode & READ_FLAG_GLOBAL_ONLY) || 
				  0 == access(system_rc_file,WRITE_ACCESS))) {
			    
			    haswarning = 1;
			    
			    lib_error(CATGETS(elm_msg_cat, ErrorSet, 
					      ErrorDomainnameErrno,
					      "Domainname query by %s failed: %s"),
				      T,strerror(E));
			    
			}
			
			if (R) {
			    int L;
			    
			    result = R;
			    ok = 1;
			    
			    if ((L = strlen(R)) > size-2 &&
				(0 != (global_mode & READ_FLAG_GLOBAL_ONLY) || 
				 0 == access(system_rc_file,WRITE_ACCESS))) {
				
				haswarning = 1;
				
				lib_error(CATGETS(elm_msg_cat, ErrorSet, 
						  ErrorDomainnameTooLong,
						  "Domainname given by %s is too long (%d, max %d): %s"),
					  T,L,size-2, R);
				
			    }
			    
			}
		    }
		    
		    if (!ok) {
#ifdef MYDOMAIN
			result = MYDOMAIN;
			DPRINT(Debug,5,(&Debug,"Compiled in domain %s\n",MYDOMAIN));
#else
			return -1;
#endif
		    }
		}
	    }
	}
	
	if (result && result[0]) {
	    int L;
	    const unsigned char *x;

	    DPRINT(Debug,5,(&Debug,
			    "gethostdomain: Using %s\n",result));	    	    


	    if (result[0] != '\0' && result[0] != '.') {
		*hostdom++ = '.';
		--size;
	    }
	    (void) strfcpy(hostdom, result, size);

	    if ((L = strlen(result)) > size-1 &&
		(0 != (global_mode & READ_FLAG_GLOBAL_ONLY) || 
		 0 == access(system_rc_file,WRITE_ACCESS)) &&
		!haswarning) {

		lib_error(CATGETS(elm_msg_cat, ErrorSet, 
				  ErrorDomainnameTooLong2,
				  "Domainname is too long (%d, max %d): %s"),
			  L,size-2, result);
	    }


	    DPRINT(Debug,5,(&Debug,
			    "gethostdomain: result %s\n",hostdom));

	    for (x =  cs2us(hostdom); *x; x++) {
		if (!isascii(*x))  {
		    DPRINT(Debug,5,(&Debug,
				    "gethostdomain: non-ascii character 0x%02x\n",
				    *x));

		    if (0 != (global_mode & READ_FLAG_GLOBAL_ONLY) || 
			0 == access(system_rc_file,WRITE_ACCESS)) {
			lib_error(CATGETS(elm_msg_cat, ErrorSet, 
					  ErrorDomainAsciiOnly,
					  "Only ASCII characters (not 0x%02x) are allowed on domain name \"%s\""),
				  *x,hostdom);
		    }
				      
		    return -1;
		}
	    }

	    return 0;
	} else {
	    DPRINT(Debug,5,(&Debug,
			    "gethostdomain failed\n"));
	    return -1;
	}
}

#ifndef STRTOK

char *strtok(source, keys)
     char *source, *keys;
{
	/** This function returns a pointer to the next word in source
	    with the string considered broken up at the characters 
	    contained in 'keys'.  Source should be a character pointer
	    when this routine is first called, then NULL subsequently.
	    When strtok has exhausted the source string, it will 
	    return NULL as the next word. 

	    WARNING: This routine will DESTROY the string pointed to
	    by 'source' when first invoked.  If you want to keep the
	    string, make a copy before using this routine!!
	 **/

	register int  last_ch;
	static   char *sourceptr;
		 char *return_value;

	if (source != NULL)
	  sourceptr = source;
	
	if (*sourceptr == '\0') 
	  return(NULL);		/* we hit end-of-string last time!? */

	sourceptr += strspn(sourceptr, keys);	/* skip leading crap */
	
	if (*sourceptr == '\0') 
	  return(NULL);		/* we've hit end-of-string */

	last_ch = strcspn(sourceptr, keys);	/* end of good stuff */

	return_value = sourceptr;		/* and get the ret   */

	sourceptr += last_ch;			/* ...value 	     */

	if (*sourceptr != '\0')		/* don't forget if we're at END! */
	  sourceptr++;			   /* and skipping for next time */

	return_value[last_ch] = '\0';		/* ..ending right    */
	
	return((char *) return_value);		/* and we're outta here! */
}

#endif


#ifndef STRPBRK

char *strpbrk(source, keys)
     char *source, *keys;
{
	/** Returns a pointer to the first character of source that is any
	    of the specified keys, or NULL if none of the keys are present
	    in the source string. 
	**/

	register char *s, *k;

	for (s = source; *s != '\0'; s++) {
	  for (k = keys; *k; k++)
	    if (*k == *s)
	      return(s);
	}
	
	return(NULL);
}

#endif

#ifndef STRSPN

int strspn(source, keys)
     char *source, *keys;
{
	/** This function returns the length of the substring of
	    'source' (starting at zero) that consists ENTIRELY of
	    characters from 'keys'.  This is used to skip over a
	    defined set of characters with parsing, usually. 
	**/

	register int loc = 0, key_index = 0;

	while (source[loc] != '\0') {
	  key_index = 0;
	  while (keys[key_index] != source[loc])
	    if (keys[key_index++] == '\0')
	      return(loc);
	  loc++;
	}

	return(loc);
}

#endif

#ifndef STRCSPN

int strcspn(source, keys)
     char *source, *keys;
{
	/** This function returns the length of the substring of
	    'source' (starting at zero) that consists entirely of
	    characters NOT from 'keys'.  This is used to skip to a
	    defined set of characters with parsing, usually. 
	    NOTE that this is the opposite of strspn() above
	**/

	register int loc = 0, key_index = 0;

	while (source[loc] != '\0') {
	  key_index = 0;
	  while (keys[key_index] != '\0')
	    if (keys[key_index++] == source[loc])
	      return(loc);
	  loc++;
	}

	return(loc);
}

#endif

#ifndef TEMPNAM
/* and a tempnam for temporary files */
static int cnt = 0;

char *tempnam( dir, pfx)
     char *dir, *pfx;
{
	char space[SLEN];
	char *newspace;
	int Len;

	if (dir == NULL) {
		dir = "/usr/tmp";
	} else if (*dir == '\0') {
		dir = "/usr/tmp";
	}
	
	if (pfx == NULL) {
		pfx = "";
	}

	elm_sfprintf(space, sizeof space,
		     FRM("%s%s%d.%d"), dir, pfx, getpid(), cnt);
	cnt++;
	
	Len = strlen(space) + 1;
	newspace = malloc(Len);
	if (newspace != NULL) {
		strfcpy(newspace, space, Len);
	}
	return newspace;
}

#endif

#ifdef compile_ELM_GETOPT

/*LINTLIBRARY*/
#ifndef NULL
#define NULL	0
#endif
#ifndef EOF
#define EOF	(-1)
#endif
#define ERR(s, c)	if(opterr){\
	char errbuf[2];\
	errbuf[0] = c; errbuf[1] = '\n';\
	(void) write(2, argv[0], (unsigned)strlen(argv[0]));\
	(void) write(2, s, (unsigned)strlen(s));\
	(void) write(2, errbuf, 2);}

extern int strcmp();

int	opterr = 1;
int	optind = 1;
int	optopt;
char	*optarg;

int ELM_GETOPT(argc, argv, opts)
     int	argc;
     char	** const argv; 
     const char *opts;
{
	static int sp = 1;
	register int c;
	register char *cp;

	if(sp == 1)
		if(optind >= argc ||
		   argv[optind][0] != '-' || argv[optind][1] == '\0')
			return(EOF);
		else if (0 == strcmp(argv[optind], "--")) {
			optind++;
			return(EOF);
		}
	optopt = c = argv[optind][sp];
	if(c == ':' || (cp=index(opts, c)) == NULL) {
		ERR(": illegal option -- ", c);
		if(argv[optind][++sp] == '\0') {
			optind++;
			sp = 1;
		}
		return('?');
	}
	if(*++cp == ':') {
		if(argv[optind][sp+1] != '\0')
			optarg = &argv[optind++][sp+1];
		else if(++optind >= argc) {
			cp = catgets(elm_msg_cat, ErrorSet, ErrorGetoptReq,
				": option requires an argument -- ");
			ERR(cp, c);
			sp = 1;
			return('?');
		} else
			optarg = argv[optind++];
		sp = 1;
	} else {
		if(argv[optind][++sp] == '\0') {
			sp = 1;
			optind++;
		}
		optarg = NULL;
	}
	return(c);
}

#endif

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
