static char rcsid[] = "@(#)$Id: posixsig.c,v 2.9 2023/12/13 16:55:32 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.9 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 lib/posixsig.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** Duplicate the old signal() call with POSIX sigaction

**/

#include "elm_defs.h"

DEBUG_VAR(Debug,__FILE__,"signal");

#ifdef POSIX_SIGNALS

#ifndef SIG_ERR
#  ifdef BADSIG
#    define SIG_ERR BADSIG
#  else
#    define SIG_ERR -1
#  endif /* BADSIG */
#endif /* SIG_ERRR */

/*
 * This routine used to duplicate the old signal() calls
 */
SIGHAND_TYPE
#if ANSI_C && !defined(apollo)
(*posix_signal(signo, fun))(int)
	int signo;
	SIGHAND_TYPE (*fun)(int);
#else
(*posix_signal(signo, fun))()
	int signo;
	SIGHAND_TYPE (*fun)();
#endif
{
	struct sigaction act;	/* new signal action structure */
	struct sigaction oact;  /* returned signal action structure */ 

	/*   Setup a sigaction struct */

 	act.sa_handler = fun;        /* Handler is function passed */
	sigemptyset(&(act.sa_mask)); /* No signal to mask while in handler */
	act.sa_flags = 0;
#ifdef SA_INTERRUPT
	act.sa_flags |= SA_INTERRUPT;           /* SunOS */
#endif

	/* use the sigaction() system call to set new and get old action */

	sigemptyset(&oact.sa_mask);
	if(sigaction(signo, &act, &oact))
		/* If sigaction failed return -1 */
	    return(SIG_ERR);
	else
        	/* use the previous signal handler as a return value */
	    return(oact.sa_handler);
}
#endif /* POSIX_SIGNALS */

#include <errno.h>
#ifndef ANSI_C
extern int errno;
#endif       

#ifdef BACKGROUD_PROCESSES       /* We assume POSIX in here */

int my_wait (pid,statptr)
     int pid; 
#if defined(BSD_TYPE) && !defined(WEXITSTATUS)
     union wait *statptr;
#else
     int *statptr;
#endif
{
    int ret,err = 0;
    
    
    DPRINT(Debug,10,(&Debug,
		     "my_wait(%d,...) ... with BACKGROUD_PROCESSES\n", 
		     pid));
    errno = 0;

    if (POLL_method && 
	have_actions()) {
	int wait_failed = 0;
	int was_handle_sigchld = handle_sigchld;
		
	DPRINT(Debug,10,(&Debug,
			 "my_wait: have_actions ... busy waiting\n"));
	while (0 == (ret = waitpid(pid,statptr,WNOHANG))) {
	    enum wait_for_status r = wait_for_timeout_f(1,
							WAIT_FOR_intr |
							(was_handle_sigchld ? 0 :  WAIT_FOR_handle_sigchld),
							&err);
							
	    	    
	    switch (r) {
	    case wait_for_done:
		if (wait_failed) {
		    DPRINT(Debug,10,(&Debug,
				     "my_wait: wait_for_timeout_f succeed after failure\n"));
		}
		
		wait_failed = 0;
		break;
	    case wait_for_none:
		DPRINT(Debug,10,(&Debug,
				 "my_wait: Unexpected result from wait_for_timeout_f\n"));
		break;
	    case wait_for_error:
		
		DPRINT(Debug,10,(&Debug,
				 "my_wait: wait_for_timeout_f errno=%d, %s\n",
				 err,strerror(err)));

		if (EINTR == err)   /* Ignore error */
		    break;
		
		if (ENOSYS == err && wait_failed)
		    goto block_waitpid;
		
		if (wait_failed > 10) {
		    DPRINT(Debug,10,(&Debug,
				     "my_wait: wait_for_timeout_f failed after failure\n"));
		    
		    goto ready;
		}

		/* Try again */
		wait_failed++;
		break;
	    }
	    
	    was_handle_sigchld = handle_sigchld;
	}

	if (-1 == ret) {
	    err = errno;
	    
	    DPRINT(Debug,10,(&Debug,
			     "my_wait: waitpid errno=%d, %s\n",
			     err,strerror(err)));	    
	}

	
    } else {
    block_waitpid:
	
	DPRINT(Debug,10,(&Debug,
			 "my_wait: using blocking waitpid\n"));

	ret = waitpid(pid,statptr,0);
	err = errno;
    }

 ready:
#if defined(BSD_TYPE) && !defined(WEXITSTATUS)
    DPRINT(Debug,10,(&Debug,
		     "my_wait(%d,*statptr=%d) = %d\n", pid,
		     statptr->w_status,ret));
#else
    DPRINT(Debug,10,(&Debug,
		     "my_wait(%d,*statptr=%d) = %d\n", pid,
		     *statptr,ret));
#endif

  if (err) {
      DPRINT(Debug,10,(&Debug,
		       " *** errno=%d (%s)\n",err,
		       strerror(err)));
  }
  errno = err;
  return ret;
}

#else

int my_wait (pid,statptr)
     int pid; 
#if defined(BSD_TYPE) && !defined(WEXITSTATUS)
     union wait *statptr;
#else
     int *statptr;
#endif
{
  int ret,err;

  DPRINT(Debug,10,(&Debug,
		   "my_wait(%d,...) ... no BACKGROUD_PROCESSES\n", pid));
  errno = 0;
  ret = 
#ifdef HASWAITPID
      waitpid(pid,statptr,0)
#else
      wait(statptr)
#endif
      ;
  err = errno;

#if defined(BSD_TYPE) && !defined(WEXITSTATUS)
  DPRINT(Debug,10,(&Debug,
		   "my_wait(%d,*statptr=%d) = %d\n", pid,		   
		   statptr->w_status,ret));
#else
  DPRINT(Debug,10,(&Debug,
		   "my_wait(%d,*statptr=%d) = %d\n", pid,		   
		   *statptr,ret));
#endif

  if (err) {
      DPRINT(Debug,10,(&Debug,
		       " *** errno=%d (%s)\n",err,
		       strerror(err)));
  }
  errno = err;

  return ret;

}
#endif


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
