static char rcsid[] = "@(#)$Id: precompiled_sets.c,v 2.4 2014/07/14 15:07:27 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.4 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "elm_defs.h"
#include "cs_imp.h"

DEBUG_VAR(Debug,__FILE__,"charset");

#define INVARIANT &precompiled_sets[0]
#define ASCII &precompiled_sets[1]
#define LATIN1 &precompiled_sets[2]
#define LATIN2 &precompiled_sets[3]       /* ISO-8859-2 */
#define LATIN5 &precompiled_sets[10]      /* ISO-8859-9 */

/* MIBenum and codeset from http://www.iana.org/assignments/character-sets  */

#ifndef ASCII_CODESET
#define ASCII_CODESET "ANSI_X3.4-1968"
#endif

struct charcode_info precompiled_sets[] = {
    { CS_charset_magic, &cs_iso646, &map_invariant, SET_valid,  "INVARIANT",  NULL, NULL, 29,   NULL },

    /* iso-ir-6 */
    { CS_charset_magic, &cs_ascii, &map_ascii, SET_valid,  "US-ASCII",
      INVARIANT, &(sets_iso_8859_X[0]),                                  3,   ASCII_CODESET },

    /* iso-ir-100 */
    { CS_charset_magic, &cs_ascii, &map_latin1, SET_valid,  "ISO-8859-1", 
      ASCII, &(sets_iso_8859_X[1]),                                      4,   "ISO_8859-1:1987" },

    /* iso-ir-101 */
    { CS_charset_magic, &cs_ascii, NULL, SET_valid,  "ISO-8859-2", 
      ASCII, &(sets_iso_8859_X[2]),                                      5,   "ISO_8859-2:1987" },

    /* iso-ir-109 */
    { CS_charset_magic, &cs_ascii, NULL, SET_valid,  "ISO-8859-3", 
      ASCII, &(sets_iso_8859_X[3]),                                      6,   "ISO_8859-3:1988" },

    /* iso-ir-110 */
    { CS_charset_magic, &cs_ascii, NULL, SET_valid,  "ISO-8859-4", 
      ASCII, &(sets_iso_8859_X[4]),                                      7,   "ISO_8859-4:1988" },

    /* iso-ir-144 */
    { CS_charset_magic, &cs_ascii, NULL, SET_valid,  "ISO-8859-5", 
      ASCII, &(sets_iso_8859_X[5]),                                      8,   "ISO_8859-5:1988" },

    /* iso-ir-127 */
    { CS_charset_magic, &cs_ascii, NULL, SET_valid,  "ISO-8859-6", 
      ASCII, &(sets_iso_8859_X[6]),                                      9,   "ISO_8859-6:1987" },

    /* iso-ir-126 */
    { CS_charset_magic, &cs_ascii, NULL, SET_valid,  "ISO-8859-7",
      ASCII, &(sets_iso_8859_X[7]),                                     10,   "ISO_8859-7:1987" },

    /* iso-ir-138 */
    { CS_charset_magic, &cs_ascii, NULL, SET_valid,  "ISO-8859-8", 
      ASCII, &(sets_iso_8859_X[8]),                                     11,   "ISO_8859-8:1988" },

    /* iso-ir-148 */
    { CS_charset_magic, &cs_ascii, NULL, SET_valid,  "ISO-8859-9", 
      ASCII, &(sets_iso_8859_X[9]),                                     12,   "ISO_8859-9:1989" },

    /* iso-ir-157 */
    { CS_charset_magic, &cs_ascii, NULL, SET_valid,  "ISO-8859-10", 
      ASCII, &(sets_iso_8859_X[10]),                                    13,   NULL },

    { CS_charset_magic, &cs_ascii, NULL, SET_valid,  "ISO-8859-11", 
      ASCII, &(sets_iso_8859_X[11]),                                  2259,  "TIS-620" },
    { CS_charset_magic, &cs_ascii, NULL, SET_valid,  "ISO-8859-13", 
      ASCII, &set_latin7,                                              109,   NULL },

    /* iso-ir-199 */
    { CS_charset_magic, &cs_ascii, NULL, SET_valid,  "ISO-8859-14", ASCII, &set_latin8,  110,   NULL },

    { CS_charset_magic, &cs_ascii, &map_885915, SET_valid,  "ISO-8859-15", 
      ASCII, &set_latin9,                                              111,   NULL },

    /* iso-ir-226 */
    { CS_charset_magic, &cs_ascii, NULL, SET_valid,  "ISO-8859-16", 
      ASCII, &set_iso885916,                                           112,   NULL },

    { CS_charset_magic, &cs_ascii, &map_koi8r, SET_valid,  "KOI8-R", ASCII, NULL,       2084,  NULL },
    { CS_charset_magic, &cs_ascii, &map_koi8u, SET_valid,  "KOI8-U", ASCII, NULL,       2088,  NULL },
    { CS_charset_magic, &cs_ascii, &map_cp1251, SET_valid, "windows-1251", ASCII, NULL, 2251,  "CP1251" },
    { CS_charset_magic, &cs_ascii, &map_cp1252, SET_valid, "windows-1252", LATIN1,NULL, 2252,  "CP1252" },
    { CS_charset_magic, &cs_utf8,  &map_utf8,  SET_valid,  "UTF-8",  NULL, &set_utf8,    106,  NULL },
    { CS_charset_magic, &cs_utf7,  &map_utf7,  SET_valid,  "UTF-7",  NULL, NULL,        1012,  NULL },

    /* Following variants are not really handled ....
       (different directonalities are not supported) */

    { CS_charset_magic, &cs_ascii, NULL, SET_valid,  "ISO-8859-6-E", 
      ASCII, &(sets_iso_8859_X[6]),                                     81, "ISO_8859-6-E" },
    { CS_charset_magic, &cs_ascii, NULL, SET_valid,  "ISO-8859-6-I", 
      ASCII, &(sets_iso_8859_X[6]),                                     82, "ISO_8859-6-I" },
    { CS_charset_magic, &cs_ascii, NULL, SET_valid,  "ISO-8859-8-E", 
      ASCII, &(sets_iso_8859_X[8]),                                     84, "ISO_8859-8-E" },
    { CS_charset_magic, &cs_ascii, NULL, SET_valid,  "ISO-8859-8-I", 
      ASCII, &(sets_iso_8859_X[8]),                                     85, "ISO_8859-8-E" },

    /* Following should be some kind special case */

    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid, "UNKNOWN-8BIT",  NULL,  NULL,   2079, NULL },
    
    
    /* Arbitary names from http://www.iana.org/assignments/character-sets    */

    /* Multibyte character set so cs_ascii does not work .... */
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,               27,  "ISO-10646-UTF-1" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,               118,  "ISO-11548-1" },
    { CS_charset_magic, &cs_iso2022,  NULL,  SET_valid, "KOI7-switched", NULL,
      &set_koi7_switched, 2105, NULL },

    { CS_charset_magic, &cs_iso646,   NULL,  SET_valid,  NULL, INVARIANT, NULL, 
                                                                        28,  "ISO_646.basic:1983" },
    /* iso-ir-2 */
    { CS_charset_magic, &cs_iso646,   NULL,  SET_valid,  "IRV",  INVARIANT, &set_iso_ir_2,              30,  "ISO_646.irv:1983" },    

    /* iso-ir-4 */
    { CS_charset_magic, &cs_iso646,   NULL,  SET_valid,  "ISO646-GB", INVARIANT,  &set_iso_ir_4,   
                                                                        20,  "BS_4730" },
    /* iso-ir-8-1 */
    { CS_charset_magic, &cs_iso646,  NULL,  SET_valid,  NULL,  INVARIANT,  &set_iso_ir_8_1,    31,  "NATS-SEFI" },

    /* iso-ir-8-2 */
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, &set_iso_ir_8_2,    32,  "NATS-SEFI-ADD" },

    /* iso-ir-9-1 */
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, &set_iso_ir_9_1,               33,  "NATS-DANO" },

    /* iso-ir-9-2 */
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL, NULL, &set_iso_ir_9_2,     34,  "NATS-DANO-ADD" },

    /* iso-ir-10 */
    { CS_charset_magic, &cs_iso646,   NULL,  SET_valid,  "ISO646-FI", INVARIANT,  &set_iso_ir_10,  
                                                                        35,  "SEN_850200_B" },

    /* iso-ir-11 */
    { CS_charset_magic, &cs_iso646,   NULL,  SET_valid,  "ISO646-SE2", INVARIANT,  &set_iso_ir_11,    
                                                                        21,  "SEN_850200_C" },

    /* iso-ir-149 */
    { CS_charset_magic, &cs_iso2022,  NULL,  SET_valid,  NULL,   NULL, &set_iso_ir_149,         36,  "KS_C_5601-1987" },

    { CS_charset_magic, &cs_iso2022,  &map_ISO2022_ascii,  SET_valid,  "ISO-2022-KR", NULL, 
      &set_ISO2022KR,  37,  NULL }, /* RFC 1557 */
    { CS_charset_magic, &cs_euc,      &map_EUC_ascii,      SET_valid,  "EUC-KR",    NULL,
      &set_EUCKR,  38,  NULL }, 
    { CS_charset_magic, &cs_iso2022,  &map_ISO2022_ascii,  SET_valid,  "ISO-2022-JP", NULL, 
      &set_ISO2022JP,      39,  NULL }, /* RFC 1468 */
    { CS_charset_magic, &cs_iso2022,  &map_ISO2022_ascii_latin1,  SET_valid,  "ISO-2022-JP-2", 
      NULL, &set_ISO2022JP2,    40,  NULL }, /* RFC 1554 */
    { CS_charset_magic, &cs_iso2022,  &map_ISO2022_ascii,  SET_valid,  "ISO-2022-CN", NULL,  
      &set_ISO2022CN,     104,  NULL }, /* RFC 1922 */
    { CS_charset_magic, &cs_iso2022,  &map_ISO2022_ascii,  SET_valid,  "ISO-2022-CN-EXT", NULL,
      &set_ISO2022CNEXT, 105,  NULL }, /* RFC 1922 */

    /* iso-ir-13 */
    { CS_charset_magic, &cs_iso2022,  NULL,  SET_valid,  NULL,  NULL, &set_iso_ir_13,  41,  "JIS_C6220-1969-jp" },

    /* iso-ir-14 */
    { CS_charset_magic, &cs_iso646,   NULL,  SET_valid,  "ISO646-JP", INVARIANT,  &set_ISO646JP,        42,  "JIS_C6220-1969-ro" },

    /* iso-ir-15 */
    { CS_charset_magic, &cs_iso646,   NULL,  SET_valid,  "ISO646-IT", INVARIANT,  &set_iso_ir_15,   22,  "IT" },

    /* iso-ir-16 */
    { CS_charset_magic, &cs_iso646,   NULL,  SET_valid,  "ISO646-PT", INVARIANT,  &set_iso_ir_16,   43,  "PT" },

    /* iso-ir-17 */
    { CS_charset_magic, &cs_iso646,   NULL,  SET_valid,  "ISO646-ES", INVARIANT,  &set_iso_ir_17,        23,  "ES" },

    /* iso-ir-18 */
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,        NULL,  &set_iso_ir_18,        44,  "greek7-old" },

    /* iso-ir-19 */
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, &set_iso_ir_19,               45,  "latin-greek" },

    /* iso-ir-21 */
    { CS_charset_magic, &cs_iso646,   NULL,  SET_valid,  "ISO646-DE", INVARIANT,  &set_iso_ir_21,  24,  "DIN_66003" },

    /* iso-ir-25 */
    { CS_charset_magic, &cs_iso646,   NULL,  SET_valid,  "ISO646-FR1", INVARIANT, &set_iso_ir_25,  46,  "NF_Z_62-010_(1973)" },

    /* iso-ir-27 */
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, &set_iso_ir_27,     47,  "Latin-greek-1" },

    /* iso-ir-37 */
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, &set_iso_ir_37,     48,  "ISO_5427" },


    /* iso-ir-42 */
    { CS_charset_magic, &cs_iso2022,  NULL,  SET_valid,  NULL,  NULL, &set_iso_ir_42,     49,  "JIS_C6226-1978" },

    /* iso-ir-47 */
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, &set_iso_ir_47,     50,  "BS_viewdata" },

    /* iso-ir-49 */
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, &set_iso_ir_49,     51,  "INIS" },

    /* iso-ir-50 */
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, &set_iso_ir_50,     52,  "INIS-8" },

    /* iso-ir-51 */
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, &set_iso_ir_51,     53,  "INIS-cyrillic" },

    /* iso-ir-54 */ 
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, &set_iso_ir_54,     54,  "ISO_5427:1981" },

    /* iso-ir-55 */ 
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, &set_iso_ir_55,     55,  "ISO_5428:1980" },

    /* iso-ir-57 */
    { CS_charset_magic, &cs_iso646,   NULL,  SET_valid,  "ISO646-CN", INVARIANT,  &set_iso_ir_57,        56,  "GB_1988-80" },

    /* iso-ir-58 */
    { CS_charset_magic, &cs_iso2022,  NULL,  SET_valid,  NULL,  NULL, &set_iso_ir_58,     57,  "GB_2312-80" },

    /* iso-ir-60 */
    { CS_charset_magic, &cs_iso646,   NULL,  SET_valid,  "ISO646-NO", INVARIANT,  &set_iso_ir_60,  25,  "NS_4551-1" },

    /* iso-ir-61 */
    { CS_charset_magic, &cs_iso646,   NULL,  SET_valid,  "ISO646-NO2", INVARIANT, &set_iso_ir_61, 58,  "NS_4551-2" },

    /* iso-ir-69 */
    { CS_charset_magic, &cs_iso646,   NULL,  SET_valid,  "ISO646-FR", INVARIANT,  &set_iso_ir_69, 26,  "NF_Z_62-010" },

    /* iso-ir-70 */
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, &set_iso_ir_70,    59,  "videotex-suppl" },

    /* iso-ir-84 */
    { CS_charset_magic, &cs_iso646,   NULL,  SET_valid,  "ISO646-PT2", INVARIANT,  &set_iso_ir_84, 60,  "PT2" },

    /* iso-ir-85 */
    { CS_charset_magic, &cs_iso646,   NULL,  SET_valid,  "ISO646-ES2", INVARIANT,  &set_iso_ir_85, 61,  "ES2" },

    /* iso-ir-86 */
    { CS_charset_magic, &cs_iso646,   NULL,  SET_valid,  "ISO646-HU", INVARIANT,  &set_iso_ir_86,  62,  "MSZ_7795.3" },

    /* iso-ir-87 */
    { CS_charset_magic, &cs_iso2022,  NULL,  SET_valid,  NULL,  NULL, &set_iso_ir_87,     63,  "JIS_C6226-1983" },

    /* iso-ir-88 */
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,               64,  "greek7" },

    /* iso-ir-89 */
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, &set_iso_ir_89,     65,  "ASMO_449" },

    /* iso-ir-90 */
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, &set_iso_ir_90,     66,  "iso-ir-90" },

    /* iso-ir-91 */
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, &set_iso_ir_91,     67,  "JIS_C6229-1984-a" },

     /* iso-ir-92 */
    { CS_charset_magic, &cs_iso646,   NULL,  SET_valid,  "ISO646-JP-OCR-B", INVARIANT,  
                                                        &set_iso_ir_92,  68,  "JIS_C6229-1984-b" },

     /* iso-ir-93 */
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, &set_iso_ir_93,     69,  "JIS_C6229-1984-b-add" },

     /* iso-ir-94 */
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, &set_iso_ir_94,     70,  "JIS_C6229-1984-hand" },

     /* iso-ir-95 */
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, &set_iso_ir_95,     71,  "JIS_C6229-1984-hand-add" },

     /* iso-ir-96 */
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, &set_iso_ir_96,     72,  "JIS_C6229-1984-kana" },

     /* iso-ir-98 */
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, &set_iso_ir_98,    73,  "ISO_2033-1983" },

     /* iso-ir-99 */
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, &set_iso_ir_99,     74,  "ANSI_X3.110-1983" },

    /* iso-ir-102 */
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, &set_iso_ir_102,    75,  "T.61-7bit" },

    /* iso-ir-103 */
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, &set_iso_ir_103,    76,  "T.61-8bit" },

    /* iso-ir-111 */
    { CS_charset_magic, &cs_ascii,    NULL,  SET_valid,  "KOI8-E",  NULL, &set_koi8e,     77,  "ECMA-cyrillic" },

    /* iso-ir-121 */
    { CS_charset_magic, &cs_iso646,   NULL,  SET_valid,  "ISO646-CA", INVARIANT, &set_iso_ir_121, 78,  "CSA_Z243.4-1985-1" },

    /* iso-ir-122 */
    { CS_charset_magic, &cs_iso646,   NULL,  SET_valid,  "ISO646-CA2", INVARIANT, &set_iso_ir_122, 79,  "CSA_Z243.4-1985-2" },

    /* iso-ir-123 */
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, &set_iso_ir_123,    80,  "CSA_Z243.4-1985-gr" },

    /* iso-ir-128 */
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, &set_iso_ir_128,    83,  "T.101-G2" },

    /* iso-ir-139 */
    { CS_charset_magic, &cs_ascii,  NULL,  SET_valid,  NULL,  ASCII, &set_iso_ir_139,     86,  "CSN_369103" },

    /* iso-ir-141 */
    { CS_charset_magic, &cs_iso646,   NULL,  SET_valid,  "ISO646-YU", INVARIANT,  &set_iso_ir_141,  87,  "JUS_I.B1.002" },

    /* iso-ir-142 */
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, &set_iso_ir_142, 14,  "ISO_6937-2-add" },

    /* iso-ir-143 */
    { CS_charset_magic, &cs_ascii,  NULL,  SET_valid,  NULL,  ASCII, &set_iso_ir_143,     88,  "IEC_P27-1" },

    /* iso-ir-146 */
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, &set_iso_ir_146,    89,  "JUS_I.B1.003-serb" },

    /* iso-ir-147 */
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, &set_iso_ir_147,    90,  "JUS_I.B1.003-mac" },

    /* iso-ir-150 */
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, &set_iso_ir_150,    91,  "greek-ccitt" },

    /* iso-ir-151 */
    { CS_charset_magic, &cs_iso646,   NULL,  SET_valid,  "ISO646-CU", INVARIANT,  
                                                    &set_iso_ir_151,   92,  "NC_NC00-10:81" },

    /* iso-ir-152 */
    { CS_charset_magic, &cs_ascii,    NULL,  SET_valid,  NULL,  ASCII, &set_iso_ir_152,   93,  "ISO_6937-2-25" },

    /* iso-ir-153 */
    { CS_charset_magic, &cs_ascii,  NULL,  SET_valid,  NULL,  ASCII, &set_iso_ir_153,    94,  "GOST_19768-74" },

    /* iso-ir-154 */
    { CS_charset_magic, &cs_ascii,  NULL,  SET_valid,  NULL,  ASCII, &set_iso_ir_154,    95,  "ISO_8859-supp" },

    /* iso-ir-155 */
    { CS_charset_magic, &cs_ascii,  NULL,  SET_valid,  NULL,  ASCII, &set_iso_ir_155,    96,  "ISO_10367-box" },

    /* iso-ir-158 */
    { CS_charset_magic, &cs_ascii,  NULL,  SET_valid,  NULL,  ASCII, &set_iso_ir_158,    97,  "latin-lap" },

    /* iso-ir-159 */
    { CS_charset_magic, &cs_iso2022,  NULL,  SET_valid,  NULL,  NULL, &set_iso_ir_159,   98,  "JIS_X0212-1990" },

    { CS_charset_magic, &cs_iso646,   NULL,  SET_valid,  "ISO646-DK", INVARIANT,  NULL,        99,  "DS_2089" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,              100,  "us-dk" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,              101,  "dk-us" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,               15,  "JIS_X0201" },
    { CS_charset_magic, &cs_iso646,   NULL,  SET_valid,  "ISO646-KR", INVARIANT,  NULL,       102,  "KSC5636" },
    { CS_charset_magic, &cs_ascii,    NULL,  SET_valid,  "DEC-MCS",  ASCII, NULL,       2008,  NULL },
    { CS_charset_magic, &cs_ascii,    NULL,  SET_valid,  "hp-roman8" ,  ASCII, NULL,    2004,  NULL },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2027,  "macintosh" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2030,  "IBM273" },
    { CS_charset_magic, &cs_ascii,    NULL,  SET_valid,  "CP437", ASCII, NULL,          2011,  "IBM437" },
    { CS_charset_magic, &cs_ascii,    NULL,  SET_valid,  "IBM775", ASCII, NULL,         2087,  NULL },
    { CS_charset_magic, &cs_ascii,    NULL,  SET_valid,  "CP850", ASCII, NULL,          2009,  "IBM850" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2045,  "IBM851" },
    { CS_charset_magic, &cs_ascii,    NULL,  SET_valid,  "CP852", ASCII, NULL,          2010,  "IBM852" },
    { CS_charset_magic, &cs_ascii,    NULL,  SET_valid,  "CP855", ASCII, NULL,          2046,  "IBM855" },
    { CS_charset_magic, &cs_ascii,    NULL,  SET_valid,  "CP857", ASCII, NULL,          2047,  "IBM857" },
    { CS_charset_magic, &cs_ascii,    NULL,  SET_valid,  "CP860", ASCII, NULL,          2048,  "IBM860" },
    { CS_charset_magic, &cs_ascii,    NULL,  SET_valid,  "CP861", ASCII, NULL,          2049,  "IBM861" },
    { CS_charset_magic, &cs_ascii,    NULL,  SET_valid,  "CP862", ASCII, NULL,          2013,  "IBM862" },
    { CS_charset_magic, &cs_ascii,    NULL,  SET_valid,  "CP863", ASCII, NULL,          2050,  "IBM863" },
    { CS_charset_magic, &cs_ascii,    NULL,  SET_valid,  "CP864", ASCII, NULL,          2051,  "IBM864" },
    { CS_charset_magic, &cs_ascii,    NULL,  SET_valid,  "CP865", ASCII, NULL,          2052,  "IBM865" },
    { CS_charset_magic, &cs_ascii,    NULL,  SET_valid,  "IBM866", ASCII, NULL,         2086,  NULL },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2053,  "IBM868" },
    { CS_charset_magic, &cs_ascii,    NULL,  SET_valid,  "CP869", ASCII, NULL,          2054,  "IBM869" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2058,  "IBM891" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2059,  "IBM903" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2060,  "IBM904" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2063,  "IBM1026" },

    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2080,  "MNEMONIC" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2081,  "MNEM" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  "VISCII",  NULL, NULL,         2082,   NULL },  /* rfc 1456 */
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2083,  "VIQR" }, /* rfc 1456 */

    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  "IBM00858",  NULL, NULL,       2089,   NULL },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  "Big5-HKSCS",  NULL, NULL,     2101,   NULL },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  "BOCU-1",    NULL,  NULL,      1020,   NULL },
    { CS_charset_magic, &cs_utf7,     NULL,  SET_valid,  "UNICODE-1-1-UTF-7",NULL, NULL, 103,  NULL },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,               16,  "JIS_Encoding" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  "Shift_JIS",  NULL, NULL,        17,  NULL },
    { CS_charset_magic, &cs_euc,  &map_EUC_ascii,  SET_valid,  "EUC-JP",  
      NULL, &set_EUCJP,           18,             
      "Extended_UNIX_Code_Packed_Format_for_Japanese" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,               19,  
      "Extended_UNIX_Code_Fixed_Width_for_Japanese" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2005,  "Adobe-Standard-Encoding" },
    { CS_charset_magic, &cs_ascii,    NULL,  SET_valid,  NULL,  ASCII, NULL,            2006,  "Ventura-US" },
    { CS_charset_magic, &cs_ascii,    NULL,  SET_valid,  NULL,  ASCII, NULL,            2007,  "Ventura-International" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2012,  "PC8-Danish-Norwegian" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2014,  "PC8-Turkish" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2015,  "IBM-Symbols" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2016,  "IBM-Thai" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2017,  "HP-Legal" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2018,  "HP-Pi-font" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2019,  "HP-Math8" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2020,  "Adobe-Symbol-Encoding" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2021,  "HP-DeskTop" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2022,  "Ventura-Math" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2023,  "Microsoft-Publishing" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2024,  "Windows-31J" },

    /* This is really EUC-CN */ 
    { CS_charset_magic, &cs_euc,      &map_EUC_ascii,  SET_valid,  "GB2312",  NULL, 
      &set_EUCCN,         2025,  "GB2312-1980" }, /* ASCII + GB 2312-80 */    

    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  "Big5",  NULL, NULL,           2026,  NULL },
    { CS_charset_magic, &cs_ascii,    NULL,  SET_valid, "windows-1250", ASCII, NULL,     2250,  NULL },
    { CS_charset_magic, &cs_ascii,    NULL,  SET_valid, "windows-1253", ASCII, NULL,     2253,  NULL },
    { CS_charset_magic, &cs_ascii,    NULL,  SET_valid, "windows-1254", ASCII ,NULL,     2254,  NULL },
    { CS_charset_magic, &cs_ascii,    NULL,  SET_valid, "windows-1255", ASCII ,NULL,     2255,  "CP1255" },
    { CS_charset_magic, &cs_ascii,    NULL,  SET_valid, "windows-1256", ASCII ,NULL,     2256,  "CP1256" },
    { CS_charset_magic, &cs_ascii,    NULL,  SET_valid, "windows-1257", ASCII ,NULL,     2257,  "CP1257" },
    { CS_charset_magic, &cs_ascii,    NULL,  SET_valid, "windows-1258", ASCII ,NULL,     2258,  NULL },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,              2085,  "HZ-GB-2312" },


    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid, "GB18030",    NULL, NULL,        114,   NULL },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid, "BRF",        NULL, NULL,        2106,  NULL },          
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid, "GBK",        NULL, NULL,        113,   NULL },

    { CS_charset_magic, &cs_ascii,    NULL,  SET_valid, "KZ-1048", ASCII,
      NULL, 119, NULL },
    { CS_charset_magic, &cs_ascii,    NULL,  SET_valid, "PTCP154", ASCII,
      NULL, 2103, NULL },



    /* How this compares to windows-1252 ... ?? */
    { CS_charset_magic, &cs_ascii, NULL, SET_valid, NULL, LATIN1, NULL,        2000, "ISO-8859-1-Windows-3.0-Latin-1" },
    { CS_charset_magic, &cs_ascii, NULL, SET_valid, NULL, LATIN2, NULL,        2001, "ISO-8859-2-Windows-Latin-2" },
    { CS_charset_magic, &cs_ascii, NULL, SET_valid, NULL, LATIN5, NULL,        2003, "ISO-8859-9-Windows-Latin-5" },

    /* Following are ebcdic character sets and therefore not suitable for ElmME+ use */
    
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  "IBM037",  NULL, NULL,         2028,   NULL },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  "IBM038",  NULL, NULL,         2029,   NULL },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  "IBM274",  NULL, NULL,         2031,   NULL },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  "IBM275",  NULL, NULL,         2032,   NULL },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  "IBM277",  NULL, NULL,         2033,   NULL },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  "IBM278",  NULL, NULL,         2034,   NULL },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  "IBM280",  NULL, NULL,         2035,   NULL },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  "IBM281",  NULL, NULL,         2036,   NULL },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  "IBM284",  NULL, NULL,         2037,   NULL },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  "IBM285",  NULL, NULL,         2039,   NULL },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  "IBM297",  NULL, NULL,         2040,   NULL },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  "IBM420",  NULL, NULL,         2041,   NULL },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  "IBM423",  NULL, NULL,         2042,   NULL },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  "IBM424",  NULL, NULL,         2043,   NULL },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  "IBM500",  NULL, NULL,         2044,   NULL },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  "IBM870",  NULL, NULL,         2055,   NULL },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  "IBM871",  NULL, NULL,         2056,   NULL },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  "IBM880",  NULL, NULL,         2057,   NULL },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  "IBM905",  NULL, NULL,         2061,   NULL },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  "IBM918",  NULL, NULL,         2062,   NULL },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2064,  "EBCDIC-AT-DE" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2065,  "EBCDIC-AT-DE-A" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2066,  "EBCDIC-CA-FR" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2067,  "EBCDIC-DK-NO" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2068,  "EBCDIC-DK-NO-A" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2069,  "EBCDIC-FI-SE" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2070,  "EBCDIC-FI-SE-A" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2071,  "EBCDIC-FR" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2072,  "EBCDIC-IT" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2073,  "EBCDIC-PT" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2074,  "EBCDIC-ES" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2075,  "EBCDIC-ES-A" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2076,  "EBCDIC-ES-S" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2077,  "EBCDIC-UK" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2078,  "EBCDIC-US" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2090,  "IBM00924" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2102,  "IBM1047" },

    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             116,  "OSD_EBCDIC_DF03_IRV" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             117,  "OSD_EBCDIC_DF04_1" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             115,  "OSD_EBCDIC_DF04_15" },


    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2091,  "IBM01140" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2092,  "IBM01141" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2093,  "IBM01142" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2094,  "IBM01143" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2095,  "IBM01144" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2096,  "IBM01145" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2097,  "IBM01146" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2098,  "IBM01147" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2099,  "IBM01148" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             2100,  "IBM01149" },

    /* Following are NOT valid charsets for MIME */

    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             1000,  "ISO-10646-UCS-2" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             1001,  "ISO-10646-UCS-4" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             1010,  "UNICODE-1-1" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             1011,  "SCSU" },  
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             1013,  "UTF-16BE" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             1014,  "UTF-16LE" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             1015,  "UTF-16" },

    /* Not exactly as UTF-8    http://www.unicode.org/unicode/reports/tr26/ */
    { CS_charset_magic, &cs_utf8,  &map_utf8,  SET_valid, NULL,  NULL, NULL,            1016,  "CESU-8" },  

    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,
        1017,  "UTF-32" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,
        1018,  "UTF-32BE" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,
        1019,  "UTF-32LE" },


    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             1002,  "ISO-10646-UCS-Basic" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             1003,  "ISO-10646-Unicode-Latin1" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             0,     "ISO-10646-J-1" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             1005,  "ISO-Unicode-IBM-1261" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             1006,  "ISO-Unicode-IBM-1268" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             1007,  "ISO-Unicode-IBM-1276" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             1008,  "ISO-Unicode-IBM-1264" },
    { CS_charset_magic, &cs_unknown,  NULL,  SET_valid,  NULL,  NULL, NULL,             1009,  "ISO-Unicode-IBM-1265" },

    { 0, NULL, NULL, 0,       NULL, NULL, NULL }

};

const charset_t ASCII_SET     = ASCII;
const charset_t INVARIANT_SET = INVARIANT;
charset_t display_charset = ASCII;  /* current charset used by terminal */
charset_t system_charset  = ASCII;  /* the charset, the locale supports */

/* 'Raw' byte buffer -- treated as ascii -- used on buffering !!!!!!  */

static struct charcode_info raw_buffer = {
    CS_charset_magic, &cs_ascii, &map_ascii, SET_valid,  "*RAW*", ASCII, &(sets_iso_8859_X[0]),  0, NULL
};
const charset_t RAW_BUFFER = &raw_buffer;

#define ARRSIZE(SET) sizeof SET / sizeof (struct charcode_info)


const int precompiled_size = ARRSIZE(precompiled_sets);

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
