static char rcsid[] = "@(#)$Id: strincmp.c,v 2.4 2014/07/14 15:07:28 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.4 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 lib/strincmp.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** compare strings ignoring case - length limited
**/

#include "elm_defs.h"

DEBUG_VAR(DebugIO,__FILE__,"core");

/* Is this needed? This is same than strncasecmp 
 *        - K E H <hurtta@ozone.FMI.FI>
 */

int strincmp(s1,s2,n)
     const char *s1, *s2;
     int n;
{
    /* case insensitive comparison */

    int d;
    while (--n >= 0) {
#ifdef ASCII_CTYPE
	if (!isascii(*s1) || !isascii(*s2))
	    d = *s1 - *s2;
	else
#endif
	    d = (tolower((unsigned char)*s1) - tolower((unsigned char)*s2));
	if ( d != 0 || *s1 == '\0' || *s2 == '\0' )
	    return d;
	++s1;
	++s2;
    }
    return(0);
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */

