static char rcsid[] = "@(#)$Id: strmcpy.c,v 2.4 2014/07/14 15:07:28 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.4 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 *
 *  Initially written by: Michael Elkins <elkins@aero.org>, 1995
 *****************************************************************************/

#include "elm_defs.h"

DEBUG_VAR(DebugIO,__FILE__,"stateio");

char * strmcpy (dest, src)
     char *dest;
     const char *src;
{
    int len = strlen (src) + 1;
    
    if (dest)
	dest = (char *) safe_realloc (dest, len);
    else
	dest = (char *) safe_malloc (len);
    strfcpy (dest, src, len);

    return dest;
}


char * strmcat (dest, src)
     char *dest;
     const char *src;
{
    int len;
    
    if (!dest)
	return strmcpy(dest,src);
    
    len = strlen (src) + 1 + strlen(dest);
    
    dest = (char *) safe_realloc (dest, len);
    strfcat (dest, src, len);

    return dest;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
