case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh

    ;;
esac

case "$subdir" in
'')
    case "$0" in
    */*) cd `expr X$0 : 'X\(.*\)/'` ;;
    esac	    

    vpathdef="#VPATH	= "
    XXsrc="."
    XXsrcroot=".."
    ;;
*)
    vpathdef="VPATH	=	$source_dir/$subdir"
    XXsrc="$source_dir/$subdir"
    XXsrcroot="$source_dir"
    ;;
esac

echo "Extracting melib/Makefile (with variable substitutions)"
cat >Makefile <<!GROK!THIS!
#!$make
#
# $Id: Makefile.SH,v 2.14 2023/12/13 16:55:32 hurtta Exp $
#
#  Makefile for the ELM (ME+) mail program.
#
# Modified by  Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
# 	               (was hurtta+elm@posti.FMI.FI)
#           or Kari Hurtta <elm@elmme-mailer.org>
#
####################################################################
#
# Variables
#	Variables established by Configure
AR		=	$ar
CC		=	$cc
CP		=	$cp
CCFLAGS		=	$ccflags $picflag $xencf
LFLAGS		=	$ldflags $backtrace_opt $xenlf
CHMOD		=	$chmod
OPTIMIZE	=	$optimize
RANLIB		=	$ranlib
RM		= 	$rm -f
TOUCH		=	$touch
TAGS		=	ctags
$vpathdef
SRC		=	$XXsrc
SRCROOT		=	$XXsrcroot
REG		=	../bin/elmregister

!GROK!THIS!

if $test "$d_shared" = "$define" ; then

	A=
	if $test "$soname_include_path" = y ; then
		A="$shlib/"
	fi

cat >>Makefile <<SUBSTITUTE
SHLIST          = ../shlib/libelmme-mime.so
INSTLIB		= \$(ELM_ROOT)//$shlib/libelmme-mime.so$d_shared_rev
SONAME          = ${soname_opt}${A}libelmme-mime.so$d_shared_rev
SHLIB		= $shlib
SUBSTITUTE

else

cat >>Makefile <<'!NO!SUBS!'
SHLIST          =
INSTLIB         =
SONAME		=
SHLIB		= 
!NO!SUBS!

fi


cat >>Makefile <<'!NO!SUBS!'
#	Other general variables
CFLAGS		=	-I$(IHDR) -I$(INCLDIR) $(CCFLAGS) $(OPTIMIZE) $(DEBUG) 
IHDR		=	../hdrs
INCLDIR		=	$(SRCROOT)/hdrs
SHELL		=	/bin/sh

# 	Lists
LIB_SRC		= 	decodeopts.c	\
			encode.c	\
			flowed.c	\
			init.c		\
			parse_util.c	\
			parse_helper.c	\
			pgp_decode.c	\
			mailcap.c	\
			mime.c		\
			mime_decode.c	\
			mime_param.c	\
			mime_parse.c	\
			mime_selector.c \
			mparser.c	\
			mpar_rfc822.c	\
			mpar_multipart.c \
			mpar_leaf.c	 \
			mimewalk.c	 \
			partial.c	 \
			state_decode.c   \
			type_check.c	 \
			tagfilter.c	 \
			tagfilter_decode.c \
			tagfilter_enriched.c \
			tagfilter_entity.c \
			tagfilter_html.c \
			tagfilter_tag.c

LIB_OBJ		=	decodeopts.o	\
			encode.o	\
			flowed.o	\
			init.o		\
			parse_util.o	\
			parse_helper.o	\
			pgp_decode.o	\
			mailcap.o	\
			mime.o		\
			mime_decode.o	\
			mime_param.o	\
			mime_parse.o	\
			mime_selector.o	\
			mparser.o	\
			mpar_rfc822.o	\
			mpar_multipart.o \
			mpar_leaf.o	 \
			mimewalk.o	 \
			partial.o	 \
			state_decode.o   \
			type_check.o	 \
			tagfilter.o	 \
			tagfilter_decode.o \
			tagfilter_enriched.o \
			tagfilter_entity.o \
			tagfilter_html.o \
			tagfilter_tag.o

all:			Makefile ../libs/libelmme-mime.a $(SHLIST)
!NO!SUBS!

cat >>Makefile <<'!NO!SUBS!'

install_s:		Makefile ../libs/libelmme-mime.a $(INSTLIB)

uninstall_s:		
	$(REG) rm $(INSTLIB)

Makefile: Makefile.SH ../config.sh
	@echo "You must run 'sh Configure -S' or 'sh Configure'"
	exit 1

../libs/libelmme-mime.a:		$(LIB_OBJ) 
			$(AR) r $@ $?
			$(RANLIB) $@

tags:
		$(TAGS) $(LIB_SRC)

clean:		
		$(RM) $(LIB_OBJ) ../libs/libelmme-mime.a ../shlib/libelmme-mime.so

# Dependencies and rules
#	Dependencies of header files upon other header files they include
.PRECIOUS:		def_melib.h $(IHDR)/elm_defs.h \
 $(IHDR)/shared_imp.h $(IHDR)/defs_major.h

$(IHDR)/elm_defs.h:	$(IHDR)/defs_major.h $(INCLDIR)/elm_nl_types.h \
 $(IHDR)/elmlib.h
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

$(IHDR)/defs_major.h: ../config.h $(IHDR)/sysdefs.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

$(IHDR)/shared_imp.h:	$(SRCROOT)/shared_libs/include/shared.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

def_melib.h:		$(INCLDIR)/elm_defs.h $(INCLDIR)/melib.h \
 $(INCLDIR)/mboxlib.h $(INCLDIR)/misclib.h $(INCLDIR)/addrlib.h
			cmp $(SRC)/$@ $@ 2>/dev/null || $(CP) $(SRC)/$@ $@
			$(CHMOD) u+w $@
			$(TOUCH) $@


#	Dependencies of C object files
decodeopts.o:		def_melib.h
flowed.o:		def_melib.h $(INCLDIR)/s_me.h
init.o:			def_melib.h $(INCLDIR)/save_opts.h $(INCLDIR)/rc_imp.h $(INCLDIR)/s_me.h 
pgp_decode.o:		def_melib.h $(INCLDIR)/s_me.h  $(INCLDIR)/s_elm.h  
parse_util.o:   	def_melib.h $(INCLDIR)/s_me.h  
parse_helper.o:   	def_melib.h
mailcap.o:		def_melib.h $(INCLDIR)/mailcap_imp.h
mime_param.o:   	def_melib.h $(INCLDIR)/s_me.h  
mime_parse.o:   	def_melib.h $(INCLDIR)/s_me.h  
mime_decode.o:  	def_melib.h $(INCLDIR)/s_me.h  $(INCLDIR)/tagfilter_imp.h
mime_selector.o:	def_melib.h $(INCLDIR)/s_me.h  
mime.o:			def_melib.h $(INCLDIR)/s_me.h  
mparser.o:		def_melib.h $(INCLDIR)/mpar_imp.h
mpar_rfc822.o:		def_melib.h $(INCLDIR)/mpar_imp.h $(INCLDIR)/s_me.h  
mpar_multipart.o:	def_melib.h $(INCLDIR)/mpar_imp.h $(INCLDIR)/s_me.h  
mpar_leaf.o:		def_melib.h $(INCLDIR)/mpar_imp.h
mimewalk.o:		def_melib.h $(INCLDIR)/s_me.h  
partial.o:		def_melib.h $(INCLDIR)/s_me.h  
state_decode.o:		def_melib.h $(INCLDIR)/state_imp.h
tagfilter.o:		def_melib.h $(INCLDIR)/tagfilter_imp.h $(INCLDIR)/s_me.h  
tagfilter_decode.o:	def_melib.h $(INCLDIR)/tagfilter_imp.h $(INCLDIR)/s_me.h
tagfilter_enriched.o:	def_melib.h $(INCLDIR)/tagfilter_imp.h
tagfilter_entity.o:	def_melib.h $(INCLDIR)/tagfilter_imp.h $(INCLDIR)/rc_imp.h \
		     	$(INCLDIR)/s_me.h  $(INCLDIR)/s_elm.h  $(INCLDIR)/commentfile.h
tagfilter_html.o:	def_melib.h $(INCLDIR)/tagfilter_imp.h
tagfilter_tag.o:	def_melib.h $(INCLDIR)/tagfilter_imp.h $(INCLDIR)/elmme-magic.h
type_check.o:		def_melib.h $(INCLDIR)/s_me.h  
encode.o:		def_melib.h $(INCLDIR)/s_elm.h
!NO!SUBS!

if $test "$d_shared" = "$define" ; then

cat >>Makefile <<'!NO!SUBS!'
../shlib/libelmme-mime.so: $(LIB_OBJ) 
		$(CC) $(LFLAGS) $(SONAME) -o $@ $(LIB_OBJ) 

$(SHLIB):
		$(REG) mkdir $(SHLIB)

$(INSTLIB):	$(SHLIB) ../shlib/libelmme-mime.so
		$(REG) copy -m 644 ../shlib/libelmme-mime.so $@
!NO!SUBS!

else

cat >>Makefile <<'!NO!SUBS!'

!NO!SUBS!

fi

