/* $Id: def_melib.h,v 2.20 2023/12/13 16:55:32 hurtta Exp $ */

#include "elm_defs.h"
#include "misclib.h"
#include "addrlib.h"
#include "melib.h"
#include "mboxlib.h"

#define MIME_PARAM_magic	0xFC04

struct mime_param {
    unsigned short magic;     /*  MIME_PARAM_magic */

    struct mp_pair {
	char *raw_param;
	char *raw_value;
    }   * params;
    int   param_count;

    charset_t  def;
    int        header_status;

    struct ascii_pair {
	int   is_compat;
	char *param;
	char *value;
    } * ascii_params;
    int ascii_param_count;

    struct string_pair {
	int   is_rfc1522_hack;
	char *param;
	struct string *value;

    } * string_params;
    int string_param_count;
};

/* -------------------------------------- */
/* Internal routines to melib             */


/* mime_decode.c */

extern FILE *arrange_decoded P_((mime_t *ptr,struct in_state  *state_in,
				 struct out_state *state_out,
				 const struct decode_opts *decode_opt,
				 struct in_state *newstate2,
				 char **name));

extern int set_filter	P_((mime_t *ptr, struct out_state *stat, 
			    const struct decode_opts *decode_opt,
			    charset_t default_content_charset,
			    charset_t override_charset,
			    charset_t *res_charset)); 

extern FILE * arrange_binary P_((mime_t *ptr,
				 struct in_state  *state_in,
				 struct out_state *state_out,
				 struct in_state *newstate2,
				 char **name));

extern int text_charset_selector  P_((mime_t *p, struct header_rec * hdr));

/* pgp_decode.c */

extern void pgp_decode  		P_((mime_t *,
					    struct in_state *s_in, 
					    struct out_state *s_out,
					    const struct decode_opts *decode_opt,
					    charset_t defcharset,
					    struct header_rec *mss,
					    type_mismatch_prompt *badtype,
					    charset_t bodydefcharset));
extern int pgp_selector P_((mime_t *p, struct header_rec * hdr));

extern void pgp_SG_decoder P_((mime_t *body, mime_t *sign,
			       struct in_state   *state_in,
			       struct out_state  *state_out,
			       const struct decode_opts *decode_opt,
			       const char *micalg, 
			       charset_t defcharset,
			       struct header_rec *mss,
			       type_mismatch_prompt *badtype,
			       charset_t bodydefcharset));
extern void pgp_EC_decoder P_((mime_t *init, mime_t *data,
			       struct in_state   *state_in,
			       struct out_state  *state_out,
			       const struct decode_opts *decode_opt,
			       charset_t     defcharset,
			       struct header_rec *mss,
			       type_mismatch_prompt *badtype,
			       charset_t bodydefcharset));

/* mime_parse.c */

extern mime_t *mime_t_alloc             P_((void));
extern void mime_get_disposition        P_((char *value, mime_t *mt,
					    charset_t def_charset,
					    struct header_errors **header_error,
					    int header_status));
extern void mime_get_content		P_((char *value, mime_t *mt,
					    charset_t def_charset,
					    struct header_errors **header_error,
					    int header_status));
extern mime_t *rfc822_parse		P_((FILE *fp, int len, 
					    charset_t defcharset));
extern mime_t * multipart_parse         P_((FILE *fp, int length, 
					    char *boundary, int opts,
					    charset_t defcharset,
					    int have_boundary));

extern mime_t *mime_read_header         P_((FILE *fp, int opts, 
					    charset_t defcharset,
					    struct header_errors **header_error,
					    int header_status,
					    struct header_rec * hdr
					    ));

extern mime_t *parse_mime_headers   P_((header_list_ptr headers,
					long part_offset,
					long body_offset,
					int opts,
					charset_t hdr_charset,
					struct header_errors **header_error,
					int header_status,
					struct header_rec * hdr));

extern void parse_mime_headers1 P_((mime_t *ptr,
				    header_list_ptr headers,
				    long part_offset,
				    long body_offset,
				    int opts,
				    charset_t hdr_charset,
				    struct header_errors  ** header_error,
				    int header_status,
				    struct header_rec * hdr));


/* return 0 if not valid, and adds/prints header error 
   if header_name != NULL
*/
enum valid_field {
    fn_subtype,
    fn_major_type,
    fn_disposition,
    fn_name_of_param
};

extern int valid_mime_token P_((const char *token, 
				const char *header_name,
				enum valid_field field_name,
				struct header_errors ** header_error));

/* mailcap.c */

/* Return 1 is view command of metamail mailcap have blacklisted */
int metamail_mailcap_is_blacklisted P_((struct  metamail_mailcap_entry *mailcap));

/* Return 1 if have view command and test succees ... */
extern int mailcap_is_valid_view P_((struct mailcap_entry *f,  mime_t *p));

/* Return 1 if run succees ... */
extern int run_mailcap_view P_((const char *file_name,	
				FILE * file_handle,
				struct out_state *state_out, 
				struct mailcap_entry *x, mime_t *p,
				struct delay_unlink * delay));

/* mime_selector.c */

extern void mime_selector_free P_((struct mime_selected_handler **p));
extern int mime_classify_subparts P_((mime_t *ptr, struct header_rec * hdr));
extern int mime_classify_best_alternative P_((mime_t *ptr,
					      mime_t **ret,
					      struct header_rec * hdr));
extern int mime_classify_start_page P_((mime_t *ptr,
					mime_t **ret,
					struct header_rec * hdr));

#ifdef ANSI_C
extern encrypted_decoder null_EC_decoder;
#endif
extern void null_EC_decoder P_((mime_t *init, mime_t *data,
				struct in_state   *state_in,
				struct out_state  *state_out,
				const struct decode_opts *decode_opt,
				charset_t    defcharset,
				struct header_rec *mss,
				type_mismatch_prompt *badtype,
				charset_t bodydefcharset));

#ifdef ANSI_C
extern signed_decoder null_SG_decoder;
#endif
extern void null_SG_decoder P_((mime_t *body,
				mime_t *sign,
				struct in_state   *state_in,
				struct out_state  *state_out,
				const struct decode_opts *decode_opt,
				const char *micalg,
				charset_t defcharset,
				struct header_rec *mss,
				type_mismatch_prompt *badtype,				
				charset_t bodydefcharset));

/* parse_util.c */

extern header_list_ptr state_read_headers P_((struct in_state *, int));

/* mime_decode.c */

extern void melib_register_decoders(void);

/* partial.c */

extern void partial_decode  		P_((mime_t *ptr, struct in_state *s_in, 
					    struct out_state *s_out,
					    const struct decode_opts *decode_opt,
					    charset_t defcharset,
					    struct header_rec *mss,
					    type_mismatch_prompt *badtype,
					    charset_t bodydefcharset
					    ));

extern int partial_selector P_((mime_t *p, struct header_rec * hdr));


/*  type_check.c */

/* Returns 0 if paging of type is not allowed */
extern int check_type_magic P_((mime_t *ptr, struct in_state *state_in, 
				struct out_state *state_out,
				const struct decode_opts *decode_opt,
				type_mismatch_prompt *badtype));


/* decodeopts.c */


extern void state_add_prefix P_((struct out_state *x,
				 const struct decode_opts *o));

/* flowed.c */

#if ANSI_C
#define E_(x) extern x;
#else
#define E_(x)
#endif


E_(text_decoder_f flowed_text_decoder)
extern void flowed_text_decoder P_((mime_t *body,
				    struct in_state   *state_in,
				    struct out_state  *state_out,
				    const struct decode_opts *decode_opt,
				    charset_t text_charset));


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
