static char rcsid[] = "@(#)$Id: init.c,v 2.1 2023/12/13 16:55:32 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.1 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_melib.h"
#include "rc_imp.h"
#include "save_opts.h"
#include "s_me.h"



DEBUG_VAR(Debug,__FILE__,"mime");

#if ANSI_C
#define S_(x) static x;
#else
#define S_(x)
#endif

static char * EDITOR_PROPLINE [] = 
    { "auto", "emacs", "ignore", NULL };
ENUMERATE editor_tfent_propline = {
    editor_propline_auto,
    NUM_editor_propline,
    &(EDITOR_PROPLINE[0]),
    NULL,
    0   	/* no boolean  */,
    NULL	/* not delayed */,
    NULL
};

charset_t                        system_tagfilter_entities_cs;
struct editor_propline         * system_tagfilter_entities_pl;
struct tagfilter_entities_conf * system_tagfilter_entities_conf;

charset_t                        user_tagfilter_entities_cs;
struct editor_propline         * user_tagfilter_entities_pl;
struct tagfilter_entities_conf * user_tagfilter_entities_conf;
int                              user_tagfilter_entities_needwrite;  

static char * PAGE_TAGFILTER[NUM_page_tagfilter_v+1] = {
    "text/enriched",
    "text/html",

    NULL
};

FLAGS page_tagfilter = {
    0,0,0,

    NUM_page_tagfilter_v, &(PAGE_TAGFILTER[0]),
    FLAGVAL(page_text_enriched) |
    FLAGVAL(page_text_html),

    1,NULL
};

static ZZZ_SAVE_TYPE melib_info_data[] = {
	
    {"editor-tfent-propline",   ZZZ_DT_ENUM(&editor_tfent_propline), ZZZ_TAIL },
    {"page-tagfilter",          ZZZ_DT_FLAGS(&page_tagfilter),       ZZZ_TAIL },

};

static int COUNT=(sizeof(melib_info_data)/sizeof(ZZZ_SAVE_TYPE));
static save_info_recs *melib_info = (save_info_recs *) melib_info_data;


S_(dump_conf_map_f dump_user_tagfilter_entities_file)
static int dump_user_tagfilter_entities_file P_((FILE *f,const char *actor,
					char *version_buff,
					int * errn_res));
static int dump_user_tagfilter_entities_file(f,actor,version_buff,errno_res) 
     FILE *f;
     const char *actor;
     char *version_buff;
     int * errno_res;
{
    int r;
    
    r = dump_tagfilter_entities(f,user_tagfilter_entities_conf,NULL,
				actor,version_buff,
				user_tagfilter_entities_cs,
				user_tagfilter_entities_pl,
				LOCAL_RC,
				errno_res);

    if (r)
	user_tagfilter_entities_needwrite = 0;
    
    return r;
}

S_(dump_message_f user_tagfilter_entities_written)
static void user_tagfilter_entities_written P_((char *fname));
static void user_tagfilter_entities_written(fname)
     char *fname;
{
    lib_error(CATGETS(elm_msg_cat, MeSet, 
		      MeTagfEntitiesSavedIn,
		      "Tagfilter entities saved in file %s."), 
	      fname);
}

S_(merge_conf_map_f merge_tagfilter_entities_file)
static int merge_tagfilter_entities_file P_((const char  * fname,
				       FILE        * f));
static int merge_tagfilter_entities_file(fname,f)
     const char  * fname;
     FILE        * f;
{
    int r;
    int errors = 0;

    if (!user_tagfilter_entities_conf) {
	DPRINT(Debug,10,(&Debug,
			 "merge_tagfilter_entities_file: %s: creating new user_tagfilter_entities_conf\n",
			 fname));
	user_tagfilter_entities_conf = new_tagfilter_entities_conf(LOCAL_RC,fname);
    }

    r = merge_tagfilter_entities(fname,
				 f,
				 user_tagfilter_entities_conf,
				 &errors,
				 &user_tagfilter_entities_cs,
				 &user_tagfilter_entities_pl,
				 LOCAL_RC,&user_tagfilter_entities_needwrite);

    if (!r) {
	DPRINT(Debug,10,(&Debug,
			 "merge_tagfilter_entities_file: %s: merge_tagfilter_entities failed\n",
			 fname));	
    }

    if (errors) {
	DPRINT(Debug,10,(&Debug,
			 "merge_tagfilter_entities_file: %s: %d errors\n",
			 fname,errors));
    }
     
    return r;
}
    
S_(init_default_hook init_tagfilter_defaults)
static void init_tagfilter_defaults P_((int *errors));
static void init_tagfilter_defaults(errors)
     int *errors;
{
    DPRINT(Debug,10,(&Debug,"init_tagfilter_defaults: starting\n"));

    system_tagfilter_entities_conf =
	parse_tagfilter_entities(system_tagfilter_entfile,errors,
				 &system_tagfilter_entities_cs,
				 &system_tagfilter_entities_pl,
				 SYSTEM_RC,
				 NULL);
    
    if (system_tagfilter_entities_conf)
	link_tagfilter_entities(system_tagfilter_entities_conf,
				errors);
    
    register_conf_write(USER_TAGFILTER_ENTFILE,
			user_tagfilter_entfile,
			dump_user_tagfilter_entities_file,
			user_tagfilter_entities_written,
			&user_tagfilter_entities_needwrite,
			merge_tagfilter_entities_file); 
        
    DPRINT(Debug,10,(&Debug,"init_tagfilter_defaults: done\n"));
}

S_(init_default_hook tagfilter_read_rc_file)
static void tagfilter_read_rc_file P_((int *errors));
static void tagfilter_read_rc_file(errors)
     int *errors;
{
    DPRINT(Debug,10,(&Debug,"tagfilter_read_rc_file: starting\n"));

    user_tagfilter_entities_conf =
	parse_tagfilter_entities(user_tagfilter_entfile,errors,
				 &user_tagfilter_entities_cs,
				 &user_tagfilter_entities_pl,
				 LOCAL_RC,&user_tagfilter_entities_needwrite);

    if (user_tagfilter_entities_needwrite) {
	DPRINT(Debug,10,(&Debug,
			 "tagfilter_read_rc_file: %s needs rewrite\n",
			 user_tagfilter_entfile));
    }
    
    if (user_tagfilter_entities_conf)
	link_tagfilter_entities(user_tagfilter_entities_conf,
				errors);
    
    DPRINT(Debug,10,(&Debug,"tagfilter_read_rc_file: done\n"));
}

S_(free_rc_hook free_tagfilter_rc_file)
static void free_tagfilter_rc_file P_((void));
static void free_tagfilter_rc_file() 
{
    DPRINT(Debug,8,(&Debug, "free_hasmark_rc_file: Freeing tagfilter entities\n"));

    if (user_tagfilter_entities_conf)
	free_tagfilter_entities_conf(&user_tagfilter_entities_conf);

    if (system_tagfilter_entities_conf)
	free_tagfilter_entities_conf(&system_tagfilter_entities_conf);

    unlink_tagfilter_entities();
    tagfilter_free_sorted_tags();
}


void init_melib(read_flags)
     int read_flags /* READ_FLAG_IGNORE_MISSING */;
{
    
    register_delayed(melib_info,COUNT,read_flags);
    
    add_init_default_hook(&init_tagfilter_defaults);
    add_read_rc_file_hook(&tagfilter_read_rc_file);
    add_free_rc_hook(&free_tagfilter_rc_file);
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
