static char rcsid[] = "@(#)$Id: parse_helper.c,v 2.9 2020/12/02 07:16:30 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.9 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *          Kari Hurtta <elm@elmme-mailer.org>
 *
 *  Moved code from src/messages/header_alloc.c
 *
 *****************************************************************************/

#include "def_melib.h"

DEBUG_VAR(Debug,__FILE__,"header");

void mime_parse_helper(entry,parsed_headers)
     struct header_rec *entry;
     header_list_ptr parsed_headers;
{
    header_list_ptr tmphdr;

    if (NULL != (tmphdr = locate_header_by_name(parsed_headers,
                                                "Content-Type"))) {
	if (is_pre_mime_content_type(&entry->mime_rec,
				     tmphdr->body)) {
            DPRINT(Debug,10,(&Debug,
                             "NOT mime's content-type: %s\n",
                             tmphdr->body));
            entry->status |= PRE_MIME_CONTENT;
        }
    }

    if (entry->binary) {
        DPRINT(Debug,10,(&Debug,
                         "-- A binary message\n"));
    }

    if (req_mime_hdrencoding &&
        !(entry->status & MIME_MESSAGE)) {
        entry -> status |= NOHDRENCODING;
        DPRINT(Debug,10,(&Debug,
                         "-- Turning on NOHDRENCODING\n"));
    }

    if (!req_mime_bodyencoding &&
        !(entry->status & PRE_MIME_CONTENT)) {
        entry -> status |= MIME_MESSAGE;
        DPRINT(Debug,10,(&Debug,
                         "-- Turning on MIME_MESSAGE\n"));
    }
}

void start_body_helper(current_header,content_start,parsed_headers)
     struct header_rec *current_header;
     long content_start;
     header_list_ptr parsed_headers;
{
    /* Notice that mark_keep_folder() also uses mime_rec.offset */
    if (current_header->mime_rec.offset != content_start) {

	DPRINT(Debug,10,(&Debug,
			 "start_body_helper: ERROR? changing {mime} offset %ld => %ld\n",
			 current_header->mime_rec.offset, content_start));

	current_header->mime_rec.offset = content_start;
    }

    DPRINT(Debug,10,(&Debug, 
		     "-- content_start=%ld\n",content_start));

    if (0 != (current_header -> status & MIME_MESSAGE)) {
	long part_offset = current_header->mime_rec.begin_offset; /* Sic! */
	long body_offset = content_start;
	
	parse_mime_headers1(&current_header->mime_rec,
			    parsed_headers,
			    part_offset,body_offset,0,
			    current_header->header_charset,
			    &(current_header->header_error),
			    current_header -> status,
			    current_header);

	if (use_PGP &&
	    0 != (get_type_flags(current_header->mime_rec.TYPE) & 
		  MIME_SIGNED)) {
	    const char *pv;

	    pv = get_mime_param_compat(current_header->
				       mime_rec.TYPE_opts,"protocol");

	    if (pv &&
		0 == istrcmp(pv,
			     "application/pgp-signature"))
		current_header->pgp |= PGP_SIGNED_MESSAGE;
	}
    } else {
	/* Notice that mark_keep_folder() also uses mime_rec.offset */
	current_header->mime_rec.offset = content_start;
	DPRINT(Debug,10,(&Debug, 
			 "-- content_start=%ld\n",content_start));
    }   
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
