static char rcsid[] = "@(#)$Id: parse_util.c,v 2.18 2021/01/17 18:53:16 hurtta Exp $";


/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.18 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI) 
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_melib.h"
#include "s_me.h"

DEBUG_VAR(Debug,__FILE__,"header");

static void header_panic P_((char *,int,char *, char *)); /* Prototype */
static void header_panic(f,ln,pr,ms) 
     char * f;
     int ln;
     char *pr;
     char *ms;
{
     panic("HEADER PANIC",f,ln,pr,ms,0);
}

long skip_envelope(hdr, fp)
     struct header_rec *hdr;
     FILE *fp;
{
  char buf[STRING];
  int tmp;
  int first_line = TRUE;

  long result = hdr->offset;

  if (0 !=  fseek(fp,hdr->offset,SEEK_SET)) {
    lib_error(CATGETS(elm_msg_cat, MeSet, MeFailedSeekEnvelope,
		      "Failed to seek beginning of mail envelope (%ld)"),
	      hdr->offset);
    DPRINT(Debug,7,(&Debug,
		    "skip_envelope=-1 (fseek error)\n"));

    return -1;
  }

  DPRINT(Debug,9,(&Debug,
		  "skip_envelope: scanning offset: %ld\n",
		  result));

  while (-1 != (result = ftell(fp))) {
      DPRINT(Debug,15,(&Debug,		      
		       "skip_envelope: start pos %ld\n",
		       result));
      
      tmp = mail_gets(buf,sizeof(buf),fp);
      if (tmp < 1)
	  break;
      DPRINT(Debug,15,(&Debug,		      
		       "skip_envelope: len=%d, got: %s\n",tmp,buf));
      
      if (have_MMDF && 
	  0 == strcmp(buf,MSG_SEPARATOR))
	  continue;

      if (0 == strncmp(buf,"From ",5)) {

	  if (! real_from(buf,NULL)) {
	      DPRINT(Debug,15,(&Debug,
			       "skip_envelope: Not From separator: %s\n",
			       buf));
	      break;
	  }

	  first_line = FALSE;
	  continue;
      } 
      if (!first_line && first_word_nc(buf, ">From")) {

	  if (! real_from(buf+1,NULL)) {
	      DPRINT(Debug,15,(&Debug,
			       "skip_envelope: Not escaped >From separator: %s\n",
			       buf));
	      break;

	  }

	  continue;
      }
      DPRINT(Debug,15,(&Debug,
		       "skip_envelope: got headers: %s\n",buf));
      break;
  }
  
  DPRINT(Debug,9,(&Debug,
		  "skip_envelope: beginning of headers=%ld\n",result));
  if (-1 == result) {
      DPRINT(Debug,9,(&Debug,
		      "skip_envelope=%ld (ftell error)\n",result));
  }
  
  if (0 !=  fseek(fp,result,SEEK_SET)) {
      lib_error(CATGETS(elm_msg_cat, MeSet, MeFailedSeekHeaders,
			"Failed to seek beginning of mail headers (%ld)"),
		result);
      DPRINT(Debug,7,(&Debug,
		      "skip_envelope=-1 (fseek error)\n"));
    return -1;
  }

  DPRINT(Debug,9,(&Debug,
		  "skip_envelope=%ld\n",result));
  return result;
}

header_list_ptr file_read_headers(fp, flag) 
     FILE * fp;
     int flag;
{
    struct in_state * state = new_in_state(STATE_in_file);
    
    header_list_ptr result;
        
    set_in_state_file(fp,state);
    
    result = state_read_headers(state, flag);
    
    free_in_state(&state);
    
    return result;
}

header_list_ptr state_read_headers(s, flag) 
     struct in_state * s;
     int flag;
{
    char buffer[MAX_UNFOLDED_HDR+1];
    int size;

    header_list_ptr result = NULL, last = NULL;
    
    DPRINT(Debug,12,(&Debug,
		     "state_read_headers() --> START\n"));
    
    while ((size = state_read_hdr_line(s,buffer,sizeof buffer,
				       RHL_CHECK_HEADER|flag)) > 0) {
	char * k;
	char * k1;
	if (1 == size && 0 == strcmp(buffer,"\n"))
	    break;
	k = strchr(buffer,':');
	if (!k)
	    break;
	

	/* Strip whitespace before ':' */
	k1 = k;
	while(k1 > buffer && 
	      whitespace(*(k1-1))) {
	    k1 --;
	    *k1 = '\0';
	}
	
	*k = '\0';
	k++;

	/* Skip whitespace after ':' */
	while (whitespace(*k))
	    k++;

	update_header_list(&result,&last,buffer,k);
		
    }
    
    DPRINT(Debug,12,(&Debug,
		     "state_read_headers()=%p <-- END\n",result));
    return result;
}


void state_write_raw_header(dest_file,decode_opt,next)
     struct out_state   * dest_file;
     const struct decode_opts *decode_opt;
     header_list_ptr next;
{
    char body[MAX_UNFOLDED_HDR + 1];  /* Allow 32 KB headers after
					 unfolding
				      */
    char * ptr;
    int first = 1;
    
    strfcpy(body,next->body, sizeof body);

    /* NOTE:  strtok skips empty fields
       therefore it does NOT return 
       ptr == body on first time when called
       if there was folding (ie nl) immediately
       after header name ....
       in other words if body[] starts with \n
    */
	
    for (ptr = strtok(body,"\n"); ptr; ptr = strtok(NULL,"\n")) { 
	if (!first) { /* Do folding */

	    if (ptr <= body)
		panic("FILE PANIC",__FILE__,__LINE__,
		      "state_write_raw_header",
		      "ptr not advanced",0);
	    
	    --ptr;
	    if (*(ptr+1) == ' ')
		*ptr = ' ';
	    else
		*ptr = '\t';

	    state_add_prefix(dest_file,decode_opt);
	} else {
	    const char * name = give_header_name(next->header_name); 
	    state_add_prefix(dest_file,decode_opt);

	    state_puts(name,dest_file);

	    state_puts(": ",dest_file);

	    first = 0;
	}

	state_puts(ptr,dest_file);		    
	/* 	state_nlputs or state_printf is needed for 
		EOLN_is_CRLF conversions 
	*/
	state_nlputs("\n",dest_file);
    }
}

int NULL_header_filter(hdr,flag, have_title)
     header_list_ptr hdr;
     int flag;
     int have_title;
{
  if (hdr -> magic != HEADER_magic)
    header_panic(__FILE__,__LINE__,"NULL_header_filter","Bad magic number");

  flag++;      /* So that flag is used */
  have_title++;
  return 1;
}


void state_write_header(s,decode_opt,next,demime,defcharset)
     struct out_state   * s;
     const struct decode_opts *decode_opt;
     header_list_ptr next;
     int             demime;
     charset_t       defcharset;
{
    struct string *buffer = NULL;
    const char * defcharset_MIME_name UNUSED_VAROK =
	defcharset ? get_charset_MIME_name(defcharset) : NULL;
    const char * filter_MIME_name     UNUSED_VAROK = 
	get_out_state_f_MIME_name(s);
    const char * name = give_header_name(next->header_name);
    int X,L1;
    charset_t Y;
    const charset_t *dY;
    int j;

    enum header_display_mode_v hm = 
	give_dt_enumerate_as_int(&pg_header_display_mode);

    

    DPRINT(Debug,13,(&Debug,
		     "state_write_header: Writing header '%s': demime=%d defcharset=%s (charset filter=%s)\n",
		     name,
		     demime,
		     defcharset_MIME_name ? defcharset_MIME_name : "<not set>",
		     filter_MIME_name     ? filter_MIME_name     : "<not set>"
		     ));
    
    buffer = give_decoded_header(next,demime,defcharset);
    
    {
	const char * buffer_MIME_name UNUSED_VAROK = 
	    get_string_MIME_name(buffer);
       
	DPRINT(Debug,13,(&Debug, "state_write_header: (header data charset=%s)\n",
			 buffer_MIME_name ? buffer_MIME_name : "<not set>"));

    }

    /* Use current header charset as filter .... */
    Y = get_out_state_filter(s);
    
    /* display_charset */
    dY = get_out_state_charset_vector(s);

    for (j = 0; dY[j]; j++) {
	const char *display_MIME_name UNUSED_VAROK = 
	    get_charset_MIME_name(dY[j]);
	charset_t cs_buffer = get_string_type(buffer);

	DPRINT(Debug,13,(&Debug,
			 "state_write_header:  output charset [%d]: %s\n",
			 j,
			 display_MIME_name ? 
			 display_MIME_name : 
			 "<no MIME name>"));

	if (match_charset_name(dY[j], cs_buffer)) {
	    const char *filter_MIME_name UNUSED_VAROK;

	    set_out_state_filter(s,cs_buffer);
	    filter_MIME_name = get_out_state_f_MIME_name(s);

	    DPRINT(Debug,13,(&Debug,
			     "state_write_header: Setting charset filter to %s\n",
			     filter_MIME_name ? 
			     filter_MIME_name : 
			     "<no MIME name>"));
	}
    }

    state_add_prefix(s,decode_opt);

    if (hdr_display_plain != hm) {
	switch (hm) {

	case hdr_display_bold: 
	    set_out_state_line_pg_flags(s,pg_BOLD);
	    break;

	default:;	
	}
    }

    state_puts(name,s);
    state_puts(": ",s);


    /* Adds now segment to line of builtin pager (flushes line), 
       but do not cause newline */
    if (hdr_display_plain != hm)
	set_out_state_line_pg_flags(s,0);

    
    L1 = string_len(buffer);
    
    for (X = 0; X < L1; ) {
	int len = 0;
	uint16 ch = 0;
	struct string * data;
	int oldX = X;
	
	while (X + len < L1) {
	    ch = give_unicode_from_string(buffer,X+len);
	    
	    if (0x000C   /* FF */ == ch ||
		0x000B   /* VT */ == ch ||
		0x000A   /* LF */ == ch)
		break;
	    len++;		  
	} 
	
	/* clip_from_string updates X */
	data = clip_from_string(buffer,&X,len);
	
	if (oldX > 0) {
	    /* folding ...*/
	    state_add_prefix(s,decode_opt);
	    state_putc('\t',s);
	}
	
	state_printf(s,FRM("%S"),data);
	state_putc('\n',s);
	X++;
	
	free_string(&data);
    }
    
    if (0 == X) {
	/* No newline printed so print it now ... 

	   state_nlputs or state_printf is needed for EOLN_is_CRLF
	   conversions 
	*/	
	state_nlputs("\n",s);
    }
    free_string(&buffer);

    set_out_state_filter(s,Y);
}

void state_write_headers(s,decode_opt,hdr,filter,flag,demime,defcharset,have_title,
			 subject_charset_hack) 
     struct out_state      * s;
     const struct decode_opts *decode_opt;
     header_list_ptr    hdr;
     header_filter    * filter;
     int                flag;
     int                demime;
     charset_t          defcharset;
     int                have_title;
     charset_t          subject_charset_hack;
{
    const char * defcharset_MIME_name UNUSED_VAROK =
	defcharset ? get_charset_MIME_name(defcharset) : NULL;
    const char * filter_MIME_name     UNUSED_VAROK = 
	get_out_state_f_MIME_name(s);   
    const char * display_MIME_name    UNUSED_VAROK = 
	get_out_state_cv_MIME_name(s,0);

    header_list_ptr next = hdr;
    int ret;

    DPRINT(Debug,10,(&Debug,
		     "state_write_headers: Writing headers: demime=%d defcharset=%s (charset filter=%s output charset=%s)\n",
		     demime,
		     defcharset_MIME_name ? defcharset_MIME_name : "<not set>",
		     filter_MIME_name     ? filter_MIME_name     : "<not set>",
		     display_MIME_name    ? display_MIME_name    : "<not set>"
		     ));

    
    for (next = hdr; next; next = next -> next_header) {
	
	if (next -> magic != HEADER_magic)
	    header_panic(__FILE__,__LINE__,"state_write_headers",
			 "Bad magic number");
	
	if (! (ret = filter(next,flag,have_title))) {
	    DPRINT(Debug,12,(&Debug,
			     "state_write_headers: header='%s', {filter}=%d FILTERED\n",
			     give_header_name(next->header_name), ret));
	    continue;
	} else {
	    DPRINT(Debug,12,(&Debug,
			     "state_write_headers: header='%s', {filter}=%d PASSED\n",
			     give_header_name(next->header_name), ret));
	}

	if (subject_charset_hack &&
	    istrcmp(give_header_name(next->header_name),"Subject") == 0) {
	    const char * MIME_name = get_charset_MIME_name(subject_charset_hack);

	    DPRINT(Debug,12,(&Debug,
			     "state_write_headers: subject charset %s\n",
			     MIME_name ? MIME_name : "<no name>"));

	    state_write_header(s,decode_opt,next,demime,subject_charset_hack);
	    	    
	} else {
	    state_write_header(s,decode_opt,next,demime,defcharset);
	}
    }
}

void state_write_raw_headers(s,decode_opt,hdr,filter,flag,have_title) 
     struct out_state      * s;
     const struct decode_opts *decode_opt;
     header_list_ptr    hdr;
     header_filter    * filter;
     int                flag;
     int have_title;
{
    const char * filter_MIME_name  UNUSED_VAROK = 
	get_out_state_f_MIME_name(s);
    const char * display_MIME_name UNUSED_VAROK = 
	get_out_state_cv_MIME_name(s,0);

    header_list_ptr next = hdr;
    int ret;

    DPRINT(Debug,10,(&Debug,
		     "state_write_raw_headers: Writing headers: (charset filter=%s output charset=%s)\n",
		     filter_MIME_name  ? filter_MIME_name  : "<not set>",
		     display_MIME_name ? display_MIME_name : "<not set>"));

    
    for (next = hdr; next; next = next -> next_header) {
	
	if (next -> magic != HEADER_magic)
	    header_panic(__FILE__,__LINE__,"state_write_raw_headers",
			 "Bad magic number");
	
	if (! (ret = filter(next,flag,have_title))) {
	    DPRINT(Debug,12,(&Debug,
			     "state_write_raw_headers: header='%s', {filter}=%d FILTERED\n",
			     give_header_name(next->header_name), ret));
	    continue;
	} else {
	    DPRINT(Debug,12,(&Debug,
			     "state_write_raw_headers: header='%s', {filter}=%d PASSED\n",
			     give_header_name(next->header_name), ret));
	}
	
	state_write_raw_header(s,decode_opt,next);
    }
}



/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
