static char rcsid[] = "@(#)$Id: tagfilter_decode.c,v 2.1 2023/12/13 16:55:32 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.1 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_melib.h"
#include "s_me.h"
#include "tagfilter_imp.h"

DEBUG_VAR(Debug,__FILE__,"mime");

/* text/enriched ---------------------------------------------------------- */

E_(CT_decoder text_enriched_decode)
void text_enriched_decode (ptr, state_in, state_out, decode_opt,defcharset, 
			   mss, badtype, bodydefcharset)
     mime_t *ptr;
     struct in_state *state_in;
     struct out_state *state_out;
     const struct decode_opts *decode_opt;
     charset_t defcharset;
     struct header_rec *mss;
     type_mismatch_prompt *badtype;
     charset_t bodydefcharset;
{
    charset_t   text_charset; /* Selected charset */
    
    if (ptr->magic != MIME_magic)
	mime_panic(__FILE__,__LINE__,"text_enriched_decode",
		   "Bad magic number");
   
    DPRINT(Debug,11,(&Debug, 
		     "text_enriched_decode -> state: offset=%ld, length=%ld; \n",
		     (long) ptr -> offset, (long) ptr -> length));
    
    if (in_state_seekable(state_in)) {
	DPRINT(Debug,11,(&Debug, 
			 "                       (file): ftell=%ld\n",
			 in_state_ftell(state_in))); 
    }

    if (set_filter(ptr,state_out,decode_opt,
		   bodydefcharset ? bodydefcharset : default_mimetext_charset,
		   mss ? mss->override_charset : NULL,
		   &text_charset)) {

	struct in_state *decoded_state_in = new_in_state(STATE_in_decode);
	
	if (set_in_state_decode(state_in,decoded_state_in,
				ptr->length,
				STATE_DECODE_is_text,
				ptr->encoding,
				NULL)) {
	    
	    tagfilter_decoder(ptr,decoded_state_in,state_out,decode_opt,text_charset,
			      &tagfilter_text_enriched);

	} else {

	    struct pager_range *title_range = 
		state_add_simple_pager_range(state_out,NULL,PR_MAX_WIDTH,0,
					     0);
	    
	    /* \n resets this */
	    set_out_state_line_mode(state_out,pg_BOLD,title_range,1 /* Newline */);	
	    state_printf(state_out,
			 CATGETS(elm_msg_cat, MeSet, MeDecodeEncodingSkipping,
				 "[ Unsupported encoding, skipping... ]\n"));
	    
	    if (decode_opt->displaying) {
		/* \n resets this */
		set_out_state_line_mode(state_out,pg_BOLD,title_range,1 /* Newline */); 
		state_printf(state_out,
			     CATGETS(elm_msg_cat, MeSet, MeDecodeUseVEncodedSave,
				     "[ Use 'v' to save this part in encoded form. ]\n"));
	    }
	    
	    free_pager_range(&title_range);
	    
	}

	free_in_state(&decoded_state_in);

    }
    
    set_out_state_filter(state_out,NULL);
    
    DPRINT(Debug,11,(&Debug, 
		     "text_enriched_decode <- END; \n"));
    
    if (in_state_seekable(state_in)) {
	DPRINT(Debug,11,(&Debug, 
			 "                     (file); ftell=%ld\n",
			 in_state_ftell(state_in))); 
    }
}


/* Returns -1 on failure otherwise same mask than mime_classify_media() */
E_(mime_run_selector text_enriched_selector)
int text_enriched_selector(p,hdr)     
     mime_t *p;
     struct header_rec * hdr;
{
    int flags = NOTPLAIN_need_metamail;

    if (p->magic != MIME_magic)
	mime_panic(__FILE__,__LINE__,"text_enriched_selector",
		   "Bad magic number");
        
    if (dt_flag_is_set(&page_tagfilter,page_text_enriched))
	flags = text_charset_selector(p,hdr);
    
    return flags;
}

/* text/html ---------------------------------------------------------- */

E_(CT_decoder text_html_decode)
void text_html_decode (ptr, state_in, state_out, decode_opt,defcharset, 
			   mss, badtype, bodydefcharset)
     mime_t *ptr;
     struct in_state *state_in;
     struct out_state *state_out;
     const struct decode_opts *decode_opt;
     charset_t defcharset;
     struct header_rec *mss;
     type_mismatch_prompt *badtype;
     charset_t bodydefcharset;
{

    if (ptr->magic != MIME_magic)
	mime_panic(__FILE__,__LINE__,"text_html_decode",
		   "Bad magic number");

    
    DPRINT(Debug,11,(&Debug, 
		     "text_html_decode -> state: offset=%ld, length=%ld; \n",
		     (long) ptr -> offset, (long) ptr -> length));
    
    if (in_state_seekable(state_in)) {
	DPRINT(Debug,11,(&Debug, 
			 "                   (file): ftell=%ld\n",
			 in_state_ftell(state_in))); 
    }

    if (set_filter(ptr,state_out,decode_opt,
		   bodydefcharset ? bodydefcharset : default_mimetext_charset,
		   mss ? mss->override_charset : NULL,
		   &text_charset)) {

	struct in_state *decoded_state_in = new_in_state(STATE_in_decode);
	
	if (set_in_state_decode(state_in,decoded_state_in,
				ptr->length,
				STATE_DECODE_is_text,
				ptr->encoding,
				NULL)) {
	    
	    tagfilter_decoder(ptr,decoded_state_in,state_out,decode_opt,text_charset,
			      &tagfilter_text_html);
	    
	} else {
	    
	    struct pager_range *title_range = 
		state_add_simple_pager_range(state_out,NULL,PR_MAX_WIDTH,0,
					     0);
	    
	    /* \n resets this */
	    set_out_state_line_mode(state_out,pg_BOLD,title_range,1 /* Newline */);	
	    state_printf(state_out,
			 CATGETS(elm_msg_cat, MeSet, MeDecodeEncodingSkipping,
				 "[ Unsupported encoding, skipping... ]\n"));
	    
	    if (decode_opt->displaying) {
		/* \n resets this */
		set_out_state_line_mode(state_out,pg_BOLD,title_range,1 /* Newline */); 
		state_printf(state_out,
			     CATGETS(elm_msg_cat, MeSet, MeDecodeUseVEncodedSave,
				     "[ Use 'v' to save this part in encoded form. ]\n"));
	    }
	    
	    free_pager_range(&title_range);
	    
	}

	free_in_state(&decoded_state_in);

    }
    
    set_out_state_filter(state_out,NULL);
    
    DPRINT(Debug,11,(&Debug, 
		     "text_html_decode <- END; \n"));
    
    if (in_state_seekable(state_in)) {
	DPRINT(Debug,11,(&Debug, 
			 "                 (file); ftell=%ld\n",
			 in_state_ftell(state_in))); 
    }    
}


/* Returns -1 on failure otherwise same mask than mime_classify_media() */
E_(mime_run_selector text_html_selector)
int text_html_selector(p,hdr)     
     mime_t *p;
     struct header_rec * hdr;
{
    int flags = NOTPLAIN_need_metamail;

    if (p->magic != MIME_magic)
	mime_panic(__FILE__,__LINE__,"text_html_selector",
		   "Bad magic number");
    
    if (dt_flag_is_set(&page_tagfilter,page_text_html))
	flags = text_charset_selector(p,hdr);
    
    return flags;
}



/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
