static char rcsid[] = "@(#)$Id: tagfilter_html.c,v 2.3 2024/09/27 16:32:09 hurtta Exp $";

/************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.3 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 ************************************************************************/

#include "def_melib.h"
#include "tagfilter_imp.h"

DEBUG_VAR(Debug,__FILE__,"mime");

#if ANSI_C
#define E_(x) extern x;
#else
#define E_(x)
#endif

/* The Html Command */

static struct TAGFILTER_CMD html_start_tag = 
    { TAGFILTER_CMD_magic, 1, "html", 0, baseC(tfc_none), &text_html_head_body,
      TAGFLT_CMD_is_static|
      TAGFLT_CMD_nested_search|  /* Opening tag is optional    */
      TAGFLT_CMD_hide_text,
      NULL, NULL };

struct tagfilter_cmd * tagfilter_html_top[] = {

    tag_command(html_start_tag),

    NULL
};

static struct TAGFILTER_CMD html_head_tag = 
    { TAGFILTER_CMD_magic, 1, "head", 0, baseC(tfc_none), &text_html_metadata,
      TAGFLT_CMD_is_static|
      TAGFLT_CMD_nested_search|    /* Opening tag is optional    */
      TAGFLT_CMD_close_search|     /* Opening tag may close this */
      TAGFLT_CMD_hide_text,
      NULL, & text_html_close_head };

static struct TAGFILTER_CMD html_body_tag =  
    { TAGFILTER_CMD_magic, 1, "body", 0, baseC(tfc_none), &text_html_flow,
      TAGFLT_CMD_is_static|
      TAGFLT_CMD_nested_search|   /* Opening tag is optional    */
      TAGFLT_CMD_show_text,
      NULL, NULL };


struct tagfilter_cmd * tagfilter_html_head_body[] = {
    tag_command(html_head_tag),
    tag_command(html_body_tag),

    NULL
};

/* Not really working because body start tag can be missing also */
struct tagfilter_cmd * tagfilter_html_close_head[] = {
    tag_command(html_body_tag),

    NULL
};


static struct TAGFILTER_CMD html_base_tag = /* XXX needed for URL support */
    { TAGFILTER_CMD_magic, 1, "base", 0, baseC(tfc_unsupported), NULL,
      TAGFLT_CMD_is_static|TAGFLT_CMD_no_context,
      NULL, NULL };
static struct TAGFILTER_CMD html_link_tag = 
    { TAGFILTER_CMD_magic, 1, "link", 0, baseC(tfc_unsupported), NULL,
      TAGFLT_CMD_is_static|TAGFLT_CMD_no_context,
      NULL, NULL };
static struct TAGFILTER_CMD html_meta_tag = /* XXX needed for charset support */
    { TAGFILTER_CMD_magic, 1, "meta", 0, baseC(tfc_unsupported), NULL,
      TAGFLT_CMD_is_static|TAGFLT_CMD_no_context,
      NULL, NULL };
static struct TAGFILTER_CMD html_noscript_head_tag = 
    { TAGFILTER_CMD_magic, 1, "noscript", 0, baseC(tfc_none),
      &text_html_noscript_head
      /*  "When scripting is disabled, in a head element: 
	  in any order, zero or more link elements, 
	  zero or more style elements, and zero or more 
	  meta elements.
	  
	  When scripting is disabled, not in a head element: 
	  transparent, but there must be 
	  no noscript element descendants.
	  
	  Otherwise: text that conforms to the requirements 
	  given in the prose."   
      */,
      TAGFLT_CMD_is_static|TAGFLT_CMD_hide_text,
      NULL, NULL };

static struct TAGFILTER_CMD html_script_head_tag =  
    { TAGFILTER_CMD_magic, 1, "script", 0, baseC(tfc_unsupported),
      NULL /* XXXX 

              script is not parsed correctly either
	    */,

      TAGFLT_CMD_is_static|TAGFLT_CMD_hide_text,
      NULL, NULL };

static struct TAGFILTER_CMD html_style_tag = 
    { TAGFILTER_CMD_magic, 1, "style", 0, baseC(tfc_unsupported), NULL,
      TAGFLT_CMD_is_static|TAGFLT_CMD_hide_text,
      NULL, NULL };


static struct TAGFILTER_CMD html_template_head_tag =
    { TAGFILTER_CMD_magic, 1, "template", 0, baseC(tfc_unsupported),
      NULL /* XXXX Content is used by script
	      but not directly:

	      Nothing content model
	    */,

      TAGFLT_CMD_is_static |TAGFLT_CMD_hide_text,
      NULL, NULL };



static struct TAGFILTER_CMD html_title_tag = 
    { TAGFILTER_CMD_magic, 1, "title", 0, baseC(tfc_unsupported), NULL,
      TAGFLT_CMD_is_static|TAGFLT_CMD_hide_text,
      NULL, NULL };


struct tagfilter_cmd * tagfilter_html_metadata[] = {

    tag_command(html_base_tag),
    tag_command(html_link_tag),
    tag_command(html_meta_tag),
    tag_command(html_noscript_head_tag),
    tag_command(html_script_head_tag),
    tag_command(html_style_tag),
    tag_command(html_template_head_tag),   
    tag_command(html_title_tag),
    
    NULL
};


/* "When scripting is disabled, in a head element: in any order, 
   zero or more link elements, zero or more style elements, and 
   zero or more meta elements."
*/

struct tagfilter_cmd * tagfilter_html_noscript_head[] = {

    tag_command(html_link_tag),
    tag_command(html_style_tag),
    tag_command(html_meta_tag),
    
    NULL
};



static struct TAGFILTER_CMD html_a_tag =  /* XXX needed for URL support */
    { TAGFILTER_CMD_magic, 1, "a", 0, baseC(tfc_unsupported),
      NULL,
      /* Transparent content model */
      TAGFLT_CMD_is_static|TAGFLT_CMD_inherit_nested_tags,
      NULL, NULL };

static struct TAGFILTER_CMD html_abbr_tag =  
    { TAGFILTER_CMD_magic, 1, "abbr", 0, baseC(tfc_unsupported),
      & text_html_phrasing,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_address_tag =  
    { TAGFILTER_CMD_magic, 1, "address", 0, baseC(tfc_unsupported),
      & text_html_address
      /* "Flow content, but with no heading content descendants, 
	  no sectioning content descendants, and no header, footer, 
	  or address element descendants."
      */,

      TAGFLT_CMD_is_static,
      NULL, NULL };



static struct TAGFILTER_CMD html_area_tag =
    { TAGFILTER_CMD_magic, 1, "area", 0, baseC(tfc_unsupported), NULL,
      TAGFLT_CMD_is_static|TAGFLT_CMD_no_context,
      NULL, NULL };

static struct TAGFILTER_CMD html_article_tag =  
    { TAGFILTER_CMD_magic, 1, "article", 0, baseC(tfc_unsupported),
      &text_html_flow,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_aside_tag =  
    { TAGFILTER_CMD_magic, 1, "aside", 0, baseC(tfc_unsupported),
      &text_html_flow,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_audio_tag =  
    { TAGFILTER_CMD_magic, 1, "audio", 0, baseC(tfc_unsupported),
      NULL,
      /* Transparent content model */
      TAGFLT_CMD_is_static|TAGFLT_CMD_inherit_nested_tags,
      NULL, NULL };


static struct TAGFILTER_CMD html_b_tag =  
    { TAGFILTER_CMD_magic, 1, "b", pg_BOLD, baseC(tfc_none),
      & text_html_phrasing,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_bdi_tag =  
    { TAGFILTER_CMD_magic, 1, "bdi", 0, baseC(tfc_unsupported),
      & text_html_phrasing,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_bdo_tag =  
    { TAGFILTER_CMD_magic, 1, "bdo", 0, baseC(tfc_unsupported),
      & text_html_phrasing,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_blockquote_tag =  
    { TAGFILTER_CMD_magic, 1, "blockquote", 0, baseC(tfc_unsupported),
      &text_html_flow,

      TAGFLT_CMD_is_static|TAGFLT_CMD_force_newline,
      NULL, NULL };

static struct TAGFILTER_CMD html_br_tag = 
    { TAGFILTER_CMD_magic, 1, "br", 0, htmlC(tfc_html_br), NULL,
      TAGFLT_CMD_is_static|TAGFLT_CMD_no_context|TAGFLT_CMD_force_newline,
      NULL, NULL };

static struct TAGFILTER_CMD html_button_tag =  
    { TAGFILTER_CMD_magic, 1, "button", 0, baseC(tfc_unsupported),
      & text_html_phrasing,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_canvas_tag =  
    { TAGFILTER_CMD_magic, 1, "canvas", 0, baseC(tfc_unsupported),
      NULL,
      /* Transparent content model */
      TAGFLT_CMD_is_static|TAGFLT_CMD_inherit_nested_tags,
      NULL, NULL };

static struct TAGFILTER_CMD html_cite_tag =  
    { TAGFILTER_CMD_magic, 1, "cite", pg_ITALIC, baseC(tfc_unsupported),
      & text_html_phrasing,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_code_tag =  
    { TAGFILTER_CMD_magic, 1, "code", 0, baseC(tfc_unsupported),
      & text_html_phrasing,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_data_tag =  
    { TAGFILTER_CMD_magic, 1, "data", 0, baseC(tfc_unsupported),
      & text_html_phrasing,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_datalist_tag =  
    { TAGFILTER_CMD_magic, 1, "datalist", 0, baseC(tfc_unsupported),
      &text_html_datalist
      /* "Either: phrasing content.
	  Or: Zero or more option and script-supporting elements."
      */,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_del_tag =  
    { TAGFILTER_CMD_magic, 1, "del",
      pg_DIM|pg_STRIKETHROUGH, baseC(tfc_unsupported),
      NULL,
      /* Transparent content model */
      TAGFLT_CMD_is_static|TAGFLT_CMD_inherit_nested_tags,
      NULL, NULL };

static struct TAGFILTER_CMD html_details_tag =  
    { TAGFILTER_CMD_magic, 1, "details", 0, baseC(tfc_unsupported),
      &text_html_details
      /* "One summary element followed by flow content." */,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_dfn_tag =  
    { TAGFILTER_CMD_magic, 1, "dfn", 0, baseC(tfc_unsupported),
      & text_html_phrasing,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_dialog_tag =  
    { TAGFILTER_CMD_magic, 1, "dialog", 0, baseC(tfc_unsupported),
      &text_html_flow,

      TAGFLT_CMD_is_static,
      NULL, NULL };

/* html_div_dl_tag is used if on dl element */

static struct TAGFILTER_CMD html_div_tag =  
    { TAGFILTER_CMD_magic, 1, "div", 0, baseC(tfc_unsupported),
      &text_html_flow,

      /* "If the element is not a child of a dl element: flow content." */
      

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_dl_tag =  
    { TAGFILTER_CMD_magic, 1, "dl", 0, baseC(tfc_unsupported),
      &text_html_dl
      /*  "Either: Zero or more groups each consisting of one or more dt elements 
	  followed by one or more dd elements, optionally intermixed with 
	  script-supporting elements.
	  Or: One or more div elements, optionally intermixed with 
	  script-supporting elements."
      */,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_em_tag =  
    { TAGFILTER_CMD_magic, 1, "em", pg_ITALIC, baseC(tfc_none),
      & text_html_phrasing,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_embed_tag = 
    { TAGFILTER_CMD_magic, 1, "embed", 0, baseC(tfc_unsupported), NULL,
      TAGFLT_CMD_is_static|TAGFLT_CMD_no_context,
      NULL, NULL };

static struct TAGFILTER_CMD html_fieldset_tag =  
    { TAGFILTER_CMD_magic, 1, "fieldset", 0, baseC(tfc_unsupported),
      &text_html_fieldset /* "Optionally a legend element, 
			     followed by flow content." */,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_figure_tag =  
    { TAGFILTER_CMD_magic, 1, "figure", 0, baseC(tfc_unsupported),
      &text_html_figure /* "Either: one figcaption element followed by flow content.
			   Or: flow content followed by one figcaption element.
			   Or: flow content."
			*/,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_footer_tag =  
    { TAGFILTER_CMD_magic, 1, "footer", 0, baseC(tfc_unsupported),
      &text_html_footer
      /* "Flow content, but with no header or footer element descendants." */,
      
      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_form_tag =  
    { TAGFILTER_CMD_magic, 1, "form", 0, baseC(tfc_unsupported),
      &text_html_form
      /* "Flow content, but with no form element descendants." */,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_h1_tag =  
    { TAGFILTER_CMD_magic, 1, "h1", pg_BOLD|pg_UNDERLINE, baseC(tfc_unsupported),
      & text_html_phrasing,

      TAGFLT_CMD_is_static|TAGFLT_CMD_force_newline,
      NULL, NULL };

static struct TAGFILTER_CMD html_h2_tag =  
    { TAGFILTER_CMD_magic, 1, "h2", pg_BOLD, baseC(tfc_unsupported),
      & text_html_phrasing,

      TAGFLT_CMD_is_static|TAGFLT_CMD_force_newline,
      NULL, NULL };

static struct TAGFILTER_CMD html_h3_tag =  
    { TAGFILTER_CMD_magic, 1, "h3", pg_BOLD, baseC(tfc_unsupported),
      & text_html_phrasing,

      TAGFLT_CMD_is_static|TAGFLT_CMD_force_newline,
      NULL, NULL };

static struct TAGFILTER_CMD html_h4_tag =  
    { TAGFILTER_CMD_magic, 1, "h4", pg_BOLD, baseC(tfc_unsupported),
      & text_html_phrasing,

      TAGFLT_CMD_is_static|TAGFLT_CMD_force_newline,
      NULL, NULL };

static struct TAGFILTER_CMD html_h5_tag =  
    { TAGFILTER_CMD_magic, 1, "h5", pg_UNDERLINE, baseC(tfc_unsupported),
      & text_html_phrasing,

      TAGFLT_CMD_is_static|TAGFLT_CMD_force_newline,
      NULL, NULL };

static struct TAGFILTER_CMD html_h6_tag =  
    { TAGFILTER_CMD_magic, 1, "h6", pg_UNDERLINE, baseC(tfc_unsupported),
      & text_html_phrasing,

      TAGFLT_CMD_is_static|TAGFLT_CMD_force_newline,
      NULL, NULL };

static struct TAGFILTER_CMD html_header_tag =  
    { TAGFILTER_CMD_magic, 1, "header", 0, baseC(tfc_unsupported),
      &text_html_footer /* "Flow content, but with no header or footer element descendants." */,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_hgroup_tag =  
    { TAGFILTER_CMD_magic, 1, "hgroup", 0, baseC(tfc_unsupported),
      & text_html_hgroup
      /* "Zero or more p elements, followed by one h1, h2, h3, h4, h5, or h6 element, 
	 followed by zero or more p elements, optionally intermixed with script-supporting 
	 elements."
      */,
      
      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_hr_tag = 
    { TAGFILTER_CMD_magic, 1, "hr", 0, htmlC(tfc_html_hr), NULL,
      TAGFLT_CMD_is_static|TAGFLT_CMD_no_context|TAGFLT_CMD_force_newline,
      NULL, NULL };

static struct TAGFILTER_CMD html_i_tag =  
    { TAGFILTER_CMD_magic, 1, "i", pg_ITALIC, baseC(tfc_none),
      & text_html_phrasing,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_iframe_tag =  
    { TAGFILTER_CMD_magic, 1, "iframe", 0, baseC(tfc_unsupported),
      NULL  /* Content model is nothing, but end tag is required */,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_img_tag =   /* need handle alt attribute */
    { TAGFILTER_CMD_magic, 1, "img", 0, htmlC(tfc_html_img), NULL,
      TAGFLT_CMD_is_static|TAGFLT_CMD_no_context,
      NULL, NULL };

static struct TAGFILTER_CMD html_input_tag =   
    { TAGFILTER_CMD_magic, 1, "input", 0, baseC(tfc_unsupported), NULL,
      TAGFLT_CMD_is_static|TAGFLT_CMD_no_context,
      NULL, NULL };

static struct TAGFILTER_CMD html_ins_tag =  
    { TAGFILTER_CMD_magic, 1, "ins", pg_BOLD, baseC(tfc_unsupported),
      NULL,
      /* Transparent content model */
      TAGFLT_CMD_is_static|TAGFLT_CMD_inherit_nested_tags,
      NULL, NULL };

static struct TAGFILTER_CMD html_kbd_tag =  
    { TAGFILTER_CMD_magic, 1, "kbd", 0, baseC(tfc_unsupported),
      & text_html_phrasing,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_label_tag =  
    { TAGFILTER_CMD_magic, 1, "label", 0, baseC(tfc_unsupported),
      & text_html_label
      /* "Phrasing content, but with no descendant labelable elements unless 
	 it is the element's labeled control, and no descendant label elements."
      */,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_main_tag =  
    { TAGFILTER_CMD_magic, 1, "main", 0, baseC(tfc_unsupported),
      &text_html_flow,
      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_map_tag =  
    { TAGFILTER_CMD_magic, 1, "map", 0, baseC(tfc_unsupported),
      NULL,
      /* Transparent content model */
      TAGFLT_CMD_is_static|TAGFLT_CMD_inherit_nested_tags,
      NULL, NULL };

static struct TAGFILTER_CMD html_mark_tag =  
    { TAGFILTER_CMD_magic, 1, "mark", pg_BOLD, baseC(tfc_unsupported),
      & text_html_phrasing,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD mathml_math_tag =  
    { TAGFILTER_CMD_magic, 1, "math", 0, baseC(tfc_unsupported),
      NULL,                  /* Changes language */
      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_menu_tag =  
    { TAGFILTER_CMD_magic, 1, "menu", 0, baseC(tfc_unsupported),
      & text_html_list_items
      /* "Zero or more li and script-supporting elements." */,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_meter_tag =  
    { TAGFILTER_CMD_magic, 1, "meter", 0, baseC(tfc_unsupported),
      & text_html_meter
      /* "Phrasing content, but there must be no meter element descendants." 
       */,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_nav_tag =  
    { TAGFILTER_CMD_magic, 1, "nav", 0, baseC(tfc_unsupported),
      &text_html_flow,
      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_noscript_body_tag = 
    { TAGFILTER_CMD_magic, 1, "noscript", 0, baseC(tfc_none),
      NULL /* "When scripting is disabled, in a head element: in any order, 
	      zero or more link elements, 
	      zero or more style elements, and zero or more meta elements.
    
	      When scripting is disabled, not in a head element: transparent, but there must be 
	      no noscript element descendants.

	      Otherwise: text that conforms to the requirements given in the prose."   
	   */,
      TAGFLT_CMD_is_static |TAGFLT_CMD_inherit_nested_tags,
      NULL, NULL };

static struct TAGFILTER_CMD html_object_tag =  
    { TAGFILTER_CMD_magic, 1, "object", 0, baseC(tfc_unsupported),
      NULL,
      /* Transparent content model */
      TAGFLT_CMD_is_static|TAGFLT_CMD_inherit_nested_tags,
      NULL, NULL };

static struct TAGFILTER_CMD html_ol_tag =  
    { TAGFILTER_CMD_magic, 1, "ol", 0, htmlC(tfc_html_ol),

      & text_html_list_items
      /* "Zero or more li and script-supporting elements." */,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_output_tag =  
    { TAGFILTER_CMD_magic, 1, "output", 0, baseC(tfc_unsupported),
      & text_html_phrasing,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_p_tag =  
    { TAGFILTER_CMD_magic, 1, "p", 0, htmlC(tfc_html_p),
      & text_html_phrasing,

      TAGFLT_CMD_is_static|TAGFLT_CMD_force_newline,
      NULL,

      /* 
	"A p element's end tag can be omitted if the p element is immediately 
         followed by an address, article, aside, blockquote, details, div, dl, 
         fieldset, figcaption, figure, footer, form, h1, h2, h3, h4, h5, h6, header, 
         hgroup, hr, main, menu, nav, ol, p, pre, search, section, table, or ul element, 
         or if there is no more content in the parent element and the parent element 
         is an HTML element that is not an a, audio, del, ins, map, noscript, or 
         video element, or an autonomous custom element."
      */

      &text_html_close_p };

static struct TAGFILTER_CMD html_picture_tag =  
    { TAGFILTER_CMD_magic, 1, "picture", 0, baseC(tfc_unsupported),
      & text_html_picture
      /* "Zero or more source elements, followed by one img element, 
	 optionally intermixed with script-supporting elements."
      */,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_pre_tag =  
    { TAGFILTER_CMD_magic, 1, "pre", 0, htmlC(tfc_html_pre),
      & text_html_phrasing,

      TAGFLT_CMD_is_static|TAGFLT_CMD_force_newline,
      NULL, NULL };

static struct TAGFILTER_CMD html_progress_tag =  
    { TAGFILTER_CMD_magic, 1, "progress", 0, baseC(tfc_unsupported),
      & text_html_progress
      /* "Phrasing content, but there must be no progress element 
	 descendants." 
      */,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_q_tag =  
    { TAGFILTER_CMD_magic, 1, "q", 0, htmlC(tfc_html_q),
      & text_html_phrasing,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_ruby_tag =  
    { TAGFILTER_CMD_magic, 1, "ruby", 0, baseC(tfc_unsupported),
      & text_html_ruby
      /* "One or the other of the following:
	    Phrasing content, but with no ruby elements and with no ruby 
	    element descendants
	    A single ruby element that itself has no ruby element descendants 
	  One or the other of the following:
	    One or more rt elements
	    An rp element followed by one or more rt elements, each of which is 
                  itself followed by an rp element "
      */,
      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_s_tag =  
    { TAGFILTER_CMD_magic, 1, "s",
      pg_DIM|pg_STRIKETHROUGH, baseC(tfc_none),
      & text_html_phrasing,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_samp_tag =  
    { TAGFILTER_CMD_magic, 1, "samp", 0, baseC(tfc_unsupported),
      & text_html_phrasing,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_script_tag =  
    { TAGFILTER_CMD_magic, 1, "script", 0, baseC(tfc_unsupported),
      NULL /* XXXX 

              script is not parsed correctly either
	    */,

      TAGFLT_CMD_is_static|TAGFLT_CMD_hide_text,
      NULL, NULL };

static struct TAGFILTER_CMD html_search_tag =  
    { TAGFILTER_CMD_magic, 1, "search", 0, baseC(tfc_unsupported),
      &text_html_flow,
      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_section_tag =  
    { TAGFILTER_CMD_magic, 1, "section", 0, baseC(tfc_unsupported),
      &text_html_flow,
      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_select_tag =  
    { TAGFILTER_CMD_magic, 1, "select", 0, baseC(tfc_unsupported),
      NULL, /* "Zero or more option, optgroup, hr, and 
	       script-supporting elements."
	    */
      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_slot_tag =  
    { TAGFILTER_CMD_magic, 1, "slot", 0, baseC(tfc_unsupported),
      NULL,
      /* Transparent content model */
      TAGFLT_CMD_is_static|TAGFLT_CMD_inherit_nested_tags,
      NULL, NULL };

static struct TAGFILTER_CMD html_small_tag =  
    { TAGFILTER_CMD_magic, 1, "small", 0, baseC(tfc_unsupported),
      & text_html_phrasing,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_span_tag =  
    { TAGFILTER_CMD_magic, 1, "span", 0, baseC(tfc_unsupported),
      & text_html_phrasing,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_strong_tag =  
    { TAGFILTER_CMD_magic, 1, "strong", pg_BOLD, baseC(tfc_none),
      & text_html_phrasing,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_sub_tag =
    { TAGFILTER_CMD_magic, 1, "sub",
      pg_SUBSCRIPT|pg_REVERSE, baseC(tfc_none),
      & text_html_phrasing,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_sup_tag =
    { TAGFILTER_CMD_magic, 1, "sup",
      pg_SUPERSCRIPT|pg_STANDOUT, baseC(tfc_none),
      & text_html_phrasing,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD svg_svg_tag =  
    { TAGFILTER_CMD_magic, 1, "svg", 0, baseC(tfc_unsupported),
      NULL /* Changes language */,

      TAGFLT_CMD_is_static|TAGFLT_CMD_hide_text,
      NULL, NULL };

static struct TAGFILTER_CMD html_table_tag =  
    { TAGFILTER_CMD_magic, 1, "table", 0, baseC(tfc_unsupported),
      & text_html_table
      /* "In this order: optionally a caption element, followed by zero or 
	 more colgroup elements, followed optionally by a thead element, 
	 followed by either zero or more tbody elements or one or more 
	 tr elements, followed optionally by a tfoot element, 
	 optionally intermixed with one or more script-supporting elements."
      */,

      TAGFLT_CMD_is_static|TAGFLT_CMD_force_newline,
      NULL, NULL };


static struct TAGFILTER_CMD html_template_tag =
    { TAGFILTER_CMD_magic, 1, "template", 0, baseC(tfc_unsupported),
      NULL /* XXXX Content is used by script
	      but not directly:

	      Nothing content model
	    */,

      TAGFLT_CMD_is_static |TAGFLT_CMD_hide_text,
      NULL, NULL };

static struct TAGFILTER_CMD html_textarea_tag =
    { TAGFILTER_CMD_magic, 1, "textarea",  pg_DIM, baseC(tfc_unsupported),

      NULL /* Text */,
      TAGFLT_CMD_is_static|TAGFLT_CMD_force_newline,
      NULL, NULL
    };

static struct TAGFILTER_CMD html_time_tag =  
    { TAGFILTER_CMD_magic, 1, "time", 0, baseC(tfc_unsupported),
      & text_html_phrasing
      /* Can not really described here

	 "If the element has a datetime attribute: Phrasing content.
	 Otherwise: Text, but must match requirements described in 
	 prose below."
      */,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_u_tag =  
    { TAGFILTER_CMD_magic, 1, "u", pg_UNDERLINE, baseC(tfc_none),
      & text_html_phrasing,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_ul_tag =
    { TAGFILTER_CMD_magic, 1, "ul",  0, htmlC(tfc_html_ul),
      & text_html_list_items
      /* "Zero or more li and script-supporting elements." */,
      TAGFLT_CMD_is_static|TAGFLT_CMD_force_newline,
      NULL, NULL
    };

static struct TAGFILTER_CMD html_var_tag =  
    { TAGFILTER_CMD_magic, 1, "var", pg_ITALIC, baseC(tfc_unsupported),
      & text_html_phrasing,

      TAGFLT_CMD_is_static,
      NULL, NULL };

static struct TAGFILTER_CMD html_video_tag =  
    { TAGFILTER_CMD_magic, 1, "video", 0, baseC(tfc_unsupported),
      NULL
      /* -- Both listig elements and transparent does not work --


	 "If the element has a src attribute: zero or more 
	 track elements, then transparent, but with no media 
	 element descendants.
	 If the element does not have a src attribute: zero or 
	 more source elements, then zero or more track elements, 
	 then transparent, but with no media element descendants."
      */,
      TAGFLT_CMD_is_static|TAGFLT_CMD_inherit_nested_tags,
      NULL, NULL };

static struct TAGFILTER_CMD html_wbr_tag = 
    { TAGFILTER_CMD_magic, 1, "wbr", 0, baseC(tfc_unsupported), NULL,
      TAGFLT_CMD_is_static|TAGFLT_CMD_no_context,
      NULL, NULL };


struct tagfilter_cmd * tagfilter_html_flow[] = {
    
    tag_command(html_a_tag),
    tag_command(html_abbr_tag),
    tag_command(html_address_tag),
    tag_command(html_area_tag),
    tag_command(html_article_tag),
    tag_command(html_aside_tag),    
    tag_command(html_audio_tag),

    tag_command(html_b_tag),
    tag_command(html_bdi_tag),
    tag_command(html_bdo_tag),
    tag_command(html_blockquote_tag),
    tag_command(html_br_tag),
    tag_command(html_button_tag),

    tag_command(html_canvas_tag),
    tag_command(html_cite_tag),
    tag_command(html_code_tag),

    tag_command(html_data_tag),
    tag_command(html_datalist_tag),
    tag_command(html_del_tag),
    tag_command(html_details_tag),
    tag_command(html_dfn_tag),
    tag_command(html_dialog_tag),
    tag_command(html_div_tag),
    tag_command(html_dl_tag),

    tag_command(html_em_tag),
    tag_command(html_embed_tag),

    tag_command(html_fieldset_tag),
    tag_command(html_figure_tag),
    tag_command(html_footer_tag),
    tag_command(html_form_tag),

    tag_command(html_h1_tag),
    tag_command(html_h2_tag),
    tag_command(html_h3_tag),
    tag_command(html_h4_tag),
    tag_command(html_h5_tag),
    tag_command(html_h6_tag),
    tag_command(html_header_tag),
    tag_command(html_hgroup_tag),
    tag_command(html_hr_tag),

    tag_command(html_i_tag),
    tag_command(html_iframe_tag),
    tag_command(html_img_tag),
    tag_command(html_input_tag),
    tag_command(html_ins_tag),
    
    tag_command(html_kbd_tag),

    tag_command(html_label_tag),
    tag_command(html_link_tag),

    tag_command(html_main_tag),
    tag_command(html_map_tag),
    tag_command(html_mark_tag),
    tag_command(mathml_math_tag),
    tag_command(html_menu_tag),
    tag_command(html_meta_tag),
    tag_command(html_meter_tag),

    tag_command(html_nav_tag),
    tag_command(html_noscript_body_tag),

    tag_command(html_object_tag),
    tag_command(html_ol_tag),
    tag_command(html_output_tag),

    tag_command(html_p_tag),
    tag_command(html_picture_tag),
    tag_command(html_pre_tag),
    tag_command(html_progress_tag),

    tag_command(html_q_tag),

    tag_command(html_ruby_tag),

    tag_command(html_s_tag),
    tag_command(html_samp_tag),
    tag_command(html_script_tag),
    tag_command(html_search_tag),
    tag_command(html_section_tag),
    tag_command(html_select_tag),
    tag_command(html_slot_tag),
    tag_command(html_small_tag),
    tag_command(html_span_tag),
    tag_command(html_strong_tag),
    tag_command(html_sub_tag),
    tag_command(html_sup_tag),
    tag_command(svg_svg_tag),

    tag_command(html_table_tag),
    tag_command(html_template_tag),
    tag_command(html_textarea_tag),
    tag_command(html_time_tag),

    tag_command(html_u_tag),
    tag_command(html_ul_tag),

    tag_command(html_var_tag),
    tag_command(html_video_tag),

    tag_command(html_wbr_tag),
    
    /* "autonomous custom elements, text" */
    
    NULL
};

/* "Runs of phrasing content form paragraphs." */

struct tagfilter_cmd * tagfilter_html_phrasing[] = {
    
    tag_command(html_a_tag),
    tag_command(html_abbr_tag),
    tag_command(html_area_tag),
    tag_command(html_audio_tag),

    tag_command(html_b_tag),
    tag_command(html_bdi_tag),
    tag_command(html_bdo_tag),
    tag_command(html_br_tag),
    tag_command(html_button_tag),

    tag_command(html_canvas_tag),
    tag_command(html_cite_tag),
    tag_command(html_code_tag),

    tag_command(html_data_tag),
    tag_command(html_datalist_tag),
    tag_command(html_del_tag),
    tag_command(html_dfn_tag),

    tag_command(html_em_tag),
    tag_command(html_embed_tag),

    tag_command(html_i_tag),
    tag_command(html_iframe_tag),
    tag_command(html_img_tag),
    tag_command(html_input_tag),
    tag_command(html_ins_tag),

    tag_command(html_kbd_tag),

    tag_command(html_label_tag),
    tag_command(html_link_tag),

    tag_command(html_map_tag),
    tag_command(html_mark_tag),
    tag_command(mathml_math_tag),
    tag_command(html_meta_tag),
    tag_command(html_meter_tag),

    tag_command(html_noscript_body_tag),

    tag_command(html_object_tag),
    tag_command(html_output_tag),

    tag_command(html_picture_tag),
    tag_command(html_progress_tag),

    tag_command(html_q_tag),

    tag_command(html_ruby_tag),

    tag_command(html_s_tag),
    tag_command(html_samp_tag),
    tag_command(html_script_tag),
    tag_command(html_select_tag),
    tag_command(html_slot_tag),
    tag_command(html_small_tag),
    tag_command(html_span_tag),
    tag_command(html_strong_tag),
    tag_command(html_sub_tag),
    tag_command(html_sup_tag),
    tag_command(svg_svg_tag),

    tag_command(html_template_tag),
    tag_command(html_textarea_tag),
    tag_command(html_time_tag),

    tag_command(html_u_tag),

    tag_command(html_var_tag),
    tag_command(html_video_tag),

    tag_command(html_wbr_tag),

    /* "autonomous custom elements, text" */

    NULL
};



static struct TAGFILTER_CMD html_option_tag =  
    { TAGFILTER_CMD_magic, 1, "option", 0, baseC(tfc_unsupported),
      NULL  /* Text */,

      TAGFLT_CMD_is_static,
      NULL, NULL };


/* "Either: phrasing content.
   Or: Zero or more option and script-supporting elements."
*/

struct tagfilter_cmd * tagfilter_html_datalist[] = {

    /* phrasing content */
    
    tag_command(html_a_tag),
    tag_command(html_abbr_tag),
    tag_command(html_area_tag),
    tag_command(html_audio_tag),

    tag_command(html_b_tag),
    tag_command(html_bdi_tag),
    tag_command(html_bdo_tag),
    tag_command(html_br_tag),
    tag_command(html_button_tag),

    tag_command(html_canvas_tag),
    tag_command(html_cite_tag),
    tag_command(html_code_tag),

    tag_command(html_data_tag),
    tag_command(html_datalist_tag),
    tag_command(html_del_tag),
    tag_command(html_dfn_tag),

    tag_command(html_em_tag),
    tag_command(html_embed_tag),

    tag_command(html_i_tag),
    tag_command(html_iframe_tag),
    tag_command(html_img_tag),
    tag_command(html_input_tag),
    tag_command(html_ins_tag),

    tag_command(html_kbd_tag),

    tag_command(html_label_tag),
    tag_command(html_link_tag),

    tag_command(html_map_tag),
    tag_command(html_mark_tag),
    tag_command(mathml_math_tag),
    tag_command(html_meta_tag),
    tag_command(html_meter_tag),

    tag_command(html_noscript_body_tag),

    tag_command(html_object_tag),
    tag_command(html_output_tag),

    tag_command(html_picture_tag),
    tag_command(html_progress_tag),

    tag_command(html_q_tag),

    tag_command(html_ruby_tag),

    tag_command(html_s_tag),
    tag_command(html_samp_tag),
    tag_command(html_script_tag),
    tag_command(html_select_tag),
    tag_command(html_slot_tag),
    tag_command(html_small_tag),
    tag_command(html_span_tag),
    tag_command(html_strong_tag),
    tag_command(html_sub_tag),
    tag_command(html_sup_tag),
    tag_command(svg_svg_tag),

    tag_command(html_template_tag),
    tag_command(html_textarea_tag),
    tag_command(html_time_tag),

    tag_command(html_u_tag),

    tag_command(html_var_tag),
    tag_command(html_video_tag),

    tag_command(html_wbr_tag),

    /* Zero or more option and script-supporting elements */

    tag_command(html_option_tag),
    tag_command(html_script_tag),
    tag_command(html_template_tag),

    NULL
};

static struct TAGFILTER_CMD html_summary_tag =  
    { TAGFILTER_CMD_magic, 1, "summary", 0, baseC(tfc_unsupported),
      NULL /* "Phrasing content, optionally intermixed with heading content." */,

      TAGFLT_CMD_is_static,
      NULL, NULL };



/* "One summary element followed by flow content." */

struct tagfilter_cmd * tagfilter_html_details[] = {
    tag_command(html_summary_tag),

    /* flow content */

    tag_command(html_a_tag),
    tag_command(html_abbr_tag),
    tag_command(html_address_tag),
    tag_command(html_area_tag),
    tag_command(html_article_tag),
    tag_command(html_aside_tag),    
    tag_command(html_audio_tag),

    tag_command(html_b_tag),
    tag_command(html_bdi_tag),
    tag_command(html_bdo_tag),
    tag_command(html_blockquote_tag),
    tag_command(html_br_tag),
    tag_command(html_button_tag),

    tag_command(html_canvas_tag),
    tag_command(html_cite_tag),
    tag_command(html_code_tag),

    tag_command(html_data_tag),
    tag_command(html_datalist_tag),
    tag_command(html_del_tag),
    tag_command(html_details_tag),
    tag_command(html_dfn_tag),
    tag_command(html_dialog_tag),
    tag_command(html_div_tag),
    tag_command(html_dl_tag),

    tag_command(html_em_tag),
    tag_command(html_embed_tag),

    tag_command(html_fieldset_tag),
    tag_command(html_figure_tag),
    tag_command(html_footer_tag),
    tag_command(html_form_tag),

    tag_command(html_h1_tag),
    tag_command(html_h2_tag),
    tag_command(html_h3_tag),
    tag_command(html_h4_tag),
    tag_command(html_h5_tag),
    tag_command(html_h6_tag),
    tag_command(html_header_tag),
    tag_command(html_hgroup_tag),
    tag_command(html_hr_tag),

    tag_command(html_i_tag),
    tag_command(html_iframe_tag),
    tag_command(html_img_tag),
    tag_command(html_input_tag),
    tag_command(html_ins_tag),
    
    tag_command(html_kbd_tag),

    tag_command(html_label_tag),
    tag_command(html_link_tag),

    tag_command(html_main_tag),
    tag_command(html_map_tag),
    tag_command(html_mark_tag),
    tag_command(mathml_math_tag),
    tag_command(html_menu_tag),
    tag_command(html_meta_tag),
    tag_command(html_meter_tag),

    tag_command(html_nav_tag),
    tag_command(html_noscript_body_tag),

    tag_command(html_object_tag),
    tag_command(html_ol_tag),
    tag_command(html_output_tag),

    tag_command(html_p_tag),
    tag_command(html_picture_tag),
    tag_command(html_pre_tag),
    tag_command(html_progress_tag),

    tag_command(html_q_tag),

    tag_command(html_ruby_tag),

    tag_command(html_s_tag),
    tag_command(html_samp_tag),
    tag_command(html_script_tag),
    tag_command(html_search_tag),
    tag_command(html_section_tag),
    tag_command(html_select_tag),
    tag_command(html_slot_tag),
    tag_command(html_small_tag),
    tag_command(html_span_tag),
    tag_command(html_strong_tag),
    tag_command(html_sub_tag),
    tag_command(html_sup_tag),
    tag_command(svg_svg_tag),

    tag_command(html_table_tag),
    tag_command(html_template_tag),
    tag_command(html_textarea_tag),
    tag_command(html_time_tag),

    tag_command(html_u_tag),
    tag_command(html_ul_tag),

    tag_command(html_var_tag),
    tag_command(html_video_tag),

    tag_command(html_wbr_tag),
    
    /* "autonomous custom elements, text" */
    
    NULL
};

static struct TAGFILTER_CMD html_dt_tag =  
    { TAGFILTER_CMD_magic, 1, "dt", 0, baseC(tfc_unsupported),
      &text_html_flow
      /* "Flow content, but with no header, footer, 
	 sectioning content, or heading content descendants." */,
      TAGFLT_CMD_is_static,
      NULL, 
      /* 
	 "A dt element's end tag can be omitted if the dt element 
	 is immediately followed by another dt element or a dd element."
      */
      &text_html_close_dtdd
    };

static struct TAGFILTER_CMD html_dd_tag =  
    { TAGFILTER_CMD_magic, 1, "dd", 0, baseC(tfc_unsupported),
      &text_html_flow,
      TAGFLT_CMD_is_static,
      NULL, 
      /* 
	 "A dd element's end tag can be omitted if the 
	 dd element is immediately followed by another dd 
	 element or a dt element, or if there is no more 
	 content in the parent element."
      */
      &text_html_close_dtdd
    };



/* This is used if on dl element, otherwise  html_div_tag is used */

static struct TAGFILTER_CMD html_div_dl_tag =  
    { TAGFILTER_CMD_magic, 1, "div", 0, baseC(tfc_unsupported),
      &text_html_div_dl

      /* "If the element is a child of a dl element: one or more dt 
	        elements followed by 
		one or more dd elements, optionally intermixed with 
		script-supporting elements."
      */,
      

      TAGFLT_CMD_is_static,
      NULL, NULL };


/* "Either: Zero or more groups each consisting of one or more dt elements followed 
    by one or more dd elements, optionally intermixed with script-supporting elements.

    Or: One or more div elements, optionally 
    intermixed with script-supporting elements."
*/

struct tagfilter_cmd * tagfilter_html_dl[] = {
    tag_command(html_dt_tag),
    tag_command(html_dd_tag),
    tag_command(html_div_dl_tag),

    /* Script-supporting elements */
    
    tag_command(html_script_tag),
    tag_command(html_template_tag),
    
    NULL
};

static struct TAGFILTER_CMD html_legend_tag =  
    { TAGFILTER_CMD_magic, 1, "legend", 0, baseC(tfc_unsupported),
      NULL, /* "Phrasing content, optionally intermixed with heading content."

	    */
      TAGFLT_CMD_is_static,
      NULL, NULL };

/* "Optionally a legend element, followed by flow content." */

struct tagfilter_cmd * tagfilter_html_fieldset[] = {
    tag_command(html_legend_tag),

    /* flow content */

    tag_command(html_a_tag),
    tag_command(html_abbr_tag),
    tag_command(html_address_tag),
    tag_command(html_area_tag),
    tag_command(html_article_tag),
    tag_command(html_aside_tag),    
    tag_command(html_audio_tag),

    tag_command(html_b_tag),
    tag_command(html_bdi_tag),
    tag_command(html_bdo_tag),
    tag_command(html_blockquote_tag),
    tag_command(html_br_tag),
    tag_command(html_button_tag),

    tag_command(html_canvas_tag),
    tag_command(html_cite_tag),
    tag_command(html_code_tag),

    tag_command(html_data_tag),
    tag_command(html_datalist_tag),
    tag_command(html_del_tag),
    tag_command(html_details_tag),
    tag_command(html_dfn_tag),
    tag_command(html_dialog_tag),
    tag_command(html_div_tag),
    tag_command(html_dl_tag),

    tag_command(html_em_tag),
    tag_command(html_embed_tag),

    tag_command(html_fieldset_tag),
    tag_command(html_figure_tag),
    tag_command(html_footer_tag),
    tag_command(html_form_tag),

    tag_command(html_h1_tag),
    tag_command(html_h2_tag),
    tag_command(html_h3_tag),
    tag_command(html_h4_tag),
    tag_command(html_h5_tag),
    tag_command(html_h6_tag),
    tag_command(html_header_tag),
    tag_command(html_hgroup_tag),
    tag_command(html_hr_tag),

    tag_command(html_i_tag),
    tag_command(html_iframe_tag),
    tag_command(html_img_tag),
    tag_command(html_input_tag),
    tag_command(html_ins_tag),
    
    tag_command(html_kbd_tag),

    tag_command(html_label_tag),
    tag_command(html_link_tag),

    tag_command(html_main_tag),
    tag_command(html_map_tag),
    tag_command(html_mark_tag),
    tag_command(mathml_math_tag),
    tag_command(html_menu_tag),
    tag_command(html_meta_tag),
    tag_command(html_meter_tag),

    tag_command(html_nav_tag),
    tag_command(html_noscript_body_tag),

    tag_command(html_object_tag),
    tag_command(html_ol_tag),
    tag_command(html_output_tag),

    tag_command(html_p_tag),
    tag_command(html_picture_tag),
    tag_command(html_pre_tag),
    tag_command(html_progress_tag),

    tag_command(html_q_tag),

    tag_command(html_ruby_tag),

    tag_command(html_s_tag),
    tag_command(html_samp_tag),
    tag_command(html_script_tag),
    tag_command(html_search_tag),
    tag_command(html_section_tag),
    tag_command(html_select_tag),
    tag_command(html_slot_tag),
    tag_command(html_small_tag),
    tag_command(html_span_tag),
    tag_command(html_strong_tag),
    tag_command(html_sub_tag),
    tag_command(html_sup_tag),
    tag_command(svg_svg_tag),

    tag_command(html_table_tag),
    tag_command(html_template_tag),
    tag_command(html_textarea_tag),
    tag_command(html_time_tag),

    tag_command(html_u_tag),
    tag_command(html_ul_tag),

    tag_command(html_var_tag),
    tag_command(html_video_tag),

    tag_command(html_wbr_tag),
    
    /* "autonomous custom elements, text" */
    
    NULL
};

static struct TAGFILTER_CMD html_figcaption_tag =  
    { TAGFILTER_CMD_magic, 1, "figcaption", 0, baseC(tfc_unsupported),
      &text_html_flow,

      TAGFLT_CMD_is_static,
      NULL, NULL };


/*  "Either: one figcaption element followed by flow content.
     Or: flow content followed by one figcaption element.
     Or: flow content."
*/

struct tagfilter_cmd * tagfilter_html_figure[] = {
    tag_command(html_figcaption_tag),

    /* flow content */

    tag_command(html_a_tag),
    tag_command(html_abbr_tag),
    tag_command(html_address_tag),
    tag_command(html_area_tag),
    tag_command(html_article_tag),
    tag_command(html_aside_tag),    
    tag_command(html_audio_tag),

    tag_command(html_b_tag),
    tag_command(html_bdi_tag),
    tag_command(html_bdo_tag),
    tag_command(html_blockquote_tag),
    tag_command(html_br_tag),
    tag_command(html_button_tag),

    tag_command(html_canvas_tag),
    tag_command(html_cite_tag),
    tag_command(html_code_tag),

    tag_command(html_data_tag),
    tag_command(html_datalist_tag),
    tag_command(html_del_tag),
    tag_command(html_details_tag),
    tag_command(html_dfn_tag),
    tag_command(html_dialog_tag),
    tag_command(html_div_tag),
    tag_command(html_dl_tag),

    tag_command(html_em_tag),
    tag_command(html_embed_tag),

    tag_command(html_fieldset_tag),
    tag_command(html_figure_tag),
    tag_command(html_footer_tag),
    tag_command(html_form_tag),

    tag_command(html_h1_tag),
    tag_command(html_h2_tag),
    tag_command(html_h3_tag),
    tag_command(html_h4_tag),
    tag_command(html_h5_tag),
    tag_command(html_h6_tag),
    tag_command(html_header_tag),
    tag_command(html_hgroup_tag),
    tag_command(html_hr_tag),

    tag_command(html_i_tag),
    tag_command(html_iframe_tag),
    tag_command(html_img_tag),
    tag_command(html_input_tag),
    tag_command(html_ins_tag),
    
    tag_command(html_kbd_tag),

    tag_command(html_label_tag),
    tag_command(html_link_tag),

    tag_command(html_main_tag),
    tag_command(html_map_tag),
    tag_command(html_mark_tag),
    tag_command(mathml_math_tag),
    tag_command(html_menu_tag),
    tag_command(html_meta_tag),
    tag_command(html_meter_tag),

    tag_command(html_nav_tag),
    tag_command(html_noscript_body_tag),

    tag_command(html_object_tag),
    tag_command(html_ol_tag),
    tag_command(html_output_tag),

    tag_command(html_p_tag),
    tag_command(html_picture_tag),
    tag_command(html_pre_tag),
    tag_command(html_progress_tag),

    tag_command(html_q_tag),

    tag_command(html_ruby_tag),

    tag_command(html_s_tag),
    tag_command(html_samp_tag),
    tag_command(html_script_tag),
    tag_command(html_search_tag),
    tag_command(html_section_tag),
    tag_command(html_select_tag),
    tag_command(html_slot_tag),
    tag_command(html_small_tag),
    tag_command(html_span_tag),
    tag_command(html_strong_tag),
    tag_command(html_sub_tag),
    tag_command(html_sup_tag),
    tag_command(svg_svg_tag),

    tag_command(html_table_tag),
    tag_command(html_template_tag),
    tag_command(html_textarea_tag),
    tag_command(html_time_tag),

    tag_command(html_u_tag),
    tag_command(html_ul_tag),

    tag_command(html_var_tag),
    tag_command(html_video_tag),

    tag_command(html_wbr_tag),
    
    /* "autonomous custom elements, text" */
    
    NULL
};

/* Can not really described here


   "Flow content, but with no header or footer element descendants."
 */

struct tagfilter_cmd * tagfilter_html_footer[] = {

    tag_command(html_a_tag),
    tag_command(html_abbr_tag),
    tag_command(html_address_tag),
    tag_command(html_area_tag),
    tag_command(html_article_tag),
    tag_command(html_aside_tag),    
    tag_command(html_audio_tag),

    tag_command(html_b_tag),
    tag_command(html_bdi_tag),
    tag_command(html_bdo_tag),
    tag_command(html_blockquote_tag),
    tag_command(html_br_tag),
    tag_command(html_button_tag),

    tag_command(html_canvas_tag),
    tag_command(html_cite_tag),
    tag_command(html_code_tag),

    tag_command(html_data_tag),
    tag_command(html_datalist_tag),
    tag_command(html_del_tag),
    tag_command(html_details_tag),
    tag_command(html_dfn_tag),
    tag_command(html_dialog_tag),
    tag_command(html_div_tag),
    tag_command(html_dl_tag),

    tag_command(html_em_tag),
    tag_command(html_embed_tag),

    tag_command(html_fieldset_tag),
    tag_command(html_figure_tag),
#if 0 /* Not allowed */
    tag_command(html_footer_tag),
#endif
    tag_command(html_form_tag),

    tag_command(html_h1_tag),
    tag_command(html_h2_tag),
    tag_command(html_h3_tag),
    tag_command(html_h4_tag),
    tag_command(html_h5_tag),
    tag_command(html_h6_tag),
#if 0  /* Not allowed */
    tag_command(html_header_tag),
#endif
    tag_command(html_hgroup_tag),
    tag_command(html_hr_tag),

    tag_command(html_i_tag),
    tag_command(html_iframe_tag),
    tag_command(html_img_tag),
    tag_command(html_input_tag),
    tag_command(html_ins_tag),
    
    tag_command(html_kbd_tag),

    tag_command(html_label_tag),
    tag_command(html_link_tag),

    tag_command(html_main_tag),
    tag_command(html_map_tag),
    tag_command(html_mark_tag),
    tag_command(mathml_math_tag),
    tag_command(html_menu_tag),
    tag_command(html_meta_tag),
    tag_command(html_meter_tag),

    tag_command(html_nav_tag),
    tag_command(html_noscript_body_tag),

    tag_command(html_object_tag),
    tag_command(html_ol_tag),
    tag_command(html_output_tag),

    tag_command(html_p_tag),
    tag_command(html_picture_tag),
    tag_command(html_pre_tag),
    tag_command(html_progress_tag),

    tag_command(html_q_tag),

    tag_command(html_ruby_tag),

    tag_command(html_s_tag),
    tag_command(html_samp_tag),
    tag_command(html_script_tag),
    tag_command(html_search_tag),
    tag_command(html_section_tag),
    tag_command(html_select_tag),
    tag_command(html_slot_tag),
    tag_command(html_small_tag),
    tag_command(html_span_tag),
    tag_command(html_strong_tag),
    tag_command(html_sub_tag),
    tag_command(html_sup_tag),
    tag_command(svg_svg_tag),

    tag_command(html_table_tag),
    tag_command(html_template_tag),
    tag_command(html_textarea_tag),
    tag_command(html_time_tag),

    tag_command(html_u_tag),
    tag_command(html_ul_tag),

    tag_command(html_var_tag),
    tag_command(html_video_tag),

    tag_command(html_wbr_tag),
    
    /* "autonomous custom elements, text" */
    
    NULL
};

/* Can not really described here

   "Flow content, but with no form element descendants."
   
 */

struct tagfilter_cmd * tagfilter_html_form[] = {

    tag_command(html_a_tag),
    tag_command(html_abbr_tag),
    tag_command(html_address_tag),
    tag_command(html_area_tag),
    tag_command(html_article_tag),
    tag_command(html_aside_tag),    
    tag_command(html_audio_tag),

    tag_command(html_b_tag),
    tag_command(html_bdi_tag),
    tag_command(html_bdo_tag),
    tag_command(html_blockquote_tag),
    tag_command(html_br_tag),
    tag_command(html_button_tag),

    tag_command(html_canvas_tag),
    tag_command(html_cite_tag),
    tag_command(html_code_tag),

    tag_command(html_data_tag),
    tag_command(html_datalist_tag),
    tag_command(html_del_tag),
    tag_command(html_details_tag),
    tag_command(html_dfn_tag),
    tag_command(html_dialog_tag),
    tag_command(html_div_tag),
    tag_command(html_dl_tag),

    tag_command(html_em_tag),
    tag_command(html_embed_tag),

    tag_command(html_fieldset_tag),
    tag_command(html_figure_tag),
    tag_command(html_footer_tag),
#if 0 /* Not allowed */
    tag_command(html_form_tag),
#endif

    tag_command(html_h1_tag),
    tag_command(html_h2_tag),
    tag_command(html_h3_tag),
    tag_command(html_h4_tag),
    tag_command(html_h5_tag),
    tag_command(html_h6_tag),
    tag_command(html_header_tag),
    tag_command(html_hgroup_tag),
    tag_command(html_hr_tag),

    tag_command(html_i_tag),
    tag_command(html_iframe_tag),
    tag_command(html_img_tag),
    tag_command(html_input_tag),
    tag_command(html_ins_tag),
    
    tag_command(html_kbd_tag),

    tag_command(html_label_tag),
    tag_command(html_link_tag),

    tag_command(html_main_tag),
    tag_command(html_map_tag),
    tag_command(html_mark_tag),
    tag_command(mathml_math_tag),
    tag_command(html_menu_tag),
    tag_command(html_meta_tag),
    tag_command(html_meter_tag),

    tag_command(html_nav_tag),
    tag_command(html_noscript_body_tag),

    tag_command(html_object_tag),
    tag_command(html_ol_tag),
    tag_command(html_output_tag),

    tag_command(html_p_tag),
    tag_command(html_picture_tag),
    tag_command(html_pre_tag),
    tag_command(html_progress_tag),

    tag_command(html_q_tag),

    tag_command(html_ruby_tag),

    tag_command(html_s_tag),
    tag_command(html_samp_tag),
    tag_command(html_script_tag),
    tag_command(html_search_tag),
    tag_command(html_section_tag),
    tag_command(html_select_tag),
    tag_command(html_slot_tag),
    tag_command(html_small_tag),
    tag_command(html_span_tag),
    tag_command(html_strong_tag),
    tag_command(html_sub_tag),
    tag_command(html_sup_tag),
    tag_command(svg_svg_tag),

    tag_command(html_table_tag),
    tag_command(html_template_tag),
    tag_command(html_textarea_tag),
    tag_command(html_time_tag),

    tag_command(html_u_tag),
    tag_command(html_ul_tag),

    tag_command(html_var_tag),
    tag_command(html_video_tag),

    tag_command(html_wbr_tag),
    
    /* "autonomous custom elements, text" */
    
    NULL

};

/* "Zero or more p elements, followed by one h1, h2, h3, h4, h5, or h6 element, 
   followed by zero or more p elements, optionally intermixed with script-supporting elements.
*/

struct tagfilter_cmd * tagfilter_html_hgroup[] = {
    tag_command(html_h1_tag),
    tag_command(html_h2_tag),
    tag_command(html_h3_tag),
    tag_command(html_h4_tag),
    tag_command(html_h5_tag),
    tag_command(html_h6_tag),
    tag_command(html_p_tag),

    /* Script-supporting elements */

    tag_command(html_script_tag),
    tag_command(html_template_tag),

    NULL
};


/* Can not really described here

   "Phrasing content, but with no descendant labelable elements 
    unless it is the element's labeled control, and no descendant label elements."

 */

struct tagfilter_cmd * tagfilter_html_label[] = {

    tag_command(html_a_tag),
    tag_command(html_abbr_tag),
    tag_command(html_area_tag),
    tag_command(html_audio_tag),

    tag_command(html_b_tag),
    tag_command(html_bdi_tag),
    tag_command(html_bdo_tag),
    tag_command(html_br_tag),
    tag_command(html_button_tag),

    tag_command(html_canvas_tag),
    tag_command(html_cite_tag),
    tag_command(html_code_tag),

    tag_command(html_data_tag),
    tag_command(html_datalist_tag),
    tag_command(html_del_tag),
    tag_command(html_dfn_tag),

    tag_command(html_em_tag),
    tag_command(html_embed_tag),

    tag_command(html_i_tag),
    tag_command(html_iframe_tag),
    tag_command(html_img_tag),
    tag_command(html_input_tag),
    tag_command(html_ins_tag),

    tag_command(html_kbd_tag),

#if 0 /* Not allowed */
    tag_command(html_label_tag),
#endif
    tag_command(html_link_tag),

    tag_command(html_map_tag),
    tag_command(html_mark_tag),
    tag_command(mathml_math_tag),
    tag_command(html_meta_tag),
    tag_command(html_meter_tag),

    tag_command(html_noscript_body_tag),

    tag_command(html_object_tag),
    tag_command(html_output_tag),

    tag_command(html_picture_tag),
    tag_command(html_progress_tag),

    tag_command(html_q_tag),

    tag_command(html_ruby_tag),

    tag_command(html_s_tag),
    tag_command(html_samp_tag),
    tag_command(html_script_tag),
    tag_command(html_select_tag),
    tag_command(html_slot_tag),
    tag_command(html_small_tag),
    tag_command(html_span_tag),
    tag_command(html_strong_tag),
    tag_command(html_sub_tag),
    tag_command(html_sup_tag),
    tag_command(svg_svg_tag),

    tag_command(html_template_tag),
    tag_command(html_textarea_tag),
    tag_command(html_time_tag),

    tag_command(html_u_tag),

    tag_command(html_var_tag),
    tag_command(html_video_tag),

    tag_command(html_wbr_tag),

    /* "autonomous custom elements, text" */

    
    NULL
};

static struct TAGFILTER_CMD html_li_tag =  
    { TAGFILTER_CMD_magic, 1, "li", 0, htmlC(tfc_html_li),
      &text_html_flow,

      TAGFLT_CMD_is_static,
      
      NULL,

      /* "An li element's end tag can be omitted if the li element is 
	 immediately followed by another li element or if there is no more content 
	 in the parent element."
      */

      &text_html_close_li };

/* "Zero or more li and script-supporting elements." */

struct tagfilter_cmd * tagfilter_html_list_items[] = {
    tag_command(html_li_tag),

    /* Script-supporting elements */

    tag_command(html_script_tag),
    tag_command(html_template_tag),

    NULL
};

/* "An li element's end tag can be omitted if the li element 
   is immediately followed by another li element or if there is no more 
   content in the parent element."
*/

struct tagfilter_cmd * tagfilter_html_close_li[] = {
    tag_command(html_li_tag),

    NULL
};


/* Can not really described here

   "A p element's end tag can be omitted if the p element is immediately followed by an 
    address, article, aside, blockquote, details, div, dl, fieldset, figcaption, figure, 
    footer, form, h1, h2, h3, h4, h5, h6, header, hgroup, hr, main, menu, nav, ol, p, 
    pre, search, section, table, or ul element, or if there is no more content in the 
    parent element and the parent element is an HTML element that is not an a, audio, 
    del, ins, map, noscript, or video element, or an autonomous custom element."
*/

struct tagfilter_cmd * tagfilter_html_close_p[] = {

    tag_command(html_address_tag),
    tag_command(html_article_tag),
    tag_command(html_aside_tag),
    
    tag_command(html_blockquote_tag),

    tag_command(html_details_tag),
    tag_command(html_div_tag),
    tag_command(html_dl_tag),

    tag_command(html_fieldset_tag),
    tag_command(html_figcaption_tag),
    tag_command(html_figure_tag),
    tag_command(html_footer_tag),
    tag_command(html_form_tag),

    tag_command(html_h1_tag),
    tag_command(html_h2_tag),
    tag_command(html_h3_tag),
    tag_command(html_h4_tag),
    tag_command(html_h5_tag),
    tag_command(html_h6_tag),
    tag_command(html_header_tag),
    tag_command(html_hgroup_tag),
    tag_command(html_hr_tag),

    tag_command(html_main_tag),
    tag_command(html_menu_tag),

    tag_command(html_nav_tag),

    tag_command(html_ol_tag),

    tag_command(html_p_tag),
    tag_command(html_pre_tag),

    tag_command(html_search_tag),
    tag_command(html_section_tag),

    tag_command(html_table_tag),

    tag_command(html_ul_tag),

    NULL
};

/* Can not really described here

   "Flow content, but with no heading content descendants, 
   no sectioning content descendants, and no header, footer, 
   or address element descendants."

*/

struct tagfilter_cmd * tagfilter_html_address[] = {

    tag_command(html_a_tag),
    tag_command(html_abbr_tag),
#if 0 /* Not allowed */
    tag_command(html_address_tag),
#endif
    tag_command(html_area_tag),
    tag_command(html_article_tag),
    tag_command(html_aside_tag),    
    tag_command(html_audio_tag),

    tag_command(html_b_tag),
    tag_command(html_bdi_tag),
    tag_command(html_bdo_tag),
    tag_command(html_blockquote_tag),
    tag_command(html_br_tag),
    tag_command(html_button_tag),

    tag_command(html_canvas_tag),
    tag_command(html_cite_tag),
    tag_command(html_code_tag),

    tag_command(html_data_tag),
    tag_command(html_datalist_tag),
    tag_command(html_del_tag),
    tag_command(html_details_tag),
    tag_command(html_dfn_tag),
    tag_command(html_dialog_tag),
    tag_command(html_div_tag),
    tag_command(html_dl_tag),

    tag_command(html_em_tag),
    tag_command(html_embed_tag),

    tag_command(html_fieldset_tag),
    tag_command(html_figure_tag),
#if 0 /* Not allowed */
    tag_command(html_footer_tag),
#endif
    tag_command(html_form_tag),

#if 0 /* Not allowed */
    tag_command(html_h1_tag),
    tag_command(html_h2_tag),
    tag_command(html_h3_tag),
    tag_command(html_h4_tag),
    tag_command(html_h5_tag),
    tag_command(html_h6_tag),
    tag_command(html_header_tag),
    tag_command(html_hgroup_tag),
#endif
    tag_command(html_hr_tag),

    tag_command(html_i_tag),
    tag_command(html_iframe_tag),
    tag_command(html_img_tag),
    tag_command(html_input_tag),
    tag_command(html_ins_tag),
    
    tag_command(html_kbd_tag),

    tag_command(html_label_tag),
    tag_command(html_link_tag),

    tag_command(html_main_tag),
    tag_command(html_map_tag),
    tag_command(html_mark_tag),
    tag_command(mathml_math_tag),
    tag_command(html_menu_tag),
    tag_command(html_meta_tag),
    tag_command(html_meter_tag),

    tag_command(html_nav_tag),
    tag_command(html_noscript_body_tag),

    tag_command(html_object_tag),
    tag_command(html_ol_tag),
    tag_command(html_output_tag),

    tag_command(html_p_tag),
    tag_command(html_picture_tag),
    tag_command(html_pre_tag),
    tag_command(html_progress_tag),

    tag_command(html_q_tag),

    tag_command(html_ruby_tag),

    tag_command(html_s_tag),
    tag_command(html_samp_tag),
    tag_command(html_script_tag),
    tag_command(html_search_tag),
    tag_command(html_section_tag),
    tag_command(html_select_tag),
    tag_command(html_slot_tag),
    tag_command(html_small_tag),
    tag_command(html_span_tag),
    tag_command(html_strong_tag),
    tag_command(html_sub_tag),
    tag_command(html_sup_tag),
    tag_command(svg_svg_tag),

    tag_command(html_table_tag),
    tag_command(html_template_tag),
    tag_command(html_textarea_tag),
    tag_command(html_time_tag),

    tag_command(html_u_tag),
    tag_command(html_ul_tag),

    tag_command(html_var_tag),
    tag_command(html_video_tag),

    tag_command(html_wbr_tag),
    
    /* "autonomous custom elements, text" */

    NULL
};

/* Can not really described here

   "Phrasing content, but there must be no 
    meter element descendants."

 */

struct tagfilter_cmd * tagfilter_html_meter[] = {

    tag_command(html_a_tag),
    tag_command(html_abbr_tag),
    tag_command(html_area_tag),
    tag_command(html_audio_tag),

    tag_command(html_b_tag),
    tag_command(html_bdi_tag),
    tag_command(html_bdo_tag),
    tag_command(html_br_tag),
    tag_command(html_button_tag),

    tag_command(html_canvas_tag),
    tag_command(html_cite_tag),
    tag_command(html_code_tag),

    tag_command(html_data_tag),
    tag_command(html_datalist_tag),
    tag_command(html_del_tag),
    tag_command(html_dfn_tag),

    tag_command(html_em_tag),
    tag_command(html_embed_tag),

    tag_command(html_i_tag),
    tag_command(html_iframe_tag),
    tag_command(html_img_tag),
    tag_command(html_input_tag),
    tag_command(html_ins_tag),

    tag_command(html_kbd_tag),

    tag_command(html_label_tag),
    tag_command(html_link_tag),

    tag_command(html_map_tag),
    tag_command(html_mark_tag),
    tag_command(mathml_math_tag),
    tag_command(html_meta_tag),
#if 0  /* Not allowed */
    tag_command(html_meter_tag),
#endif
    
    tag_command(html_noscript_body_tag),

    tag_command(html_object_tag),
    tag_command(html_output_tag),

    tag_command(html_picture_tag),
    tag_command(html_progress_tag),

    tag_command(html_q_tag),

    tag_command(html_ruby_tag),

    tag_command(html_s_tag),
    tag_command(html_samp_tag),
    tag_command(html_script_tag),
    tag_command(html_select_tag),
    tag_command(html_slot_tag),
    tag_command(html_small_tag),
    tag_command(html_span_tag),
    tag_command(html_strong_tag),
    tag_command(html_sub_tag),
    tag_command(html_sup_tag),
    tag_command(svg_svg_tag),

    tag_command(html_template_tag),
    tag_command(html_textarea_tag),
    tag_command(html_time_tag),

    tag_command(html_u_tag),

    tag_command(html_var_tag),
    tag_command(html_video_tag),

    tag_command(html_wbr_tag),

    /* "autonomous custom elements, text" */

    NULL
};


static struct TAGFILTER_CMD html_source_tag =   
    { TAGFILTER_CMD_magic, 1, "source", 0, baseC(tfc_unsupported), NULL,
      TAGFLT_CMD_is_static|TAGFLT_CMD_no_context,
      NULL, NULL };


/*  "Zero or more source elements, followed by one 
     img element, optionally intermixed with script-supporting 
     elements."
*/

struct tagfilter_cmd * tagfilter_html_picture[] = {
    tag_command(html_source_tag),
    tag_command(html_img_tag),

    /* Script-supporting elements */

    tag_command(html_script_tag),
    tag_command(html_template_tag),

    NULL
};
    
/* Can not really described here

   "Phrasing content, but there must be no progress 
    element descendants."

 */

struct tagfilter_cmd * tagfilter_html_progress[] = {

    tag_command(html_a_tag),
    tag_command(html_abbr_tag),
    tag_command(html_area_tag),
    tag_command(html_audio_tag),

    tag_command(html_b_tag),
    tag_command(html_bdi_tag),
    tag_command(html_bdo_tag),
    tag_command(html_br_tag),
    tag_command(html_button_tag),

    tag_command(html_canvas_tag),
    tag_command(html_cite_tag),
    tag_command(html_code_tag),

    tag_command(html_data_tag),
    tag_command(html_datalist_tag),
    tag_command(html_del_tag),
    tag_command(html_dfn_tag),

    tag_command(html_em_tag),
    tag_command(html_embed_tag),

    tag_command(html_i_tag),
    tag_command(html_iframe_tag),
    tag_command(html_img_tag),
    tag_command(html_input_tag),
    tag_command(html_ins_tag),

    tag_command(html_kbd_tag),

    tag_command(html_label_tag),
    tag_command(html_link_tag),

    tag_command(html_map_tag),
    tag_command(html_mark_tag),
    tag_command(mathml_math_tag),
    tag_command(html_meta_tag),
    tag_command(html_meter_tag),

    tag_command(html_noscript_body_tag),

    tag_command(html_object_tag),
    tag_command(html_output_tag),

    tag_command(html_picture_tag),
#if 0  /* Not allowed */
    tag_command(html_progress_tag),
#endif
    
    tag_command(html_q_tag),

    tag_command(html_ruby_tag),

    tag_command(html_s_tag),
    tag_command(html_samp_tag),
    tag_command(html_script_tag),
    tag_command(html_select_tag),
    tag_command(html_slot_tag),
    tag_command(html_small_tag),
    tag_command(html_span_tag),
    tag_command(html_strong_tag),
    tag_command(html_sub_tag),
    tag_command(html_sup_tag),
    tag_command(svg_svg_tag),

    tag_command(html_template_tag),
    tag_command(html_textarea_tag),
    tag_command(html_time_tag),

    tag_command(html_u_tag),

    tag_command(html_var_tag),
    tag_command(html_video_tag),

    tag_command(html_wbr_tag),

    /* "autonomous custom elements, text" */

    
    NULL
};

static struct TAGFILTER_CMD html_rt_tag =  
    { TAGFILTER_CMD_magic, 1, "rt", 0, baseC(tfc_unsupported),
      & text_html_phrasing,

      TAGFLT_CMD_is_static,
      NULL, 

      /* "An rt element's end tag can be omitted 
          if the rt element is immediately followed 
          by an rt or rp element, or if there is no more 
	  content in the parent element."
      */
      & text_html_close_rtrp
    };

static struct TAGFILTER_CMD html_rp_tag =  
    { TAGFILTER_CMD_magic, 1, "rp", 0, baseC(tfc_unsupported),
      NULL  /* Text */,
      

      TAGFLT_CMD_is_static,
      NULL,

      /*  "An rp element's end tag can be omitted 
	  if the rp element is immediately followed by 
	   an rt or rp element, or if there is no 
	   more content in the parent element."
      */
      & text_html_close_rtrp
    };

/* Can not really described here

   "One or the other of the following:
        Phrasing content, but with no ruby elements and with no ruby 
            element descendants
        A single ruby element that itself has no ruby element descendants 
    One or the other of the following:
        One or more rt elements
        An rp element followed by one or more rt elements, each of which 
           is itself followed by an rp element "
 */


struct tagfilter_cmd * tagfilter_html_ruby[] = {
    tag_command(html_rt_tag),
    tag_command(html_rp_tag),

    /* Phrasing content - also ruby included */
    
    tag_command(html_a_tag),
    tag_command(html_abbr_tag),
    tag_command(html_area_tag),
    tag_command(html_audio_tag),

    tag_command(html_b_tag),
    tag_command(html_bdi_tag),
    tag_command(html_bdo_tag),
    tag_command(html_br_tag),
    tag_command(html_button_tag),

    tag_command(html_canvas_tag),
    tag_command(html_cite_tag),
    tag_command(html_code_tag),

    tag_command(html_data_tag),
    tag_command(html_datalist_tag),
    tag_command(html_del_tag),
    tag_command(html_dfn_tag),

    tag_command(html_em_tag),
    tag_command(html_embed_tag),

    tag_command(html_i_tag),
    tag_command(html_iframe_tag),
    tag_command(html_img_tag),
    tag_command(html_input_tag),
    tag_command(html_ins_tag),

    tag_command(html_kbd_tag),

    tag_command(html_label_tag),
    tag_command(html_link_tag),

    tag_command(html_map_tag),
    tag_command(html_mark_tag),
    tag_command(mathml_math_tag),
    tag_command(html_meta_tag),
    tag_command(html_meter_tag),

    tag_command(html_noscript_body_tag),

    tag_command(html_object_tag),
    tag_command(html_output_tag),

    tag_command(html_picture_tag),
    tag_command(html_progress_tag),

    tag_command(html_q_tag),

    tag_command(html_ruby_tag),

    tag_command(html_s_tag),
    tag_command(html_samp_tag),
    tag_command(html_script_tag),
    tag_command(html_select_tag),
    tag_command(html_slot_tag),
    tag_command(html_small_tag),
    tag_command(html_span_tag),
    tag_command(html_strong_tag),
    tag_command(html_sub_tag),
    tag_command(html_sup_tag),
    tag_command(svg_svg_tag),

    tag_command(html_template_tag),
    tag_command(html_textarea_tag),
    tag_command(html_time_tag),

    tag_command(html_u_tag),

    tag_command(html_var_tag),
    tag_command(html_video_tag),

    tag_command(html_wbr_tag),

    /* "autonomous custom elements, text" */
    
    NULL
};


static struct TAGFILTER_CMD html_caption_tag =  
    { TAGFILTER_CMD_magic, 1, "caption", 0, baseC(tfc_unsupported),
      &text_html_caption
      /* "Flow content, but with no descendant table elements." */,

      TAGFLT_CMD_is_static|TAGFLT_CMD_close_search,
      NULL,
      NULL

      /* "A caption element's end tag can be omitted if the caption element is not immediately 
	 followed by ASCII whitespace or a comment."
      */
    };


static struct TAGFILTER_CMD html_colgroup_tag =  
    { TAGFILTER_CMD_magic, 1, "colgroup", 0, baseC(tfc_unsupported),
      &text_html_colgroup
      /* "If the span attribute is present: Nothing.
	  If the span attribute is absent: Zero or more col and template elements."
      */,

      TAGFLT_CMD_is_static|TAGFLT_CMD_close_search|TAGFLT_CMD_nested_search,

      NULL, NULL

      /* "A colgroup element's start tag can be omitted if the first thing inside the 
	 colgroup element is a col element, and if the element is not immediately preceded 
	 by another colgroup element whose end tag has been omitted. (It can't be omitted 
	 if the element is empty.)
	 A colgroup element's end tag can be omitted if the colgroup element is not immediately 
	 followed by ASCII whitespace or a comment."
      */
    };

static struct TAGFILTER_CMD html_thead_tag =  
    { TAGFILTER_CMD_magic, 1, "thead", 0, baseC(tfc_unsupported),
      &text_html_tr_list
      /* "Zero or more tr and script-supporting elements." */,
      
      TAGFLT_CMD_is_static,
      NULL,

      &text_html_close_thead
      /* "A thead element's end tag can be omitted if the thead 
	 element is immediately followed by a tbody or tfoot element."
      */
    };

static struct TAGFILTER_CMD html_tbody_tag =  
    { TAGFILTER_CMD_magic, 1, "tbody", 0, baseC(tfc_unsupported),
      &text_html_tr_list
      /* "Zero or more tr and script-supporting elements." */,

      TAGFLT_CMD_is_static|TAGFLT_CMD_nested_search,
      /* "A tbody element's start tag can be omitted if the first thing 
	  inside the tbody element is a tr element, and if the element is not 
          immediately preceded by a tbody, thead, or tfoot element whose end 
	  tag has been omitted. (It can't be omitted if the element is empty.)"
      */
      
      NULL,

      &text_html_close_tbody
      /* "A tbody element's end tag can be omitted if the tbody element 
	 is immediately followed by a tbody or tfoot element, or 
	 if there is no more content in the parent element." */
    };

static struct TAGFILTER_CMD html_tr_tag =  
    { TAGFILTER_CMD_magic, 1, "tr", 0, baseC(tfc_unsupported),
      &text_html_tr
      /* "Zero or more td, th, and script-supporting elements." */,

      TAGFLT_CMD_is_static|TAGFLT_CMD_force_newline,
      NULL,

      &text_html_close_tr
      /* "A tr element's end tag can be omitted if the tr element is 
	 immediately followed by another tr element, or if there is 
	 no more content in the parent element."
      */
    };


static struct TAGFILTER_CMD html_tfoot_tag =  
    { TAGFILTER_CMD_magic, 1, "tfoot", 0, baseC(tfc_unsupported),
      &text_html_tr_list
      /* "Zero or more tr and script-supporting elements." */,
      TAGFLT_CMD_is_static,
      NULL, NULL

      /* "A tfoot element's end tag can be omitted if there is 
	 no more content in the parent element."
      */
    };

/* Can not really described here

   "In this order: optionally a caption element, 
    followed by zero or more colgroup elements, 
    followed optionally by a thead element, 
    followed by either zero or more tbody elements or one or 
    more tr elements, followed optionally by a tfoot element, 
    optionally intermixed with one or more script-supporting 
    elements."   
 */


struct tagfilter_cmd * tagfilter_html_table[] = {
    tag_command(html_caption_tag),
    tag_command(html_colgroup_tag),
    tag_command(html_thead_tag),
    tag_command(html_tbody_tag),
    tag_command(html_tr_tag),
    tag_command(html_tfoot_tag),

    /* Script-supporting elements */

    tag_command(html_script_tag),
    tag_command(html_template_tag),

    NULL
};


/* "If the element is a child of a dl element: one or more 
    dt elements followed by one or more dd elements, 
    optionally intermixed with script-supporting elements."
*/

struct tagfilter_cmd * tagfilter_html_div_dl[] = {
    tag_command(html_dt_tag),
    tag_command(html_dd_tag),

    /* Script-supporting elements */

    tag_command(html_script_tag),
    tag_command(html_template_tag),

    NULL
};

/* Can not really described here

   "Flow content, but with no descendant table elements."

 */


struct tagfilter_cmd * tagfilter_html_caption[] = {

    tag_command(html_a_tag),
    tag_command(html_abbr_tag),
    tag_command(html_address_tag),
    tag_command(html_area_tag),
    tag_command(html_article_tag),
    tag_command(html_aside_tag),    
    tag_command(html_audio_tag),

    tag_command(html_b_tag),
    tag_command(html_bdi_tag),
    tag_command(html_bdo_tag),
    tag_command(html_blockquote_tag),
    tag_command(html_br_tag),
    tag_command(html_button_tag),

    tag_command(html_canvas_tag),
    tag_command(html_cite_tag),
    tag_command(html_code_tag),

    tag_command(html_data_tag),
    tag_command(html_datalist_tag),
    tag_command(html_del_tag),
    tag_command(html_details_tag),
    tag_command(html_dfn_tag),
    tag_command(html_dialog_tag),
    tag_command(html_div_tag),
    tag_command(html_dl_tag),

    tag_command(html_em_tag),
    tag_command(html_embed_tag),

    tag_command(html_fieldset_tag),
    tag_command(html_figure_tag),
    tag_command(html_footer_tag),
    tag_command(html_form_tag),

    tag_command(html_h1_tag),
    tag_command(html_h2_tag),
    tag_command(html_h3_tag),
    tag_command(html_h4_tag),
    tag_command(html_h5_tag),
    tag_command(html_h6_tag),
    tag_command(html_header_tag),
    tag_command(html_hgroup_tag),
    tag_command(html_hr_tag),

    tag_command(html_i_tag),
    tag_command(html_iframe_tag),
    tag_command(html_img_tag),
    tag_command(html_input_tag),
    tag_command(html_ins_tag),
    
    tag_command(html_kbd_tag),

    tag_command(html_label_tag),
    tag_command(html_link_tag),

    tag_command(html_main_tag),
    tag_command(html_map_tag),
    tag_command(html_mark_tag),
    tag_command(mathml_math_tag),
    tag_command(html_menu_tag),
    tag_command(html_meta_tag),
    tag_command(html_meter_tag),

    tag_command(html_nav_tag),
    tag_command(html_noscript_body_tag),

    tag_command(html_object_tag),
    tag_command(html_ol_tag),
    tag_command(html_output_tag),

    tag_command(html_p_tag),
    tag_command(html_picture_tag),
    tag_command(html_pre_tag),
    tag_command(html_progress_tag),

    tag_command(html_q_tag),

    tag_command(html_ruby_tag),

    tag_command(html_s_tag),
    tag_command(html_samp_tag),
    tag_command(html_script_tag),
    tag_command(html_search_tag),
    tag_command(html_section_tag),
    tag_command(html_select_tag),
    tag_command(html_slot_tag),
    tag_command(html_small_tag),
    tag_command(html_span_tag),
    tag_command(html_strong_tag),
    tag_command(html_sub_tag),
    tag_command(html_sup_tag),
    tag_command(svg_svg_tag),

#if 0 /* Not allowed */	
    tag_command(html_table_tag),
#endif
    tag_command(html_template_tag),
    tag_command(html_textarea_tag),
    tag_command(html_time_tag),

    tag_command(html_u_tag),
    tag_command(html_ul_tag),

    tag_command(html_var_tag),
    tag_command(html_video_tag),

    tag_command(html_wbr_tag),
    
    /* "autonomous custom elements, text" */
    
    NULL
};


static struct TAGFILTER_CMD html_col_tag =  
    { TAGFILTER_CMD_magic, 1, "col", 0, baseC(tfc_unsupported),
      NULL /* Nothing */,
      TAGFLT_CMD_is_static|TAGFLT_CMD_no_context,
      NULL, NULL };
           
/* Can not really described here

   "If the span attribute is present: Nothing.
    If the span attribute is absent: 
    Zero or more col and template elements."

 */


struct tagfilter_cmd * tagfilter_html_colgroup[] = {
    tag_command(html_col_tag),
    tag_command(html_template_tag),
    NULL
};

/* "Zero or more tr and script-supporting elements." */

struct tagfilter_cmd * tagfilter_html_tr_list[] = {
    tag_command(html_tr_tag),

    /* Script-supporting elements */

    tag_command(html_script_tag),
    tag_command(html_template_tag),
    
    NULL
};

static struct TAGFILTER_CMD html_td_tag =  
    { TAGFILTER_CMD_magic, 1, "td", 0, baseC(tfc_unsupported),
      &text_html_flow,
      TAGFLT_CMD_is_static,
      NULL,
      &text_html_close_td
      /* "A td element's end tag can be omitted if the td element is immediately followed 
	 by a td or th element, or if there is no more content in the parent element." */
};


static struct TAGFILTER_CMD html_th_tag =  
    { TAGFILTER_CMD_magic, 1, "th", 0, baseC(tfc_unsupported),
      &text_html_th
      /* "Flow content, but with no header, footer, 
	 sectioning content, or heading content descendants."
      */,
      
      TAGFLT_CMD_is_static,
      NULL,
      &text_html_close_th
      /* "A th element's end tag can be omitted if the th element 
	 is immediately followed by a td or th element, or if 
	 there is no more content in the parent element." */
};

/* "Zero or more td, th, and script-supporting elements." */


struct tagfilter_cmd * tagfilter_html_tr[] = {
    tag_command(html_td_tag),
    tag_command(html_th_tag),
    
    /* Script-supporting elements */

    tag_command(html_script_tag),
    tag_command(html_template_tag),
    
    NULL
};

/* "A thead element's end tag can be omitted if the thead 
    element is immediately followed by a tbody or tfoot element."
*/

struct tagfilter_cmd * tagfilter_html_close_thead[] = {
    tag_command(html_tbody_tag),
    tag_command(html_tfoot_tag),
    
    NULL
};

/* "A tbody element's end tag can be omitted if the tbody 
    element is immediately followed by a tbody or tfoot element, or 
    if there is no more content in the parent element."
*/

struct tagfilter_cmd * tagfilter_html_close_tbody[] = {
    tag_command(html_tbody_tag),
    tag_command(html_tfoot_tag),

    NULL
};

/* "A tr element's end tag can be omitted 
    if the tr element is immediately followed by 
    another tr element, or if there is no more 
    content in the parent element."
*/

struct tagfilter_cmd * tagfilter_html_close_tr[] = {
    tag_command(html_tr_tag),

    NULL
};

/* "A td element's end tag can be omitted 
   if the td element is immediately followed by a td or th element, 
   or if there is no more content in the parent element."
*/

struct tagfilter_cmd * tagfilter_html_close_td[] = {
    tag_command(html_td_tag),
    tag_command(html_th_tag),

    NULL
};

/*  Can not really described here

    "Flow content, but with no header, footer, sectioning content, or
     heading content descendants."

*/


struct tagfilter_cmd * tagfilter_html_th[] = {

    tag_command(html_a_tag),
    tag_command(html_abbr_tag),
    tag_command(html_address_tag),
    tag_command(html_area_tag),
#if 0  /* Not allowed */
    tag_command(html_article_tag),
    tag_command(html_aside_tag),
#endif
    tag_command(html_audio_tag),

    tag_command(html_b_tag),
    tag_command(html_bdi_tag),
    tag_command(html_bdo_tag),
    tag_command(html_blockquote_tag),
    tag_command(html_br_tag),
    tag_command(html_button_tag),

    tag_command(html_canvas_tag),
    tag_command(html_cite_tag),
    tag_command(html_code_tag),

    tag_command(html_data_tag),
    tag_command(html_datalist_tag),
    tag_command(html_del_tag),
    tag_command(html_details_tag),
    tag_command(html_dfn_tag),
    tag_command(html_dialog_tag),
    tag_command(html_div_tag),
    tag_command(html_dl_tag),

    tag_command(html_em_tag),
    tag_command(html_embed_tag),

    tag_command(html_fieldset_tag),
    tag_command(html_figure_tag),
#if 0  /* Not allowed */
    tag_command(html_footer_tag),
#endif
    tag_command(html_form_tag),

#if 0  /* Not allowed */
    tag_command(html_h1_tag),
    tag_command(html_h2_tag),
    tag_command(html_h3_tag),
    tag_command(html_h4_tag),
    tag_command(html_h5_tag),
    tag_command(html_h6_tag),
    tag_command(html_header_tag),
    tag_command(html_hgroup_tag),
#endif
    tag_command(html_hr_tag),

    tag_command(html_i_tag),
    tag_command(html_iframe_tag),
    tag_command(html_img_tag),
    tag_command(html_input_tag),
    tag_command(html_ins_tag),
    
    tag_command(html_kbd_tag),

    tag_command(html_label_tag),
    tag_command(html_link_tag),

    tag_command(html_main_tag),
    tag_command(html_map_tag),
    tag_command(html_mark_tag),
    tag_command(mathml_math_tag),
    tag_command(html_menu_tag),
    tag_command(html_meta_tag),
    tag_command(html_meter_tag),

#if 0  /* Not allowed */
    tag_command(html_nav_tag),
#endif
    tag_command(html_noscript_body_tag),

    tag_command(html_object_tag),
    tag_command(html_ol_tag),
    tag_command(html_output_tag),

    tag_command(html_p_tag),
    tag_command(html_picture_tag),
    tag_command(html_pre_tag),
    tag_command(html_progress_tag),

    tag_command(html_q_tag),

    tag_command(html_ruby_tag),

    tag_command(html_s_tag),
    tag_command(html_samp_tag),
    tag_command(html_script_tag),
    tag_command(html_search_tag),
#if 0  /* Not allowed */
    tag_command(html_section_tag),
#endif
    tag_command(html_select_tag),
    tag_command(html_slot_tag),
    tag_command(html_small_tag),
    tag_command(html_span_tag),
    tag_command(html_strong_tag),
    tag_command(html_sub_tag),
    tag_command(html_sup_tag),
    tag_command(svg_svg_tag),

    tag_command(html_table_tag),
    tag_command(html_template_tag),
    tag_command(html_textarea_tag),
    tag_command(html_time_tag),

    tag_command(html_u_tag),
    tag_command(html_ul_tag),

    tag_command(html_var_tag),
    tag_command(html_video_tag),

    tag_command(html_wbr_tag),
    
    /* "autonomous custom elements, text" */
        
    NULL
};

/* "A th element's end tag can be omitted if the th element is
    immediately followed by a td or th element, or if there is no more
    content in the parent element."
*/

struct tagfilter_cmd * tagfilter_html_close_th[] = {
    tag_command(html_td_tag),
    tag_command(html_th_tag),

    NULL
};


/* "A dt element's end tag can be omitted if the dt element is 
    immediately followed by another dt element or a dd element."

   "A dd element's end tag can be omitted if the dd element is
    immediately followed by another dd element or a dt element, or if
    there is no more content in the parent element."
*/

struct tagfilter_cmd * tagfilter_html_close_dtdd[] = {
    tag_command(html_dt_tag),
    tag_command(html_dd_tag),

    NULL
};

/* "An rt element's end tag can be omitted if the rt element is
   immediately followed by an rt or rp element, or if there is no more
   content in the parent element."

   "An rp element's end tag can be omitted if the rp element is
   immediately followed by an rt or rp element, or if there is no more
   content in the parent element."
*/

struct tagfilter_cmd * tagfilter_html_close_rtrp[] = {
    tag_command(html_rt_tag),
    tag_command(html_rp_tag),

    NULL
};

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */

  
