static char rcsid[] = "@(#)$Id: type_check.c,v 2.8 2015/11/01 18:23:37 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.8 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_melib.h"
#include "s_me.h"

DEBUG_VAR(Debug,__FILE__,"mime");


/* Returns 0 if paging of type is not allowed */
int check_type_magic(ptr,state_in,state_out, decode_opt, badtype)
     mime_t *ptr; 
     struct in_state *state_in; 
     struct out_state *state_out;
     const struct decode_opts *decode_opt;
     type_mismatch_prompt *badtype;
{
    long f;
    struct scan_list *scanlist = NULL;
    struct scan_list *Y;
    int ch;
    struct mime_types_item *found;
    int ret = 0;

    if (! in_state_seekable(state_in)) {
	DPRINT(Debug,5,(&Debug, 
			"check_type_magic=1 --- skipping scan -- not seekapble\n"));

	return 1;
    }

    f = in_state_ftell(state_in);
    if (f != 0) {
	DPRINT(Debug,5,(&Debug, 
			"check_type_magic: ftell=%ld\n",f));

	panic("MIME TYPES PANIC",__FILE__,__LINE__,"check_type_magic",
	      "Not beginning",0);
    }

    /* NOTE:

       application/octet-stream means unknown type

       we should not be decoding it here anyway ....

    */

    if (get_major_type_code(ptr->TYPE) == MIME_TYPE_APPLICATION &&
	0 == istrcmp(get_subtype_name(ptr->TYPE),"octet-stream")) {
	
	DPRINT(Debug,5,(&Debug, 
			"check_type_magic=1: APPLICATION/octet-stream unsupported\n"));
	
	return 1;
    }



    if (user_mimetypes_map)
	scanlist = get_scan_list_by_type(user_mimetypes_map,ptr->TYPE);
    if (system_mimetypes_map) {
	struct scan_list * X = get_scan_list_by_type(system_mimetypes_map,
						     ptr->TYPE);
	
	if (X) {
	    if (scanlist) {
		append_scanlist(scanlist,X);
		free_scan_list(&X);
	    } else
		scanlist = X;
	}
    }

    Y = get_scan_list_by_type(builtin_mimetypes_map,ptr->TYPE);
    
    if (Y) {
	if (scanlist) {
	    append_scanlist(scanlist,Y);
	    free_scan_list(&Y);
	} else
	    scanlist = Y;
    }

    if (!scanlist) {
	DPRINT(Debug,7,(&Debug, 
			"check_type_magic=1 --- no scanlist\n"));
	return 1;
    }

    if (! have_scanlist(scanlist)) {
	DPRINT(Debug,7,(&Debug, 
			"check_type_magic=1 --- empty scanlist\n"));

	free_scan_list(&scanlist);
	return 1;
    }

    while (EOF != (ch = state_getc(state_in))) {
	int need_more = 0;
	
	need_more = scanlist_need_more(scanlist,ch);
	
	if (!need_more) {
	    DPRINT(Debug,9,(&Debug,    
			    "check_type_magic: magic scan finished\n"));
	    break;
	}
    }

    found = loc_mime_type_from_scan(scanlist);

    if (found)
	ret = 1;
    else {
	struct pager_range *title_range = 
	    state_add_simple_pager_range(state_out,NULL,PR_MAX_WIDTH,0,
					 0);


	ret = badtype(ptr, decode_opt->displaying);

	if (ret) {
	    if (decode_opt->displaying) {
		
		state_nlputs("\n",state_out);
	
		/* \n resets this */	
		set_out_state_line_mode(state_out,pg_BOLD,title_range,1 /* Newline */);
		state_nlputs("[ ",state_out);
		state_printf(state_out,
			     CATGETS(elm_msg_cat, MeSet, MeMiscMatchMessage,
				     "Signature of this part do not match to type."));

		state_nlputs(" ]\n\n",state_out);       
		
	    }
	} else {
	    
	    state_nlputs("\n",state_out);
	    
	    set_out_state_line_mode(state_out,pg_BOLD,title_range,1 /* Newline */);
	    state_nlputs("[ ",state_out);
	    state_printf(state_out,
			 CATGETS(elm_msg_cat, MeSet, MeMiscMatchMessageSkipped,
				 "Signature of this part do not match to type. Part skipped."));
	

	    state_nlputs(" ]\n",state_out);  
	    
	    if (decode_opt->displaying) {
		state_printf(state_out,
			     CATGETS(elm_msg_cat, MeSet, MeMiscMatchUse,
				     "[ Use 'v' to save this part. ]\n"));
	    }
	    
	    state_nlputs("\n",state_out);
	}			

	free_pager_range(&title_range);
    }

    free_scan_list(&scanlist);
    in_state_fseek(state_in, 0);

    DPRINT(Debug,7,(&Debug, 
		    "check_type_magic=%d\n",ret));

    return ret;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
