/* $Id: shared_smtp.h,v 2.8 2018/12/01 08:19:45 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.8 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *       or Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#ifdef REMOTE_MBX

/* SMTP_flags */
#define SMTP_submission         1       
#define SMTP_noverify           2       
#define SMTP_reserve            4
#define SMTP_logged             8



#define SMTP_mailer_info_magic	0xF203

/* mailer info keeps connection information ... */
struct smtp_info {
    unsigned short magic;       /* SMTP_mailer_info_magic */

    struct remote_account RA;
    struct run_state RS;
    struct Read_Buffer  read_buffer;
    struct Write_Buffer write_buffer;

    /* Last command */
    char      command[4];

    struct schedule_timelimit   NOOP_start;
    
    enum smtp_state {  smtp_wait_reply, smtp_reply_read,
		       smtp_reply_incomplete,
		       smtp_idle, smtp_command, 
		       smtp_need_data, smtp_data, 
		       smtp_error, smtp_closing
    } state;
    char response_code[4];
    int seen_badpid;
    
    char ** response_text;
    int     response_text_len;

    int     SMTP_flags;

    char    *incomplete_command;
    int      incomplete_command_len;

    char   **ESMTP_keywords;
    int      ESMTP_keyword_len;   /* -1 == EHLO not issued yet */

    unsigned                    stalled:1;
};


typedef int f_smtp_start_command P_((struct smtp_info *I, char *command));
typedef int f_smtp_push_data P_((struct smtp_info *I, const char *data,
				 int len, int is_data_line));
typedef void f_smtp_command_arg P_((struct smtp_info *I, const char *str));
typedef void f_smtp_command_ready P_((struct smtp_info *I, int data_end));
typedef int f_smtp_command_ok P_((struct smtp_info *I, char response_code[4]));
typedef const char * f_smtp_command_response P_((struct smtp_info *I,int *idx));
typedef void f_smtp_command_reset P_((struct smtp_info *I));
typedef const struct string * f_smtp_Server P_((struct smtp_info *I));

struct smtp_callbacks {
    f_smtp_start_command    * start_command;
    f_smtp_push_data        * push_data;
    f_smtp_command_arg      * command_arg;
    f_smtp_command_ready    * command_ready;
    f_smtp_command_ok       * command_ok;
    f_smtp_command_response * command_response;
    f_smtp_command_reset    * command_reset;
    f_smtp_Server           * Server;
};

#endif

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
