case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh

    ;;
esac

case "$subdir" in
'')
    case "$0" in
    */*) cd `expr X$0 : 'X\(.*\)/'` ;;
    esac	    

    vpathdef="#VPATH	= "
    regarg=
    XXsrc="."
    XXsrcroot="../../"
    ;;
*)
    vpathdef="VPATH	=	$source_dir/$subdir"
    regarg="-A \"$source_dir/$subdir/\""
    XXsrc="$source_dir/$subdir"
    XXsrcroot="$source_dir"
    ;;
esac

# List required ../../shlib/libelmme-XXXX.so here so that
# libelmme-resolv.so may be loaded with program, which do not 
# have linked these.
libxs=""

# If it is not possible to resolve mail program symbols from
# dynamic library, link libelmme-resolv.so with libelmme-base.so

if $test $d_dynamic_main = "$define" ; then
	   : 
else
	libxs="$libxs ../../shlib/libelmme-base.so"
fi

echo "Extracting shared_libs/resolv/Makefile (with variable substitutions)"
$cat >Makefile <<!GROK!THIS!
#!$make
#
# $Id: Makefile.SH,v 1.9 2022/06/27 09:08:40 hurtta Exp $
#
#  Makefile for the ELM (ME+) mail program.
#
#  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
#      or  Kari Hurtta <elm@elmme-mailer.org>
#
#
INSTLIB		= \$(ELM_ROOT)//$shlib/libelmme-resolv.so$d_shared_rev
AR		=	$ar
CC		=	$cc
CCFLAGS		=	$ccflags $picflag $xencf
LFLAGS		=	$ldflags $backtrace_opt $xenlf
CP		=	$cp
RM              =       $rm -f
MV              =       $mv
CAT		=	$cat
LIB		=	\$(ELM_ROOT)//$lib
OPTIMIZE	=	$optimize
RANLIB		=	$ranlib
TOUCH           =       $touch
CHMOD           =       $chmod
LIBXS           =       $libxs
$vpathdef
REGARG		=	$regarg
SRC		=	$XXsrc
SRCROOT		=	$XXsrcroot
RESOLVLINK	=	$resolv_link
!GROK!THIS!


if $test "$resolv_sendok" = "$define" ; then
cat >>Makefile <<'EOX'
TEST2		=	../../bin/elmresolvertest2
EOX
else
cat >>Makefile <<'EOX'
TEST2		=	
EOX
fi

A=
if $test "$soname_include_path" = y ; then
	A="$shlib/"
fi



cat >>Makefile <<SUBSTITUTE
SONAME          = ${soname_opt}${A}libelmme-resolv.so$d_shared_rev
SUBSTITUTE

if $test "$resolv_lib_dir" != ""; then
    $cat >>Makefile <<EOS
LIBDIRLIST      =  -L$resolv_lib_dir $rpath_opt$resolv_lib_dir
EOS
else
    cat >>Makefile <<'EOX'
LIBDIRLIST      =
EOX
fi

if $test "$resolv_include_dir" != "" ; then
    $cat >>Makefile <<EOS
INCDIRLIST      = -I$resolv_include_dir
EOS
else
    $cat >>Makefile <<'EOX'
INCDIRLIST      =
EOX
fi

$cat >>Makefile <<'!NO!SUBS!'
CFLAGS		=	-I$(IHDR) -I$(INCLDIR) -I$(IHDR2) \
 -I$(INCLDIR2) $(INCDIRLIST) -I. $(CCFLAGS) $(OPTIMIZE)
# -I. is required for resolvconf.h
INCLDIR		=	$(SRCROOT)/shared_libs/include
INCLDIR2	=	$(SRCROOT)/hdrs
IHDR		=	../include
IHDR2		=	../../hdrs
OBJS            =       resolv.o query.o
REG             =       ../../bin/elmregister -M resolv $(REGARG)


all:	Makefile libresolv.a ../../shlib/libelmme-resolv.so \
  ../../bin/elmresolvertest $(TEST2)
install_s: all $(INSTLIB) $(LIB)/elmrc-resolv-info

uninstall_s:
	$(REG) rm $(INSTLIB) $(LIB)/elmrc-resolv-info

clean: 
	rm -f $(OBJS) ../../shlib/libelmme-resolv.so libresolv.a

.PRECIOUS: $(IHDR)/elmshared.h o$(IHDR2)/elm_defs.h $(IHDR2)/defs_major.h

$(IHDR)/elmshared.h: $(IHDR2)/elm_defs.h $(INCLDIR2)/patchlevel.h \
 $(INCLDIR)/shared.h 
	-$(CHMOD) -f u+w $@
	$(TOUCH) $@

$(IHDR2)/elm_defs.h: $(IHDR2)/defs_major.h $(INCLDIR2)/elm_nl_types.h \
 $(INCLDIR2)/hdrs/elmlib.h 
	-$(CHMOD) -f u+w $@
	$(TOUCH) $@

$(IHDR2)/defs_major.h: ../../config.h $(IHDR2)/sysdefs.h 
	-$(CHMOD) -f u+w $@
	$(TOUCH) $@

Makefile: Makefile.SH ../../config.sh config.res
	@echo "You must run 'sh Configure -S' or 'sh Configure'"
	exit 1

resolvconf.h: resolvconf.h.SH ../../config.sh config.res
	@echo "You must run 'sh Configure -S' or 'sh Configure'"
	exit 1
	
../../config.sh config.res:
	@echo "You must run 'sh Configure'"
	exit 1

lint:		

tags:

clean:		

elmresolv.h: $(INCLDIR)/elmshared.h $(INCLDIR2)/connection_imp.h \
 $(INCLDIR2)/s_resolv.h  $(INCLDIR2)/schedule_time.h \
 resolvconf.h
	cmp $(SRC)/$@ $@ 2>/dev/null || $(CP) $(SRC)/$@ $@
	$(CHMOD) u+w $@
	$(TOUCH) $@

resolv.o: elmresolv.h $(INCLDIR2)/rc_imp.h $(INCLDIR2)/save_opts.h

query.o: elmresolv.h

libresolv.a: $(OBJS)
	$(AR) r $@ $?
	$(RANLIB) $@

../../shlib/libelmme-resolv.so: $(OBJS) $(LIBXS)
	$(CC) $(LFLAGS) $(LIBDIRLIST) $(SONAME) -o $@ $(OBJS) \
 $(LIBXS) $(RESOLVLINK)

$(INSTLIB): ../../shlib/libelmme-resolv.so
	$(REG) copy -m 644 $? $@

testconfig.h: ../../config.h resolvconf.h
	$(CAT) ../../config.h resolvconf.h > $@

resolvertest.o: testconfig.h $(SRC)/resolvertest.c
	$(CC) $(CCLAGS) -I. -c -o $@ $(SRC)/resolvertest.c

../../bin/elmresolvertest: resolvertest.o
	$(CC) $(LFLAGS) $(LIBDIRLIST) -o $@ resolvertest.o $(RESOLVLINK)

$(LIB)/elmrc-resolv-info: elmrc-resolv-info
	$(REG) copy -m 444 $? $@

!NO!SUBS!

if $test "$resolv_sendok" = "$define" ; then
    $cat >>Makefile <<'!NO!SUBS!'
resolvertest2.o: testconfig.h $(SRC)/resolvertest2.c
	$(CC) $(CCLAGS) -I. -c -o $@ $(SRC)/resolvertest2.c

../../bin/elmresolvertest2: resolvertest2.o
	$(CC) $(LFLAGS) $(LIBDIRLIST) -o $@ resolvertest2.o $(RESOLVLINK)

!NO!SUBS!
fi

for i in $headers 
do
	cat >>Makefile <<!SUBS!
copy_$i:    \$(INCLDIR2)/$i
		cmp \$? \$(IHDR2)/$i 2>/dev/null || \$(CP) \$? \$(IHDR2)/$i

!SUBS!
done
