/* $Id: elmtls.h,v 2.12 2020/06/05 13:43:17 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.12 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *       or Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include <openssl/ssl.h>
#include <openssl/bio.h>
#include <openssl/err.h>
#include <openssl/rand.h>


#include "elmshared.h"
#include "s_tls.h"
#include "tlsconf.h"

enum tls_version { tls_none = -1, 
		   v_ssl = 0,
		   v_tls = 1,
		   v_tls1,
		   v_tls1_1,
		   v_tls1_2,

		   NUM_tls_version
};

extern char * TLS_VERSION[NUM_tls_version+1];

extern ENUMERATE default_tls_version;

#ifdef REMOTE_MBX

extern int tls_version_supported P_((const char *config,
				     enum tls_version tls));

extern struct stream_type TLS_STREAM;
extern struct SE_option_type tls_options;

#define TLS_starttls 1   
#define TLS_tls      2

struct SE_option_value {   /* TLS option values */
    enum tls_version v_starttls;
    enum tls_version v_tls;
    int flags;
};

extern int tls_init P_((int *errors));
extern union stream_types create_TLS_stream P_((enum tls_version tls));


#include "ss_imp.h"
#include "schedule_time.h"
#include "connection_imp.h"
#include "mboxlib.h"
#include "mbx_imp.h"

extern enum tls_connection_state { 
    tls_not_connected = 0,
	tls_connected = 1,
	tls_error     = 2,
	tls_closing   = 3,
	tls_closed    = 4
				 } ss_TLS_state P_((struct streamsched *ss,
						    int stack_idx));

extern enum tls_peer_verify {
    tls_not_verified = 0,
	tls_peer_verified = 1,
	tls_verify_failed = -1        /* Value also used with SS_verify */
	} ss_TLS_verify P_((struct streamsched *ss,
			    int stack_idx,
			    struct string **errormsg,
			    struct string **peer_name));


extern int ra_wrap_tls P_((struct remote_account * ra,
			   union stream_types      tls_stream,
			   const char            * proto_string,
			   enum CAPA_phase *phase /* may be NULL */));


#endif

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
