static char rcsid[] = "@(#)$Id: imap.c,v 2.12 2022/02/12 14:00:06 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.12 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "elmtls.h"

#if ANSI_C
#define S_(x) static x;
#else
#define S_(x)
#endif

DEBUG_VAR(Debug,__FILE__,"tls");

#ifdef REMOTE_MBX

S_(imap_capa_handler imap_STARTTLS_handler)
static int imap_STARTTLS_handler P_((struct connection_cache *con,
				     char *capa,
				     size_t con_size,
				     struct imap_callbacks *commands,
				     size_t cb_size,
				     struct SE_option   *service_config,
				     size_t sc_size,
				     enum CAPA_phase *phase));
static int imap_STARTTLS_handler(con,capa,con_size,commands,cb_size,
				 service_config,sc_size,
				 phase)
     struct connection_cache *con;
     char *capa;
     size_t con_size;
     struct imap_callbacks *commands;
     size_t cb_size;
     struct SE_option   *service_config;
     size_t sc_size;
     enum CAPA_phase *phase;
{
    union stream_types T;
    imap_states ret1;
    enum tls_version tls =
	give_dt_enumerate_as_int(&default_tls_version);
    const char * tls_config = "default-tls-version";
    int bits;
    char * proto_text = NULL;

    int ret = 1;

    if (! StreamOK(sizeof (struct stream_type))) {
	DPRINT(Debug,1,(&Debug,			    
			"tls:imap_STARTTLS_handler: sizeof (struct stream_type) mismatch\n"));
	
	/* do nothing  
	   -- not need to return failure 
	   -- just disable ourself
	*/
	goto fail;
    }

    if (con_size != sizeof (*con)) {
	DPRINT(Debug,1,(&Debug,			    
			"tls:imap_STARTTLS_handler: sizeof (struct connection_cache) = %d != %d\n",
			sizeof (*con),con_size));
	
	/* do nothing  
	   -- not need to return failure 
	   -- just disable ourself
	*/
	goto fail;
    }

    if (cb_size != sizeof (*commands)) {
	DPRINT(Debug,1,(&Debug,			    
			"tls:imap_STARTTLS_handler: sizeof (struct imap_callbacks) = %d != %d\n",
			sizeof (*commands),cb_size));
	
	/* do nothing  
	   -- not need to return failure 
	   -- just disable ourself
	*/
	goto fail;
    }

    if (sc_size != sizeof (*service_config)) {
	DPRINT(Debug,1,(&Debug,			    
			"tls:imap_STARTTLS_handler: sizeof (struct struct SE_option) = %d != %d\n",
			sizeof (*service_config),sc_size));
	
	/* do nothing  
	   -- not need to return failure 
	   -- just disable ourself
	*/
	goto fail;
    }


    if (!remote_account_OK (sizeof (con->C))) {
	DPRINT(Debug,1,(&Debug,			    
			"tls:imap_STARTTLS_handler: sizeof (struct remote_account) mismatch\n"));
	
	/* do nothing  
	   -- not need to return failure 
	   -- just disable ourself
	*/
	goto fail;
    }

    if (con->type != &IMAP_connection) {
	DPRINT(Debug,1,(&Debug,			    
			"tls:imap_STARTTLS_handler: connection not IMAP connection?\n"));
	goto fail;
    }
 
    if (!tls_init(NULL)) {
	DPRINT(Debug,1,(&Debug,			    
			"tls:imap_STARTTLS_handler: Initialization failed\n"));

	goto fail;
    }
   
    /* SIC!
       Both cyrus-imap and Communigate PRO lists STARTTLS 
       on capability listing when they are already active.
    */

    StreamInfo(con -> C.stream,SS_ssf,&bits,NULL,NULL);
    if (bits > 0) {
	DPRINT(Debug,4,(&Debug,			    
			"tls:imap_STARTTLS_handler: Already %d 'bits' encryption -- TLS already active?\n",
			bits));
	goto fail;
    }

    if (service_config) {
	if (service_config->type != &tls_options ||
	    !service_config->value) {
	    panic("TLS PANIC",__FILE__,__LINE__,"imap_STARTTLS_handler",
		  "Bad option storage",0);
	}

	if (0 != (service_config->value->flags & TLS_starttls)) {
	    tls        = service_config->value->v_starttls;
	    tls_config = "tls:starttls-version";
	} else if (! dt_flag_is_set(&use_tls,use_tls_starttls)) {
	    
	    DPRINT(Debug,4,(&Debug,			    
			    "tls:imap_STARTTLS_handler: starttls disabled by use-tls\n"));
	    goto fail;
	    
	} else if (0 != (service_config->value->flags & TLS_tls)) {
	    tls = service_config->value->v_tls;
	    tls_config = "tls:tls-version";
	}

	if (tls_none == tls) {
	    DPRINT(Debug,4,(&Debug,			    
			    "tls:imap_STARTTLS_handler: tls disabled\n"));
	    goto fail;
	}
	
    } else {
	DPRINT(Debug,10,(&Debug,			    
			 "tls:imap_STARTTLS_handler: no mail services config\n"));
	
	if (! dt_flag_is_set(&use_tls,use_tls_starttls)) {
	    
	    DPRINT(Debug,4,(&Debug,			    
			    "tls:imap_STARTTLS_handler: starttls disabled by use-tls\n"));
	    goto fail;
	    
	} 	
    }

    DPRINT(Debug,4,(&Debug,			    
		    "tls:imap_STARTTLS_handler: version: %d",tls));
    switch(tls) {
    case tls_none: DPRINT(Debug,4,(&Debug, " tls_none")); break;
    case v_ssl:    DPRINT(Debug,4,(&Debug, " v_ssl"));    break;
    case v_tls:    DPRINT(Debug,4,(&Debug, " v_tls"));    break;
    case v_tls1:   DPRINT(Debug,4,(&Debug, " v_tls1"));   break;
    case v_tls1_1: DPRINT(Debug,4,(&Debug, " v_tls1_1")); break;
    case v_tls1_2: DPRINT(Debug,4,(&Debug, " v_tls1_2")); break;
    case NUM_tls_version: DPRINT(Debug,4,(&Debug, " NUM_tls_version")); break;
    }
    DPRINT(Debug,4,(&Debug,"\n"));

    if (!tls_version_supported(tls_config,tls)) {
	DPRINT(Debug,4,(&Debug,			    
			"tls:imap_STARTTLS_handler: tls version not supported\n"));
	goto fail;            /* Just fail ... */		
    }


    if (!commands->start_command(con,"STARTTLS")) {
        commands->clear_command(con);
	goto fail;            /* Just fail ... */		
    }
    commands->end_command(con);

    if (!commands->command_ok(con,&ret1,NULL)) {
	commands->clear_command(con);
	goto fail;            /* Just fail .... */
    }

    commands->clear_command(con);

    /* After that we need need return failure if something
       goes wrong because connection is messed beyond repair
     */

    T = create_TLS_stream(tls);
    if (T.TYPE == NULL) {
	/* Error message ? */
	ret = 0;
	goto fail;
    }

    if (tls >= 0 && tls < NUM_tls_version) {
        proto_text = elm_message(FRM("IMAP/%s"),TLS_VERSION[tls]);
    } else {
	proto_text = safe_strdup("IMAP/TLS?");
    }
    
    if (!ra_wrap_tls(& (con -> C),
		     T,
		     proto_text,
		     phase)) {

	ret = 0;
	goto fail;
    }

 fail:
    if (proto_text) {
	free(proto_text);
	proto_text = NULL;
    }

    DPRINT(Debug,10,(&Debug,			    
		     "tls:imap_STARTTLS_handler=%d\n",
		     ret));
        
    return ret;

}


static struct provides_shared_IMAP_CAPA LIST[] = {
    { "STARTTLS",  1,  imap_STARTTLS_handler },
};

#ifdef ANSI_C
provides_shared_IMAP_CAPA_f provides_shared_IMAP_CAPA;
#endif
struct provides_shared_IMAP_CAPA * provides_shared_IMAP_CAPA(count,s_size)
     int *count; 
     size_t *s_size;
{
    *s_size = sizeof (LIST[0]);
    
    *count = (sizeof LIST) / *s_size;

    return &(LIST[0]);
}

#endif

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
