case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh

    ;;
esac

case "$subdir" in
'')
    case "$0" in
    */*) cd `expr X$0 : 'X\(.*\)/'` ;;
    esac	    

    vpathdef="#VPATH		= "
    XXsrc="."
    XXsrcroot="../"
    ;;
*)
    vpathdef="VPATH		=	$source_dir/$subdir"
    XXsrc="$source_dir/$subdir"
    XXsrcroot="$source_dir"
    ;;
esac

liblist="mime misc mbox mailer addr alias base"
libx=
libxs=
for i in $liblist
do
  libx="$libx ../libs/libelmme-$i.a"
  libxs="$libxs ../shlib/libelmme-$i.so"
done

echo "Extracting src/Makefile (with variable substitutions)"
: if mailermode is not 2755 then we dont need the chgrp
: set chgrp to a null command in this case
if test "$mailermode" = 755; then
	chgrp=":"
fi

case "$d_locale" in
define)
	localetarget='$(ETC)/elm.mimecharsets $(ETC)/elm.terminalinfo'
	;;
*)
	localetarget=
	;;
esac

subdirlist="messages screen aliases menu_common url block list command pager"

: Avoid duplicate option
if $test "X$dynamic_opt" != "X$backtrace_opt" ; then
   XX="$backtrace_opt"
else
   XX=
fi

cat >Makefile <<!GROK!THIS!
#!$make
#
# $Id: Makefile.SH,v 2.32 2022/08/19 16:13:05 hurtta Exp $
#
#  Makefile for the ELM (ME+) mail program.
#
# Modified by Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
#                     (was hurtta+elm@posti.FMI.FI)
#             Kari Hurtta <elm@elmme-mailer.org>
######################################################################
# Based on Elm 2.4 src/Makefile.SH. That code was following copyright:
#
#	Copyright (c) 1988-1992 USENET Community Trust
#	Copyright (c) 1986,1987 Dave Taylor
######################################################################
#
# Variables
#	Variables established by Configure
CC		=	$cc
CCFLAGS		=	$ccflags $picflag $xencf
CHGRP		=	$chgrp
CHMOD		=	$chmod
CP		=	$cp
DEST		=	\$(ELM_ROOT)//$bin
ECHO		=	$echo
LFLAGS		=	$ldflags $dynamic_opt $XX $xenlf
LIB		=	\$(ELM_ROOT)//$lib
ETC		=	\$(ELM_ROOT)//$etc
LIB2		= 	$dlopen_lib $libs 
LIBS		=	$cryptlib $termlib $dbm
LINT		=	$lint
MAILGRP		=	$mailgrp
MAILERMODE	=	$mailermode
MV		=	$mv
OPTIMIZE	=	$optimize
RM		= 	$rm -f
TOUCH		=	$touch
TAGS		=	ctags
LIBX            =       $libx
LOCALETARG	=	$localetarget
$vpathdef
SRC		=	$XXsrc
SRCROOT		=	$XXsrcroot
!GROK!THIS!

if $test "X$rpath_ok" = XOK ; then

# Use -rpath for directories need by shared_libs 
# It is is possible to also use -rpath-link on Linux and SunOS
# but it may require extra Configure test....

	 rlink=
	 for domake in $shared_list ; do
		dir=
		varname="\$${domake}_lib_dir"
		eval "dir=$varname"
		if $test "X$dir" != X ; then
			rlink="$rlink $rpath_opt$dir"
		fi
	 done

	 cat >>Makefile <<!GROK!THIS!
RPATH           =       $rpath_opt$shlib $rlink
!GROK!THIS!

else
	 cat >>Makefile <<!GROK!THIS!
RPATH           =       
!GROK!THIS!

fi

if $test "$make_sets_make" != "$define" ; then  

	cat >>Makefile <<!GROK!THIS!
MAKE		=	$make
!GROK!THIS!

fi

if $test "$d_shared" = "$define" ; then

cat >>Makefile <<'!NO!SUBS!'
SHLIST          = $(BIN)/elm-shared
!NO!SUBS!
cat >>Makefile <<!SUBS!
LIBXS            =       $libxs
!SUBS!

else

cat >>Makefile <<'!NO!SUBS!'
SHLIST          =
!NO!SUBS!

fi

cat >>Makefile <<'!NO!SUBS!'

#	Other general variables
BIN		=	../bin
CFLAGS		=	-I$(IHDR) -I$(INCLDIR) $(CCFLAGS) $(OPTIMIZE)
INCLDIR		=	$(SRCROOT)/hdrs
IHDR		=	../hdrs
SHELL		=	/bin/sh
REG             =       ../bin/elmregister

# 	Lists
ELM_SRC		=	addr_prompt.c   \
                        addr_util.c	\
			alias.c		\
			alias_display.c \
			alias_info.c	\
			alias_info_1.c	\
			alias_itemized.c	\
			aliaslib.c	\
			args.c		\
			a_edit.c	\
			a_screen.c	\
			a_sort.c	\
			a_quit.c	\
			attach_menu.c	\
			browser.c	\
			browser_help.c  \
			builtin++.c	\
			calendar.c	\
			canceled.c      \
			date.c		\
			delete.c	\
			digest.c	\
			duplicate_removal.c \
			edit.c		\
			editmsg.c	\
			edithdr.c	\
			enter_helper.c  \
			elm.c		\
			exitprog.c	\
			extended.c	\
			file.c		\
			file_util.c	\
			fileio.c	\
			fbrowser.c	\
			fb_options.c	\
			hdrconfg.c	\
			help.c		\
			in_utils.c	\
			init.c		\
			leavembox.c	\
			lock.c		\
			limit.c		\
			mailcap_sel.c	\
			mailbox.c	\
			mailmsg1.c	\
			mailmsg2.c	\
			menu.c		\
			menu2.c		\
			metapager.c	\
		 	mime.c          \
			mime_encode.c	\
			mkhdrs.c	\
                        network.c       \
			newmbox.c	\
			openmailbox.c	\
			options.c	\
			opt_generic.c	\
			out_utils.c	\
			pattern.c	\
			partial.c	\
			pgp.c		\
			quit.c		\
			quotadisp.c	\
			read_rc.c	\
                        reconnect.c     \
			remail.c	\
			reply.c		\
			save_opts.c	\
			savecopy.c	\
			screen.c	\
			showmsg.c	\
			showmsg_c.c	\
			showmsg_1.c	\
			signals.c	\
			snd_display.c	\
			snd_preview.c	\
			sort.c		\
			strings.c	\
			syscall.c	\
			thread.c	\
			utils.c		\
			view_folder.c   \
			view_one_thread.c

ELM_OBJ		=	addr_prompt.o   \
                        addr_util.o	\
			alias.o		\
			alias_display.o	\
			alias_info.o	\
			alias_info_1.o	\
			alias_itemized.o \
			aliaslib.o	\
			args.o		\
			attach_menu.o	\
			a_edit.o	\
			a_screen.o	\
			a_sort.o	\
			a_quit.o	\
			browser.o	\
			browser_help.o	\
			builtin++.o	\
			calendar.o	\
			canceled.o      \
			date.o		\
			delete.o	\
			digest.o	\
			duplicate_removal.o \
			edit.o		\
			editmsg.o	\
			edithdr.o	\
			elm.o		\
			enter_helper.o  \
			exitprog.o	\
			extended.o	\
			fbrowser.o	\
			fb_options.o	\
			file.o		\
			file_util.o	\
			fileio.o	\
			hdrconfg.o	\
			help.o		\
			in_utils.o	\
			init.o		\
			leavembox.o	\
			lock.o		\
			limit.o		\
			mailcap_sel.o	\
			mailbox.o	\
			mailmsg1.o	\
			mailmsg2.o	\
			menu.o		\
			menu2.o		\
			metapager.o	\
			mime.o		\
			mime_encode.o	\
			motion.o        \
			movement.o	\
			mkhdrs.o	\
                        network.o       \
			newmbox.o	\
			openmailbox.o	\
			options.o	\
			opt_generic.o	\
			out_utils.o	\
			pattern.o	\
			partial.o	\
			pgp.o		\
			quit.o		\
			quotadisp.o	\
			read_rc.o	\
                        reconnect.o     \
			remail.o	\
			reply.o		\
			save_opts.o	\
			savecopy.o	\
			screen.o	\
			showmsg.o	\
			showmsg_c.o	\
			showmsg_1.o	\
			signals.o	\
			snd_display.o	\
			snd_preview.o	\
			sort.o		\
			strings.o	\
			syscall.o	\
			utils.o		\
			thread.o	\
			view_folder.o	\
			view_one_thread.o

# Standard targets
all:		Makefile $(BIN)/elm $(SHLIST)
!NO!SUBS!

for i in $subdirlist
do
cat >>Makefile <<!SUBS!
		cd $i; \$(MAKE) \$(MJ) \$(MFLAGS) \$@
!SUBS!
done

cat >>Makefile <<'!NO!SUBS!'

install_s:	Makefile $(DEST) $(DEST)/elm  
!NO!SUBS!

for i in $subdirlist
do
cat >>Makefile <<!SUBS!
		cd $i; \$(MAKE) \$(MJ) \$(MFLAGS) \$@
!SUBS!
done

cat >>Makefile <<'!NO!SUBS!'

$(DEST):
		$(REG) mkdir $(DEST)

$(LIB):
		$(REG) mkdir $(LIB)

$(LIB)/elm.map.bin: 
		$(REG) mkdir $(LIB)/elm.map.bin

$(LIB)/elm.map.txt:
		$(REG) mkdir $(LIB)/elm.map.txt

url/liburl.a:
		cd url; $(MAKE) $(MJ) $(MFLAGS) all

block/libblock.a:
		cd block; $(MAKE) $(MJ) $(MFLAGS) all

list/liblist.a:
		cd list; $(MAKE) $(MJ) $(MFLAGS) all

messages/libmessages.a:
		cd messages; $(MAKE) $(MJ) $(MFLAGS) all

screen/libscreen.a:
		cd screen; $(MAKE) $(MJ) $(MFLAGS) all


pager/libpager.a:
		cd pager; $(MAKE) $(MJ) $(MFLAGS) all

aliases/libaliases.a:
		cd aliases; $(MAKE) $(MJ) $(MFLAGS) all

menu_common/libmcommon.a:
		cd menu_common; $(MAKE) $(MJ) $(MFLAGS) all

command/libelmcommand.a:
		cd command; $(MAKE) $(MJ) $(MFLAGS) all


!NO!SUBS!

if $test "X$etc" != "X$lib" ; then

cat >>Makefile <<'!NO!SUBS!'
$(ETC):
	$(REG) mkdir $(ETC)

!NO!SUBS!

fi

cat >>Makefile <<'!NO!SUBS!'
uninstall_s:	
		$(REG) rm $(DEST)/elm 
!NO!SUBS!

for i in $subdirlist
do
cat >>Makefile <<!SUBS!
		cd $i; \$(MAKE) \$(MJ) \$(MFLAGS) \$@
!SUBS!
done

cat >>Makefile <<'!NO!SUBS!'

Makefile: Makefile.SH ../config.sh
	@echo "You must run 'sh Configure -S' or 'sh Configure'"
	exit 1


tags:
		$(TAGS) $(ELM_SRC)

clean: 
		$(RM) $(ELM_OBJ) $(BIN)/elm $(SHLIST)
!NO!SUBS!

for i in $subdirlist
do
cat >>Makefile <<!SUBS!
		cd $i; \$(MAKE) \$(MJ) \$(MFLAGS) \$@
!SUBS!
done

cat >>Makefile <<'!NO!SUBS!'

# Dependencies and rules
#	Dependencies of header files upon other header files they include
.PRECIOUS:		def_elm.h $(IHDR)/me.h $(IHDR)/elm_defs.h \
 $(IHDR)/defs_major.h def_browser.h def_sndmail.h 

$(IHDR)/elm_defs.h:	$(IHDR)/defs_major.h $(INCLDIR)/elm_nl_types.h \
 $(INCLDIR)/elmlib.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

$(IHDR)/defs_major.h: ../config.h $(IHDR)/sysdefs.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

$(IHDR)/me.h:	$(INCLDIR)/melib.h $(INCLDIR)/misclib.h \
 $(INCLDIR)/addrlib.h $(INCLDIR)/aliaslib.h $(INCLDIR)/mime.h
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

def_elm.h:		$(IHDR)/elm_defs.h  \
 $(INCLDIR)/me.h $(INCLDIR)/elm_globals.h  $(INCLDIR)/mailerlib.h \
 $(INCLDIR)/mboxlib.h $(INCLDIR)/schedule_time.h
			cmp $(SRC)/$@ $@ 2>/dev/null || $(CP) $(SRC)/$@ $@
			$(CHMOD) u+w $@
			$(TOUCH) $@

def_browser.h:		def_elm.h $(INCLDIR)/pager.h $(INCLDIR)/pg_range_imp.h
			cmp $(SRC)/$@ $@ 2>/dev/null || $(CP) $(SRC)/$@ $@
			$(CHMOD) u+w $@
			$(TOUCH) $@

def_sndmail.h:		def_elm.h
			cmp $(SRC)/$@ $@ 2>/dev/null || $(CP) $(SRC)/$@ $@
			$(CHMOD) u+w $@
			$(TOUCH) $@


#	Dependencies of C object files
addr_prompt.o:  def_elm.h $(INCLDIR)/s_elm.h $(INCLDIR)/s_me.h
addr_util.o:	def_elm.h $(INCLDIR)/s_elm.h $(INCLDIR)/s_me.h
alias.o:	def_elm.h  $(INCLDIR)/s_aliases.h $(INCLDIR)/s_elm.h 
alias_display.o:	def_elm.h $(INCLDIR)/s_aliases.h
alias_info.o:		def_elm.h $(INCLDIR)/s_aliases.h
alias_info_1.o:		def_elm.h $(INCLDIR)/s_elm.h
alias_itemized.o:	def_elm.h $(INCLDIR)/s_aliases.h
aliaslib.o:	def_elm.h $(INCLDIR)/s_elm.h 
args.o:		def_elm.h $(INCLDIR)/patchlevel.h $(INCLDIR)/s_elm.h
a_edit.o:	def_elm.h $(INCLDIR)/s_aliases.h
a_screen.o:	def_elm.h $(INCLDIR)/s_aliases.h 
a_sort.o:	def_elm.h $(INCLDIR)/s_aliases.h
a_quit.o:	def_elm.h $(INCLDIR)/s_aliases.h
attach_menu.o:	def_elm.h $(INCLDIR)/s_elm.h $(INCLDIR)/s_me.h
browser.o:	def_browser.h $(INCLDIR)/s_elm.h $(INCLDIR)/browser.h $(INCLDIR)/fbrowser.h
browser_help.o:	def_browser.h 
builtin++.o:	def_elm.h $(INCLDIR)/s_elm.h $(INCLDIR)/pager.h
calendar.o:	def_elm.h
canceled.o:	def_elm.h $(INCLDIR)/s_elm.h
date.o:		def_elm.h
delete.o:	def_elm.h $(INCLDIR)/s_elm.h
digest.o:	def_elm.h $(INCLDIR)/s_elm.h
duplicate_removal.o:	  def_elm.h
edit.o:		def_elm.h
editmsg.o:	def_elm.h $(INCLDIR)/s_elm.h
edithdr.o:	def_elm.h $(INCLDIR)/s_elm.h
elm.o:		def_elm.h $(INCLDIR)/s_elm.h $(INCLDIR)/patchlevel.h
enter_helper.o: def_elm.h
encode.o:	def_elm.h $(INCLDIR)/s_elm.h
exitprog.o:	def_elm.h $(INCLDIR)/s_elm.h
extended.c:	def_elm.h $(INCLDIR)/s_me.h
fbrowser.o:	def_elm.h $(INCLDIR)/s_fbrowser.h $(INCLDIR)/fbrowser.h \
 $(INCLDIR)/browser.h
fb_options.o:	def_elm.h $(INCLDIR)/s_fbrowser.h $(INCLDIR)/browser.h \
 $(INCLDIR)/patchlevel.h
file.o:		def_elm.h $(INCLDIR)/s_elm.h
file_util.o:	def_elm.h $(INCLDIR)/s_elm.h
fileio.o:	def_elm.h $(INCLDIR)/s_elm.h
hdrconfg.o:	def_elm.h $(INCLDIR)/s_elm.h  $(INCLDIR)/me.h
help.o:		def_elm.h $(INCLDIR)/s_elm.h
in_utils.o:	def_elm.h $(INCLDIR)/s_elm.h
init.o:		def_elm.h $(INCLDIR)/fbrowser.h \
  $(INCLDIR)/patchlevel.h $(INCLDIR)/s_elm.h \
 $(INCLDIR)/s_elm.h 
leavembox.o:	def_elm.h $(INCLDIR)/s_elm.h $(INCLDIR)/me.h
limit.o:	def_elm.h $(INCLDIR)/s_elm.h $(INCLDIR)/s_aliases.h
lock.o:		def_elm.h $(INCLDIR)/s_elm.h
mailcap_sel.o:	def_elm.h $(INCLDIR)/me.h  $(INCLDIR)/mailcap_imp.h
mailbox.o:	def_elm.h $(INCLDIR)/s_elm.h
mailmsg1.o:	def_elm.h $(INCLDIR)/s_elm.h
mailmsg2.o:	def_sndmail.h $(INCLDIR)/s_elm.h $(INCLDIR)/menu2.h \
 $(INCLDIR)/s_me.h
menu2.o:	def_elm.h $(INCLDIR)/menu2.h
menu.o:		def_elm.h $(INCLDIR)/menu.h
metapager.o:	def_elm.h $(INCLDIR)/s_elm.h
mime.o:		def_elm.h $(INCLDIR)/s_elm.h
mime_encode.o:  def_elm.h
motion.o:       def_elm.h $(INCLDIR)/s_elm.h
movement.o:	def_elm.h $(INCLDIR)/s_me.h
mkhdrs.o:	def_elm.h $(INCLDIR)/s_elm.h
network.o:	def_elm.h $(INCLDIR)/s_me.h
newmbox.o:	def_elm.h $(INCLDIR)/s_elm.h
openmailbox.o:	def_elm.h $(INCLDIR)/s_me.h
options.o:	def_elm.h $(INCLDIR)/s_elm.h $(INCLDIR)/save_opts.h \
 $(INCLDIR)/rc_imp.h $(INCLDIR)/patchlevel.h
opt_generic.o:	def_elm.h $(INCLDIR)/s_elm.h $(INCLDIR)/save_opts.h \
 $(INCLDIR)/rc_imp.h $(INCLDIR)/opt_imp.h
out_utils.o:	def_elm.h $(INCLDIR)/s_me.h
pattern.o:	def_elm.h $(INCLDIR)/s_elm.h
partial.o:	def_elm.h $(INCLDIR)/s_elm.h
pgp.o:		def_elm.h
quit.o:		def_elm.h $(INCLDIR)/s_elm.h
quotadisp.o:	def_elm.h $(INCLDIR)/s_me.h $(INCLDIR)/pager.h
read_rc.o:	def_elm.h $(INCLDIR)/s_elm.h $(INCLDIR)/save_opts.h \
 $(INCLDIR)/rc_imp.h
reconnect.o:     def_elm.h $(INCLDIR)/s_me.h $(INCLDIR)/s_elm.h
remail.o:	def_sndmail.h $(INCLDIR)/s_elm.h
reply.o:	def_elm.h $(INCLDIR)/s_elm.h 
save_opts.o:	def_elm.h $(INCLDIR)/save_opts.h $(INCLDIR)/s_elmrc.h \
 $(INCLDIR)/rc_imp.h
savecopy.o:	def_elm.h $(INCLDIR)/s_elm.h
screen.o:	def_elm.h $(INCLDIR)/s_elm.h $(INCLDIR)/s_aliases.h 
showmsg.o:	def_elm.h $(INCLDIR)/s_elm.h $(INCLDIR)/s_me.h
showmsg_c.o:	def_elm.h $(INCLDIR)/s_elm.h
showmsg_1.o:	def_elm.h 
signals.o:	def_elm.h $(INCLDIR)/s_elm.h
snd_display.o:	def_sndmail.h $(INCLDIR)/s_elm.h 
snd_preview.o:	def_sndmail.h $(INCLDIR)/s_elm.h 
sort.o:		def_elm.h $(INCLDIR)/s_elm.h
strings.o:	def_elm.h $(INCLDIR)/s_elm.h
syscall.o:	def_elm.h $(INCLDIR)/s_elm.h $(INCLDIR)/s_me.h
utils.o:	def_elm.h $(INCLDIR)/s_elm.h
thread.o:	def_elm.h $(INCLDIR)/s_me.h
view_folder.o:	def_elm.h $(INCLDIR)/s_elm.h
view_one_thread.o:	def_elm.h $(INCLDIR)/s_me.h

#	Dependencies and rules for compiling C programs
$(BIN)/elm:	$& $(ELM_OBJ) $(LIBX) \
 menu_common/libmcommon.a messages/libmessages.a screen/libscreen.a \
 aliases/libaliases.a url/liburl.a block/libblock.a \
 list/liblist.a command/libelmcommand.a pager/libpager.a
		$(CC) $(LFLAGS) -o $@ $(ELM_OBJ) \
 menu_common/libmcommon.a messages/libmessages.a \
 screen/libscreen.a aliases/libaliases.a  \
 list/liblist.a url/liburl.a block/libblock.a  \
 command/libelmcommand.a pager/libpager.a \
 $(LIBX) $(LIBS) $(LIB2)

#	Dependencies and rules for installing C programs

!NO!SUBS!

for i in $libx
do
	y="`echo $i|$sed 's%^../%%'`"
cat >>Makefile <<!SUBS!
$i:
	cd ..; \$(MAKE) \$(MJ) \$(MFLAGS) $y
!SUBS!
done

if $test "$d_shared" = "$define" ; then

cat >>Makefile <<'!NO!SUBS!'

$(BIN)/elm-shared: $& $(ELM_OBJ)  $(LIBXS) \
 messages/libmessages.a screen/libscreen.a \
 aliases/libaliases.a menu_common/libmcommon.a url/liburl.a \
 block/libblock.a list/liblist.a command/libelmcommand.a \
 pager/libpager.a
		$(CC) $(LFLAGS) -o $@ $(RPATH) $(ELM_OBJ) \
 screen/libscreen.a aliases/libaliases.a \
 menu_common/libmcommon.a messages/libmessages.a \
 list/liblist.a url/liburl.a \
 block/libblock.a command/libelmcommand.a \
 pager/libpager.a $(LIBXS) $(LIBS) $(LIB2)

$(DEST)/elm:	$(BIN)/elm-shared
		$(REG) copy -g $(MAILGRP) -m $(MAILERMODE) $? $@

!NO!SUBS!

	for i in $libxs
	do
		y="`echo $i|$sed 's%^../%%'`"
cat >>Makefile <<!SUBS!
$i:
	cd ..; \$(MAKE) \$(MJ) \$(MFLAGS) $y
!SUBS!
	done


else

cat >>Makefile <<'!NO!SUBS!'
$(DEST)/elm:	$(BIN)/elm
		$(REG) copy -g $(MAILGRP) -m $(MAILERMODE) $? $@
!NO!SUBS!

fi
