static char rcsid[] = "@(#)$Id: a_quit.c,v 2.5 2014/07/14 15:07:29 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.5 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 src/a_quit.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** a_quit: leave the aliases menu and return to the main menu.
  
**/

#include "def_elm.h"
#include "s_aliases.h"


DEBUG_VAR(Debug,__FILE__,"alias");

#include <errno.h>
#ifndef ANSI_C
extern int errno;		/* system error number on failure */
#endif

int delete_aliases(newaliases, prompt, aview, page, LOC)
     int newaliases, prompt;
     struct AliasView *aview;
     struct menu_context  * page;
     struct screen_parts *LOC;
{
    /*
     *	Update aliases by processing deletions.  Prompting is
     *	done as directed by user input and elmrc options.
     *
     *	If "prompt" is false, then no prompting is done.
     *	Otherwise prompting is dependent upon the variable
     *	question_me, as set by an elmrc option.  This behavior
     *	makes the 'q' command prompt just like '$', while
     *	retaining the 'Q' command for a quick exit that never
     *	prompts.
     *
     *	Return	1		Aliases were deleted
     * 		newalias	Aliases were not deleted
     *
     *	The return allows the caller to determine if the "newalias"
     *	routine should be run.
     */
    
        
    int to_delete = 0, to_keep = 0, i, marked_deleted = 0, ask_questions;
    int answer;
    int ac = get_alias_count(aview);


    DPRINT(Debug,1,
	   (&Debug, "\n\n-- leaving aliases --\n\n"));
    
    if (ac == 0)
	return(newaliases);	/* nothing changed */
    
    ask_questions = ((!prompt) ? FALSE : ask_delete);
    
    /* YES or NO on softkeys */
    /*
      if (hp_softkeys && ask_questions) {
      define_softkeys(YESNO);
      softkeys_on();
      }
    */
    
    /* Determine if deleted messages are really to be deleted */
    
    /* we need to know how many there are to delete */
    for (i=0; i<ac; i++) {
	struct  aliasview_record *a =  give_alias (aview,i);
	if (a &&
	    aliasview_have_status_mask(a,DELETED))
	    marked_deleted++;
    }
    DPRINT(Debug,4,(&Debug, 
		    "Number of aliases marked deleted = %d\n",
		    marked_deleted));

    if(marked_deleted) {
	answer = (always_del ? *def_ans_yes : *def_ans_no);	/* default answer */
	if(ask_questions) {
	    if (marked_deleted == 1)
		answer = prompt_letter(0,"",answer,
				       PROMPT_yesno|PROMPT_cancel,
				       LOC->prompt_page,
				       CATGETS(elm_msg_cat, AliasesSet, AliasesDelete,
					       "Delete 1 alias? (%c/%c) "), 
				       *def_ans_yes, *def_ans_no);
	    else
		answer = prompt_letter(0,"",answer,
				       PROMPT_yesno|PROMPT_cancel,
				       LOC->prompt_page,
				       CATGETS(elm_msg_cat, AliasesSet, 
					       AliasesDeletePlural,
					       "Delete %d aliases? (%c/%c) "),
				       marked_deleted, *def_ans_yes, *def_ans_no);
	    
	    
	    if (TERMCH_interrupt_char == answer) {
		return -1;
	    }
	}
	
	if(answer == *def_ans_yes) {
	    
	    for (i = 0; i < ac; i++) {
		struct aliasview_record *a =  give_alias (aview,i);
		
		if (a &&
		    aliasview_have_status_mask(a, DELETED)) {
		    
		    const struct string * A UNUSED_VAROK = aliasview_key(a);
		    
		    DPRINT(Debug,8,(&Debug,
				    "Alias number %d, %S is deletion %d\n",
				    i, A, to_delete));
		    
		    /* makes alias to be NULL -- does not change index */
		    delete_alias_from_aview(aview,i);
		    
		    to_delete++;
		}
		else {
		    to_keep++;
		}
	    }
	    /*
	     * Formulate message as to number of keeps and deletes.
	     * This is only complex so that the message is good English.
	     */
	    if (to_keep > 0) {
		set_alias_current(aview,1);		/* Reset current alias */
		if (to_keep == 1)
		    lib_error(CATGETS(elm_msg_cat, AliasesSet, 
				      AliasesKeepDelete,
				      "[Keeping 1 alias and deleting %d.]"), 
			      to_delete);
		else
		    lib_error(CATGETS(elm_msg_cat, AliasesSet, 
				      AliasesKeepDeletePlural,
				      "[Keeping %d aliases and deleting %d.]"),
			      to_keep, to_delete);
	    }
	    else {
		set_alias_current(aview,0);		/* No aliases left */
		lib_error(CATGETS(elm_msg_cat, AliasesSet, AliasesDeleteAll,
				  "[Deleting all aliases.]"));
	    }
	    
	}
    }
    
    DPRINT(Debug,3,(&Debug,
		    "Aliases deleted: %d\n", to_delete));
    
    /* If all aliases are to be kept we don't need to do anything
     */
    
    if(to_delete == 0) {
	DPRINT(Debug,3,(&Debug,
			"Aliases kept as is!\n"));
	return(newaliases);
    }
    
    menu_trigger_redraw(LOC->header_page);
    menu_trigger_redraw(LOC->title_page); 

    return(1);
}

void exit_alias(aview)
     struct AliasView *aview;
{
    
    int i;
    int ac = get_alias_count(aview);

    /* Clear the deletes from all aliases.  */
    
    for(i = 0; i < ac; i++) {
	struct aliasview_record *a = give_alias(aview,i);

	if (a &&
	    aliasview_have_status_mask(a, DELETED))
	    aliasview_clearf_status(a, DELETED);
	
	
    }

    DPRINT(Debug,5,
	   (&Debug, "\nexit_alias:  Done clearing deletes.\n"));

}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
