static char rcsid[] = "@(#)$Id: a_screen.c,v 2.13 2021/07/14 07:19:22 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.13 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 src/a_screen.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/**  alias screen display routines for ELM program

**/

#include "def_elm.h"
#include "s_aliases.h"

DEBUG_VAR(Debug,__FILE__,"alias");

char *show_alias_status(entry)
     struct  aliasview_record  *entry;
{
    /* Based on show_status() on src/screen.c */

    /** This routine returns a pair of characters indicative of
	the status of this message.  The first character represents
	the interim status.

	N = New alias
	D = Deleted alias
	X = Expunged alias

	and the second represents the permanent attributes 
	
	_ = (space) default
    **/

    int status = aliasview_get_status(entry);
    int type   = aliasview_get_type(entry);

    static char mybuffer[3];
    
    /** the first character, please **/
    
    if (ison(status,DELETED))	mybuffer[0] = 'D';
    else if (ison(status,NEW))		mybuffer[0] = 'N';
    else if (ison(type,EXPUNGED))       mybuffer[0] = 'X';
    else                                mybuffer[0] = ' ';
    
    /** and the second... **/
    
                                        mybuffer[1] = ' ';
    
					mybuffer[2] = '\0';

    return( (char *) mybuffer);
}


void alias_screen(aview, page) 
     struct AliasView *aview;
     struct menu_context *page;
{
    
    /* Stolen from showscreen() */
  
    menu_ClearScreen(page);

    /* Call refresh routines of children */
    menu_redraw_children(page);
            
    show_last_error();

    /* define_softkeys(ALIAS); */
}

#if ANSI_C
subpage_simple_redraw sb_alias_menu;
#endif
int sb_alias_menu(ptr,list)
     struct menu_context  *ptr;
     struct menu_param *list; 
{
    enum user_level_v 
	ul = give_dt_enumerate_as_int(&user_level);

    menu_ClearScreen(ptr);

    /** write alias menu... **/
    /* Moved from alias.c */

    if (ul == user_level_beginner) {	/* Give less options  */
	menu_print_format_center(ptr,0, 
				 CATGETS(elm_msg_cat, AliasesSet, 
					 AliasesRMenuLn1,
					 "You can use any of the following commands by pressing the first character;"));
	menu_print_format_center(ptr,1, 
				 CATGETS(elm_msg_cat, AliasesSet, 
					 AliasesRMenuLn2,
					 "a)lias current message, n)ew alias, d)elete or u)ndelete an alias,"));
	menu_print_format_center(ptr,2, 
				 CATGETS(elm_msg_cat, AliasesSet, 
					 AliasesRMenuLn3,
					 "m)ail to alias, or r)eturn to main menu.  To view an alias, press <return>."));
	menu_print_format_center(ptr,3,
				 CATGETS(elm_msg_cat, AliasesSet, 
					 AliasesRMenuLn4,
					 "j = move down, k = move up, ? = help"));
    } else {
	menu_print_format_center(ptr,0, 
				 CATGETS(elm_msg_cat, AliasesSet, 
					 AliasesMenuLn1,
					 "Alias commands:  ?=help, <n>=set current to n, /=search pattern"));
	menu_print_format_center(ptr,1, 
				 CATGETS(elm_msg_cat, AliasesSet, 
					 AliasesMenuLn2a,
					 "a)lias current message, c)hange, d)elete, e)dit %s, f)ully expand,"),
				 USER_ALIASES_FILE);
	menu_print_format_center(ptr,2, 
				 CATGETS(elm_msg_cat, AliasesSet, 
					 AliasesMenuLn3,
					 "l)imit display, m)ail, n)ew alias, r)eturn, t)ag, u)ndelete, or e(x)it"));
    }

    return 1;
}

static int string_nonnull P_((const struct string *S));
static int string_nonnull(S)
     const struct string *S;
{
    if (!S)
	return 0;
    return string_len(S);
}

struct string *build_alias_line(entry, message_number, highlight, page, index_width)
     struct aliasview_record *entry;
     int message_number, highlight;
     struct menu_context *page;
     int index_width;
{

    /** Build in buffer the alias header ... entry is the current
	message entry, 'highlight' is either TRUE or FALSE,
	and 'message_number' is the number of the alias.
    **/
    
    struct string * buffer   = NULL;
    struct string * mybuffer = NULL;
    struct string * ret      = NULL;

    int name_width;
    int LINES, COLUMNS;

    int is_tagged                          = aliasview_ison_status(entry,TAGGED);
    const struct string         * keyname  = aliasview_key(entry);
    const struct address_alias  * aliasval = aliasview_address_alias(entry);
    
    struct string       * alias_type   = NULL;
    struct string       * system_flag  = NULL;


    menu_get_sizes(page,&LINES,&COLUMNS);
    
    buffer = format_string(FRM("%s%s%c%-*d "),
			   (highlight && arrow_cursor)? "->" : "  ",
			   show_alias_status(entry),
			   (is_tagged ?  '+' : ' '),
			   index_width,
			   message_number);

    /* Set the name display width. */
    name_width = COLUMNS-40;

    if (aliasval) {

	const struct string         * comment  = 
	    address_alias_get_comment(aliasval);
	
	const struct string *firstn   = NULL;
	const struct string *lastn    = NULL;
	const struct address *address = NULL;
	
	const struct string       *phrase = NULL;
	const struct alias_vector *vector = NULL;
		
	int  is_person = 
	    address_alias_get_person(aliasval,&firstn,&lastn,&address);
	
	int  is_group  = 
	    address_alias_get_group(aliasval,&phrase,&vector);
	
	const struct addr_list * adrlist   = 
	    address_alias_get_list(aliasval);
		
	if (is_person  && !is_group && !adrlist) {
	    
	    alias_type = format_string(CATGETS(elm_msg_cat, AliasesSet, AliasesPerson,
					       "Person"));
	    
	    if (lastn && string_nonnull(firstn) && string_nonnull(comment))
		mybuffer = format_string(FRM("%S %S, %S"),
					 lastn,firstn,comment);
	    else if (lastn && string_nonnull(firstn))
		mybuffer = format_string(FRM("%S %S"),
				     lastn,firstn);
	    else if (lastn && string_nonnull(comment))
		mybuffer = format_string(FRM("%S, %S"),
					 lastn,comment);
	    else if (lastn)
		mybuffer = dup_string(lastn);
	    else if (address) 
		mybuffer = address_to_string(address);
	    else 
		goto FAIL;
	    
	} else if (is_group && !is_person && !adrlist) {
	    
	    alias_type = format_string(CATGETS(elm_msg_cat, AliasesSet, AliasesGroup,
					       " Group"));
	    
	    if (phrase && string_nonnull(comment))
		mybuffer = format_string(FRM("%S, %S"),
					 phrase,comment); 
	    else if (phrase)
		mybuffer = dup_string(phrase); 
	    else if (vector) { 
		int cn = alias_vector_item_count(vector);
		
		if (!cn)
		    goto FAIL;
		
		if (cn > 2)
		    mybuffer =  format_string(FRM("%S, %S, ..."),
					      alias_vector_get_alias(vector,0),
					      alias_vector_get_alias(vector,1));
		else if (cn > 1)
		    mybuffer =  format_string(FRM("%S, %S"),
					      alias_vector_get_alias(vector,0),
					      alias_vector_get_alias(vector,1));
		else
		    mybuffer =  dup_string(alias_vector_get_alias(vector,0));
		
	    } else 
		goto FAIL;
	    
	} else if (adrlist && !is_person && !is_group)  {
	    
	    int gcount = addr_list_group_count(adrlist);
	    int acount = addr_list_item_count(adrlist);
	    
	    alias_type = format_string(CATGETS(elm_msg_cat, AliasesSet, AliasesAddrs,
					       " Addrs"));
	    if (1 == gcount) {
		const struct string *groupphrase = addr_list_get_group(adrlist,0);
		
		if (groupphrase && string_nonnull(comment))
		    mybuffer = format_string(FRM("%S, %S"),
					     groupphrase,comment); 
		else if (phrase)
		    mybuffer = dup_string(groupphrase); 
		goto NOGRP;
		
	    } else {
	    NOGRP:
		if (acount > 0) {
		    int g;
		    struct string * S;
		    
		    address  = addr_list_get_item(adrlist,0,&g);
		    S        = address_to_string(address);
		    
		    if (acount > 1)
			mybuffer =  format_string(FRM("%S, ..."),S);
		    else
			mybuffer =  format_string(FRM("%S"),S);
		    
		    free_string(&S);
		    
		} else
		    goto FAIL;
	    } 
	    
	} else {
	    
	    alias_type = format_string(CATGETS(elm_msg_cat, AliasesSet, AliasesMixed,
					       " Mixed"));
	    
	FAIL:
	    if (string_nonnull(comment)) 
		mybuffer = dup_string(comment); 	    
	    else 
		mybuffer =  format_string(FRM("?"));	
	    
	}
    } else {
	alias_type = format_string(CATGETS(elm_msg_cat, AliasesSet, AliasesEmpty,
					   " Empty"));
	mybuffer = format_string(CATGETS(elm_msg_cat, AliasesSet, AliasesNoValue,
					 "No value"));
    }
    
    
    if (aliasview_get_type(entry) & SYSTEM)
	system_flag = format_string(CATGETS(elm_msg_cat, AliasesSet, AliasesSystemFlag,
					    "(S)"));
    else
	system_flag = format_string(FRM("   "));

    /* complete line with name, type and alias. */
    ret = format_string(FRM("%S%-*.*S %S%S %-20.20S"),
			buffer,
			/* give max and min width parameters for 'name' */
			name_width, name_width, mybuffer,
			alias_type,
			system_flag,
			keyname);
   
    free_string(&system_flag);
    free_string(&alias_type);
    free_string(&mybuffer);
    free_string(&buffer);
    
    return ret;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
