static char rcsid[] = "@(#)$Id: alias_info_1.c,v 2.7 2018/06/28 07:37:39 hurtta Exp $";


/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.7 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 src/showmsg_c.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/


#include "def_elm.h"
#include "s_elm.h"

DEBUG_VAR(Debug,__FILE__,"alias");


typedef int show_alias_f P_((struct AliasView *aview,
			     int i,
			     struct pager_page * PP));


#if ANSI_C
static show_alias_f show_alias_1;
#endif
static int show_alias_1 P_((struct AliasView *aview,
			    int i,
			    struct pager_page * PP));
static int show_alias_1(aview,i,PP)
     struct AliasView *aview;
     int i;
     struct pager_page * PP;
{
    struct aliasview_record *a = give_alias(aview,i);
    
    if (a)
	return alias_info(a,PP->root);
    else {
        DPRINT(Debug,3,(&Debug,
			"give_alias [%d] fails",i));
    }
    
    return 0;
}


#if ANSI_C
static show_alias_f show_alias_2;
#endif
static int show_alias_2 P_((struct AliasView *aview,
			    int i,
			    struct pager_page * PP));
static int show_alias_2(aview,i,PP)
     struct AliasView *aview;
     int i;
     struct pager_page * PP;
{
    struct aliasview_record *a = give_alias(aview,i);
    
    if (a)
	return alias_expansion_info0(a,NULL,PP->root,aview,1);
    else {
        DPRINT(Debug,3,(&Debug,
			"give_alias [%d] fails",i));
    }
    
    return 0;
}


static int show_alias_info_x P_((struct AliasView *aview,
				 struct menu_context  *page,
				 struct menu_context  *header_area,
				 show_alias_f F));

static int show_alias_info_x(aview,page,header_area,F)
     struct AliasView *aview;
     struct menu_context  *page;
     struct menu_context  *header_area;
     show_alias_f F;
{
    struct menu_common MENU;

    int alias_current = get_alias_current(aview);
    int i = 0;	    
    struct pager_page * PP = init_pager_page(&MENU);
    struct string     * msg_line = NULL;

    int LINES, COLUMNS;

    menu_get_sizes(PP->root, &LINES, &COLUMNS);   
    
    set_mcommon_from_aliasview(&MENU, aview);
    
    i = F(aview,alias_current-1,PP);
    
    while (i > 0) {
	int C 
	    = process_motion_command(i,&MENU,&msg_line);

	/* whole screen */
	if (menu_resized(PP->root)) {
	    menu_get_sizes(PP->root, &LINES, &COLUMNS);   
	    menu_trigger_redraw(PP->root);
	}
	if (menu_need_redraw(PP->root)) {
	    menu_ClearScreen(PP->root);
	    menu_redraw_children(PP->root);
	}
	
	/* display prompt */
	if (PP->prompt_area) {
	    /* clear what was left over from previous command 
	     * and display last generated message.
	     */
	    
	    /* create areas if missing */
	    if (!PP->border_line)
		sb_showmsg_update_border(PP->border_line,
					 PP->PARAM);
	    	    
	    if (menu_need_redraw(PP->border_line)) {
		DPRINT(Debug,1, (&Debug, "border line redraw???\n"));
		sb_showmsg_update_border(PP->border_line, 
					 PP->PARAM);
	    }
	    if (menu_need_redraw(PP->prompt_area)) {
		DPRINT(Debug,1, (&Debug, "prompt area redraw???\n"));
		sb_showmsg_update_prompt(PP->prompt_area, 
					 PP->PARAM);
	    }
	    
	    if (msg_line)
		menu_print_center(PP->root,LINES-1,msg_line);
	    
	} 
		
	switch(C) {
	case motion_done:   /* Print prompt */
	    
	    if (PP->prompt_area) {
		menu_PutLineX(PP->prompt_area,0,0,
			      FRM("%S"),mcommon_give_item(&MENU, m_Prompt));
		
		i = menu_ReadCh(PP->prompt_area,
				'i'|READCH_CURSOR);   /* get next command from user */
	    } else {
		/* display bottom line prompt with last generated message */
		menu_MoveCursor(PP->root,LINES-1, 0);
		menu_CleartoEOS(PP->root);
		
		if (msg_line)
		    menu_Write_to_screen(PP->root,
					 CATGETS(elm_msg_cat, ElmSet, ElmCommandLine,
						 "%S Command ('i' to return to index): "),
					 msg_line);
		else
		    menu_Write_to_screen(PP->root,
					 CATGETS(elm_msg_cat, ElmSet, ElmCommandLineNoErr,
						 "Command ('i' to return to index): "));
		
	    }
	    
	    if (msg_line)
		free_string(& msg_line); /* null last generated message */
	    break;
	    
	case motion_view: {
	    alias_current = get_alias_current(aview);
	    
	    i = F(aview,alias_current-1,PP);
	}
	    break;
	    
	case  motion_exit_loop:
	    i = '\0';
	    goto OUT;
	    
	case EOF:
	    i = EOF;
	    goto OUT;
	    
	case 'i':
	case 'q':
	    clear_error();		/* zero out pending msg   */

	    i = '\0';
	    goto OUT;
	    
	default:
	    goto OUT;
	    
	}
    }
    
 OUT:
    
    exit_pager_page(&PP,page);
    
    menu_trigger_redraw(page);
    get_page(&MENU, header_area);
    
    return i;	
}


int show_alias_info(aview,page,header_area)
     struct AliasView *aview;
     struct menu_context  *page;
     struct menu_context  *header_area;
{

    return show_alias_info_x(aview,page,header_area,show_alias_1);
}

int show_alias_expanded(aview,page,header_area)
     struct AliasView *aview;
     struct menu_context  *page;
     struct menu_context  *header_area;
{
    return show_alias_info_x(aview,page,header_area,show_alias_2);
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
