static char rcsid[] = "@(#)$Id: buffer.c,v 2.6 2015/04/13 04:34:53 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.6 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_aliases.h"

DEBUG_VAR(Debug,__FILE__,"alias");

/* Access routines for alias editing */

void free_alias_buffer(rec)
     struct alias_buffer **rec;
{
    if (ALIASVIEW_buffer_magic != (*rec)->magic)
	panic("ALIAS VIEW PANIC",__FILE__,__LINE__,"free_alias_buffer",
	      "bad aliasview record magic",0);

    if ((*rec)->alias_key)
	free_string(&(*rec)->alias_key);

    if ((*rec)->alias_value)
      free_address_alias(& (*rec)->alias_value);

    (*rec)->magic = 0;   /* Invalidate */
    
    free(*rec);
    *rec = NULL;
}


struct alias_buffer * malloc_empty_alias_buffer()
{
    struct alias_buffer *ret = safe_malloc(sizeof(*ret));
    
    /* bzero is defined hdrs/elm_defs.h */
    bzero((void *)ret,sizeof (*ret));

    ret->alias_key      = NULL;
    ret->alias_value    = NULL;

    ret->magic          = ALIASVIEW_buffer_magic;

    return ret;
}

struct alias_buffer * malloc_alias_buffer(key,value)
     const struct string *key;
     const struct address_alias *value;
{
    struct alias_buffer *ret = malloc_empty_alias_buffer();

    ret->alias_key      = dup_string(key);    
    if (value)
	ret->alias_value    = dup_address_alias(value);
    else
	ret->alias_value = new_address_alias(NULL,NULL,NULL,NULL,NULL,NULL);

    return ret;
}

const struct string * alias_buffer_key(rec)
     const struct alias_buffer *rec;
{
    if (ALIASVIEW_buffer_magic != rec->magic)
	panic("ALIAS VIEW PANIC",__FILE__,__LINE__,"alias_buffer_key",
	      "bad aliasview record magic",0);
    
    return rec->alias_key;
}

void  set_alias_buffer_key(rec,key)
     struct alias_buffer *rec;
     const struct string *key;
{
    if (ALIASVIEW_buffer_magic != rec->magic)
	panic("ALIAS VIEW PANIC",__FILE__,__LINE__,"alias_buffer_key",
	      "bad aliasview record magic",0);

    if (rec->alias_key)
	free_string(&(rec->alias_key));

    rec->alias_key = dup_string(key);
}


const struct address_alias * alias_buffer_value(rec)
     const struct alias_buffer  *rec;
{
    if (ALIASVIEW_buffer_magic != rec->magic)
	panic("ALIAS VIEW PANIC",__FILE__,__LINE__,"alias_buffer_value",
	      "bad aliasview record magic",0);
    
    return rec->alias_value;
}

void  set_alias_buffer_value(rec,value)
     struct alias_buffer *rec;
     struct address_alias *value;
{
    if (ALIASVIEW_buffer_magic != rec->magic)
	panic("ALIAS VIEW PANIC",__FILE__,__LINE__,"set_alias_buffer_value",
	      "bad aliasview record magic",0);

    if (rec->alias_value)
	free_address_alias(& rec->alias_value);

    rec->alias_value = dup_address_alias(value);
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
