static char rcsid[] = "@(#)$Id: record.c,v 2.5 2014/11/15 11:00:24 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.5 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_aliases.h"

DEBUG_VAR(Debug,__FILE__,"alias");

/* Access routines to fake alias record */


void free_aliasview_record(rec)
     struct aliasview_record **rec;
{
    if (ALIASVIEW_record_magic != (*rec)->magic)
	panic("ALIAS VIEW PANIC",__FILE__,__LINE__,"free_aliasview_record",
	      "bad aliasview record magic",0);

    if ((*rec)->alias_key)
	free_string(& ((*rec)->alias_key));
    (*rec)->alias_value    = NULL;  /* Shared */

    (*rec)->type = 0;
    (*rec)->status = 0;

    (*rec)->magic = 0;   /* Invalidate */
    
    free(*rec);
    *rec = NULL;
}

struct aliasview_record * malloc_aliasview_record(key,value,type,status)
     const struct string *key;
     const struct address_alias *value;
     int type;
     int status;
{
    struct aliasview_record *ret = safe_malloc(sizeof(*ret));
    
    /* bzero is defined hdrs/elm_defs.h */
    bzero((void *)ret,sizeof (*ret));

    if (key)
	ret->alias_key  = dup_string(key);
    else
	ret->alias_key  = NULL;
    
    ret->alias_value    = value;  /* Shared */

    ret->type           = type;
    ret->status         = status;         

    ret->magic          = ALIASVIEW_record_magic;

    return ret;
}

void replace_aliasview_record(rec,key,value)
     struct aliasview_record *rec;
     const struct string *key;
     const struct address_alias *value;
{
    if (ALIASVIEW_record_magic != rec->magic)
	panic("ALIAS VIEW PANIC",__FILE__,__LINE__,"replace_aliasview_record",
	      "bad aliasview record magic",0);

    if (rec->alias_key)
	free_string(& (rec->alias_key));
    if (key)
	rec->alias_key  = dup_string(key);
    rec->alias_value    = value;  /* Shared */

}

const struct string * aliasview_key(a)
     struct aliasview_record *a;
{
     if (ALIASVIEW_record_magic != a->magic)
	panic("ALIAS VIEW PANIC",__FILE__,__LINE__,"aliasview_key",
	      "bad aliasview record magic",0);

     return a->alias_key;

}

const struct address_alias * aliasview_address_alias(a)
     struct aliasview_record *a;
{
     if (ALIASVIEW_record_magic != a->magic)
	panic("ALIAS VIEW PANIC",__FILE__,__LINE__,"aliasview_address_alias",
	      "bad aliasview record magic",0);

     return a->alias_value;
}   

extern int aliasview_have_type_mask(a,mask)   
     struct aliasview_record *a; 
     int mask;
{
    if (ALIASVIEW_record_magic != a->magic)
	panic("ALIAS VIEW PANIC",__FILE__,__LINE__,"aliasview_have_type_mask",
	      "bad aliasview record magic",0);

    return a->type & mask;
}

extern int aliasview_have_status_mask(a,mask)   
     struct aliasview_record *a; 
     int mask;
{
    if (ALIASVIEW_record_magic != a->magic)
	panic("ALIAS VIEW PANIC",__FILE__,__LINE__,"aliasview_have_status_mask",
	      "bad aliasview record magic",0);

    return a->status & mask;
}

const struct string * aliasview_get_key(rec)
     struct aliasview_record *rec;
{
    if (ALIASVIEW_record_magic != rec->magic)
	panic("ALIAS VIEW PANIC",__FILE__,__LINE__,"aliasview_get_key",
	      "bad magic",0);

    return rec->alias_key;
}

const struct address_alias * aliasview_get_alias(rec)
     struct aliasview_record *rec;
{
    if (ALIASVIEW_record_magic != rec->magic)
	panic("ALIAS VIEW PANIC",__FILE__,__LINE__,"aliasview_get_alias",
	      "bad magic",0);

    return rec->alias_value;
}

int aliasview_get_type(rec)
     struct aliasview_record *rec;
{
    if (ALIASVIEW_record_magic != rec->magic)
	panic("ALIAS VIEW PANIC",__FILE__,__LINE__,"aliasview_get_type",
	      "bad magic",0);

    return rec->type;
}

int aliasview_get_status(rec)
     struct aliasview_record *rec;
{
    if (ALIASVIEW_record_magic != rec->magic)
	panic("ALIAS VIEW PANIC",__FILE__,__LINE__,"aliasview_get_status",
	      "bad magic",0);

    return rec->status;
}


int aliasview_setf_status(rec,stat) 
     struct aliasview_record *rec;
     int stat;
{
    if (ALIASVIEW_record_magic != rec->magic)
	panic("ALIAS VIEW PANIC",__FILE__,__LINE__,"aliasview_setf_status",
	      "bad magic",0);

    setit(rec->status,stat);
    return rec->status;
}

int aliasview_ison_status(rec,stat) 
     struct aliasview_record *rec;
     int stat;
{
    if (ALIASVIEW_record_magic != rec->magic)
	panic("ALIAS VIEW PANIC",__FILE__,__LINE__,"aliasview_ison_status",
	      "bad magic",0);

    return ison(rec->status,stat);
}

extern int aliasview_clearf_status(rec,stat) 
     struct aliasview_record *rec;
     int stat;
{
    if (ALIASVIEW_record_magic != rec->magic)
	panic("ALIAS VIEW PANIC",__FILE__,__LINE__,"aliasview_clearf_status",
	      "bad magic",0);

    clearit(rec->status,stat);

    return rec->status;
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
