static char rcsid[] = "@(#)$Id: block.c,v 2.6 2013/12/21 19:48:36 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.6 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_block.h"
#include "s_elm.h"

DEBUG_VAR(Debug,__FILE__,"textblock");

struct text_block * alloc_block(block_type)
     struct text_block_type *block_type;
{
    struct text_block *ret = safe_malloc(sizeof (*ret));

    if (BLOCK_type_magic != block_type->magic)
	panic("TEXT BLOCK PANIC",__FILE__,__LINE__,"alloc_block",
              "Bad (block type) magic number",0);
    
    /* bzero is defined hdrs/elm_defs.h */
    bzero((void *)ret,sizeof (*ret));

    ret->magic  = BLOCK_magic;

    ret->block_type = block_type;

    ret->u.dummy    = NULL;
    ret->quote      = 0;

    ret->block_type->tb_alloc_it(ret);

    return ret;
}


int add_block_to_mail(block,already_has_text,edit_buffer,edit_charset)
     struct text_block *block;
     int        * already_has_text;
     FILE       * edit_buffer;
     charset_t  * edit_charset;
{
    int errors = 0;
    int idx = 0;
    struct string * buf = NULL;
    charset_t cs;

    if (BLOCK_magic != block->magic)
	panic("TEXT BLOCK PANIC",__FILE__,__LINE__,"add_block_to_mail",
              "Bad magic number",0);
    
    if (BLOCK_type_magic != block->block_type->magic)
	panic("TEXT BLOCK PANIC",__FILE__,__LINE__,"add_block_to_mail",
              "Bad (block type) magic number",0);

    cs = block->block_type->tb_get_charset_from_it(block);
    if (! *already_has_text) {

	/* Change charset */
	
	if (charset_superset_of(display_charset,cs)) {

	    const char *MIME_name   UNUSED_VAROK = 
		get_charset_MIME_name(cs);
	    const char *MIME_name_d UNUSED_VAROK = 
		get_charset_MIME_name(display_charset);

	    DPRINT(Debug,4, (&Debug, 
			     "add_block_to_mail: charset parameter %s is subset of display charset %s\n",
			     MIME_name   ? MIME_name   : "<no MIME name>",
			     MIME_name_d ? MIME_name_d : "<no MIME name>"));
	    *edit_charset = display_charset;
	} else
	    *edit_charset = cs;
    } else {
	/* WARNING: This test assumes that superset is byte per byte superset
         *          not just superset of characters
	 */
	if (charset_superset_of(*edit_charset,cs)) {
	    const char *MIME_name   UNUSED_VAROK = 
		get_charset_MIME_name(cs);
	    const char *MIME_name_e UNUSED_VAROK = 
		get_charset_MIME_name(*edit_charset);

	    DPRINT(Debug,4, (&Debug, 
			     "add_block_to_mail: charset parameter %s is superset of edit charset %s\n",
			     MIME_name   ? MIME_name   : "<no MIME name>",
			     MIME_name_e ? MIME_name_e : "<no MIME name>"));
	    *edit_charset = cs;
	}
    }


    if (cs != *edit_charset && 
	(!(CS_mapping & charset_properties(cs)) ||
	 !(CS_mapping & charset_properties(*edit_charset)))) {

	const char *MIME_name = get_charset_MIME_name(cs);
	const char *MIME_name_e = get_charset_MIME_name(*edit_charset);


	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCantConvertCharset,
			      "Can't convert text from charset %s to charset %s"),
		  MIME_name   ? MIME_name   : "<no MIME name>",
		  MIME_name_e ? MIME_name_e : "<no MIME name>");
	errors++;
    }

    /* get_line_from_it do not return \n */
    while (NULL != (buf = block->block_type->get_line_from_it(block,&idx,&errors))) {

	struct string * out_str = convert_string(*edit_charset,buf,0);
	char * buffer = NULL;
	int len;

	bytestream_from_string(out_str,&buffer,&len);
	
	if (len > 0) {
	    
	    if ('[' == buffer[0] && block->quote)
		putc('[',edit_buffer);

	    if (len != fwrite(buffer,1,len,edit_buffer)) {
		errors++;
	    }

	}

	putc('\n',edit_buffer);

	if (buffer)
	    free(buffer);
	free_string(&out_str);
	free_string(&buf);

	*already_has_text = 1;
    }

    
    if (errors || ferror(edit_buffer))
	return 0;

    return 1;
}

const char * get_block_filename(block)
     struct text_block *block;
{
    if (BLOCK_magic != block->magic)
	panic("TEXT BLOCK PANIC",__FILE__,__LINE__,"get_block_filename",
              "Bad magic number",0);

    if (BLOCK_type_magic != block->block_type->magic)
	panic("TEXT BLOCK PANIC",__FILE__,__LINE__,"get_block_filename",
              "Bad (block type) magic number",0);

    return  block->block_type->tb_get_filename_from_it(block);
}

void free_block(block)
     struct text_block **block;
{

    if (BLOCK_magic != (*block)->magic)
      panic("TEXT BLOCK PANIC",__FILE__,__LINE__,"free_block",
              "Bad magic number",0);
    
    if (BLOCK_type_magic != (*block)->block_type->magic)
	panic("TEXT BLOCK PANIC",__FILE__,__LINE__,"free_block",
              "Bad (block type) magic number",0);
	

    (*block)->block_type->tb_free_it(*block);

    (*block)->quote = 0;

    (*block)->magic = 0;  /* Invalidate */
    free(*block);
    *block = NULL;
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */

