static char rcsid[] = "@(#)$Id: stringblock.c,v 2.7 2015/03/17 16:35:17 hurtta Exp $";

/*****************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.7 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 ****************************************************************************/

#include "def_block.h"

DEBUG_VAR(Debug,__FILE__,"textblock");

#define BLOCK_string_magic	0xED03

struct stringblock {
    unsigned short        magic;     /* BLOCK_string_magic */
  
    struct string       * str;
};

#if ANSI_C
#define S_(x) static x;
#else
#define S_(x)
#endif

S_(tb_free_block tb_free_stringblock)
static void tb_free_stringblock P_((struct text_block *block));
static void tb_free_stringblock(block)
     struct text_block *block;
{
    if (BLOCK_string_magic != block->u.stringblock->magic)
	panic("TEXT BLOCK PANIC",__FILE__,__LINE__,"tb_free_stringblock",
              "Bad magic number",0);

    if (block->u.stringblock->str)
	free_string(& (block->u.stringblock->str));

    block->u.stringblock->magic = 0;   /* Invalidate */
    free(block->u.stringblock);
    block->u.stringblock = NULL;
}


S_(tb_free_block tb_alloc_stringblock)
static void tb_alloc_stringblock P_((struct text_block *block));
static void tb_alloc_stringblock(block)
     struct text_block *block;
{
    block->u.stringblock = safe_malloc(sizeof (* block->u.stringblock));

    /* bzero is defined hdrs/elm_defs.h */
    bzero((void *)block->u.stringblock,sizeof (* block->u.stringblock));

    block->u.stringblock->magic = BLOCK_string_magic;

    block->u.stringblock->str  = NULL;
}

S_(tb_get_charset_from_block tb_get_charset_from_stringblock)
static charset_t tb_get_charset_from_stringblock P_((struct text_block *block));
static charset_t tb_get_charset_from_stringblock(block)
     struct text_block *block;
{
   if (BLOCK_string_magic != block->u.stringblock->magic)
	panic("TEXT BLOCK PANIC",__FILE__,__LINE__,"tb_get_charset_from_block",
              "Bad magic number",0);

  
   return get_string_type(block->u.stringblock->str);
}

/* idx == 0 is first line 
   \n is not returned
*/
S_(get_line_from_block get_line_from_stringblock)
static struct string * get_line_from_stringblock P_((struct text_block *block, int *idx, int *errors));
static struct string * get_line_from_stringblock(block,idx,errors)
     struct text_block *block; 
     int *idx; 
     int *errors;
{
    struct string *ret = NULL;
    int L;
    int i;
    int start = *idx;
    int end;

    if (BLOCK_string_magic != block->u.stringblock->magic)
	panic("TEXT BLOCK PANIC",__FILE__,__LINE__,"get_line_from_stringblock",
              "Bad magic number",0);

    L = string_len(block->u.stringblock->str);
    end = L;

    if (*idx >= L)
	return NULL;

    for (i = *idx; i < L; i++) {
	uint16 ch = give_unicode_from_string(block->u.stringblock->str,i);

	if (0x000A /* LF  '\n' */ == ch) {
	    end   = i;
	    *idx  = i+1;
	    goto found;
	}

	if (i+1 < L &&
	    0x000D /* CR  '\r' */ == ch &&	    
	    0x000A /* LF  '\n' */ == 
	    give_unicode_from_string(block->u.stringblock->str,i+1) ) {
	    end   = i;
	    *idx  = i+2;
	    goto found;
	}
    }
    *idx = end;


 found:

    ret = clip_from_string(block->u.stringblock->str,&start,end-start);

    if (start != end)
	panic("TEXT BLOCK PANIC",__FILE__,__LINE__,"get_line_from_stringblock",
	      "Clipping Error",0);

    return ret;

}

S_(tb_get_filename_from_block tb_get_filename_from_stringblock)
static const char * tb_get_filename_from_stringblock 
P_((struct text_block *block));
static const char * tb_get_filename_from_stringblock(block) 
     struct text_block *block;
{
    if (BLOCK_string_magic != block->u.stringblock->magic)
	panic("TEXT BLOCK PANIC",__FILE__,__LINE__,
	      "tb_get_filename_from_stringblock",
              "Bad magic number",0);

    return NULL;
}

static struct text_block_type STRINGBLOCK = {
    BLOCK_type_magic,
    tb_free_stringblock,
    tb_alloc_stringblock,
    tb_get_charset_from_stringblock,
    get_line_from_stringblock,
    tb_get_filename_from_stringblock
};

struct text_block * block_from_string(S,quote)
     const struct string *S;
     int quote;
{

    struct text_block *ret = NULL;

    ret = alloc_block(&STRINGBLOCK);

    ret->u.stringblock->str  = dup_string(S);
    
    ret->quote = quote;

    return ret;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */

