static char rcsid[] = "@(#)$Id: calendar.c,v 2.7 2016/10/18 17:52:59 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.7 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 src/calendar.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** This routine implements a rather snazzy idea suggested by Warren
    Carithers of the Rochester Institute of Technology that allows
    mail to contain entries formatted in a manner that will allow direct
    copying into a users calendar program.

    All lines in the current message beginning with "->", e.g.

	-> Mon 04/21 1:00p meet with chairman candidate

    get copied into the user's calendar file.

**/

#include "def_elm.h"

DEBUG_VAR(Debug,__FILE__,"misc");

#include <errno.h>
#ifndef ANSI_C
extern int errno;
#endif         

#include <s_error.h>

static char * is_cal_entry P_((char *string));
static int extract_info P_((FILE *save_to_fd,  
			    struct MailboxView *mailbox));

void scan_calendar(mailbox)
     struct MailboxView  *mailbox;
{
	FILE *calendar;
	int  count;
	int  err UNUSED_VAROK;
	const char * cal_val = give_dt_estr_as_str(&calendar_file_e,"calendar",
						   NULL,NULL);

	if (!cal_val) {
	    sleep_message();
	    return;
	}

	/* First step is to open the calendar file for appending... **/

	if (can_open(cal_val, "a") != 0) {
	  err = errno;
	  DPRINT(Debug,2,
		 (&Debug,
		  "Error: wrong permissions to append to calendar %s\n",
		  cal_val));
	  DPRINT(Debug,2,
		 (&Debug, "** - %s **\n", strerror(err)));
	  lib_error(CATGETS(elm_msg_cat, ErrorSet, ErrorCalendarCanOpen,
			    "Not able to append to file %s!"), 
		    cal_val);
	  return; 
	}

	save_file_stats(cal_val,NULL);

	if ((calendar = fopen(cal_val,"a")) == NULL) {
	  err = errno;
	  DPRINT(Debug,2,(&Debug, 
			  "Error: couldn't append to calendar file %s (scan)\n", 
			  cal_val));
	  DPRINT(Debug,2,(&Debug, 
			  "** - %s **\n", strerror(err)));
	  lib_error(CATGETS(elm_msg_cat, ErrorSet, ErrorCalendarAppend,
			    "Couldn't append to file %s!"), 
		    cal_val);
	  return; 
	}
	
	count = extract_info(calendar, mailbox);

	fclose(calendar);

	restore_file_stats(cal_val);

	if (count > 0) {
	  if (count > 1)
	    lib_error(CATGETS(elm_msg_cat, ErrorSet, ErrorCalendarSavedPlural,
			      "%d entries saved in calendar file."), 
		      count);
	  else
	    lib_error(CATGETS(elm_msg_cat, ErrorSet, ErrorCalendarSaved,
			      "1 entry saved in calendar file."));
	} else 
	  lib_error(CATGETS(elm_msg_cat, ErrorSet, ErrorCalendarNoneSaved,
			    "No calendar entries found in that message."));

	return;
}

static int extract_info(save_to_fd,mailbox)
     FILE *save_to_fd;
     struct MailboxView *mailbox;
{
    /** Save the relevant parts of the current message to the given
	calendar file.  The only parameter is an opened file
	descriptor, positioned at the end of the existing file **/
    
    int entries = 0, lines;
    int line_length;
    char buffer[SLEN], *cp;
    
    int current = get_current(mailbox);
    struct header_rec *hdr = 0;
    FILE * ZZ;

    if (!current)
	return 0;

    if (!give_message_data(mailbox,current-1,&hdr, &ZZ,NULL,NO_mime_parse)) {
	
	lib_error(CATGETS(elm_msg_cat, ErrorSet, ErrorCalendarSeek,
			  "ELM [seek] failed trying to read %d bytes into file."),
		  hdr ? hdr->offset : -1);
	return(0);
    }
    
    /* how many lines in message? */
    
    lines = hdr->lines;

    /* now while not EOF & still in message... scan it! */
    
    while (lines) {	
	if((line_length = mail_gets(buffer, SLEN, ZZ)) == 0)
	    break;

	if(buffer[line_length - 1] == '\n')
	    lines--;					/* got a full line */
	
	if((cp = is_cal_entry(buffer)) != NULL) {
	    entries++;
	    fprintf(save_to_fd,"%s", cp);
	}
	
    }
    DPRINT(Debug,4,(&Debug,
		    "Got %d calender entr%s.\n", 
		    entries, entries > 1? "ies":"y"));
    
    return(entries);
}

static char *
is_cal_entry(string)
register char *string;
{
	/* If string is of the form
         * {optional white space} ->{optional white space} {stuff}
	 * return a pointer to stuff, otherwise return NULL.
	 */
	while( whitespace(*string) )
	  string++;      /* strip leading W/S */
	
	if(strncmp(string, "->", 2) == 0) {
	  for(string +=2 ; whitespace(*string); string++)
		  ;
	  return(string);
	}
	return(NULL);
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
