static char rcsid[] = "@(#)$Id: aliascmd.c,v 1.8 2016/10/18 17:53:00 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.8 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_command.h"
#include "s_command.h"
#include "patchlevel.h"

DEBUG_VAR(Debug,__FILE__,"command");

/* increment refcount */
struct elm_commands *give_alias_commands() 
{        

    static struct elm_commands  * alias_commands = NULL;
    struct elm_commands  * ret = NULL;

    if (alias_commands) {
	inc_commands_refcount(alias_commands);
	return alias_commands;
    }

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandAliasKeyTitle,"Alias command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandAliasDescTitle,
					      "Elm %s PL%s Action"),
				      VERSION,PATCHLEVEL),
			&alias_commands);


    /* TODO? center */
    add_commands_title(ret,pg_BOLD,CATGETS(elm_msg_cat, CommandSet,
					   CommandAliasTitle1,
					   "            Commands available from the Alias Menu in Elm %s"),
		       VERSION);


    {
	int cmds[] = { LINE_FEED, RETURN, ' ', 'v', 0 };

	add_commands_help_many(ret,0,cmds,
			       CATGETS(elm_msg_cat, CommandSet, CommandAliasView,
				       "View the address for the currently selected alias."));

    }

    if (ALLOW_subshell)
	add_commands_help_single(ret,NULL,0,'!',
				 CATGETS(elm_msg_cat, CommandSet, CommandCommonShell,
					 "Escape to the UNIX shell of your choice, or just to enter commands."));

    {
	int cmds[] = { '$', F5_KEY_MARK, 0 };
	
	add_commands_help_many(ret,0,cmds,
			       CATGETS(elm_msg_cat, CommandSet, CommandAliasDollar,
				       "Force resynchronization of aliases, processing additions and deletions."));
    }

    {	
	int cmds[] = { '+', RIGHT_MARK, PAGEDOWN_MARK, 0 };
	
	add_commands_help_many(ret,0, cmds, 
			       CATGETS(elm_msg_cat, CommandSet, CommandAliasNextPage,
				       "Go to the next index page."));
    }

    {
	int cmds[] = { '-', LEFT_MARK, PAGEUP_MARK, 0 };

	add_commands_help_many(ret,0, cmds, 
			       CATGETS(elm_msg_cat, CommandSet, CommandAliasPreviousPage,
				       "Go to the previous index page."));
    }

    {
	int cmds[] = { '*', END_MARK, 0 };

	add_commands_help_many(ret,0,cmds,
			       CATGETS(elm_msg_cat, CommandSet, CommandAliasLast,
				       "Set current alias to last alias."));
    }

    {
	int cmds[] = { '/', FIND_MARK, 0 };
	
	add_commands_help_many(ret,0,cmds,
			       CATGETS(elm_msg_cat, CommandSet, CommandAliaspSlash,
				       "Search for specified name or alias in list."));

    }

    add_commands_help_single_keyext(ret,NULL,0,NUMBER_MARK,
				    format_string(CATGETS(elm_msg_cat, CommandSet,
							  CommandReturnKey,
							  "<return>")),
				    CATGETS(elm_msg_cat, CommandSet, 
					    CommandAliasMakeCurrent,
					    "Make specified number the current alias."));


    {
	int cmds[] = { '=', HOME_MARK, 0 };

	add_commands_help_many(ret,0, cmds, 
			       CATGETS(elm_msg_cat, CommandSet, CommandAliasFirst,
				       "Set current alias to first alias."));
    }

    {
	int cmds[] = { '?', HELP_MARK, 0 };

	add_commands_help_many(ret,0, cmds,
			       CATGETS(elm_msg_cat, CommandSet, CommandCommonCommandHelp,
				       "Show command help or this screen of information."));	
    }

    add_commands_help_single(ret,NULL,0,'a',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandAliasAddMessage,
				     "Add (return) address of current message to alias database."));

    add_commands_help_single(ret,NULL,0,'c',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandAliasChangeCurrent,
				     "Change current user alias, modifying alias database at next resync."));

    {
	int cmds[] = { 'd', DELETE_MARK, 0 };
	
	add_commands_help_many(ret,0,cmds,
			       CATGETS(elm_msg_cat, CommandSet, 
				       CommandAliasDelete,
				       "Mark the current alias for deletion from alias database."));
    }

    add_commands_help_single(ret,NULL,0,ctrl('D'),
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandAliasDeletePattern,
				     "Mark for deletion user aliases matching specified pattern."));

    add_commands_help_single(ret,NULL,0,'e',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandAliasEditText,
				     "Edit the alias text file directly (will run newalias)."));

    add_commands_help_single(ret,NULL,0,'F',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandAliasFullyExpandPrompt,
				     "Prompt alias name and display fully expanded address of it."));

    add_commands_help_single(ret,NULL,0,'f',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandAliasFullyExpand,
				     "Display fully expanded address of current alias."));
    
    add_commands_help_single(ret,NULL,0,'H',
			     CATGETS(elm_msg_cat, CommandSet, CommandAliasGotoFirstLinePage,
				     "Go to first line of page."));



    add_commands_help_single(ret,NULL,0,'J',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandAliasIncrementOne,
				     "Increment current alias by one."));

    {
	int cmds[] = { 'j', DOWN_MARK , 0 };
	
	add_commands_help_many(ret,0, cmds, 
			       CATGETS(elm_msg_cat, CommandSet, CommandAliasAdvanceNextUndeleted,
				       "Advance to next undeleted alias."));

    }

    add_commands_help_single(ret,NULL,0,'K',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandAliasDecrementOne,
				     "Decrement current alias by one."));



    {
	int cmds[] = { 'k', UP_MARK , 0 };
	
	add_commands_help_many(ret,0, cmds, 
			       CATGETS(elm_msg_cat, CommandSet, CommandAliasAdvancePrevUndeleted,
				       "Advance to previous undeleted alias."));
    }
				       

    add_commands_help_single(ret,NULL,0,'L',
			     CATGETS(elm_msg_cat, CommandSet, CommandAliasGotoLastLinePage,
				     "Go to last line of page."));

    add_commands_help_single(ret,NULL,0,'l',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandAliasLimit,
				     "Limit displayed aliases on the specified criteria."));
    
    add_commands_help_single(ret,NULL,0,ctrl('L'),
			     CATGETS(elm_msg_cat, CommandSet, CommandMainRewriteScreen,
				     "Rewrite the screen."));
    
    add_commands_help_single(ret,NULL,0,'m',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandAliasSendMail,
				     "Send mail to the current or tagged aliases."));

    add_commands_help_single(ret,NULL,0,'n',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandAliasNewAlias,
				     "Add a new user alias, adding to alias database at next resync."));
			     


    {
	int cmds[] = { 'R' , 'Q' , 'I', 0 };
	
	
	add_commands_help_many(ret,0,cmds,
			       CATGETS(elm_msg_cat, CommandSet, 
				       CommandAliasReturnAlias,
				       "Return from alias menu (no prompting)."));
    }

    {
	int cmds[] = { 'r' , 'q' , 'i', 0 };
	
	add_commands_help_many(ret,0,cmds,
			       CATGETS(elm_msg_cat, CommandSet, 
				       CommandAliasReturnAliasPrompting,
				       "Return from alias menu (with prompting)."));
    }

    add_commands_help_single(ret,NULL,0,'T',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandAliasTagCurrentNext,
				     "Tag current alias and go to next alias."));

    add_commands_help_single(ret,NULL,0,'t',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandAliasTagCurrent,
				     "Tag current alias for further operations."));

    add_commands_help_single(ret,NULL,0,ctrl('T'),
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandAliasTagPattern,
				     "Tag aliases matching specified pattern."));

    add_commands_help_single(ret,NULL,0,'u',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandAliasUnmark,
				     "Unmark the current alias for deletion from alias database."));

    add_commands_help_single(ret,NULL,0,ctrl('U'),
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandAliasUnmarkPattern,
				     "Mark for undeletion user aliases matching specified pattern."));

    {
	int cmds[] = { 'x' , 'X',  0 };
	
	add_commands_help_many(ret,0,cmds,
			       CATGETS(elm_msg_cat, CommandSet, 
				       CommandAliasExitMenu,
				       "Exit from alias menu, abandoning any pending deletions."));
    }


    add_commands_help_single(ret,NULL,0,'^',
			     CATGETS(elm_msg_cat, CommandSet, CommandAliasToggleStatus,
				     "Toggle the Delete/Undelete status of the current alias."));

    add_commands_help_single(ret,NULL,0,F3_KEY_MARK,
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandAliasToggleMenu,
				     "Toggle menu on/off"));

    DPRINT(Debug,30,(&Debug,
		     "give_alias_commands=%p [pointer %p]\n",
		     ret,&alias_commands));

    return ret;
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
