static char rcsid[] = "@(#)$Id: attach_menucmd.c,v 1.5 2016/10/18 17:53:00 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.5 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_command.h"
#include "s_command.h"
#include "patchlevel.h"

DEBUG_VAR(Debug,__FILE__,"command");

struct elm_commands *give_attach_menu_mime_commands() /* increment refcount */
{
    static struct elm_commands  *attach_menu_mime_commands = NULL;
    struct elm_commands  * ret = NULL;

    if (attach_menu_mime_commands) {
	inc_commands_refcount(attach_menu_mime_commands);
	return attach_menu_mime_commands;
    }

    ret = new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					     CommandMimeStructKeyTitle,
					     "Menu command")),
		       format_string(CATGETS(elm_msg_cat, CommandSet,
					     CommandMimeStructDescTitle,
					     "Elm %s PL%s Action"),
				     VERSION,PATCHLEVEL),
		       &attach_menu_mime_commands);

    add_commands_title(ret,pg_BOLD,CATGETS(elm_msg_cat, CommandSet,
					   CommandMimeStructTitle1,
					   "            Commands available from MIME structure Menu in Elm %s"),
		       VERSION);

    {
	int cmds[] = { '\n','\r', ' ', 0 };
	
	add_commands_help_many(ret,0, cmds, 
			       CATGETS(elm_msg_cat, CommandSet,
				       CommandMimeStructDisplayPart,
				       "Display the current Mime part."));
    }

    if (ALLOW_subshell)
	add_commands_help_single(ret,NULL,0,'!',
				 CATGETS(elm_msg_cat, CommandSet, CommandCommonShell,
					 "Escape to the UNIX shell of your choice, or just to enter commands."));

    {
	int cmds[] = { '*', END_MARK, 0 };

	add_commands_help_many(ret,0, cmds, 
			       CATGETS(elm_msg_cat, CommandSet,
				       CommandMimeStructLastPart,
				       "Go to the last Mime part."));
    } 



    {	
	int cmds[] = { '+', RIGHT_MARK, PAGEDOWN_MARK,  0 };

	add_commands_help_many(ret,0, cmds, 
			       CATGETS(elm_msg_cat, CommandSet,
				       CommandMimeStructNextPage,
				       "Go to the next page of Mime parts."));

    }

    {
	int cmds[] = { '-', LEFT_MARK, PAGEUP_MARK, 0 };

	add_commands_help_many(ret,0, cmds, 
			       CATGETS(elm_msg_cat, CommandSet,
				       CommandMimeStructPreviousPage,
				       "Go to the previous page of Mime parts."));
    }

    {
	int cmds[] = { '=', HOME_MARK, 0 };
	
	add_commands_help_many(ret,0, cmds, 
			       CATGETS(elm_msg_cat, CommandSet,
				       CommandMimeStructFirstPart,
				       "Go to the first Mime part."));
    }

    {
	int cmds[] = { '?', HELP_MARK, 0 };

	add_commands_help_many(ret,0, cmds,
			       CATGETS(elm_msg_cat, CommandSet, CommandCommonCommandHelp,
				       "Show command help or this screen of information."));	
    }

    add_commands_help_single(ret,NULL,0,'b',
			     CATGETS(elm_msg_cat, CommandSet,
				     CommandMimeStructDisplaytBuiltin,
				     "Display the current Mime part as text on builtin pager."));

    if (use_PGP)
	add_commands_help_single(ret,NULL,0,ctrl('F'),
				 CATGETS(elm_msg_cat, CommandSet, CommandCommonForgetPassphrase,
					 "Forget PGP passphrase and close cached connections."));
#if defined(REMOTE_MBX)
    else	
	add_commands_help_single(ret,NULL,0,ctrl('F'),
				 CATGETS(elm_msg_cat, CommandSet, CommandCommonForgetPassphrase,
					 "Forget PGP passphrase and close cached connections."));
#endif

    {
	int cmds[] = { 'j', 'J', 'n', ctrl('N'), DOWN_MARK, 0 };

	add_commands_help_many(ret,0, cmds, 
			       CATGETS(elm_msg_cat, CommandSet,
				       CommandMimeStructNextPart,
				       "Go to the next Mime part."));
    }

    {
	int cmds[] = { 'k', 'K',  ctrl('K'), UP_MARK, 0 };

	add_commands_help_many(ret,0, cmds, 
			       CATGETS(elm_msg_cat, CommandSet,
				       CommandMimeStructPreviousPart,
				       "Go to the previous Mime part."));
	
    }

    add_commands_help_single(ret,NULL,0, ctrl('L'),
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandMainRewriteScreen,
				     "Rewrite the screen."));


    add_commands_help_single(ret,NULL,0,'p',
			     CATGETS(elm_msg_cat, CommandSet,
				     CommandMimeStructPrintPart,
				     "Print the current Mime part."));
    
    {
	int cmds[] = { 'q', 'x', 'i', TERMCH_interrupt_char, 0 };
	
	add_commands_help_many(ret,0, cmds, 
			       CATGETS(elm_msg_cat, CommandSet,
				       CommandMimeStructQuit,
				       "Quit visiting Mime structure menu and return to index."));
    }


    add_commands_help_single(ret,NULL,0,'s',
			     CATGETS(elm_msg_cat, CommandSet,
				     CommandMimeStructSavePart,
				     "Save the current Mime part."));

    add_commands_help_single(ret,NULL,0,'v',
			     CATGETS(elm_msg_cat, CommandSet,
				     CommandMimeStructExpandPart,
				     "Expand the current Mime part or view Mime subparts."));


    return ret;
}

struct elm_commands *give_attach_menu_norm_commands() /* increment refcount */
{
    static struct elm_commands  *attach_menu_norm_commands = NULL;
    struct elm_commands  * ret = NULL;

    if (attach_menu_norm_commands) {
	inc_commands_refcount(attach_menu_norm_commands);
	return attach_menu_norm_commands;
    }

    ret = new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					     CommandAttachmentKeyTitle,
					     "Menu command")),
		       format_string(CATGETS(elm_msg_cat, CommandSet,
					     CommandAttachmentDescTitle,
					     "Elm %s PL%s Action"),
				     VERSION,PATCHLEVEL),
		       &attach_menu_norm_commands);

    add_commands_title(ret,pg_BOLD,CATGETS(elm_msg_cat, CommandSet,
					   CommandAttachmentTitle1,
					   "            Commands available from Attachment Menu in Elm %s"),
		       VERSION);


    {
	int cmds[] = { '\n','\r', ' ', 0 };
	
	add_commands_help_many(ret,0, cmds, 
			       CATGETS(elm_msg_cat, CommandSet,
				       CommandAttachmentDisplayCurrent,
				       "Display the current attachment."));
    }

    if (ALLOW_subshell)
	add_commands_help_single(ret,NULL,0,'!',
				 CATGETS(elm_msg_cat, CommandSet, 
					 CommandCommonShell,
					 "Escape to the UNIX shell of your choice, or just to enter commands."));


    {
	int cmds[] = { '*', END_MARK, 0 };

	add_commands_help_many(ret,0, cmds, 
			       CATGETS(elm_msg_cat, CommandSet,
				       CommandAttachmentLastPart,
				       "Go to the last attachment."));
    } 


    {	
	int cmds[] = { '+', RIGHT_MARK, PAGEDOWN_MARK,  0 };

	add_commands_help_many(ret,0, cmds, 
			       CATGETS(elm_msg_cat, CommandSet,
				       CommandAttachmentNextPage,
				       "Go to the next page of attachments."));

    }

    {
	int cmds[] = { '-', LEFT_MARK, PAGEUP_MARK, 0 };

	add_commands_help_many(ret,0, cmds, 
			       CATGETS(elm_msg_cat, CommandSet,
				       CommandAttachmentPreviousPage,
				       "Go to the previous page of attachments."));
    }

    {
	int cmds[] = { '=', HOME_MARK, 0 };
	
	add_commands_help_many(ret,0, cmds, 
			       CATGETS(elm_msg_cat, CommandSet,
				       CommandAttachmentFirstPart,
				       "Go to the first attachment."));
    }

    {
	int cmds[] = { '?', HELP_MARK, 0 };

	add_commands_help_many(ret,0, cmds,
			       CATGETS(elm_msg_cat, CommandSet, 
				       CommandCommonCommandHelp,
				       "Show command help or this screen of information."));	
    }

    add_commands_help_single(ret,NULL,0,'a',
			     CATGETS(elm_msg_cat, CommandSet,
				     CommandAttachmentAttach,
				     "Attach an attachment."));

    add_commands_help_single(ret,NULL,0,'b',
			     CATGETS(elm_msg_cat, CommandSet,
				     CommandAttachmentDisplaytBuiltin,
				     "Display the current attachment as text on builtin pager."));

    add_commands_help_single(ret,NULL,0,'d',
			     CATGETS(elm_msg_cat, CommandSet,
				     CommandAttachmentDelete,
				     "Delete the current attachment."));


    add_commands_help_single(ret,NULL,0,'e',
			     CATGETS(elm_msg_cat, CommandSet,
				     CommandAttachmentEdit,
				     "Edit the current attachment."));

    if (use_PGP)
	add_commands_help_single(ret,NULL,0,ctrl('F'),
				 CATGETS(elm_msg_cat, CommandSet, 
					 CommandCommonForgetPassphrase,
					 "Forget PGP passphrase and close cached connections."));
#if defined(REMOTE_MBX)
    else
	add_commands_help_single(ret,NULL,0,ctrl('F'),
				 CATGETS(elm_msg_cat, CommandSet, 
					 CommandCommonForgetPassphrase,
					 "Forget PGP passphrase and close cached connections."));
#endif

    {
	int cmds[] = { 'j', 'J', 'n', ctrl('N'), DOWN_MARK, 0 };

	add_commands_help_many(ret,0, cmds, 
			       CATGETS(elm_msg_cat, CommandSet,
				       CommandAttachmentNext,
				       "Go to the next attachment."));
    }

    {
	int cmds[] = { 'k', 'K',  ctrl('K'), UP_MARK, 0 };

	add_commands_help_many(ret,0, cmds, 
			       CATGETS(elm_msg_cat, CommandSet,
				       CommandAttachmentPrevious,
				       "Go to the previous attachment."));
	
    }

    add_commands_help_single(ret,NULL,0, ctrl('L'),
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandMainRewriteScreen,
				     "Rewrite the screen."));

    add_commands_help_single(ret,NULL,0,'m',
			     CATGETS(elm_msg_cat, CommandSet,
				     CommandAttachmentModify,
				     "Modify the current attachment."));


    add_commands_help_single(ret,NULL,0,'p',
			     CATGETS(elm_msg_cat, CommandSet,
				     CommandAttachmentPrint,
				     "Print the current attachment."));
    {
	int cmds[] = { 'q', 'x', 'i', TERMCH_interrupt_char, 0 };
	
	add_commands_help_many(ret,0, cmds, 
			       CATGETS(elm_msg_cat, CommandSet,
				       CommandAttachmentQuit,
				       "Quit visiting attachment menu."));
    }

    add_commands_help_single(ret,NULL,0,'s',
			     CATGETS(elm_msg_cat, CommandSet,
				     CommandAttachmentSavePart,
				     "Save the current attachment."));

    add_commands_help_single(ret,NULL,0,'v',
			     CATGETS(elm_msg_cat, CommandSet,
				     CommandAttachmentExpandPart,
				     "Expand current attachment or view Mime subparts."));

    return ret;
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
