static char rcsid[] = "@(#)$Id: canceledmailcmd.c,v 1.4 2014/11/15 11:00:24 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.4 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_command.h"
#include "s_command.h"
#include "patchlevel.h"

DEBUG_VAR(Debug,__FILE__,"command");

struct elm_commands *give_view_canceled_mail_commands() 
{        

    static struct elm_commands  * view_canceled_mail_commands = NULL;

    struct elm_commands  * ret = NULL;

    if (view_canceled_mail_commands) {
	inc_commands_refcount(view_canceled_mail_commands);
	return view_canceled_mail_commands;
    }

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandViewCanMailKeyTitle,
					      "Viewing canceled mails command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandViewCanMailDescTitle,
					      "Elm %s PL%s Action"),
				      VERSION,PATCHLEVEL),
			&view_canceled_mail_commands);

    {
	int cmds[] = { ctrl('J'), ctrl('M'), 0 };

	add_commands_help_many(ret,0,cmds,
			       CATGETS(elm_msg_cat, CommandSet, 
				       CommandViewCanMailSelect,
				       "Selects the current message for sending."));
    }


    add_commands_help_single(ret,NULL,0,' ',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandMainDisplayCurrentMessage,
				     "Display the current message."));

    {
	int cmds[] = { '$', F5_KEY_MARK, 0 };

	add_commands_help_many(ret,0,cmds,
			       CATGETS(elm_msg_cat, CommandSet, 
				       CommandViewCanMailSync,
				       "Force resynchronization of the canceled mails. This will purge deleted mail."));

    }


    {
	int cmds[] = { 'q', 'i', 0 };

	add_commands_help_many(ret,0,cmds,
			       CATGETS(elm_msg_cat, CommandSet, 
				       CommandViewCanMailQuit,
				       "Quit the canceled mails, asking about deletion."));
    }

    {
	int cmds[] = { 'X', 'Q', ctrl('Q') , 0 };

	add_commands_help_many(ret,0,cmds,
			       CATGETS(elm_msg_cat, CommandSet, 
				       CommandViewCanMailQuickExit,
				       "Exit leaving the canceled mails untouched, unconditionally."));
    }


    add_commands_help_single(ret,NULL,0,F3_KEY_MARK,
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandMainToggleMenu,
				     "Toggle menu on/off"));


    {
	struct elm_commands *motion = give_motion_commands();
	
	add_commands_help_merge(ret,motion,0);
	
	free_commands(&motion);    /* Just decrements refcount */
    }

    DPRINT(Debug,30,(&Debug,
		     "give_view_canceled_mail_commands=%p [pointer %p]\n",
		     ret,&view_canceled_mail_commands));

    return ret;
}


struct elm_commands *give_canceled_mail_pager_commands() 
{        

    static struct elm_commands  * canceled_mail_pager_commands = NULL;

    struct elm_commands  * ret = NULL;

    if (canceled_mail_pager_commands) {
	inc_commands_refcount(canceled_mail_pager_commands);
	return canceled_mail_pager_commands;
    }

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandCanMailPgKeyTitle,
					      "Viewing canceled mails command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandCanMailPgDescTitle,
					      "Elm %s PL%s Action (pager)"),
				      VERSION,PATCHLEVEL),
			&canceled_mail_pager_commands);

    /* none */


    {
	struct elm_commands *core = give_common_core_commands();
	
	add_commands_help_merge(ret,core,0);

	free_commands(&core);    /* Just decrements refcount */
    }

    DPRINT(Debug,30,(&Debug,
		     "give_canceled_mail_pager_commands=%p [pointer %p]\n",
		     ret,&canceled_mail_pager_commands));

    return ret;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
