static char rcsid[] = "@(#)$Id: digestcmd.c,v 1.10 2017/11/18 16:49:27 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.10 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_command.h"
#include "s_command.h"
#include "patchlevel.h"

DEBUG_VAR(Debug,__FILE__,"command");

/* increment refcount */
struct elm_commands *give_digestmbx_commands() 
{        

    static struct elm_commands  * digestmbx_commands = NULL;
    struct elm_commands  * ret = NULL;

    if (digestmbx_commands) {
	inc_commands_refcount(digestmbx_commands);
	return digestmbx_commands;
    }

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandDigestKeyTitle,"Message digest command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandDigestDescTitle,
					      "Elm %s PL%s Action"),
				      VERSION,PATCHLEVEL),
			&digestmbx_commands);

    {
	int cmds[] = { '?', HELP_MARK, 0 };

	add_commands_help_many(ret,0, cmds,
			       CATGETS(elm_msg_cat, CommandSet, CommandCommonCommandHelp,
				       "Show command help or this screen of information."));	
    }


    {
	enum fragment_handling_v fh = 
	    give_dt_enumerate_as_int(&fragment_handling);

	 if (fragment_handling_auto == fh)
	     add_commands_help_single(ret,NULL,0,'A',
				      CATGETS(elm_msg_cat, CommandSet, CommandDigestAssemble,
					      "Assemble message fragments. This command may also be executed automatically."));
	 else
	     add_commands_help_single(ret,NULL,0,'A',
				      CATGETS(elm_msg_cat, CommandSet, CommandDigestAssembleNoAuto,
					      "Assemble message fragments."));

    }

    add_commands_help_single(ret,NULL,0,'o',
			     CATGETS(elm_msg_cat, CommandSet, CommandDigestOptionsMenu,
				     "Go to the options submenu."));

    add_commands_help_single(ret,NULL,0,F3_KEY_MARK,
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandDigestToggleMenu,
				     "Toggle menu on/off"));



    {
	struct elm_commands *mbx = give_additional_mailbox_commands();
	
	add_commands_help_merge(ret,mbx,0);

	free_commands(&mbx);    /* Just decrements refcount */
    }



#if 0
    {
	struct elm_commands *common = give_digest_common_commands();
	
	add_commands_help_merge(ret,common,0);

	free_commands(&common);    /* Just decrements refcount */

    }

#else
    {
	struct elm_commands *core = give_common_core_commands();
	
	add_commands_help_merge(ret,core,0);

	free_commands(&core);    /* Just decrements refcount */
    }
#endif


    DPRINT(Debug,30,(&Debug,
		     "give_digestmbx_commands=%p [pointer %p]\n",
		     ret,&digestmbx_commands));

    return ret;
}


/* increment refcount */
struct elm_commands *give_digestpager_commands() 
{        

    static struct elm_commands  * digestpager_commands = NULL;
    struct elm_commands  * ret = NULL;

    if (digestpager_commands) {
	inc_commands_refcount(digestpager_commands);
	return digestpager_commands;
    }

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandDigestPgKeyTitle,"Message digest command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandDigestPgDescTitle,
					      "Elm %s PL%s Action (pager)"),
				      VERSION,PATCHLEVEL),
			&digestpager_commands);

    {
      struct elm_commands *cpager = give_cpager_commands();
      
      add_commands_help_merge(ret,cpager,0);
      
      free_commands(&cpager);    /* Just decrements refcount */
      
    }

#if 0
    {
	struct elm_commands *common = give_digest_common_commands();
	
	add_commands_help_merge(ret,common,0);

	free_commands(&common);    /* Just decrements refcount */

    }

#else
    {
	struct elm_commands *core = give_common_core_commands();
	
	add_commands_help_merge(ret,core,0);

	free_commands(&core);    /* Just decrements refcount */
    }
#endif


    DPRINT(Debug,30,(&Debug,
		     "give_digestmbx_commands=%p [pointer %p]\n",
		     ret,&digestpager_commands));



    return ret;
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
