static char rcsid[] = "@(#)$Id: extendedcmd.c,v 1.8 2020/01/19 11:52:54 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.8 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_command.h"
#include "s_command.h"
#include "patchlevel.h"

DEBUG_VAR(Debug,__FILE__,"command");

/* increment refcount */
struct elm_commands *give_extended_commands() 
{        

    static struct elm_commands  * extended_commands = NULL;
    struct elm_commands  * ret = NULL;

    if (extended_commands) {
	inc_commands_refcount(extended_commands);
	return extended_commands;
    }

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandExtendedKeyTitle,"Extended command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandExtendedDescTitle,
					      "Elm %s PL%s Action"),
				      VERSION,PATCHLEVEL),
			&extended_commands);

    
    {
	int cmds[] = { '\n','\r', 0 };
	
	add_commands_help_many(ret,FLAG_KEY_no_nested, cmds, 
			       CATGETS(elm_msg_cat, CommandSet, CommandExtendedSelectCurrent,
				       "Execute currently selected command."));
    }


    add_commands_help_single(ret,NULL,FLAG_KEY_no_nested ,'?',
			     CATGETS(elm_msg_cat, CommandSet, CommandCommonCommandHelp,
				     "Show command help or this screen of information."));


    add_commands_help_single(ret,NULL,0,'d',
			     CATGETS(elm_msg_cat, CommandSet, CommandExtendedDuplicate,
				     "Enter duplicate removal mode."));

    
    {
      int cmds[] = { 'j', 'J', DOWN_MARK, 0 };

      add_commands_help_many(ret,FLAG_KEY_no_nested, cmds,
			     CATGETS(elm_msg_cat, CommandSet, CommandExtendedNextCommand,
				     "Go to the next command."));
    }

    {
      int cmds[] = { 'k', 'K', UP_MARK, 0 };
	
	add_commands_help_many(ret,FLAG_KEY_no_nested, cmds, 
			       CATGETS(elm_msg_cat, CommandSet, CommandExtendedPreviousCommand,
				       "Go to the previous command."));
    }

    add_commands_help_single(ret,NULL,FLAG_KEY_no_nested, ctrl('L'),
			     CATGETS(elm_msg_cat, CommandSet,
				     CommandExtendedRedraw,
				     "Redraws extended command screen."));

    add_commands_help_single(ret,NULL,0,'o',
			     CATGETS(elm_msg_cat, CommandSet, CommandExtendedOpenMailbox,
				     "Open mailbox to current view."));

    {
      int cmds[] = { 'q', 'x', 'i', TERMCH_interrupt_char, 0 };

      add_commands_help_many(ret,FLAG_KEY_no_nested,cmds,
			     CATGETS(elm_msg_cat, CommandSet, CommandExtendedQuit,
				     "Quit extended command."));
    }

    add_commands_help_single(ret,NULL,0,'r',
			     CATGETS(elm_msg_cat, CommandSet, CommandExtendedReConnMailbox,
				     "Reconnect broken mailbox connection."));
    
    add_commands_help_single(ret,NULL,0,'t',
			     CATGETS(elm_msg_cat, CommandSet, CommandExtendedViewThreads,
				     "View threads."));

    add_commands_help_single(ret,NULL,0,'u',
			     CATGETS(elm_msg_cat, CommandSet, CommandExtendedMailQuota,
				     "Show mail quota usage."));
    
    DPRINT(Debug,30,(&Debug,
		     "give_extended_commands=%p [pointer %p]\n",
		     ret,&extended_commands));


    return ret;
}
