static char rcsid[] = "@(#)$Id: fbrowsercmd.c,v 1.5 2016/10/18 17:53:00 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.5 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_command.h"
#include "s_command.h"
#include "patchlevel.h"


DEBUG_VAR(Debug,__FILE__,"command");

/* increment refcount */
struct elm_commands *give_fbrowser_commands() 
{        

    static struct elm_commands  * fbrowser_commands = NULL;
    struct elm_commands  * ret = NULL;

    if (fbrowser_commands) {
	inc_commands_refcount(fbrowser_commands);
	return fbrowser_commands;
    }

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandFBKeyTitle,"Command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandFBDescTitle,
					      "Elm %s PL%s Action"),
				      VERSION,PATCHLEVEL),
			&fbrowser_commands);

    add_commands_title(ret,pg_BOLD,
		       CATGETS(elm_msg_cat, CommandSet,
			       CommandFBHelpTitle,
			       "Help for the Elm 2.5 style File Selection Browser"));

    {
	int cmds[] = { '\n','\r', ' ', 0 };

	add_commands_help_many(ret,0, cmds, 
                               CATGETS(elm_msg_cat, CommandSet, 
                                       CommandFBSelectEntry,
				       "Select the currently highlighted entry."));
    }

    if (ALLOW_subshell)
	add_commands_help_single(ret,NULL,0,'!',
				 CATGETS(elm_msg_cat, CommandSet, CommandCommonShell,
					 "Escape to the UNIX shell of your choice, or just to enter commands."));

    {
	int cmds[] = { '$', F5_KEY_MARK, 0 };

	add_commands_help_many(ret,0, cmds, 
                               CATGETS(elm_msg_cat, CommandSet, 
                                       CommandFBResyncDirectory,
				       "Resynchronize directory."));

    }

    {
	int cmds[] = { '*' , END_MARK, 0 };

	add_commands_help_many(ret,0, cmds, 
                               CATGETS(elm_msg_cat, CommandSet, 
                                       CommandFBLastEntry,
				       "Move to last entry."));

    }

    {
	int cmds[] = { '+', PAGEDOWN_MARK, RIGHT_MARK, 0 };

	add_commands_help_many(ret,0, cmds, 
                               CATGETS(elm_msg_cat, CommandSet, 
                                       CommandFBNextPage,
				       "Move down to next page."));
    }

    {
	int cmds[] = { '-', PAGEUP_MARK, RIGHT_MARK, 0 };

	add_commands_help_many(ret,0, cmds, 
                               CATGETS(elm_msg_cat, CommandSet, 
                                       CommandFBPreviousPage,
				       "Move up to previous page."));
    }
     
    add_commands_help_single(ret,NULL,0,'.',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandFBEnterFilenameCurrent,
				     "Enter a filename in the current directory (2)."));

    add_commands_help_single(ret,NULL,0,'/',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandFBEnterFilenameRoot,
				     "Enter a filename in your mail folders directory (2)."));

    {
	int cmds[] = { '1', HOME_MARK, 0, };

	add_commands_help_many(ret,0, cmds, 
                               CATGETS(elm_msg_cat, CommandSet, 
                                       CommandFBFirstEntry,
				       "Move to first entry."));
    }


    add_commands_help_single(ret,NULL,0,'=',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandFBEnterFilenameFolders,
				     "Enter a filename in your mail folders directory (2)."));

    {
        int cmds[] = { '?' , HELP_MARK, 0 };

	add_commands_help_many(ret,0, cmds,
			       CATGETS(elm_msg_cat, CommandSet, 
				       CommandCommonCommandHelp,
				       "Show command help or this screen of information."));	
    }				       

    add_commands_help_single(ret,NULL,0,'c',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandFBChangeDir,
				     "Change directory (2)."));

    {
        int cmds[] = { 'f', F6_KEY_MARK, 0 };

        add_commands_help_many(ret,0, cmds, 
                               CATGETS(elm_msg_cat, CommandSet, 
                                       CommandFBEnterFilename,
				       "Enter a default filename (2)."));
    }
				     
    {
        int cmds[] = { 'j', 'J', DOWN_MARK, 0 };

        add_commands_help_many(ret,0, cmds, 
                               CATGETS(elm_msg_cat, CommandSet, 
                                       CommandFBNextEntry,
				       "Move down to next entry."));
    }

    {
	int cmds[] = { 'k', 'K', UP_MARK, 0 };
	
	add_commands_help_many(ret,0, cmds, 
			       CATGETS(elm_msg_cat, CommandSet, 
				       CommandFBPreviousEntry,
				       "Move up to previous entry."));
    }

    {
        int cmds[] = { 'l', 'p',  0 };

        add_commands_help_many(ret,0, cmds, 
                               CATGETS(elm_msg_cat, CommandSet, 
                                       CommandFBLimitDisplay,
				       "Limit display - specify a new match pattern for entries (3)."));
    }

    add_commands_help_single(ret,NULL,0, ctrl('L'),
                             CATGETS(elm_msg_cat, CommandSet, 
				     CommandFBRedrawDisplay,
				     "Redraw display."));

    add_commands_help_single(ret,NULL,0,'m',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandFBMakeDirectory,
				     "Make a directory (3)."));
    
    add_commands_help_single(ret,NULL,0,'o',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandFBOptions,
				     "Options settings (3)."));

    {
	int cmds[] = { 'q', 'x', 0 };

	add_commands_help_many(ret,0, cmds, 
                               CATGETS(elm_msg_cat, CommandSet, 
                                       CommandFBLeaveBrowser,
				       "Leave the browser without making a selection."));
    }
				       

    add_commands_help_single(ret,NULL,0, ctrl('R'),
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandFBRecallPrevious,
				     "Recall - change to previously browsed directory."));


    add_commands_help_single(ret,NULL,0,'~',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandFBEnterFilenameHome,
				     "Enter a filename in your home directory (2)."));

    add_commands_help_single(ret,NULL,0,F3_KEY_MARK,
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandMainToggleMenu,
				     "Toggle menu on/off"));

    add_commands_help_single(ret,NULL,0,F4_KEY_MARK,
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandFBReturnOtherBrowser,
				     "Returns Elm ME+ style file or folder browser (1)."));

    add_commands_trailer(ret,0,
			 CATGETS(elm_msg_cat, CommandSet,
				 CommandFBHelpTr1,
				 "(1) F4 toggles between Elme ME+ style and Elm 2.5 style file browser."));
    add_commands_trailer(ret,0,
			 CATGETS(elm_msg_cat, CommandSet,
				 CommandFBHelpTr2,
				 "(2) Returns Elm ME+ style file or folder browser."));
    add_commands_trailer(ret,0,
			 CATGETS(elm_msg_cat, CommandSet,
				 CommandFBHelpTr3,
				 "(3) Marked commands require additional entry."));


    return ret;
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
