static char rcsid[] = "@(#)$Id: headercmd.c,v 1.3 2016/10/18 17:53:00 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.3 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_command.h"
#include "s_command.h"
#include "patchlevel.h"

DEBUG_VAR(Debug,__FILE__,"command");

struct elm_commands *give_edithdr_commands() 
{
    static struct elm_commands  * edithdr_commands = NULL;
    struct elm_commands  * ret = NULL;
    
    if (edithdr_commands) {
	inc_commands_refcount(edithdr_commands);
	return edithdr_commands;
    }
    
    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandEhdrKeyTitle,
					      "Edit header command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandEhdrDescTitle,
					      "Elm %s PL%s Action"),
				      VERSION,PATCHLEVEL),
			&edithdr_commands);
    
    
    {
	int cmds[] = { '\n','\r',TERMCH_interrupt_char,
		       'q', 'Q', 0 };

	add_commands_help_many(ret,0, cmds,
			       CATGETS(elm_msg_cat, CommandSet, 
				       CommandEhdrLeaveEditScreen,
				       "Leave Message Header Edit Screen."));
    }

    if (ALLOW_subshell)
	add_commands_help_single(ret,NULL,0,'!',
				 CATGETS(elm_msg_cat, CommandSet, 
					 CommandCommonShell,
					 "Escape to the UNIX shell of your choice, or just to enter commands."));    

    {
	int cmds[] = { '?', HELP_MARK, 0 };

	add_commands_help_many(ret,0, cmds,
			       CATGETS(elm_msg_cat, CommandSet, CommandCommonCommandHelp,
				       "Show command help or this screen of information."));	
    }


     {
	 int cmds[] = { 'a', 'A', 0 };

	 add_commands_help_many(ret,0, cmds,
				CATGETS(elm_msg_cat, CommandSet, 
					CommandEhdrActionField,
					"Edit Action: -header field."));

     }


     {
	 int cmds[] = { 'b', 'B', 0 };

	 add_commands_help_many(ret,0, cmds,
				CATGETS(elm_msg_cat, CommandSet, 
					CommandEhdrBccField,
					"Edit Bcc: -header field."));

     }



     {
	 int cmds[] = { 'c', 'C', 0 };

	 add_commands_help_many(ret,0, cmds,
				CATGETS(elm_msg_cat, CommandSet, 
					CommandEhdrCcField,
					"Edit Cc: -header field."));

     }



    {
	int cmds[] = { 'd', 'D', 0 };

	add_commands_help_many(ret,0, cmds,
			       CATGETS(elm_msg_cat, CommandSet, 
				       CommandEhdrEditor,
				       "Edit headers on editor."));
    }

     {
	 int cmds[] = { 'e', 'E', 0 };

	 add_commands_help_many(ret,0, cmds,
				CATGETS(elm_msg_cat, CommandSet, 
					CommandEhdrExpiresField,
					"Edit Expires: -header field."));

     }


     {
	 int cmds[] = { 'f', 'F', 0 };

	 add_commands_help_many(ret,0, cmds,
				CATGETS(elm_msg_cat, CommandSet, 
					CommandEhdrFromField,
					"Edit From: -header field."));

     }


     {
	 int cmds[] = { 'i', 'I', 0 };

	 add_commands_help_many(ret,0, cmds,
				CATGETS(elm_msg_cat, CommandSet, 
					CommandEhdrInReplyToField,
					"Edit In-reply-to: -header field."));

     }


    add_commands_help_single(ret,NULL,0, ctrl('L'),
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandMainRewriteScreen,
				     "Rewrite the screen."));

     {
	 int cmds[] = { 'n', 'N', 0 };

	 add_commands_help_many(ret,0, cmds,
				CATGETS(elm_msg_cat, CommandSet, 
					CommandEhdrPrecedenceField,
					"Edit Precedence: -header field."));

     }


     {
	 int cmds[] = { 'p', 'P', 0 };

	 add_commands_help_many(ret,0, cmds,
				CATGETS(elm_msg_cat, CommandSet, 
					CommandEhdrPriorityField,
					"Edit Priority: -header field."));

     }


     {
	 int cmds[] = { 'r', 'R', 0 };

	 add_commands_help_many(ret,0, cmds,
				CATGETS(elm_msg_cat, CommandSet, 
					CommandEhdrReplyToField,
					"Edit Reply-to: -header field."));

     }


     {
	 int cmds[] = { 's', 'S', 0 };

	 add_commands_help_many(ret,0, cmds,
				CATGETS(elm_msg_cat, CommandSet, 
					CommandEhdrSubjectField,
					"Edit Subject: -header field."));

     }


     {
	 int cmds[] = { 't', 'T', 0 };

	 add_commands_help_many(ret,0, cmds,
				CATGETS(elm_msg_cat, CommandSet, 
					CommandEhdrToField,
					"Edit To: -header field."));

     }

     {
	 int cmds[] = { 'u', 'U', 0 };

	 add_commands_help_many(ret,0, cmds,
				CATGETS(elm_msg_cat, CommandSet, 
					CommandEhdrUserField,
					"Edit user defined header field."));
     }


    return ret;
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */

