static char rcsid[] = "@(#)$Id: maincmd.c,v 1.20 2017/11/18 16:49:27 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.20 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_command.h"
#include "s_command.h"
#include "patchlevel.h"


DEBUG_VAR(Debug,__FILE__,"command");

/* increment refcount */
static struct elm_commands *give_motion_common_commands P_((void)); 
static struct elm_commands *give_motion_common_commands() 
{        

    static struct elm_commands  * motion_common_commands = NULL;
    struct elm_commands  * ret = NULL;

    if (motion_common_commands) {
	inc_commands_refcount(motion_common_commands);
	return motion_common_commands;
    }

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandMainKeyTitle,"Command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandMainDescTitle,
					      "Elm %s PL%s Action"),
				      VERSION,PATCHLEVEL),
			&motion_common_commands);

    {
      int cmds[] = { 'd', DELETE_MARK, 0 };

      add_commands_help_many(ret,0,cmds,
			     CATGETS(elm_msg_cat, CommandSet, CommandCommonDelete,
				     "Mark the current message for future deletion."));
    }

    add_commands_help_single(ret,NULL,0,'J',
			     CATGETS(elm_msg_cat, CommandSet, CommandCommonNextMessage,
				     "Go to the next message."));

    {
	int cmds[] = { 'j', DOWN_MARK, 0 };

	add_commands_help_many(ret,0, cmds, 
			       CATGETS(elm_msg_cat, CommandSet, CommandCommonNextUndeleted,
				       "Go to the next undeleted message."));
    }

    add_commands_help_single(ret,NULL,0,'K',
			     CATGETS(elm_msg_cat, CommandSet, CommandCommonPreviousMessage,
				     "Go to the previous message."));

    {
	int cmds[] = { 'k', UP_MARK, 0 };

	
	add_commands_help_many(ret,0, cmds, 
			       CATGETS(elm_msg_cat, CommandSet, CommandCommonPreviousUndeleted,
				       "Go to the previous undeleted message."));
    }

    add_commands_help_single(ret,NULL,0,'T',
			     CATGETS(elm_msg_cat, CommandSet, CommandCommonTagAndNext,
				     "Tag a message (or untag if tagged) and go to next message."));

    add_commands_help_single(ret,NULL,0,'t',
			     CATGETS(elm_msg_cat, CommandSet, CommandCommonTagMessage,
				     "Tag a message for further operations (or untag if tagged)."));

    add_commands_help_single(ret,NULL,0,'u',
			     CATGETS(elm_msg_cat, CommandSet, CommandCommonUndeleteMessage,
				     "Undelete - remove the deletion mark on the message."));


    DPRINT(Debug,30,(&Debug,
		     "give_motion_common_commands=%p [pointer %p]\n",
		     ret,&motion_common_commands));

    return ret;
}

/* increment refcount */
static struct elm_commands *give_motion_extra_commands P_((void)); 
static struct elm_commands *give_motion_extra_commands() 
{        

    static struct elm_commands  * motion_extra_commands = NULL;
    struct elm_commands  * ret = NULL;

    if (motion_extra_commands) {
	inc_commands_refcount(motion_extra_commands);
	return motion_extra_commands;
    }

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandMainKeyTitle,"Command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandMainDescTitle,
					      "Elm %s PL%s Action"),
				      VERSION,PATCHLEVEL),
			&motion_extra_commands);

    {
	int cmds[] = { '*', END_MARK, 0 };

	add_commands_help_many(ret,0,cmds,
			       CATGETS(elm_msg_cat, CommandSet, CommandMainLastMessage,
				       "Go to the last message in the current folder."));
    }

    {	
	int cmds[] = { '+', RIGHT_MARK, PAGEDOWN_MARK, 0 };

	add_commands_help_many(ret,0, cmds, 
			       CATGETS(elm_msg_cat, CommandSet, CommandMainNextPage,
				       "Go to the next page of messages."));
    }

    {
	int cmds[] = { '-', LEFT_MARK, PAGEUP_MARK, 0 };

	add_commands_help_many(ret,0, cmds, 
			       CATGETS(elm_msg_cat, CommandSet, CommandMainPreviousPage,
				       "Go to the previous page of messages."));
    }


    {
	struct elm_commands * find_commands = new_dummy_prefixed_commands();

	int cmds[] = { '/', FIND_MARK, 0 };
	
	add_commands_help_single(find_commands,NULL,0,'/',
				 CATGETS(elm_msg_cat, CommandSet, CommandFindSearchMessage,
					 "Search entire message texts for pattern."));

	add_commands_help_many_prefix(ret,
				      find_commands,
				      0, cmds, 
				      CATGETS(elm_msg_cat, CommandSet, CommandMainSearchFolder,
					      "Search for specified pattern in folder."));

	free_commands(&find_commands);    /* Just decrement refcount */
    }

    add_commands_help_single_keyext(ret,NULL,0,NUMBER_MARK,
				    format_string(CATGETS(elm_msg_cat, CommandSet,
							  CommandReturnKey,
							  "<return>")),
				    CATGETS(elm_msg_cat, CommandSet, CommandMainMakeMessageCurrent,
					    "Make specified number the current message."));

    {
	int cmds[] = { '=', HOME_MARK, 0 };

	add_commands_help_many(ret,0, cmds, 
			       CATGETS(elm_msg_cat, CommandSet, CommandMainFirstMessage,
				       "Go to the first message in the current folder."));
    }

    {
	int cmds[] = { '?', HELP_MARK, 0 };

	add_commands_help_many(ret,0, cmds,
			       CATGETS(elm_msg_cat, CommandSet, CommandCommonCommandHelp,
				       "Show command help or this screen of information."));	
    }

    add_commands_help_single(ret,NULL,0,ctrl('D'),
			     CATGETS(elm_msg_cat, CommandSet, CommandMainDeletePattern,
				     "Mark for deletion all messages with the specified pattern."));

    add_commands_help_single(ret,NULL,0,'F',
			     CATGETS(elm_msg_cat, CommandSet, CommandMainFlag,
				     "Flag current message (as important)"));

    add_commands_help_single(ret,NULL,0,'H',
			     CATGETS(elm_msg_cat, CommandSet, CommandMainGotoFirstLinePage,
				     "Go to first line of page."));

    add_commands_help_single(ret,NULL,0,'L',
			     CATGETS(elm_msg_cat, CommandSet, CommandMainGotoLastLinePage,
				     "Go to last line of page."));

    add_commands_help_single(ret,NULL,0,'l',
			     CATGETS(elm_msg_cat, CommandSet, CommandMainLimitDisplay,
				     "Limit displayed messages based on the specified criteria."));

    add_commands_help_single(ret,NULL,0, ctrl('L'),
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandMainRewriteScreen,
				     "Rewrite the screen."));

    add_commands_help_single(ret,NULL,0,ctrl('T'),
			     CATGETS(elm_msg_cat, CommandSet, CommandMainTagPattern,
				     "Tag all messages with the specified pattern."));

    add_commands_help_single(ret,NULL,0,ctrl('U'),
			     CATGETS(elm_msg_cat, CommandSet, CommandMainUndeletePattern,
				     "Undelete all messages with the specified pattern."));

    add_commands_help_single(ret,NULL,0,'^',
			     CATGETS(elm_msg_cat, CommandSet, CommandMainToggleStatus,
				     "Toggle the Delete/Undelete status of the current message."));
				


    DPRINT(Debug,30,(&Debug,
		     "give_motion_extra_commands=%p [pointer %p]\n",
		     ret,&motion_extra_commands));

    return ret;
}


/* increment refcount */
struct elm_commands *give_motion_commands() 
{        

    static struct elm_commands  * motion_commands = NULL;
    struct elm_commands  * ret = NULL;

    if (motion_commands) {
	inc_commands_refcount(motion_commands);
	return motion_commands;
    }


    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandMainKeyTitle,"Command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandMainDescTitle,
					      "Elm %s PL%s Action"),
				      VERSION,PATCHLEVEL),
			&motion_commands);

   {
	struct elm_commands *motion = give_motion_common_commands();
	
	add_commands_help_merge(ret,motion,0);
	
	free_commands(&motion);    /* Just decrements refcount */
    }

    {
	struct elm_commands *motion = give_motion_extra_commands();
	
	add_commands_help_merge(ret,motion,0);
	
	free_commands(&motion);    /* Just decrements refcount */
    }
	

    DPRINT(Debug,30,(&Debug,
		     "give_motion_commands=%p [pointer %p]\n",
		     ret,&motion_commands));

    return ret;
}


/* increment refcount */
struct elm_commands *give_common_core_commands() 
{        

    static struct elm_commands  * common_core_commands = NULL;
    struct elm_commands  * ret = NULL;

    if (common_core_commands) {
	inc_commands_refcount(common_core_commands);
	return common_core_commands;
    }

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandMainKeyTitle,"Command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandMainDescTitle,
					      "Elm %s PL%s Action"),
				      VERSION,PATCHLEVEL),
			&common_core_commands);
    
    if (ALLOW_subshell)
	add_commands_help_single(ret,NULL,0,'!',
				 CATGETS(elm_msg_cat, CommandSet, 
					 CommandCommonShell,
					 "Escape to the UNIX shell of your choice, or just to enter commands."));

    if (ENABLE_calendar)
	add_commands_help_single(ret,NULL,0,'<',
				 CATGETS(elm_msg_cat, CommandSet, CommandCommonCalendar,
					 "Scan current message for calendar entries (if enabled)."));
    
    add_commands_help_single(ret,NULL,0,'b',
			     CATGETS(elm_msg_cat, CommandSet, CommandCommonBounce,
				     "Bounce (remail) a message to someone as if you have never seen it."));

    add_commands_help_single(ret,NULL,0,'C',
			     CATGETS(elm_msg_cat, CommandSet, CommandCommonCopy,
				     "Copy current message or tagged messages to specified file."));


    if (use_PGP)
	add_commands_help_single(ret,NULL,0,ctrl('E'),
				 CATGETS(elm_msg_cat, CommandSet, CommandCommonExtractPGPKey,
					 "Extract PGP public keys from current message."));

    add_commands_help_single(ret,NULL,0,'f',
			     CATGETS(elm_msg_cat, CommandSet, CommandCommonForward,
				     "Forward the current message to someone, return address is yours."));

    if (use_PGP)
	add_commands_help_single(ret,NULL,0,ctrl('F'),
				 CATGETS(elm_msg_cat, CommandSet, CommandCommonForgetPassphrase,
					 "Forget PGP passphrase and close cached connections."));
#if defined(REMOTE_MBX)
    else
	add_commands_help_single(ret,NULL,0,ctrl('F'),
				 CATGETS(elm_msg_cat, CommandSet, CommandCommonForgetPassphrase,
					 "Forget PGP passphrase and close cached connections."));
#endif

    add_commands_help_single(ret,NULL,0,'g',
			     CATGETS(elm_msg_cat, CommandSet, CommandCommonGroupReply,
				     "Group reply not only to the sender, but to everyone who received msg."));

    add_commands_help_single(ret,NULL,0,'h',
			     CATGETS(elm_msg_cat, CommandSet, CommandCommonDisplayHeaders,
				     "Display message with all Headers (ignore weedout list)."));

    {
	struct elm_commands *list_info_cmds = give_list_info_commands();

	add_commands_help_single(ret,list_info_cmds,0,'I',
				 CATGETS(elm_msg_cat, CommandSet, CommandCommonList,
					 "Display a mailing list information of current message."));

	free_commands(&list_info_cmds);   /* Just decrements refcount */
    }




    add_commands_help_single(ret,NULL,0,'O',
			     CATGETS(elm_msg_cat, CommandSet, CommandCommonOverrideMsgCharset,
				     "Override charset of current message or tagged messages."));

    add_commands_help_single(ret,NULL,0,'P',
			     CATGETS(elm_msg_cat, CommandSet, CommandCommonTextPrint,
				     "Print the text of current message or the tagged messages."));

    add_commands_help_single(ret,NULL,0,'p',
			     CATGETS(elm_msg_cat, CommandSet, CommandCommonPrint,
				     "Print the current message or the tagged messages."));

    add_commands_help_single(ret,NULL,0,'S',
			     CATGETS(elm_msg_cat, CommandSet, CommandCommonSaveTextMessage,
				     "Save text current message or tagged messages to specified file."));

    {
	int cmds[] = { 's', '>', 0 };
	
	add_commands_help_many(ret,0,cmds,
			       CATGETS(elm_msg_cat, CommandSet, CommandCommonSaveMessage,
				       "Save current message or tagged messages to specified file."));
    }

    add_commands_help_single(ret,NULL,0,'v',
			     CATGETS(elm_msg_cat, CommandSet, CommandCommonViewMimeSt,
				     "View MIME structure (attachments) in current message."));


    {
	struct elm_commands *motion = give_motion_common_commands();
	
	add_commands_help_merge(ret,motion,0);
	
	free_commands(&motion);    /* Just decrements refcount */
    }
	

    DPRINT(Debug,30,(&Debug,
		     "give_common_core_commands=%p [pointer %p]\n",
		     ret,&common_core_commands));

    return ret;
}



/* increment refcount */
struct elm_commands *give_common_commands() 
{        

    static struct elm_commands  * common_commands = NULL;
    struct elm_commands  * ret = NULL;

    if (common_commands) {
	inc_commands_refcount(common_commands);
	return common_commands;
    }
    
    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandMainKeyTitle,"Command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandMainDescTitle,
					      "Elm %s PL%s Action"),
				      VERSION,PATCHLEVEL),
			&common_commands);
	        
    if (use_PGP)
	add_commands_help_single(ret,NULL,0,ctrl('K'),
				 CATGETS(elm_msg_cat, CommandSet, CommandCommonMailPGPKeys,
					 "Mail PGP public key(s)"));

    {
	
	struct elm_commands * mail_commands = new_dummy_prefixed_commands();

	add_commands_help_single(mail_commands,NULL,0,'/',
				 CATGETS(elm_msg_cat, CommandSet, CommandMailCanceled,
					 "Select canceled (forgotten) mail."));
       
	add_commands_help_single(ret,mail_commands,0,'m',
				 CATGETS(elm_msg_cat, CommandSet, CommandCommonSendMail,
					 "Create and send mail to the specified person or persons."));

	free_commands(&mail_commands);    /* Just decrement refcount */
    }

    {
	struct elm_commands *generic_reply_cmds = give_generic_reply_commands();

	add_commands_help_single(ret,generic_reply_cmds,0,'R',
			     CATGETS(elm_msg_cat, CommandSet, CommandCommonGenericReply,
				     "Generic Reply -command prefix. This includes sending mail to mailing list."));

	free_commands(&generic_reply_cmds);   /* Just decrements refcount */
    }

    add_commands_help_single(ret,NULL,0,'r',
			     CATGETS(elm_msg_cat, CommandSet, CommandCommonReplyMessage,
				     "Reply to the message.  This only sends to the originator of the message."));
   

    add_commands_help_single(ret,NULL,0,'V',
			     CATGETS(elm_msg_cat, CommandSet, CommandCommonViewDigest,
				     "View digest as mailbox."));


    add_commands_help_single(ret,NULL,0,'X',
			     CATGETS(elm_msg_cat, CommandSet, CommandCommonQuickExit,
				     "Exit leaving the folder untouched, unconditionally."));

    add_commands_help_single(ret,NULL,0,'|',
			     CATGETS(elm_msg_cat, CommandSet, CommandCommonPipe,
				     "Pipe the current message or tagged messages to the command specified."));

    {
	struct elm_commands *core = give_common_core_commands();
	
	add_commands_help_merge(ret,core,0);

	free_commands(&core);    /* Just decrements refcount */
    }
				     

    DPRINT(Debug,30,(&Debug,
		     "give_common_commands=%p [pointer %p]\n",
		     ret,&common_commands));

    return ret;
}


/* increment refcount */
struct elm_commands *give_additional_mailbox_commands() 
{
    static struct elm_commands  * mbx_commands = NULL;
    struct elm_commands  * ret = NULL;

    if (mbx_commands) {
	inc_commands_refcount(mbx_commands);
	return mbx_commands;
    }

    /* mailbox commands, which are not common (pager) commands */

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandMainKeyTitle,"Command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandMainDescTitle,
					      "Elm %s PL%s Action"),
				      VERSION,PATCHLEVEL),
			&mbx_commands);

    {
	int cmds[] = { '\n','\r', ' ', 0 };
	
	add_commands_help_many(ret,0, cmds, 
			       CATGETS(elm_msg_cat, CommandSet, CommandMainDisplayCurrentMessage,
				       "Display the current message."));
    }

    add_commands_help_single(ret,NULL,0,'#',
			     CATGETS(elm_msg_cat, CommandSet, CommandMainDebugAll,
				     "Debug - display all information known about current message."));


    add_commands_help_single(ret,NULL,0,'@',
			     CATGETS(elm_msg_cat, CommandSet, CommandMainDebugSummary,
				     "Debug - display a summary of the messages on the header page."));

    add_commands_help_single(ret,NULL,0,'a',
			     CATGETS(elm_msg_cat, CommandSet, CommandMainAliasSubmenu,
				     "Enter the alias sub-menu section.  Create and display aliases."));
    
    {
	struct elm_commands  *extended_commands = give_extended_commands();

	add_commands_help_single(ret,extended_commands,0,'E',
				 CATGETS(elm_msg_cat, CommandSet, CommandMainExtendedCommand,
					 "Extended command prefix."));

	free_commands(&extended_commands); /* Just decrements refcount */
    }



    add_commands_help_single(ret,NULL,0,'M',
			     CATGETS(elm_msg_cat, CommandSet, CommandMainToggleMailingList,
				     "Toggle display of mailing list information."));

    add_commands_help_single(ret,NULL,0,'n',
			     CATGETS(elm_msg_cat, CommandSet, CommandMainDisplayThenNext,
				     "Display the current message, then move current to next message."));
    add_commands_help_single(ret,NULL,0,ctrl('N'),
			     CATGETS(elm_msg_cat, CommandSet, CommandMainDisplayThenNextU,
				     "Display the message, then move current to next unread message."));

    add_commands_help_single(ret,NULL,0,'U',
			     CATGETS(elm_msg_cat, CommandSet, CommandMainUnreadMessage,
				     "Unread - change status from read to unread."));
    

    {
	struct elm_commands *motion = give_motion_extra_commands();
	
	add_commands_help_merge(ret,motion,0);
	
	free_commands(&motion);    /* Just decrements refcount */
    }

 
    DPRINT(Debug,30,(&Debug,
		     "give_additional_mailbox_commands=%p [pointer %p]\n",
		     ret,& mbx_commands));

    return ret;

} 

/* increment refcount */
struct elm_commands *give_main_commands() 
{        

    static struct elm_commands  * main_commands = NULL;
    struct elm_commands  * ret = NULL;

    if (main_commands) {
	inc_commands_refcount(main_commands);
	return main_commands;
    }

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandMainKeyTitle,"Command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandMainDescTitle,
					      "Elm %s PL%s Action"),
				      VERSION,PATCHLEVEL),
			&main_commands);


    {
	int cmds[] = { '$', F5_KEY_MARK, 0 };

	add_commands_help_many(ret,0,cmds,
			       CATGETS(elm_msg_cat, CommandSet, CommandMainDollar,
				       "Force resynchronization of the current folder. This will purge deleted mail."));
    }    

    {
	enum fragment_handling_v fh = 
	    give_dt_enumerate_as_int(&fragment_handling);

	if (fragment_handling_auto == fh)
	    add_commands_help_single(ret,NULL,0,'A',
				     CATGETS(elm_msg_cat, CommandSet, CommandMainAssemble,
					     "Assemble message fragments. This command may also be executed automatically."));
	else
	    add_commands_help_single(ret,NULL,0,'A',
				     CATGETS(elm_msg_cat, CommandSet, CommandMainAssembleNoAuto,
					     "Assemble message fragments."));
    }


    add_commands_help_single(ret,NULL,0,'c',
			     CATGETS(elm_msg_cat, CommandSet, CommandMainChangeFolder,
				     "Change folders, leaving the current folder as if 'quitting'."));

    if (ALLOW_mailbox_editing)  {
	enum user_level_v ul = 
	    give_dt_enumerate_as_int(&user_level);

	if (ul >= user_level_expert) 
	    add_commands_help_single(ret,NULL,0,'e',
				     CATGETS(elm_msg_cat, CommandSet, CommandMainEditor,
					     "Invoke the editor on the entire folder, resynchronizing when done."));
    }
    
    add_commands_help_single(ret,NULL,0,'o',
			     CATGETS(elm_msg_cat, CommandSet, CommandMainOptionsMenu,
				     "Go to the options submenu."));


    add_commands_help_single(ret,NULL,0,'Q',
			     CATGETS(elm_msg_cat, CommandSet, CommandMainQuickQuit,
				     "Quick quit the mailer, save read, leave unread, delete deleted."));

    add_commands_help_single(ret,NULL,0,'q',
			     CATGETS(elm_msg_cat, CommandSet, CommandMainQuitMailer,
				     "Quit the mailer, asking about deletion, saving, etc."));

    {
	int cmds[] = { 'x', ctrl('Q'), 0 };
    
	/* Ctrl-Q is not on pager commands */

	add_commands_help_many(ret,0,cmds,
				 CATGETS(elm_msg_cat, CommandSet, 
					 CommandCommonExitFolder,
					 "Exit leaving the folder untouched, ask permission if changed."));
			     
    }

    add_commands_help_single(ret,NULL,0,F3_KEY_MARK,
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandMainToggleMenu,
				     "Toggle menu on/off"));


    {
	struct elm_commands *mbx = give_additional_mailbox_commands();
	
	add_commands_help_merge(ret,mbx,0);

	free_commands(&mbx);    /* Just decrements refcount */
    }


    {
	struct elm_commands *common = give_common_commands();
	
	add_commands_help_merge(ret,common,0);

	free_commands(&common);    /* Just decrements refcount */

    }

			     
    add_commands_help_single(ret,NULL,0,TERMCH_backspace,
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandTerminalBackspace,
				     "Terminal: Erase prevous character on text prompts."));
    
    add_commands_help_single(ret,NULL,0,TERMCH_kill_line,
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandTerminalKillLine,
				     "Terminal: Erase text on text prompts."));

    add_commands_help_single(ret,NULL,0,TERMCH_word_erase,
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandTerminalWordErase,
				     "Terminal: Erase previous word on text prompts."));

    add_commands_help_single(ret,NULL,0,TERMCH_interrupt_char,
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandTerminalInterrupt,
				     "Terminal: Interrupt command."));
    
    add_commands_help_single(ret,NULL,0,TERMCH_reprint_char,
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandTerminalReprint,
				     "Terminal: Reprint text  on text prompts."));

    
    add_commands_help_single(ret,NULL,0,TERMCH_eof_char,
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandTerminalEOF,
				     "Terminal: Signal end of file on text prompts."));
			     
    add_commands_help_single(ret,NULL,0,TERMCH_report_VQUIT,   /* Generates signal */
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandTerminalQuit,
				     "Terminal: Quit Elm or interrupt text prompts."));
    
    add_commands_help_single(ret,NULL,0,TERMCH_report_VSUSP,   /* Generates signal */
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandTerminalSusp,
				     "Terminal: Suspend Elm (if job control is enabled)."));

    add_commands_help_single(ret,NULL,0,TERMCH_report_VSTOP,
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandTerminalVSTOP,
				     "Terminal: Stop terminal output if  XON/XOFF flow control is enabled."));

    add_commands_help_single(ret,NULL,0,TERMCH_report_VSTART,
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandTerminalVSTART,
				     "Terminal: Start terminal output if  XON/XOFF flow control is enabled."));


    DPRINT(Debug,30,(&Debug,
		     "give_main_commands=%p [pointer %p]\n",
		     ret,& main_commands));

    			     
    return ret;
}



/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
