static char rcsid[] = "@(#)$Id: opt_gencmd.c,v 1.3 2016/02/10 19:48:10 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.3 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_command.h"
#include "s_command.h"
#include "opt_imp.h"

/* For UCHAR_MAX */
#include <limits.h>

DEBUG_VAR(Debug,__FILE__,"command");

#define CHARCOUNT   128


struct elm_commands * give_option_commands(STORE,cfg_opts,extra_actions,
					   key_title,desc_title,
					   title_pg_flags,title,quittext,
					   opt_string)
				   
     struct elm_commands  ** STORE;
     struct optsmenu       * cfg_opts;
     struct option_extra   * extra_actions;
     struct string         * key_title  /* shared, free'ed by free_commands */;
     struct string         * desc_title /* shared, free'ed by free_commands */;
     int                     title_pg_flags;
     struct string         * title      /* shared, free'ed by free_commands */;
     struct string         * quittext   /* shared, free'ed by free_commands */;
     char                  * opt_string;
{
    struct elm_commands  * ret = NULL;
    struct option_extra * x;
    int i;
    int char_backref[UCHAR_MAX];
    int have_disabled = 0;
	     
    if (*STORE) {
	free_string(&key_title);
	free_string(&desc_title);
	if (title)
	    free_string(&title);

	inc_commands_refcount(*STORE);
	return *STORE;
    }

    ret = new_commands(key_title,desc_title,STORE);

    if (title)
	add_commands_title_shared (ret,title_pg_flags,title);

    for (i = 0; i < UCHAR_MAX; i++)
	     char_backref[i] = 0;

    for (i = 0; i < cfg_opts->item_count; i++) {
	unsigned char c = (unsigned char) cfg_opts->items[i].letter;

	char_backref[c] = 1;

    }

    for (x = extra_actions; x; x = x->next) {
	if (x->key < TERMCH_min_char && x->key < REDRAW_MARK &&
	    x->key < UCHAR_MAX) {
	    unsigned char c = (unsigned char) x->key;

	    char_backref[c] = 1;
	}
    }


    /* gen_options() check that if key do not found,
       also lower key version of given keyword 

       if not on opt_string, it is no available */


    for (i = 0; i < cfg_opts->item_count; i++) {
	
	unsigned char c = cfg_opts->items[i].letter;
	char * x1 = index(opt_string,c);
	int keys_table[3];
	unsigned char upper = 0;
	
#ifdef ASCII_CTYPE
	if (isascii(c))
#endif
	    upper = toupper(c);

	if (c == upper || char_backref[upper])
	    upper = 0;
	    
	keys_table[0] = c;
	keys_table[1] = upper;
	keys_table[2] = 0;
	
	
	if (cfg_opts->items[i].one_liner_text) {
	    if (x1) 
		add_commands_help_many2(ret,0,
					keys_table,
					pg_BOLD,
					FRM("%S"),
					cfg_opts->items[i].one_liner_text);
		
	    else {
		add_commands_help_many(ret,0,
				       keys_table,
				       CATGETS(elm_msg_cat, CommandSet, 
					       CommandOptDisabled,
					       "%S [disabled]"),
				       cfg_opts->items[i].one_liner_text);
		have_disabled = 1;
	    }
	}
    }

    for (x = extra_actions; x; x = x->next) {

	int keys_table[3];

	if (OPTION_EXTRA_magic != x->magic)
	    panic("RC PANIC",__FILE__,__LINE__,
		  "add_optgen_to_commands",
		  "Bad magic number",0);

	keys_table[0] = x->key;
	keys_table[1] = 0;

	if (x->key < TERMCH_min_char && x->key < REDRAW_MARK &&
	    x->key < UCHAR_MAX) {
	    unsigned char upper = 0;
	    unsigned char c = (unsigned char) x->key;

#ifdef ASCII_CTYPE
	    if (isascii(c))
#endif
		upper = toupper(c);
	    if (c == upper || char_backref[upper])
		upper = 0;

	    keys_table[1] = upper;
	    keys_table[2] = 0;
	}

	if (x->help_text)
	    add_commands_help_many(ret,0,
				   keys_table,
				     FRM("%S"),
				     x->help_text);
    }

    add_commands_help_s_shared(ret,0,'q',quittext);

    add_commands_help_single(ret,NULL,0, ctrl('L'),
                             CATGETS(elm_msg_cat, CommandSet, 
				     CommandOptRedrawDisplay,
				     "Redraw display."));
    
    add_commands_help_single(ret,NULL,0,'>',
			     CATGETS(elm_msg_cat, CommandSet,
				     CommandOptSave,
				     "Save current options to elmrc file."));
    
    {
	int cmds[] = { '?' , HELP_MARK, 0 };
	
	add_commands_help_many(ret,0, cmds,
			       CATGETS(elm_msg_cat, CommandSet, 
				       CommandCommonCommandHelp,
				       "Show command help or this screen of information."));	
    }	

    if (have_disabled)
	add_commands_trailer(ret,0,
			     CATGETS(elm_msg_cat, CommandSet,
				     CommandOptDisabledTr,
				     "[disabled] Command disabled."));

    sort_commands(ret);

    return ret;
} 

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
